/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.envsupport.math;

import jadex.extension.envsupport.math.IVector1;
import jadex.extension.envsupport.math.IVector2;
import jadex.extension.envsupport.math.Vector2Double;
import java.math.BigDecimal;

public class Vector1Long
implements IVector1 {
    public static final IVector1 ZERO = new Vector1Long(0L);
    private long x_;

    public Vector1Long(long value) {
        this.x_ = value;
    }

    public Vector1Long() {
    }

    @Override
    public IVector1 add(IVector1 vector) {
        this.x_ += vector.getAsLong();
        return this;
    }

    @Override
    public IVector1 subtract(IVector1 vector) {
        this.x_ -= vector.getAsLong();
        return this;
    }

    @Override
    public IVector1 multiply(IVector1 vector) {
        this.x_ *= vector.getAsLong();
        return this;
    }

    @Override
    public IVector1 zero() {
        this.x_ = 0L;
        return this;
    }

    @Override
    public IVector1 negate() {
        this.x_ = -this.x_;
        return this;
    }

    @Override
    public IVector1 sqrt() {
        this.x_ = (long)Math.sqrt(this.x_);
        return this;
    }

    @Override
    public IVector1 cbrt() {
        this.x_ = (long)Math.cbrt(this.x_);
        return this;
    }

    @Override
    public IVector1 mod(IVector1 mod) {
        this.x_ %= mod.getAsLong();
        return this;
    }

    @Override
    public IVector1 getDistance(IVector1 vector) {
        long distance = Math.abs(this.x_) - Math.abs(vector.getAsLong());
        return new Vector1Long(distance);
    }

    @Override
    public int getAsInteger() {
        return (int)this.x_;
    }

    @Override
    public long getAsLong() {
        return this.x_;
    }

    public void setAsLong(long x) {
        this.x_ = x;
    }

    @Override
    public float getAsFloat() {
        return this.x_;
    }

    @Override
    public double getAsDouble() {
        return this.x_;
    }

    @Override
    public BigDecimal getAsBigDecimal() {
        return new BigDecimal(this.x_);
    }

    @Override
    public IVector1 copy() {
        return new Vector1Long(this.x_);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return this.copy();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IVector1) {
            return this.equals((IVector1)obj);
        }
        return false;
    }

    public int hashCode() {
        return (int)this.x_;
    }

    @Override
    public boolean equals(IVector1 vector) {
        return vector != null && this.x_ == vector.getAsLong();
    }

    @Override
    public boolean greater(IVector1 vector) {
        return this.x_ > vector.getAsLong();
    }

    @Override
    public boolean less(IVector1 vector) {
        return this.x_ < vector.getAsLong();
    }

    @Override
    public IVector2 createVector2(IVector1 sec) {
        return new Vector2Double(this.getAsLong(), sec.getAsLong());
    }

    public String toString() {
        return Long.toString(this.x_);
    }
}

