/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.envsupport.math;

import jadex.extension.envsupport.math.IVector1;
import jadex.extension.envsupport.math.IVector2;
import jadex.extension.envsupport.math.Vector1Double;
import jadex.extension.envsupport.math.Vector3Double;
import java.math.BigDecimal;
import java.text.DecimalFormat;

public class Vector2Double
implements IVector2,
Cloneable {
    public static final IVector2 ZERO = new Vector2Double(0.0);
    private double x_;
    private double y_;

    public Vector2Double() {
        this.x_ = 0.0;
        this.y_ = 0.0;
    }

    public Vector2Double(IVector2 vector) {
        this.x_ = vector.getXAsDouble();
        this.y_ = vector.getYAsDouble();
    }

    public Vector2Double(double scalar) {
        this.x_ = scalar;
        this.y_ = scalar;
    }

    public Vector2Double(double x, double y) {
        this.x_ = x;
        this.y_ = y;
    }

    @Override
    public IVector2 assign(IVector2 vector) {
        this.x_ = vector.getXAsDouble();
        this.y_ = vector.getYAsDouble();
        return this;
    }

    @Override
    public IVector2 add(double scalar) {
        this.x_ += scalar;
        this.y_ += scalar;
        return this;
    }

    @Override
    public IVector2 add(IVector1 scalar) {
        this.x_ += scalar.getAsDouble();
        this.y_ += scalar.getAsDouble();
        return this;
    }

    @Override
    public IVector2 add(IVector2 vector) {
        this.x_ += vector.getXAsDouble();
        this.y_ += vector.getYAsDouble();
        return this;
    }

    @Override
    public IVector2 subtract(double scalar) {
        this.x_ -= scalar;
        this.y_ -= scalar;
        return this;
    }

    @Override
    public IVector2 subtract(IVector1 scalar) {
        this.x_ -= scalar.getAsDouble();
        this.y_ -= scalar.getAsDouble();
        return this;
    }

    @Override
    public IVector2 subtract(IVector2 vector) {
        this.x_ -= vector.getXAsDouble();
        this.y_ -= vector.getYAsDouble();
        return this;
    }

    @Override
    public IVector2 mod(IVector2 modulus) {
        double mx = modulus.getXAsDouble();
        double my = modulus.getYAsDouble();
        this.x_ = (this.x_ + mx) % mx;
        this.y_ = (this.y_ + my) % my;
        return this;
    }

    @Override
    public IVector2 multiply(double scalar) {
        this.x_ *= scalar;
        this.y_ *= scalar;
        return this;
    }

    @Override
    public IVector2 multiply(IVector1 scalar) {
        this.x_ *= scalar.getAsDouble();
        this.y_ *= scalar.getAsDouble();
        return this;
    }

    @Override
    public IVector2 multiply(IVector2 vector) {
        this.x_ *= vector.getXAsDouble();
        this.y_ *= vector.getYAsDouble();
        return this;
    }

    @Override
    public IVector2 divide(IVector2 vector) {
        this.x_ /= vector.getXAsDouble();
        this.y_ /= vector.getYAsDouble();
        return this;
    }

    @Override
    public IVector2 zero() {
        this.x_ = 0.0;
        this.y_ = 0.0;
        return this;
    }

    @Override
    public IVector2 negateX() {
        this.x_ = -this.x_;
        return this;
    }

    @Override
    public IVector2 negateY() {
        this.y_ = -this.y_;
        return this;
    }

    @Override
    public IVector2 negate() {
        this.x_ = -this.x_;
        this.y_ = -this.y_;
        return this;
    }

    @Override
    public IVector2 randomX(IVector1 lower, IVector1 upper) {
        double l = lower.getAsDouble();
        double u = upper.getAsDouble();
        double r = Math.random();
        r *= u - l;
        this.x_ = r += l;
        return this;
    }

    @Override
    public IVector2 randomY(IVector1 lower, IVector1 upper) {
        double l = lower.getAsDouble();
        double u = upper.getAsDouble();
        double r = Math.random();
        r *= u - l;
        this.y_ = r += l;
        return this;
    }

    @Override
    public IVector2 normalize() {
        double length = Math.sqrt(this.x_ * this.x_ + this.y_ * this.y_);
        if (length != 0.0) {
            this.x_ /= length;
            this.y_ /= length;
        }
        return this;
    }

    @Override
    public IVector2 redirect(double angle) {
        double length = Math.sqrt(this.x_ * this.x_ + this.y_ * this.y_);
        this.x_ = Math.cos(angle) * length;
        this.y_ = Math.sin(angle) * length;
        return this;
    }

    @Override
    public IVector1 getLength() {
        return new Vector1Double(Math.sqrt(this.x_ * this.x_ + this.y_ * this.y_));
    }

    @Override
    public IVector1 getSquaredLength() {
        return new Vector1Double(this.x_ * this.x_ + this.y_ * this.y_);
    }

    @Override
    public IVector1 getDirection() {
        return new Vector1Double(Math.atan2(this.y_, this.x_));
    }

    @Override
    public float getDirectionAsFloat() {
        return (float)Math.atan2(this.y_, this.x_);
    }

    @Override
    public double getDirectionAsDouble() {
        return Math.atan2(this.y_, this.x_);
    }

    @Override
    public IVector1 getMean() {
        return new Vector1Double((this.x_ + this.y_) / 2.0);
    }

    @Override
    public IVector1 getDistance(IVector2 vector) {
        double dx = this.x_ - vector.getXAsDouble();
        double dy = this.y_ - vector.getYAsDouble();
        return new Vector1Double(Math.sqrt(dx * dx + dy * dy));
    }

    @Override
    public IVector1 getX() {
        return new Vector1Double(this.x_);
    }

    @Override
    public IVector1 getY() {
        return new Vector1Double(this.y_);
    }

    public void setX(IVector1 x) {
        this.x_ = x.getAsDouble();
    }

    public void setY(IVector1 y) {
        this.y_ = y.getAsDouble();
    }

    @Override
    public int getXAsInteger() {
        return (int)this.x_;
    }

    @Override
    public int getYAsInteger() {
        return (int)this.y_;
    }

    @Override
    public long getXAsLong() {
        return (long)this.x_;
    }

    @Override
    public long getYAsLong() {
        return (long)this.y_;
    }

    @Override
    public float getXAsFloat() {
        return (float)this.x_;
    }

    @Override
    public float getYAsFloat() {
        return (float)this.y_;
    }

    @Override
    public double getXAsDouble() {
        return this.x_;
    }

    @Override
    public double getYAsDouble() {
        return this.y_;
    }

    @Override
    public BigDecimal getXAsBigDecimal() {
        return new BigDecimal(this.x_);
    }

    @Override
    public BigDecimal getYAsBigDecimal() {
        return new BigDecimal(this.y_);
    }

    @Override
    public IVector2 copy() {
        return new Vector2Double(this.x_, this.y_);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return this.copy();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IVector2) {
            return this.equals((IVector2)obj);
        }
        return false;
    }

    @Override
    public boolean equals(IVector2 vector) {
        return Double.doubleToLongBits(this.x_) == Double.doubleToLongBits(vector.getXAsDouble()) && Double.doubleToLongBits(this.y_) == Double.doubleToLongBits(vector.getYAsDouble());
    }

    public int hashCode() {
        return (int)this.x_ * 31 + (int)this.y_;
    }

    public Vector3Double getVector3DoubleValueNoHight() {
        return new Vector3Double(this.x_, 0.0, this.y_);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        DecimalFormat format = new DecimalFormat("####.####");
        if (this.x_ < 1000.0 || this.x_ > 0.001) {
            buffer.append(format.format(this.x_));
        } else {
            buffer.append(Double.toString(this.x_));
        }
        buffer.append(", ");
        if (this.y_ < 10000.0 || this.y_ > 0.001) {
            buffer.append(format.format(this.y_));
        } else {
            buffer.append(Double.toString(this.y_));
        }
        return buffer.toString();
    }

    public static IVector2 getVector2(Double a, Double b) {
        Vector2Double ret = null;
        if (a != null && b != null) {
            ret = a == 0.0 && b == 0.0 ? ZERO : new Vector2Double(a, b);
        } else if (a != null || b != null) {
            ret = new Vector2Double(a == null ? 0.0 : a, b == null ? 0.0 : b);
        }
        return ret;
    }

    @Override
    public double getInnerProductAsDouble(IVector2 vector) {
        double bx = vector.getXAsDouble();
        double by = vector.getYAsDouble();
        return this.x_ * bx + this.y_ * by;
    }

    @Override
    public IVector1 getDirection(IVector2 vector) {
        return null;
    }

    @Override
    public double getDirectionAsDouble(IVector2 vector) {
        double qa = Math.sqrt(this.x_ * this.x_ + this.y_ * this.y_);
        double qb = Math.sqrt(vector.getXAsDouble() * vector.getXAsDouble() + vector.getYAsDouble() * vector.getYAsDouble());
        return Math.cos(this.getInnerProductAsDouble(vector) / (qa * qb));
    }

    @Override
    public float getDirectionAsFloat(IVector2 vector) {
        return 0.0f;
    }
}

