/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.envsupport.math;

import jadex.extension.envsupport.math.IVector1;
import jadex.extension.envsupport.math.IVector2;
import jadex.extension.envsupport.math.Vector1Double;
import jadex.extension.envsupport.math.Vector1Int;
import java.math.BigDecimal;

public class Vector2Int
implements IVector2 {
    public static final IVector2 ZERO = new Vector2Int(0);
    public static final IVector2 UNIT = new Vector2Int(1);
    private int x_;
    private int y_;

    public Vector2Int() {
        this.x_ = 0;
        this.y_ = 0;
    }

    public Vector2Int(IVector2 vector) {
        this.x_ = vector.getXAsInteger();
        this.y_ = vector.getYAsInteger();
    }

    public Vector2Int(int scalar) {
        this.x_ = scalar;
        this.y_ = scalar;
    }

    public Vector2Int(int x, int y) {
        this.x_ = x;
        this.y_ = y;
    }

    @Override
    public IVector2 assign(IVector2 vector) {
        this.x_ = vector.getXAsInteger();
        this.y_ = vector.getYAsInteger();
        return this;
    }

    @Override
    public IVector2 add(double scalar) {
        this.x_ += (int)scalar;
        this.y_ += (int)scalar;
        return this;
    }

    @Override
    public IVector2 add(IVector1 scalar) {
        this.x_ += scalar.getAsInteger();
        this.y_ += scalar.getAsInteger();
        return this;
    }

    @Override
    public IVector2 add(IVector2 vector) {
        this.x_ += vector.getXAsInteger();
        this.y_ += vector.getYAsInteger();
        return this;
    }

    @Override
    public IVector2 subtract(double scalar) {
        this.x_ -= (int)scalar;
        this.y_ -= (int)scalar;
        return this;
    }

    @Override
    public IVector2 subtract(IVector1 scalar) {
        this.x_ -= scalar.getAsInteger();
        this.y_ -= scalar.getAsInteger();
        return this;
    }

    @Override
    public IVector2 subtract(IVector2 vector) {
        this.x_ -= vector.getXAsInteger();
        this.y_ -= vector.getYAsInteger();
        return this;
    }

    @Override
    public IVector2 mod(IVector2 modulus) {
        int mx = modulus.getXAsInteger();
        int my = modulus.getYAsInteger();
        this.x_ = (this.x_ + mx) % mx;
        this.y_ = (this.y_ + my) % my;
        return this;
    }

    @Override
    public IVector2 multiply(double scalar) {
        this.x_ *= (int)scalar;
        this.y_ *= (int)scalar;
        return this;
    }

    @Override
    public IVector2 multiply(IVector1 scalar) {
        this.x_ *= scalar.getAsInteger();
        this.y_ *= scalar.getAsInteger();
        return this;
    }

    @Override
    public IVector2 multiply(IVector2 vector) {
        this.x_ *= vector.getXAsInteger();
        this.y_ *= vector.getYAsInteger();
        return this;
    }

    @Override
    public IVector2 divide(IVector2 vector) {
        this.x_ /= vector.getXAsInteger();
        this.y_ /= vector.getYAsInteger();
        return this;
    }

    @Override
    public IVector2 zero() {
        this.x_ = 0;
        this.y_ = 0;
        return this;
    }

    @Override
    public IVector2 negateX() {
        this.x_ = -this.x_;
        return this;
    }

    @Override
    public IVector2 negateY() {
        this.y_ = -this.y_;
        return this;
    }

    @Override
    public IVector2 negate() {
        this.x_ = -this.x_;
        this.y_ = -this.y_;
        return this;
    }

    @Override
    public IVector2 randomX(IVector1 lower, IVector1 upper) {
        double l = lower.getAsDouble();
        double u = upper.getAsDouble();
        double r = Math.random();
        r *= u - l;
        this.x_ = (int)(r += l);
        return this;
    }

    @Override
    public IVector2 randomY(IVector1 lower, IVector1 upper) {
        double l = lower.getAsDouble();
        double u = upper.getAsDouble();
        double r = Math.random();
        r *= u - l;
        this.y_ = (int)(r += l);
        return this;
    }

    @Override
    public IVector2 normalize() {
        double length = Math.sqrt(this.x_ * this.x_ + this.y_ * this.y_);
        if (length != 0.0) {
            this.x_ = (int)((double)this.x_ / length);
            this.y_ = (int)((double)this.y_ / length);
        }
        return this;
    }

    @Override
    public IVector2 redirect(double angle) {
        double length = Math.sqrt(this.x_ * this.x_ + this.y_ * this.y_);
        this.x_ = (int)Math.round(Math.cos(angle) * length);
        this.y_ = (int)Math.round(Math.sin(angle) * length);
        return this;
    }

    @Override
    public IVector1 getLength() {
        return new Vector1Double(Math.sqrt(this.x_ * this.x_ + this.y_ * this.y_));
    }

    @Override
    public IVector1 getSquaredLength() {
        return new Vector1Double(this.x_ * this.x_ + this.y_ * this.y_);
    }

    @Override
    public IVector1 getDirection() {
        return new Vector1Double(Math.atan2(this.y_, this.x_));
    }

    @Override
    public float getDirectionAsFloat() {
        return (float)Math.atan2(this.y_, this.x_);
    }

    @Override
    public double getDirectionAsDouble() {
        return Math.atan2(this.y_, this.x_);
    }

    @Override
    public IVector1 getMean() {
        return new Vector1Int(this.x_ + this.y_ >> 1);
    }

    @Override
    public IVector1 getDistance(IVector2 vector) {
        int dx = this.x_ - vector.getXAsInteger();
        int dy = this.y_ - vector.getYAsInteger();
        return new Vector1Double((int)Math.sqrt(dx * dx + dy * dy));
    }

    @Override
    public IVector1 getX() {
        return new Vector1Int(this.x_);
    }

    @Override
    public IVector1 getY() {
        return new Vector1Int(this.y_);
    }

    public void setX(IVector1 x) {
        this.x_ = x.getAsInteger();
    }

    public void setY(IVector1 y) {
        this.y_ = y.getAsInteger();
    }

    @Override
    public int getXAsInteger() {
        return this.x_;
    }

    @Override
    public int getYAsInteger() {
        return this.y_;
    }

    @Override
    public long getXAsLong() {
        return this.x_;
    }

    @Override
    public long getYAsLong() {
        return this.y_;
    }

    @Override
    public float getXAsFloat() {
        return this.x_;
    }

    @Override
    public float getYAsFloat() {
        return this.y_;
    }

    @Override
    public double getXAsDouble() {
        return this.x_;
    }

    @Override
    public double getYAsDouble() {
        return this.y_;
    }

    @Override
    public BigDecimal getXAsBigDecimal() {
        return new BigDecimal(this.x_);
    }

    @Override
    public BigDecimal getYAsBigDecimal() {
        return new BigDecimal(this.y_);
    }

    @Override
    public IVector2 copy() {
        return new Vector2Int(this);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return this.copy();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IVector2) {
            IVector2 vector = (IVector2)obj;
            return this.equals(vector);
        }
        return false;
    }

    @Override
    public boolean equals(IVector2 vector) {
        return vector != null && this.x_ == vector.getXAsInteger() && this.y_ == vector.getYAsInteger();
    }

    public int hashCode() {
        return this.x_ * 31 + this.y_;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.x_);
        buffer.append(", ");
        buffer.append(this.y_);
        return buffer.toString();
    }

    public static IVector2 getVector2(Integer a, Integer b) {
        IVector2 ret = null;
        if (a != null && b != null) {
            ret = a == 0 && b == 0 ? ZERO : new Vector2Int(a, b);
        }
        return ret;
    }

    @Override
    public double getInnerProductAsDouble(IVector2 vector) {
        return 0.0;
    }

    @Override
    public IVector1 getDirection(IVector2 vector) {
        return null;
    }

    @Override
    public double getDirectionAsDouble(IVector2 vector) {
        return 0.0;
    }

    @Override
    public float getDirectionAsFloat(IVector2 vector) {
        return 0.0f;
    }
}

