/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.envsupport.math;

import jadex.extension.envsupport.math.IVector1;
import jadex.extension.envsupport.math.IVector2;
import jadex.extension.envsupport.math.IVector3;
import jadex.extension.envsupport.math.Vector1Double;
import jadex.extension.envsupport.math.Vector1Int;
import java.math.BigDecimal;

public class Vector3Int
implements IVector3 {
    public static final IVector3 ZERO = new Vector3Int(0);
    private int x_;
    private int y_;
    private int z_;

    public Vector3Int() {
        this.x_ = 0;
        this.y_ = 0;
        this.z_ = 0;
    }

    public Vector3Int(IVector3 vector) {
        this.x_ = vector.getXAsInteger();
        this.y_ = vector.getYAsInteger();
        this.z_ = vector.getZAsInteger();
    }

    public Vector3Int(int scalar) {
        this.x_ = scalar;
        this.y_ = scalar;
        this.z_ = scalar;
    }

    public Vector3Int(int x, int y, int z) {
        this.x_ = x;
        this.y_ = y;
        this.z_ = z;
    }

    @Override
    public IVector3 add(double scalar) {
        this.x_ += (int)scalar;
        this.y_ += (int)scalar;
        this.z_ += (int)scalar;
        return this;
    }

    @Override
    public IVector3 add(IVector1 scalar) {
        this.x_ += scalar.getAsInteger();
        this.y_ += scalar.getAsInteger();
        this.z_ += scalar.getAsInteger();
        return this;
    }

    @Override
    public IVector3 add(IVector3 vector) {
        this.x_ += vector.getXAsInteger();
        this.y_ += vector.getYAsInteger();
        this.z_ += vector.getZAsInteger();
        return this;
    }

    @Override
    public IVector3 subtract(IVector1 scalar) {
        this.x_ -= scalar.getAsInteger();
        this.y_ -= scalar.getAsInteger();
        this.z_ -= scalar.getAsInteger();
        return this;
    }

    @Override
    public IVector3 subtract(IVector3 vector) {
        this.x_ -= vector.getXAsInteger();
        this.y_ -= vector.getYAsInteger();
        this.z_ -= vector.getZAsInteger();
        return this;
    }

    @Override
    public IVector3 assign(IVector3 vector) {
        this.x_ = vector.getXAsInteger();
        this.y_ = vector.getYAsInteger();
        this.z_ = vector.getZAsInteger();
        return this;
    }

    @Override
    public IVector3 copy() {
        return new Vector3Int(this);
    }

    @Override
    public IVector3 divide(IVector3 vector) {
        this.x_ /= vector.getXAsInteger();
        this.y_ /= vector.getYAsInteger();
        this.z_ /= vector.getZAsInteger();
        return this;
    }

    @Override
    public boolean equals(IVector3 vector) {
        return vector != null && this.x_ == vector.getXAsInteger() && this.y_ == vector.getYAsInteger() && this.z_ == vector.getXAsInteger();
    }

    @Override
    public IVector2 getDirection() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IVector1 getDistance(IVector3 vector) {
        double dx = (double)this.x_ - vector.getXAsDouble();
        double dy = (double)this.y_ - vector.getYAsDouble();
        double dz = (double)this.z_ - vector.getZAsDouble();
        return new Vector1Double(Math.sqrt(dx * dx + dy * dy + dz * dz));
    }

    @Override
    public IVector1 getLength() {
        return new Vector1Double(Math.sqrt(this.x_ * this.x_ + this.y_ * this.y_ + this.z_ * this.z_));
    }

    @Override
    public IVector1 getX() {
        return new Vector1Int(this.x_);
    }

    @Override
    public BigDecimal getXAsBigDecimal() {
        return new BigDecimal(this.x_);
    }

    @Override
    public double getXAsDouble() {
        return this.x_;
    }

    @Override
    public float getXAsFloat() {
        return this.x_;
    }

    @Override
    public int getXAsInteger() {
        return this.x_;
    }

    @Override
    public long getXAsLong() {
        return this.x_;
    }

    @Override
    public IVector1 getY() {
        return new Vector1Int(this.y_);
    }

    @Override
    public BigDecimal getYAsBigDecimal() {
        return new BigDecimal(this.y_);
    }

    @Override
    public double getYAsDouble() {
        return this.y_;
    }

    @Override
    public float getYAsFloat() {
        return this.y_;
    }

    @Override
    public int getYAsInteger() {
        return this.y_;
    }

    @Override
    public long getYAsLong() {
        return this.y_;
    }

    @Override
    public IVector1 getZ() {
        return new Vector1Int(this.z_);
    }

    @Override
    public BigDecimal getZAsBigDecimal() {
        return new BigDecimal(this.z_);
    }

    @Override
    public double getZAsDouble() {
        return this.z_;
    }

    @Override
    public float getZAsFloat() {
        return this.z_;
    }

    @Override
    public int getZAsInteger() {
        return this.z_;
    }

    @Override
    public long getZAsLong() {
        return this.z_;
    }

    @Override
    public IVector3 mod(IVector3 modulus) {
        int mx = modulus.getXAsInteger();
        int my = modulus.getYAsInteger();
        int mz = modulus.getZAsInteger();
        this.x_ = (this.x_ + mx) % mx;
        this.y_ = (this.y_ + my) % my;
        this.z_ = (this.z_ + mz) % mz;
        return this;
    }

    @Override
    public IVector3 multiply(double scalar) {
        this.x_ *= (int)scalar;
        this.y_ *= (int)scalar;
        this.z_ *= (int)scalar;
        return this;
    }

    @Override
    public IVector3 multiply(IVector1 scalar) {
        this.x_ *= scalar.getAsInteger();
        this.y_ *= scalar.getAsInteger();
        this.z_ *= scalar.getAsInteger();
        return this;
    }

    @Override
    public IVector3 multiply(IVector3 vector) {
        this.x_ *= vector.getXAsInteger();
        this.y_ *= vector.getYAsInteger();
        this.z_ *= vector.getZAsInteger();
        return this;
    }

    @Override
    public IVector3 negate() {
        this.x_ = -this.x_;
        this.y_ = -this.y_;
        this.z_ = -this.z_;
        return this;
    }

    @Override
    public IVector3 negateX() {
        this.x_ = -this.x_;
        return this;
    }

    @Override
    public IVector3 negateY() {
        this.y_ = -this.y_;
        return this;
    }

    @Override
    public IVector3 negateZ() {
        this.z_ = -this.z_;
        return this;
    }

    @Override
    public IVector3 normalize() {
        double length = Math.sqrt(this.x_ * this.x_ + this.y_ * this.y_ + this.z_ * this.z_);
        if (length != 0.0) {
            this.x_ = (int)((double)this.x_ / length);
            this.y_ = (int)((double)this.y_ / length);
            this.z_ = (int)((double)this.z_ / length);
        }
        return this;
    }

    @Override
    public IVector3 randomX(IVector1 lower, IVector1 upper) {
        double l = lower.getAsDouble();
        double u = upper.getAsDouble();
        double r = Math.random();
        r *= u - l;
        this.x_ = (int)(r += l);
        return this;
    }

    @Override
    public IVector3 randomY(IVector1 lower, IVector1 upper) {
        double l = lower.getAsDouble();
        double u = upper.getAsDouble();
        double r = Math.random();
        r *= u - l;
        this.y_ = (int)(r += l);
        return this;
    }

    @Override
    public IVector3 randomZ(IVector1 lower, IVector1 upper) {
        double l = lower.getAsDouble();
        double u = upper.getAsDouble();
        double r = Math.random();
        r *= u - l;
        this.z_ = (int)(r += l);
        return this;
    }

    @Override
    public IVector3 subtract(double scalar) {
        this.x_ -= (int)scalar;
        this.y_ -= (int)scalar;
        this.z_ -= (int)scalar;
        return this;
    }

    @Override
    public IVector3 zero() {
        this.x_ = 0;
        this.y_ = 0;
        this.z_ = 0;
        return this;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return this.copy();
    }

    public String toString() {
        String ret = "Vector3Int(" + this.x_ + ", " + this.y_ + ", " + this.z_ + ")";
        return ret;
    }
}

