/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.envsupport.observer.graphics.drawable;

import jadex.extension.envsupport.observer.graphics.drawable.AbstractVisual2D;
import jadex.javaparser.IParsedExpression;
import java.awt.Color;

public class Primitive
extends AbstractVisual2D {
    public static final int ABSOLUTE_POSITION = 1;
    public static final int ABSOLUTE_SIZE = 2;
    public static final int ABSOLUTE_ROTATION = 4;
    public static final int PRIMITIVE_TYPE_ELLIPSE = 0;
    public static final int PRIMITIVE_TYPE_RECTANGLE = 1;
    public static final int PRIMITIVE_TYPE_REGULARPOLYGON = 2;
    public static final int PRIMITIVE_TYPE_TEXT = 3;
    public static final int PRIMITIVE_TYPE_TEXTUREDRECTANGLE = 4;
    public static final int PRIMITIVE_TYPE_TRIANGLE = 5;
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    public static final int ALIGN_TOP = 0;
    public static final int ALIGN_MIDDLE = 1;
    public static final int ALIGN_BOTTOM = 2;
    protected boolean enableDCPos;
    protected boolean enableDCSize;
    protected boolean enableDCRot;
    protected Object color_;
    protected IParsedExpression drawcondition;
    protected Object[] renderinfos;
    protected int type;
    protected int halign;
    protected int valign;

    public Primitive() {
        this.type = 0;
        this.enableDCPos = true;
        this.enableDCSize = true;
        this.enableDCRot = true;
        this.setColor(Color.WHITE);
        this.flushRenderInfo();
    }

    public Primitive(int type, Object position, Object rotation, Object size, int absFlags, Object c, IParsedExpression drawcondition) {
        super(position, rotation, size);
        this.type = type;
        this.enableDCPos = (absFlags & 1) == 0;
        this.enableDCSize = (absFlags & 2) == 0;
        this.enableDCRot = (absFlags & 4) == 0;
        this.drawcondition = drawcondition;
        if (c == null) {
            c = Color.WHITE;
        }
        this.setColor(c);
        this.flushRenderInfo();
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void enableAbsolutePosition(boolean enable) {
        this.enableDCPos = !enable;
    }

    public void enableAbsoluteSize(boolean enable) {
        this.enableDCSize = !enable;
    }

    public void enableAbsoluteRotation(boolean enable) {
        this.enableDCRot = !enable;
    }

    public boolean isRelativePosition() {
        return this.enableDCPos;
    }

    public boolean isRelativeSize() {
        return this.enableDCSize;
    }

    public boolean isRelativeRotation() {
        return this.enableDCRot;
    }

    public void setDrawCondition(IParsedExpression drawcondition) {
        this.drawcondition = drawcondition;
    }

    public IParsedExpression getDrawCondition() {
        return this.drawcondition;
    }

    public Object getColor() {
        return this.color_;
    }

    public void setColor(Object c) {
        this.color_ = c;
    }

    public int getVAlign() {
        return this.valign;
    }

    public void setVAlign(int valign) {
        this.valign = valign;
    }

    public int getHAlign() {
        return this.halign;
    }

    public void setHAlign(int halign) {
        this.halign = halign;
    }

    public Object getRenderInfo(int infoId) {
        return this.renderinfos[infoId];
    }

    public void setRenderInfo(int infoId, Object info) {
        if (this.renderinfos.length <= infoId) {
            Object[] newInfoArray = new Object[infoId + 1];
            System.arraycopy(this.renderinfos, 0, newInfoArray, 0, this.renderinfos.length);
            this.renderinfos = newInfoArray;
        }
        this.renderinfos[infoId] = info;
    }

    public void flushRenderInfo() {
        this.renderinfos = new Object[0];
    }
}

