/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.envsupport.observer.graphics.drawable;

import jadex.extension.envsupport.math.IVector2;
import jadex.extension.envsupport.math.Vector2Double;
import jadex.extension.envsupport.math.Vector3Double;
import jadex.extension.envsupport.observer.graphics.AbstractViewport;
import jadex.extension.envsupport.observer.graphics.IViewport;
import jadex.extension.envsupport.observer.graphics.drawable.DrawableCombiner;
import jadex.extension.envsupport.observer.graphics.drawable.Primitive;
import jadex.javaparser.IParsedExpression;
import java.awt.Color;
import java.awt.Font;
import java.awt.font.TextLayout;

public final class Text
extends Primitive {
    public static final float BASE_VIEWPORT_SIZE = 300.0f;
    private Font baseFont;
    private String text;

    public Text() {
        this(null, null, null, null, 0, 0, 0, null);
    }

    public Text(Object position, Font baseFont, Color color, String text, int halign, int valign, int absFlags, IParsedExpression drawcondition) {
        super(3, position, Vector3Double.ZERO.copy(), new Vector2Double(1.0), absFlags, color, drawcondition);
        this.setHAlign(halign);
        this.setVAlign(valign);
        if (baseFont == null) {
            baseFont = new Font(null);
        }
        this.baseFont = baseFont;
        if (text == null) {
            text = "";
        }
        this.text = text;
    }

    public Font getBaseFont() {
        return this.baseFont;
    }

    public String getText() {
        return this.text;
    }

    public double getTextHAlignment(TextLayout tl) {
        double xAlign = 0.0;
        switch (this.getHAlign()) {
            case 2: {
                xAlign -= (double)tl.getAdvance();
                break;
            }
            case 1: {
                xAlign -= (double)(tl.getAdvance() / 2.0f);
            }
        }
        return xAlign;
    }

    public static final IVector2 getBasePosition(AbstractViewport vp, IVector2 dcPos, IVector2 position, IVector2 canvasSize, boolean invX, boolean invY) {
        IVector2 pos = vp.getPosition().copy().negate().add(vp.getObjectShift()).add(dcPos).add(position).divide(vp.getPaddedSize()).multiply(canvasSize);
        if (invX) {
            pos.negateX().add(new Vector2Double(canvasSize.getXAsDouble(), 0.0));
        }
        if (invY) {
            pos.negateY().add(new Vector2Double(0.0, canvasSize.getYAsDouble()));
        }
        return pos;
    }

    public static final float getBasicFontScale(IVector2 canvasSize, IVector2 areaSize, IVector2 size) {
        return Math.min(canvasSize.getXAsFloat(), canvasSize.getYAsFloat()) / 300.0f * areaSize.copy().divide(size).getMean().getAsFloat();
    }

    public static final String getReplacedText(DrawableCombiner dc, Object obj, String text, IViewport vp) {
        String[] tokens = text.split("\\$");
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < tokens.length; ++i) {
            if ((i & 1) == 0) {
                sb.append(tokens[i]);
                continue;
            }
            if ("".equals(tokens[i])) {
                sb.append("$");
                continue;
            }
            sb.append(String.valueOf(dc.getBoundValue(obj, tokens[i], vp)));
        }
        return sb.toString();
    }
}

