/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.envsupport.observer.graphics.drawable3d;

import jadex.extension.envsupport.observer.graphics.drawable3d.AbstractVisual3d;
import jadex.extension.envsupport.observer.graphics.drawable3d.special.SpatialControl;
import jadex.javaparser.IParsedExpression;
import java.awt.Color;
import java.util.ArrayList;

public class Primitive3d
extends AbstractVisual3d {
    public static final int ABSOLUTE_POSITION = 1;
    public static final int ABSOLUTE_SIZE = 2;
    public static final int ABSOLUTE_ROTATION = 4;
    public static final int PRIMITIVE_TYPE_SPHERE = 0;
    public static final int PRIMITIVE_TYPE_BOX = 1;
    public static final int PRIMITIVE_TYPE_CYLINDER = 2;
    public static final int PRIMITIVE_TYPE_ARROW = 3;
    public static final int PRIMITIVE_TYPE_DOME = 4;
    public static final int PRIMITIVE_TYPE_TORUS = 5;
    public static final int PRIMITIVE_TYPE_OBJECT3D = 6;
    public static final int PRIMITIVE_TYPE_TEXT3D = 7;
    public static final int PRIMITIVE_TYPE_SKY = 8;
    public static final int PRIMITIVE_TYPE_TERRAIN = 9;
    public static final int PRIMITIVE_TYPE_SOUND = 10;
    public static final int PRIMITIVE_TYPE_POINTLIGHT = 11;
    public static final int PRIMITIVE_TYPE_DIRECTIONALLIGHT = 12;
    public static final int PRIMITIVE_TYPE_EFFECT = 13;
    public static final int PRIMITIVE_TYPE_QUAD = 14;
    public static final String SHADOW_OFF = "Off";
    public static final String SHADOW_CAST = "Cast";
    public static final String SHADOW_RECEIVE = "Receive";
    protected boolean enableDCPos;
    protected boolean enableDCSize;
    protected boolean enableDCRot;
    protected Object color_;
    protected String texturePath_;
    protected String materialPath_;
    protected IParsedExpression drawcondition;
    protected Object[] renderinfos;
    protected int type;
    protected String shadowtype;
    private ArrayList<SpatialControl> controler;

    public Primitive3d() {
        this.type = 0;
        this.shadowtype = SHADOW_OFF;
        this.enableDCPos = false;
        this.enableDCSize = false;
        this.enableDCRot = false;
        this.setColor(Color.MAGENTA);
        this.texturePath_ = "";
        this.materialPath_ = "";
    }

    public Primitive3d(int type) {
        this.type = type;
        this.shadowtype = SHADOW_OFF;
        this.enableDCPos = false;
        this.enableDCSize = false;
        this.enableDCRot = false;
        this.setColor(Color.MAGENTA);
        this.texturePath_ = "";
        this.materialPath_ = "";
    }

    public Primitive3d(int type, Object position, IParsedExpression drawcondition) {
        super(position, null, null);
        this.type = type;
        this.shadowtype = SHADOW_OFF;
        this.enableDCPos = false;
        this.enableDCSize = false;
        this.enableDCRot = false;
        this.texturePath_ = "";
        this.materialPath_ = "";
        this.drawcondition = drawcondition;
    }

    public Primitive3d(int type, Object position, Object c, IParsedExpression drawcondition) {
        super(position, null, null);
        this.type = type;
        this.shadowtype = SHADOW_OFF;
        this.enableDCPos = false;
        this.enableDCSize = false;
        this.enableDCRot = false;
        this.setColor(c);
        this.texturePath_ = "";
        this.materialPath_ = "";
        this.drawcondition = drawcondition;
    }

    public Primitive3d(int type, Object position, Object rotation, Object size, IParsedExpression drawcondition) {
        super(position, rotation, size);
        this.type = type;
        this.setTexturePath("");
        this.setShadowtype(SHADOW_OFF);
        this.drawcondition = drawcondition;
    }

    public Primitive3d(int type, Object position, Object rotation, Object size, Object c) {
        super(position, rotation, size);
        this.type = type;
        if (c == null) {
            c = Color.DARK_GRAY;
        }
        this.setColor(c);
        this.setTexturePath("");
        this.setShadowtype(SHADOW_OFF);
    }

    public Primitive3d(int type, Object position, Object rotation, Object size, Object c, IParsedExpression drawcondition, String shadowtype) {
        super(position, rotation, size);
        this.type = type;
        if (c == null) {
            c = Color.WHITE;
        }
        this.setColor(c);
        this.setTexturePath("");
        if (shadowtype.equals(SHADOW_CAST) || shadowtype.equals(SHADOW_RECEIVE) || shadowtype.equals(SHADOW_OFF)) {
            this.setShadowtype(shadowtype);
        } else {
            this.setShadowtype(SHADOW_OFF);
        }
        this.drawcondition = drawcondition;
    }

    public Primitive3d(int type, Object position, Object rotation, Object size, int absFlags, Object c, String materialPath, String texturePath, IParsedExpression drawcondition, String shadowtype, ArrayList<SpatialControl> controler) {
        super(position, rotation, size);
        this.type = type;
        this.enableDCPos = (absFlags & 1) == 0;
        this.enableDCSize = (absFlags & 2) == 0;
        this.enableDCRot = (absFlags & 4) == 0;
        this.drawcondition = drawcondition;
        if (c == null) {
            c = Color.DARK_GRAY;
        }
        this.setColor(c);
        this.setMaterialPath(materialPath);
        this.setTexturePath(texturePath);
        if (shadowtype.equals(SHADOW_CAST) || shadowtype.equals(SHADOW_RECEIVE) || shadowtype.equals(SHADOW_OFF)) {
            this.setShadowtype(shadowtype);
        } else {
            this.setShadowtype(SHADOW_OFF);
        }
        this.controler = controler;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void enableAbsolutePosition(boolean enable) {
        this.enableDCPos = !enable;
    }

    public void enableAbsoluteSize(boolean enable) {
        this.enableDCSize = !enable;
    }

    public void enableAbsoluteRotation(boolean enable) {
        this.enableDCRot = !enable;
    }

    public boolean isRelativePosition() {
        return this.enableDCPos;
    }

    public boolean isRelativeSize() {
        return this.enableDCSize;
    }

    public boolean isRelativeRotation() {
        return this.enableDCRot;
    }

    public void setDrawCondition(IParsedExpression drawcondition) {
        this.drawcondition = drawcondition;
    }

    public IParsedExpression getDrawCondition() {
        return this.drawcondition;
    }

    public Object getColor() {
        return this.color_;
    }

    public void setColor(Object c) {
        this.color_ = c;
    }

    public void setTexturePath(String texturepath) {
        this.texturePath_ = texturepath;
    }

    public String getTexturePath() {
        return this.texturePath_;
    }

    public String getShadowtype() {
        return this.shadowtype;
    }

    public void setShadowtype(String shadowtype) {
        this.shadowtype = shadowtype;
    }

    public String getMaterialPath() {
        return this.materialPath_;
    }

    public void setMaterialPath(String materialPath_) {
        this.materialPath_ = materialPath_;
    }

    public ArrayList<SpatialControl> getControler() {
        return this.controler;
    }

    public void setControler(ArrayList<SpatialControl> controler) {
        this.controler = controler;
    }
}

