/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.envsupport.observer.graphics.java2d;

import jadex.commons.IValueFetcher;
import jadex.extension.envsupport.math.IVector2;
import jadex.extension.envsupport.observer.graphics.java2d.ILayerJ2DRenderer;
import jadex.extension.envsupport.observer.graphics.java2d.ViewportJ2D;
import jadex.extension.envsupport.observer.graphics.layer.GridLayer;
import jadex.extension.envsupport.observer.graphics.layer.Layer;
import jadex.extension.envsupport.observer.gui.SObjectInspector;
import jadex.extension.envsupport.observer.perspective.IPerspective;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

public class GridLayerJ2DRenderer
implements ILayerJ2DRenderer {
    @Override
    public void draw(IPerspective persp, Layer layer, IVector2 areaSize, ViewportJ2D vp) {
        Rectangle2D.Float r;
        Color c = layer.getColor() instanceof Color ? (Color)layer.getColor() : (Color)SObjectInspector.getProperty(persp, (String)layer.getColor(), "$perspective", (IValueFetcher)vp.getPerspective().getObserverCenter().getSpace().getFetcher());
        Graphics2D g = vp.getContext();
        g.setColor(c);
        IVector2 pixSize = vp.getPixelSize();
        IVector2 step = areaSize.copy().subtract(pixSize).divide(areaSize.copy().divide(((GridLayer)layer).getGridSize()));
        for (float x = 0.0f; x < areaSize.getXAsFloat(); x += step.getXAsFloat()) {
            r = new Rectangle2D.Float(x, 0.0f, pixSize.getXAsFloat(), areaSize.getYAsFloat());
            g.fill(r);
        }
        for (float y = 0.0f; y < areaSize.getYAsFloat(); y += step.getYAsFloat()) {
            r = new Rectangle2D.Float(0.0f, y, areaSize.getXAsFloat(), pixSize.getYAsFloat());
            g.fill(r);
        }
    }
}

