/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.envsupport.observer.graphics.java2d;

import jadex.extension.envsupport.observer.graphics.drawable.DrawableCombiner;
import jadex.extension.envsupport.observer.graphics.drawable.Primitive;
import jadex.extension.envsupport.observer.graphics.drawable.RegularPolygon;
import jadex.extension.envsupport.observer.graphics.java2d.AbstractJ2DRenderer;
import jadex.extension.envsupport.observer.graphics.java2d.ViewportJ2D;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;

public class RegularPolygonJ2DRenderer
extends AbstractJ2DRenderer {
    @Override
    public void draw(DrawableCombiner dc, Primitive primitive, Object obj, ViewportJ2D vp) {
        GeneralPath shape;
        try {
            shape = (GeneralPath)primitive.getRenderInfo(0);
        }
        catch (Exception e) {
            int vertices = ((RegularPolygon)primitive).getVertexCount();
            shape = new GeneralPath();
            shape.moveTo(0.5f, 0.0f);
            for (int i = 1; i < vertices; ++i) {
                double x = Math.PI * 2 / (double)vertices * (double)i;
                shape.lineTo((float)(Math.cos(x) / 2.0), (float)(Math.sin(x) / 2.0));
            }
            shape.closePath();
            primitive.setRenderInfo(0, shape);
        }
        Graphics2D g = vp.getContext();
        if (!this.setupMatrix(dc, primitive, obj, g, vp)) {
            return;
        }
        Color c = (Color)dc.getBoundValue(obj, primitive.getColor(), vp);
        if (c == null) {
            c = Color.WHITE;
        }
        g.setColor(c);
        g.fill(shape);
    }
}

