/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.envsupport.observer.graphics.java2d;

import jadex.extension.envsupport.math.IVector2;
import jadex.extension.envsupport.observer.graphics.ModulateComposite;
import jadex.extension.envsupport.observer.graphics.drawable.DrawableCombiner;
import jadex.extension.envsupport.observer.graphics.drawable.Primitive;
import jadex.extension.envsupport.observer.graphics.drawable.TexturedRectangle;
import jadex.extension.envsupport.observer.graphics.java2d.AbstractJ2DRenderer;
import jadex.extension.envsupport.observer.graphics.java2d.ViewportJ2D;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class TexturedRectangleJ2DRenderer
extends AbstractJ2DRenderer {
    @Override
    public void draw(DrawableCombiner dc, Primitive primitive, Object obj, ViewportJ2D vp) {
        BufferedImage image;
        try {
            image = (BufferedImage)primitive.getRenderInfo(0);
        }
        catch (Exception e) {
            image = vp.getImage(((TexturedRectangle)primitive).getTexturePath());
            primitive.setRenderInfo(0, image);
        }
        Graphics2D g = vp.getContext();
        IVector2 size = (IVector2)dc.getBoundValue(obj, primitive.getSize(), vp);
        g.translate(-size.getXAsDouble() / 2.0, -size.getYAsDouble() / 2.0);
        if (!this.setupMatrix(dc, primitive, obj, g, vp)) {
            return;
        }
        Color currentColor = (Color)dc.getBoundValue(obj, primitive.getColor(), vp);
        if (currentColor == null) {
            currentColor = Color.WHITE;
        }
        final Color fcurrentColor = currentColor;
        if (!Color.WHITE.equals(currentColor)) {
            ModulateComposite modComposite = new ModulateComposite(){

                @Override
                protected Color getColor() {
                    return fcurrentColor;
                }
            };
            Composite c = g.getComposite();
            g.setComposite(modComposite);
            g.drawImage(image, vp.getImageTransform(image.getWidth(), image.getHeight()), null);
            g.setComposite(c);
        } else {
            g.drawImage(image, vp.getImageTransform(image.getWidth(), image.getHeight()), null);
        }
    }
}

