/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.envsupport.observer.graphics.java2d;

import jadex.commons.IValueFetcher;
import jadex.extension.envsupport.math.IVector2;
import jadex.extension.envsupport.observer.graphics.ModulateComposite;
import jadex.extension.envsupport.observer.graphics.java2d.ILayerJ2DRenderer;
import jadex.extension.envsupport.observer.graphics.java2d.ViewportJ2D;
import jadex.extension.envsupport.observer.graphics.layer.Layer;
import jadex.extension.envsupport.observer.graphics.layer.TiledLayer;
import jadex.extension.envsupport.observer.gui.SObjectInspector;
import jadex.extension.envsupport.observer.perspective.IPerspective;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public class TiledLayerJ2DRenderer
implements ILayerJ2DRenderer {
    @Override
    public void draw(IPerspective persp, Layer layer, IVector2 areaSize, ViewportJ2D vp) {
        BufferedImage image;
        Graphics2D g = vp.getContext();
        TiledLayer tl = (TiledLayer)layer;
        try {
            image = (BufferedImage)layer.getRenderInfo(0);
        }
        catch (Exception e) {
            image = vp.getImage(tl.getTexturePath());
            tl.setRenderInfo(0, image);
        }
        Composite c = g.getComposite();
        if (!Color.WHITE.equals(layer.getColor())) {
            final Color color = layer.getColor() instanceof Color ? (Color)layer.getColor() : (Color)SObjectInspector.getProperty(persp, (String)layer.getColor(), "$perspective", (IValueFetcher)vp.getPerspective().getObserverCenter().getSpace().getFetcher());
            g.setComposite(new ModulateComposite(){

                @Override
                protected Color getColor() {
                    return color;
                }
            });
        }
        for (double x = 0.0; x < areaSize.getXAsDouble(); x += tl.getTileSize().getXAsDouble()) {
            for (double y = 0.0; y < areaSize.getYAsDouble(); y += tl.getTileSize().getYAsDouble()) {
                AffineTransform transform = g.getTransform();
                g.translate(x, y);
                g.scale(tl.getTileSize().getXAsDouble(), tl.getTileSize().getYAsDouble());
                g.drawImage(image, vp.getImageTransform(image.getWidth(), image.getHeight()), null);
                g.setTransform(transform);
            }
        }
        g.setComposite(c);
    }
}

