/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.envsupport.observer.graphics.java2d;

import jadex.extension.envsupport.observer.graphics.drawable.DrawableCombiner;
import jadex.extension.envsupport.observer.graphics.drawable.Primitive;
import jadex.extension.envsupport.observer.graphics.java2d.AbstractJ2DRenderer;
import jadex.extension.envsupport.observer.graphics.java2d.ViewportJ2D;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;

public class TriangleJ2DRenderer
extends AbstractJ2DRenderer {
    private static final GeneralPath J2D_TRIANGLE = new GeneralPath();

    @Override
    public void draw(DrawableCombiner dc, Primitive primitive, Object obj, ViewportJ2D vp) {
        Graphics2D g = vp.getContext();
        AffineTransform transform = g.getTransform();
        if (!this.setupMatrix(dc, primitive, obj, g, vp)) {
            return;
        }
        Color c = (Color)dc.getBoundValue(obj, primitive.getColor(), vp);
        g.setColor(c);
        g.fill(J2D_TRIANGLE);
        g.setTransform(transform);
    }

    static {
        J2D_TRIANGLE.moveTo(0.0f, 0.5f);
        J2D_TRIANGLE.lineTo((float)(-(0.25 * Math.sqrt(3.0))), -0.25f);
        J2D_TRIANGLE.lineTo((float)(0.25 * Math.sqrt(3.0)), -0.25f);
        J2D_TRIANGLE.closePath();
    }
}

