/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.envsupport.observer.gui;

import jadex.bridge.IExternalAccess;
import jadex.bridge.service.search.SServiceProvider;
import jadex.bridge.service.types.clock.IClockService;
import jadex.bridge.service.types.cms.IComponentManagementService;
import jadex.commons.IChangeListener;
import jadex.commons.future.DefaultResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.commons.gui.future.SwingDefaultResultListener;
import jadex.extension.envsupport.dataview.IDataView;
import jadex.extension.envsupport.environment.AbstractEnvironmentSpace;
import jadex.extension.envsupport.environment.IEnvironmentSpace;
import jadex.extension.envsupport.math.IVector2;
import jadex.extension.envsupport.observer.gui.IObserverCenter;
import jadex.extension.envsupport.observer.gui.ObserverCenterWindow;
import jadex.extension.envsupport.observer.gui.plugin.IObserverCenterPlugin;
import jadex.extension.envsupport.observer.gui.plugin.IntrospectorPlugin;
import jadex.extension.envsupport.observer.gui.plugin.VisualsPlugin;
import jadex.extension.envsupport.observer.perspective.IPerspective;
import jadex.extension.envsupport.observer.perspective.Perspective2D;
import jadex.extension.envsupport.observer.perspective.Perspective3D;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.event.WindowStateListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ObserverCenter
implements IObserverCenter {
    private static final int[] PLUGIN_REFRESH_TIMES = new int[]{0, 50, 100, 250, 500, 1000};
    private static final int[] VIEWPORT_RATES = new int[]{-1, 0, 5, 10, 20, 30, 50, 60, 70, 75, 85, 100, 120};
    private static final int DEFAULT_VIEWPORT_RATE = -1;
    private ObserverCenterWindow mainwindow;
    private IObserverCenterPlugin activeplugin;
    private List<IObserverCenterPlugin> plugins;
    private Timer vptimer;
    private Timer plugintimer;
    private ClassLoader classloader;
    private Map externaldataviews;
    private String selecteddataviewname;
    private Map<String, IPerspective> perspectives;
    private IPerspective selectedperspective;
    private AbstractEnvironmentSpace space;
    protected List selectedObjectListeners;
    protected IChangeListener clocklistener;
    protected boolean killonexit;
    protected IClockService clock;
    protected boolean disposed;

    @Override
    public void startObserver(final String title, IEnvironmentSpace space, ClassLoader classloader, boolean killonexit) {
        this.plugins = new ArrayList<IObserverCenterPlugin>();
        this.selectedObjectListeners = Collections.synchronizedList(new ArrayList());
        this.space = (AbstractEnvironmentSpace)space;
        this.killonexit = killonexit;
        this.perspectives = Collections.synchronizedMap(new HashMap());
        this.externaldataviews = Collections.synchronizedMap(new HashMap());
        this.classloader = classloader;
        Map spaceviews = space.getDataViews();
        if (!spaceviews.isEmpty()) {
            this.selecteddataviewname = (String)spaceviews.keySet().iterator().next();
        }
        this.activeplugin = null;
        SServiceProvider.getService((IExternalAccess)space.getExternalAccess(), IClockService.class, (String)"platform").addResultListener((IResultListener)new DefaultResultListener<IClockService>(){

            public void resultAvailable(IClockService result) {
                ObserverCenter.this.clock = result;
            }
        });
        Runnable init = new Runnable(){

            @Override
            public void run() {
                if (ObserverCenter.this.disposed) {
                    return;
                }
                ObserverCenter.this.mainwindow = new ObserverCenterWindow(title);
                JMenu refreshMenu = new JMenu("Display");
                JMenu pluginMenu = new JMenu("Plugin Refresh");
                ButtonGroup group = new ButtonGroup();
                for (int i = 0; i < PLUGIN_REFRESH_TIMES.length; ++i) {
                    JRadioButtonMenuItem item = new JRadioButtonMenuItem(new PluginRefreshAction(PLUGIN_REFRESH_TIMES[i]));
                    if (PLUGIN_REFRESH_TIMES[i] == 100) {
                        item.setSelected(true);
                    }
                    group.add(item);
                    pluginMenu.add(item);
                }
                refreshMenu.add(pluginMenu);
                ObserverCenter.this.vptimer = new Timer(33, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ObserverCenter.this.updateDisplay();
                    }
                });
                ObserverCenter.this.clocklistener = new IChangeListener(){
                    boolean repainting = false;

                    public void changeOccurred(jadex.commons.ChangeEvent event) {
                        if (!this.repainting && "next_timepoint".equals(event.getType())) {
                            this.repainting = true;
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    repainting = false;
                                    ObserverCenter.this.updateDisplay();
                                }
                            });
                        }
                    }
                };
                JMenu viewportMenu = new JMenu("Viewport Refresh");
                group = new ButtonGroup();
                for (int i = 0; i < VIEWPORT_RATES.length; ++i) {
                    JRadioButtonMenuItem item = new JRadioButtonMenuItem(new ViewportRefreshAction(VIEWPORT_RATES[i]));
                    if (VIEWPORT_RATES[i] == -1) {
                        item.setSelected(true);
                        item.getAction().actionPerformed(null);
                    }
                    group.add(item);
                    viewportMenu.add(item);
                }
                refreshMenu.add(viewportMenu);
                ObserverCenter.this.mainwindow.addMenu(refreshMenu);
                ObserverCenter.this.plugintimer = new Timer(100, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        IObserverCenterPlugin apl = ObserverCenter.this.activeplugin;
                        if (apl != null) {
                            apl.refresh();
                        }
                    }
                });
                ObserverCenter.this.plugintimer.start();
                ObserverCenter.this.mainwindow.addWindowListener(new ObserverWindowController());
                ObserverCenter.this.mainwindow.addWindowStateListener(new WindowStateListener(){

                    @Override
                    public void windowStateChanged(WindowEvent e) {
                        IPerspective p = ObserverCenter.this.getSelectedPerspective();
                        if (p instanceof Perspective2D) {
                            ((Perspective2D)p).getViewport().refreshCanvasSize();
                        }
                    }
                });
            }
        };
        if (EventQueue.isDispatchThread()) {
            init.run();
        } else {
            EventQueue.invokeLater(init);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataView(String name, IDataView dataview) {
        Map map = this.externaldataviews;
        synchronized (map) {
            this.externaldataviews.put(name, dataview);
            if (this.selecteddataviewname == null) {
                this.selecteddataviewname = name;
            }
        }
    }

    public Map getDataViews() {
        HashMap allViews = new HashMap();
        allViews.putAll(this.externaldataviews);
        allViews.putAll(this.space.getDataViews());
        return allViews;
    }

    @Override
    public IDataView getSelectedDataView() {
        IDataView dataview = this.space.getDataView(this.selecteddataviewname);
        if (dataview == null) {
            dataview = (IDataView)this.externaldataviews.get(this.selecteddataviewname);
        }
        return dataview;
    }

    public String getSelectedDataViewName() {
        return this.selecteddataviewname;
    }

    public void setSelectedDataView(String name) {
        this.selecteddataviewname = name;
        this.selectedperspective.setSelectedObject(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IFuture<Void> addPerspective(final String name, final IPerspective perspective) {
        final Future ret = new Future();
        if (SwingUtilities.isEventDispatchThread()) {
            Exception e = null;
            Map<String, IPerspective> map = this.perspectives;
            synchronized (map) {
                try {
                    perspective.setObserverCenter(this);
                    perspective.setName(name);
                    this.perspectives.put(name, perspective);
                    if (this.perspectives.size() == 1) {
                        this.setSelectedPerspective(name);
                    }
                }
                catch (Exception ex) {
                    e = ex;
                }
            }
            if (e != null) {
                ret.setException(e);
            } else {
                ret.setResult(null);
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Exception e = null;
                    Map map = ObserverCenter.this.perspectives;
                    synchronized (map) {
                        try {
                            perspective.setObserverCenter(ObserverCenter.this);
                            perspective.setName(name);
                            ObserverCenter.this.perspectives.put(name, perspective);
                            if (ObserverCenter.this.perspectives.size() == 1) {
                                ObserverCenter.this.setSelectedPerspective(name);
                            }
                        }
                        catch (Exception ex) {
                            e = ex;
                        }
                    }
                    if (e != null) {
                        ret.setException(e);
                    } else {
                        ret.setResult(null);
                    }
                }
            });
        }
        return ret;
    }

    public Map getPerspectives() {
        return this.perspectives;
    }

    public IPerspective getSelectedPerspective() {
        return this.selectedperspective;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedPerspective(final String name) {
        if (SwingUtilities.isEventDispatchThread()) {
            IPerspective perspective;
            IPerspective selp = null;
            Map<String, IPerspective> map = this.perspectives;
            synchronized (map) {
                selp = this.getSelectedPerspective();
            }
            if (selp != null && selp instanceof Perspective3D) {
                ((Perspective3D)selp).getViewport().pauseApp();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if ((perspective = this.perspectives.get(name)) instanceof Perspective2D) {
                ((Perspective2D)perspective).flushRenderInfo();
            }
            perspective.setObserverCenter(this);
            this.selectedperspective = perspective;
            this.mainwindow.setPerspectiveView(perspective.getView());
            perspective.setSelectedObject(null);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Map map = ObserverCenter.this.perspectives;
                    synchronized (map) {
                        System.out.println("------------------------RUNNABLE C_HANGE---------------------");
                        IPerspective perspective = (IPerspective)ObserverCenter.this.perspectives.get(name);
                        perspective.setObserverCenter(ObserverCenter.this);
                        ObserverCenter.this.selectedperspective = perspective;
                        ObserverCenter.this.mainwindow.setPerspectiveView(perspective.getView());
                        perspective.setSelectedObject(null);
                    }
                }
            });
        }
    }

    public void setOpenGLMode(final String name, final boolean opengl) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Map map = ObserverCenter.this.perspectives;
                synchronized (map) {
                    Perspective2D p;
                    IPerspective perspective = (IPerspective)ObserverCenter.this.perspectives.get(name);
                    double z = 1.0;
                    IVector2 ps = null;
                    if (perspective instanceof Perspective2D) {
                        p = (Perspective2D)perspective;
                        z = p.getZoom();
                        ps = p.getViewport().getPosition();
                    }
                    perspective.setOpenGl(opengl);
                    if (name.equals(ObserverCenter.this.selectedperspective.getName())) {
                        ObserverCenter.this.mainwindow.setPerspectiveView(ObserverCenter.this.selectedperspective.getView());
                        ObserverCenter.this.selectedperspective.reset();
                    }
                    if (perspective instanceof Perspective2D) {
                        p = (Perspective2D)perspective;
                        final IVector2 pos = ps;
                        final double zoom = z;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                p.setZoom(zoom);
                                p.getViewport().setPosition(pos);
                            }
                        });
                    }
                }
            }
        });
    }

    @Override
    public AbstractEnvironmentSpace getSpace() {
        return this.space;
    }

    public void addSelectedObjectListener(ChangeListener listener) {
        this.selectedObjectListeners.add(listener);
    }

    public void removeSelectedObjectListener(ChangeListener listener) {
        this.selectedObjectListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireSelectedObjectChange() {
        List list = this.selectedObjectListeners;
        synchronized (list) {
            for (ChangeListener l : this.selectedObjectListeners) {
                l.stateChanged(new ChangeEvent(this));
            }
        }
    }

    @Override
    public void loadPlugins(final List customplugins) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.internalLoadPlugins(customplugins);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ObserverCenter.this.internalLoadPlugins(customplugins);
                }
            });
        }
    }

    protected void internalLoadPlugins(List customplugins) {
        int i;
        IObserverCenterPlugin plugin = new IntrospectorPlugin();
        this.plugins.add(plugin);
        plugin = new VisualsPlugin();
        this.plugins.add(plugin);
        if (customplugins != null) {
            this.plugins.addAll(customplugins);
        }
        for (i = 0; i < this.plugins.size(); ++i) {
            this.addPluginButton(this.plugins.get(i));
        }
        if (this.plugins.size() > 0) {
            for (i = 1; i < this.plugins.size(); ++i) {
                if (!this.plugins.get(i).isStartOnLoad()) continue;
                this.activatePlugin(this.plugins.get(i));
            }
            this.activatePlugin(this.plugins.get(0));
        }
    }

    private void addPluginButton(IObserverCenterPlugin plugin) {
        if (!plugin.isVisible()) {
            return;
        }
        String iconPath = plugin.getIconPath();
        if (iconPath == null) {
            this.mainwindow.addToolbarItem(plugin.getName(), new PluginAction(plugin));
        } else {
            try {
                BufferedImage image = ImageIO.read(this.classloader.getResource(iconPath));
                ImageIcon icon = new ImageIcon(image);
                this.mainwindow.addToolbarItem(plugin.getName(), icon, new PluginAction(plugin));
            }
            catch (Exception e) {
                System.err.println("Icon image " + iconPath + " not found.");
                this.mainwindow.addToolbarItem(plugin.getName(), new PluginAction(plugin));
            }
        }
    }

    private void activatePlugin(IObserverCenterPlugin plugin) {
        IObserverCenterPlugin oldPlugin = this.activeplugin;
        if (oldPlugin != null && !oldPlugin.isStartOnLoad()) {
            oldPlugin.shutdown();
        }
        if (plugin.isVisible()) {
            this.mainwindow.setPluginView(plugin.getName(), plugin.getView());
        }
        plugin.start(this);
        this.activeplugin = plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDisplay() {
        Map<String, IPerspective> map = this.perspectives;
        synchronized (map) {
            if (this.selectedperspective != null) {
                this.selectedperspective.refresh();
            }
        }
    }

    @Override
    public void dispose() {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        if (this.plugintimer != null) {
            this.plugintimer.stop();
        }
        for (IPerspective persp : this.perspectives.values()) {
            if (persp instanceof Perspective2D) {
                ((Perspective2D)persp).getViewport().dispose();
                continue;
            }
            if (!(persp instanceof Perspective3D)) continue;
            ((Perspective3D)persp).getViewport().stopApp();
        }
        if (this.clocklistener != null) {
            this.clock.removeChangeListener(this.clocklistener);
        }
        if (this.vptimer != null) {
            this.vptimer.stop();
        }
        if (this.plugintimer != null) {
            this.plugintimer.stop();
        }
        if (this.mainwindow != null) {
            this.mainwindow.dispose();
        }
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classloader;
    }

    private class ObserverWindowController
    implements WindowListener {
        private ObserverWindowController() {
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowClosed(WindowEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            ObserverCenter.this.dispose();
            if (ObserverCenter.this.killonexit) {
                SServiceProvider.getService((IExternalAccess)ObserverCenter.this.space.getExternalAccess(), IComponentManagementService.class, (String)"platform").addResultListener((IResultListener)new SwingDefaultResultListener(ObserverCenter.this.mainwindow){

                    public void customResultAvailable(Object result) {
                        IComponentManagementService cms = (IComponentManagementService)result;
                        cms.destroyComponent(ObserverCenter.this.space.getExternalAccess().getComponentIdentifier());
                    }
                });
            }
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }
    }

    private class ViewportRefreshAction
    extends AbstractAction {
        private int delay;

        public ViewportRefreshAction(int fps) {
            if (fps == -1) {
                this.delay = -1;
                this.putValue("Name", "Sync on Clock");
            } else if (fps == 0) {
                this.delay = 0;
                this.putValue("Name", "Off");
            } else {
                this.delay = 1000 / fps;
                this.putValue("Name", Integer.toString(fps) + " FPS");
            }
        }

        @Override
        public void actionPerformed(final ActionEvent event) {
            if (this.delay == -1) {
                SServiceProvider.getService((IExternalAccess)ObserverCenter.this.space.getExternalAccess(), IClockService.class, (String)"platform").addResultListener((IResultListener)new SwingDefaultResultListener(ObserverCenter.this.mainwindow){

                    public void customResultAvailable(Object result) {
                        ObserverCenter.this.vptimer.stop();
                        IClockService clock = (IClockService)result;
                        clock.addChangeListener(ObserverCenter.this.clocklistener);
                    }

                    public void customExceptionOccurred(Exception exception) {
                        if (event != null) {
                            super.customExceptionOccurred(exception);
                        }
                    }
                });
            } else if (this.delay == 0) {
                SServiceProvider.getService((IExternalAccess)ObserverCenter.this.space.getExternalAccess(), IClockService.class, (String)"platform").addResultListener((IResultListener)new SwingDefaultResultListener(ObserverCenter.this.mainwindow){

                    public void customResultAvailable(Object result) {
                        ObserverCenter.this.vptimer.stop();
                        IClockService clock = (IClockService)result;
                        clock.removeChangeListener(ObserverCenter.this.clocklistener);
                    }

                    public void customExceptionOccurred(Exception exception) {
                        if (event != null) {
                            super.customExceptionOccurred(exception);
                        }
                    }
                });
            } else {
                SServiceProvider.getService((IExternalAccess)ObserverCenter.this.space.getExternalAccess(), IClockService.class, (String)"platform").addResultListener((IResultListener)new SwingDefaultResultListener(ObserverCenter.this.mainwindow){

                    public void customResultAvailable(Object result) {
                        IClockService clock = (IClockService)result;
                        clock.removeChangeListener(ObserverCenter.this.clocklistener);
                        ObserverCenter.this.vptimer.setDelay(ViewportRefreshAction.this.delay);
                        ObserverCenter.this.vptimer.start();
                    }

                    public void customExceptionOccurred(Exception exception) {
                        if (event != null) {
                            super.customExceptionOccurred(exception);
                        }
                    }
                });
            }
        }
    }

    private class PluginRefreshAction
    extends AbstractAction {
        private int time_;

        public PluginRefreshAction(int time) {
            this.time_ = time;
            if (this.time_ <= 0) {
                this.putValue("Name", "Never");
            } else {
                this.putValue("Name", Integer.toString(this.time_) + "ms");
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ObserverCenter.this.plugintimer.stop();
            if (this.time_ > 0) {
                ObserverCenter.this.plugintimer.setDelay(this.time_);
                ObserverCenter.this.plugintimer.start();
            }
        }
    }

    private class PluginAction
    extends AbstractAction {
        private IObserverCenterPlugin plugin;

        public PluginAction(IObserverCenterPlugin plugin) {
            this.plugin = plugin;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ObserverCenter.this.activatePlugin(this.plugin);
        }
    }
}

