/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.envsupport.observer.gui;

import jadex.commons.gui.SGUI;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class ObserverCenterWindow
extends JFrame {
    private JMenuBar menubar;
    private JToolBar toolbar;
    protected JPanel mainpanel;
    private JSplitPane splitpane;
    protected Set knownpluginviews = new HashSet();
    protected boolean disposed;
    protected boolean fullscreen = false;
    protected Dimension olddim;
    protected Point oldpos;
    protected Component oldcomp;
    protected int olddivider;
    protected KeyListener fullscreenlistener;

    public ObserverCenterWindow(String title) {
        super(title);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (!ObserverCenterWindow.this.disposed) {
                    ObserverCenterWindow.this.menubar = new JMenuBar();
                    ObserverCenterWindow.this.setJMenuBar(ObserverCenterWindow.this.menubar);
                    ObserverCenterWindow.this.mainpanel = new JPanel(new BorderLayout());
                    ObserverCenterWindow.this.toolbar = new JToolBar("Toolbar", 0);
                    ObserverCenterWindow.this.mainpanel.add((Component)ObserverCenterWindow.this.toolbar, "North");
                    ObserverCenterWindow.this.splitpane = new JSplitPane(1, true);
                    ObserverCenterWindow.this.splitpane.setOneTouchExpandable(true);
                    JPanel pluginpanel = new JPanel(new CardLayout());
                    ObserverCenterWindow.this.splitpane.setLeftComponent(pluginpanel);
                    JPanel perspectivepanel = new JPanel(new CardLayout());
                    ObserverCenterWindow.this.splitpane.setRightComponent(perspectivepanel);
                    ObserverCenterWindow.this.mainpanel.add((Component)ObserverCenterWindow.this.splitpane, "Center");
                    ObserverCenterWindow.this.getContentPane().add((Component)ObserverCenterWindow.this.mainpanel, "Center");
                    ObserverCenterWindow.this.setResizable(true);
                    ObserverCenterWindow.this.setBackground(null);
                    ObserverCenterWindow.this.pack();
                    ObserverCenterWindow.this.setSize(800, 600);
                    ObserverCenterWindow.this.setLocation(SGUI.calculateMiddlePosition((Window)ObserverCenterWindow.this));
                    ObserverCenterWindow.this.setVisible(true);
                    ObserverCenterWindow.this.splitpane.setDividerLocation(250);
                    ObserverCenterWindow.this.fullscreenlistener = new KeyAdapter(){

                        @Override
                        public void keyPressed(KeyEvent e) {
                            if (e.getKeyCode() == 122) {
                                ObserverCenterWindow.this.makeFullscreen();
                            }
                        }
                    };
                }
            }
        };
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            EventQueue.invokeLater(runnable);
        }
    }

    public void makeFullscreen() {
        WindowListener[] wls;
        boolean fs = this.oldcomp == null;
        this.menubar.setVisible(!fs);
        this.splitpane.setVisible(!fs);
        this.toolbar.setVisible(!fs);
        for (WindowListener wl : wls = this.getWindowListeners()) {
            this.removeWindowListener(wl);
        }
        if (fs) {
            this.oldpos = this.getLocation();
            this.olddim = this.getSize();
            this.oldcomp = this.splitpane.getRightComponent();
            this.olddivider = this.splitpane.getDividerLocation();
            this.splitpane.remove(this.oldcomp);
            this.mainpanel.add(this.oldcomp, "Center");
            this.dispose();
            this.disposed = false;
            this.setUndecorated(true);
            this.setVisible(true);
            this.setLocation(0, 0);
            this.setSize(Toolkit.getDefaultToolkit().getScreenSize());
        } else {
            this.splitpane.setRightComponent(this.oldcomp);
            this.mainpanel.remove(this.oldcomp);
            this.mainpanel.add((Component)this.splitpane, "Center");
            this.dispose();
            this.disposed = false;
            this.setUndecorated(false);
            this.setVisible(true);
            this.setLocation(this.oldpos);
            this.setSize(this.olddim);
            this.splitpane.setDividerLocation(this.olddivider);
            this.oldcomp = null;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (WindowListener wl : wls) {
                    ObserverCenterWindow.this.addWindowListener(wl);
                }
            }
        });
    }

    @Override
    public void dispose() {
        this.disposed = true;
        super.dispose();
    }

    public void addMenu(JMenu menu) {
        this.menubar.add(menu);
    }

    public void removeMenu(JMenu menu) {
        this.menubar.remove(menu);
    }

    public void addToolbarItem(String name, Action action) {
        JButton button = new JButton(action);
        button.setText(name);
        this.toolbar.add(button);
    }

    public void addToolbarItem(String name, Icon icon, Action action) {
        JButton button = new JButton(action);
        button.setIcon(icon);
        button.setToolTipText(name);
        this.toolbar.add(button);
    }

    public void setPluginView(String pluginname, Component view) {
        if (view == null) {
            return;
        }
        JPanel pluginpanel = (JPanel)this.splitpane.getLeftComponent();
        CardLayout cl = (CardLayout)pluginpanel.getLayout();
        if (!this.knownpluginviews.contains(pluginname)) {
            this.knownpluginviews.add(pluginname);
            pluginpanel.add(view, pluginname);
        }
        cl.show(pluginpanel, pluginname);
    }

    public void setPerspectiveView(Component view) {
        int loc = this.splitpane.getDividerLocation();
        Component oldview = this.splitpane.getRightComponent();
        if (oldview != null) {
            oldview.removeKeyListener(this.fullscreenlistener);
        }
        this.splitpane.setRightComponent(view);
        view.addKeyListener(this.fullscreenlistener);
        this.splitpane.setDividerLocation(loc);
    }

    public boolean isFullscreen() {
        return this.fullscreen;
    }

    public void setFullscreen(boolean fullscreen) {
        this.fullscreen = fullscreen;
    }
}

