/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.envsupport.observer.gui;

import jadex.commons.IPropertyObject;
import jadex.commons.IValueFetcher;
import jadex.commons.beans.BeanInfo;
import jadex.commons.beans.IntrospectionException;
import jadex.commons.beans.Introspector;
import jadex.commons.beans.PropertyDescriptor;
import jadex.extension.envsupport.environment.ISpaceObject;
import jadex.javaparser.IParsedExpression;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;

public class SObjectInspector {
    public static Object getId(Object obj) {
        if (obj instanceof ISpaceObject) {
            return ((ISpaceObject)obj).getId();
        }
        Object ret = SObjectInspector.getProperty(obj, "id");
        if (ret == null) {
            ret = SObjectInspector.getProperty(obj, "name");
        }
        if (ret == null) {
            ret = obj.toString();
        }
        return ret;
    }

    public static Object getType(Object obj) {
        if (obj instanceof ISpaceObject) {
            return ((ISpaceObject)obj).getType();
        }
        Object ret = SObjectInspector.getProperty(obj, "type");
        if (ret == null) {
            ret = obj.getClass().getName();
        }
        return ret;
    }

    public static Set getPropertyNames(Object obj) {
        if (obj instanceof IPropertyObject) {
            return ((IPropertyObject)obj).getPropertyNames();
        }
        HashSet<String> ret = new HashSet<String>();
        try {
            BeanInfo info = Introspector.getBeanInfo(obj.getClass());
            PropertyDescriptor[] descs = info.getPropertyDescriptors();
            for (int i = 0; i < descs.length; ++i) {
                ret.add(descs[i].getName());
            }
        }
        catch (IntrospectionException introspectionException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return ret;
    }

    public static Object getProperty(Object obj, String name) {
        return SObjectInspector.getProperty(obj, name, "$object");
    }

    public static Object getProperty(Object obj, String name, String objname) {
        return SObjectInspector.getProperty(obj, name, objname, null);
    }

    public static Object getProperty(Object obj, String name, String objname, IValueFetcher fetcher) {
        Object ret = null;
        if (obj instanceof IPropertyObject) {
            ret = ((IPropertyObject)obj).getProperty(name);
        }
        if (ret == null) {
            try {
                BeanInfo info = Introspector.getBeanInfo(obj.getClass());
                PropertyDescriptor[] descs = info.getPropertyDescriptors();
                for (int i = 0; i < descs.length; ++i) {
                    if (!descs[i].getName().equals(name)) continue;
                    Method getter = descs[i].getReadMethod();
                    return getter.invoke(obj, (Object[])null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (ret instanceof IParsedExpression) {
            ret = ((IParsedExpression)ret).getValue(fetcher);
        }
        return ret;
    }
}

