/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.envsupport.observer.gui.plugin;

import jadex.commons.SUtil;
import jadex.extension.envsupport.math.Vector2Double;
import jadex.extension.envsupport.observer.gui.ObserverCenter;
import jadex.extension.envsupport.observer.gui.plugin.IObserverCenterPlugin;
import jadex.extension.envsupport.observer.perspective.IPerspective;
import jadex.extension.envsupport.observer.perspective.Perspective2D;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;

public class VisualsPlugin
implements IObserverCenterPlugin {
    private static final String NAME = "Visuals";
    private JSplitPane mainPane = new JSplitPane();
    private JTable perspectivelist;
    private JList dataviewlist;
    private JSpinner zoomSpinner;
    private JCheckBox invertXBox;
    private JCheckBox invertYBox;
    private ObserverCenter observerCenter_;
    private ListSelectionListener perspectiveController_;
    private ListSelectionListener dataviewController_;

    public VisualsPlugin() {
        this.mainPane.setOrientation(0);
        this.mainPane.setOneTouchExpandable(true);
        this.mainPane.setDividerLocation(160);
        this.mainPane.setResizeWeight(0.5);
        this.mainPane.setMinimumSize(new Dimension(50, 400));
        JSplitPane persViewPane = new JSplitPane();
        persViewPane.setOrientation(0);
        persViewPane.setOneTouchExpandable(true);
        persViewPane.setDividerLocation(80);
        persViewPane.setResizeWeight(0.5);
        this.mainPane.setTopComponent(persViewPane);
        JPanel perspectivePanel = new JPanel(new GridBagLayout());
        perspectivePanel.setBorder(new TitledBorder("Perspective"));
        persViewPane.setTopComponent(perspectivePanel);
        DefaultTableModel perspectiveModel = new DefaultTableModel(new String[]{"Perspective", "OpenGL"}, 0){

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                if (columnIndex == 1) {
                    return Boolean.class;
                }
                return super.getColumnClass(columnIndex);
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 1;
            }
        };
        perspectiveModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (e.getColumn() == 1) {
                    int row = VisualsPlugin.this.perspectivelist.getSelectedRow();
                    String selection = null;
                    if (row != -1) {
                        selection = (String)((DefaultTableModel)VisualsPlugin.this.perspectivelist.getModel()).getValueAt(row, 0);
                    }
                    if (selection != null) {
                        Boolean opengl = (Boolean)((DefaultTableModel)VisualsPlugin.this.perspectivelist.getModel()).getValueAt(row, 1);
                        VisualsPlugin.this.observerCenter_.setOpenGLMode(selection, opengl);
                    }
                }
            }
        });
        this.perspectivelist = new JTable(perspectiveModel);
        this.perspectivelist.setSelectionModel(new DefaultListSelectionModel());
        JScrollPane perspectiveScrollPane = new JScrollPane(this.perspectivelist);
        this.perspectiveController_ = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int row = VisualsPlugin.this.perspectivelist.getSelectedRow();
                String selection = null;
                if (row != -1) {
                    selection = (String)((DefaultTableModel)VisualsPlugin.this.perspectivelist.getModel()).getValueAt(row, 0);
                }
                if (selection != null) {
                    VisualsPlugin.this.observerCenter_.setSelectedPerspective(selection);
                }
            }
        };
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.anchor = 10;
        c.fill = 1;
        perspectivePanel.add((Component)perspectiveScrollPane, c);
        JPanel dataviewPanel = new JPanel(new GridBagLayout());
        dataviewPanel.setBorder(new TitledBorder("Dataview"));
        persViewPane.setBottomComponent(dataviewPanel);
        this.dataviewlist = new JList(new DefaultComboBoxModel());
        JScrollPane dataviewScrollPane = new JScrollPane(this.dataviewlist);
        this.dataviewController_ = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                String selection = (String)VisualsPlugin.this.dataviewlist.getSelectedValue();
                VisualsPlugin.this.observerCenter_.setSelectedDataView(selection);
            }
        };
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.anchor = 11;
        c.fill = 1;
        dataviewPanel.add((Component)dataviewScrollPane, c);
        JPanel controlPanel = new JPanel(new GridBagLayout());
        controlPanel.setBorder(new TitledBorder("Controls"));
        this.mainPane.setBottomComponent(controlPanel);
        JPanel movePanel = new JPanel(new GridBagLayout());
        String baseImgLoc = "/jadex/extension/envsupport/observer/images/";
        String[] moveImgNames = new String[]{"arrow_up.png", "arrow_right.png", "arrow_down.png", "arrow_left.png", "x_small.png"};
        int[] moveButtonPos = new int[]{1, 2, 1, 0};
        for (int i = 0; i < 5; ++i) {
            JButton b = new JButton();
            c = new GridBagConstraints();
            if (i < 4) {
                c.gridx = moveButtonPos[i];
                c.gridy = moveButtonPos[(i + 3) % 4];
                final Vector2Double direction = new Vector2Double(i == 1 || i == 3 ? 0.1 : 0.0, i == 0 || i == 2 ? 0.1 : 0.0);
                if ((i & 2) != 0) {
                    direction.negate();
                }
                b.setAction(new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        IPerspective p = VisualsPlugin.this.observerCenter_.getSelectedPerspective();
                        if (p instanceof Perspective2D) {
                            Perspective2D pers = (Perspective2D)p;
                            pers.shiftPosition(direction.copy());
                        }
                    }
                });
            } else if (i == 4) {
                c.gridx = 1;
                c.gridy = 1;
                b.setAction(new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        IPerspective p = VisualsPlugin.this.observerCenter_.getSelectedPerspective();
                        if (p instanceof Perspective2D) {
                            p.resetZoomAndPosition();
                        }
                    }
                });
            }
            try {
                b.setIcon(new ImageIcon(ImageIO.read(SUtil.getResource((String)(baseImgLoc + moveImgNames[i]), (ClassLoader)this.getClass().getClassLoader()))));
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            b.setBorderPainted(false);
            b.setContentAreaFilled(false);
            c.weighty = 0.0;
            c.weightx = 0.0;
            c.anchor = 10;
            c.fill = 0;
            movePanel.add((Component)b, c);
        }
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.ipady = 10;
        c.anchor = 11;
        c.fill = 0;
        controlPanel.add((Component)movePanel, c);
        JPanel zoomPanel = new JPanel(new GridBagLayout());
        c.gridx = 0;
        c.gridy = 1;
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.anchor = 11;
        c.fill = 0;
        controlPanel.add((Component)zoomPanel, c);
        JLabel zoomDesc = new JLabel("Zoom");
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.ipadx = 30;
        c.anchor = 11;
        c.fill = 0;
        zoomPanel.add((Component)zoomDesc, c);
        this.zoomSpinner = new JSpinner(new SpinnerNumberModel(1.0, 0.1, 20.0, 0.0));
        this.zoomSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                IPerspective p = VisualsPlugin.this.observerCenter_.getSelectedPerspective();
                if (p instanceof Perspective2D) {
                    Perspective2D pers = (Perspective2D)p;
                    double newVal = (Double)VisualsPlugin.this.zoomSpinner.getValue();
                    pers.setZoom(newVal);
                }
            }
        });
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.anchor = 11;
        c.fill = 0;
        zoomPanel.add((Component)this.zoomSpinner, c);
        JPanel invertPanel = new JPanel(new GridBagLayout());
        c.gridx = 0;
        c.gridy = 2;
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.anchor = 11;
        c.fill = 0;
        controlPanel.add((Component)invertPanel, c);
        this.invertXBox = new JCheckBox(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IPerspective p = VisualsPlugin.this.observerCenter_.getSelectedPerspective();
                if (p instanceof Perspective2D) {
                    Perspective2D pers = (Perspective2D)p;
                    pers.setInvertXAxis(VisualsPlugin.this.invertXBox.isSelected());
                }
            }
        });
        this.invertXBox.setText("X-Axis Inversion");
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.anchor = 11;
        c.fill = 0;
        invertPanel.add((Component)this.invertXBox, c);
        this.invertYBox = new JCheckBox(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IPerspective p = VisualsPlugin.this.observerCenter_.getSelectedPerspective();
                if (p instanceof Perspective2D) {
                    Perspective2D pers = (Perspective2D)p;
                    pers.setInvertYAxis(VisualsPlugin.this.invertYBox.isSelected());
                }
            }
        });
        this.invertYBox.setText("Y-Axis Inversion");
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.anchor = 11;
        c.fill = 0;
        invertPanel.add((Component)this.invertYBox, c);
        JPanel dummy = new JPanel();
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 2;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.anchor = 11;
        c.fill = 1;
        controlPanel.add((Component)dummy, c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(ObserverCenter main) {
        Map dataviews;
        Map perspectives;
        this.observerCenter_ = main;
        Map map = perspectives = this.observerCenter_.getPerspectives();
        synchronized (map) {
            Set themeNames = perspectives.entrySet();
            for (Map.Entry entry : themeNames) {
                String name = (String)entry.getKey();
                Boolean opengl = ((IPerspective)entry.getValue()).getOpenGl();
                ((DefaultTableModel)this.perspectivelist.getModel()).addRow(new Object[]{name, opengl});
            }
            String perspname = this.observerCenter_.getSelectedPerspective().getName();
            int row = 0;
            while (!this.perspectivelist.getValueAt(row, 0).equals(perspname)) {
                ++row;
            }
            this.perspectivelist.getSelectionModel().setSelectionInterval(row, row);
        }
        this.perspectivelist.getSelectionModel().addListSelectionListener(this.perspectiveController_);
        Map map2 = dataviews = this.observerCenter_.getDataViews();
        synchronized (map2) {
            Set dataviewnames = dataviews.keySet();
            for (String name : dataviewnames) {
                ((DefaultComboBoxModel)this.dataviewlist.getModel()).addElement(name);
            }
        }
        this.dataviewlist.addListSelectionListener(this.dataviewController_);
        this.refresh();
    }

    @Override
    public void shutdown() {
        this.perspectivelist.getSelectionModel().removeListSelectionListener(this.perspectiveController_);
        while (((DefaultTableModel)this.perspectivelist.getModel()).getRowCount() > 0) {
            ((DefaultTableModel)this.perspectivelist.getModel()).removeRow(0);
        }
        this.dataviewlist.removeListSelectionListener(this.dataviewController_);
        ((DefaultComboBoxModel)this.dataviewlist.getModel()).removeAllElements();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getIconPath() {
        return this.getClass().getPackage().getName().replaceAll("gui.plugin", "").concat("images.").replaceAll("\\.", "/").concat("visuals_icon.png");
    }

    @Override
    public Component getView() {
        return this.mainPane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        String selection = this.observerCenter_.getSelectedPerspective().getName();
        selection = this.observerCenter_.getSelectedDataViewName();
        Map dataviews = this.observerCenter_.getDataViews();
        this.dataviewlist.removeListSelectionListener(this.dataviewController_);
        ((DefaultComboBoxModel)this.dataviewlist.getModel()).removeAllElements();
        Map map = dataviews;
        synchronized (map) {
            Set dataviewnames = dataviews.keySet();
            for (String name : dataviewnames) {
                ((DefaultComboBoxModel)this.dataviewlist.getModel()).addElement(name);
            }
        }
        this.dataviewlist.setSelectedValue(selection, true);
        this.dataviewlist.addListSelectionListener(this.dataviewController_);
        IPerspective p = this.observerCenter_.getSelectedPerspective();
        if (p instanceof Perspective2D) {
            Perspective2D pers = (Perspective2D)p;
            this.zoomSpinner.setValue(pers.getZoom());
            ((SpinnerNumberModel)this.zoomSpinner.getModel()).setMaximum(Double.valueOf(pers.getZoomLimit()));
            ((SpinnerNumberModel)this.zoomSpinner.getModel()).setStepSize(pers.getZoomStepping());
            this.invertXBox.setSelected(pers.getInvertXAxis());
            this.invertYBox.setSelected(pers.getInvertYAxis());
        }
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public boolean isStartOnLoad() {
        return false;
    }
}

