/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.envsupport.observer.perspective;

import jadex.commons.IValueFetcher;
import jadex.commons.meta.TypedPropertyObject;
import jadex.extension.envsupport.dataview.IDataView;
import jadex.extension.envsupport.environment.AbstractEnvironmentSpace;
import jadex.extension.envsupport.environment.space2d.Space2D;
import jadex.extension.envsupport.math.IVector1;
import jadex.extension.envsupport.math.IVector2;
import jadex.extension.envsupport.math.Vector1Double;
import jadex.extension.envsupport.math.Vector2Double;
import jadex.extension.envsupport.observer.graphics.IViewport;
import jadex.extension.envsupport.observer.graphics.IViewportListener;
import jadex.extension.envsupport.observer.graphics.drawable.DrawableCombiner;
import jadex.extension.envsupport.observer.graphics.drawable.TexturedRectangle;
import jadex.extension.envsupport.observer.graphics.java2d.ViewportJ2D;
import jadex.extension.envsupport.observer.graphics.layer.Layer;
import jadex.extension.envsupport.observer.gui.IObserverCenter;
import jadex.extension.envsupport.observer.gui.SObjectInspector;
import jadex.extension.envsupport.observer.perspective.IPerspective;
import jadex.javaparser.IParsedExpression;
import jadex.javaparser.SimpleValueFetcher;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class Perspective2D
extends TypedPropertyObject
implements IPerspective {
    public static boolean OPENGL = true;
    protected String name;
    protected IObserverCenter obscenter;
    protected IViewport viewport;
    protected SelectionController selectioncontroller;
    protected Object selectedobject;
    protected int selectCycle;
    protected Comparator displayorder;
    protected IVector2 objectShift;
    protected IVector1 selectorDistance;
    protected boolean invertxaxis;
    protected boolean invertyaxis;
    protected boolean tryopengl;
    protected Color bgColor;
    protected Map visuals;
    protected Layer[] prelayers;
    protected Layer[] postlayers;
    protected DrawableCombiner marker;
    protected double zoomlimit = 20.0;
    protected SimpleValueFetcher fetcher;
    private boolean rendering;

    public Perspective2D() {
        super(null);
        this.setBackground(null);
        this.visuals = Collections.synchronizedMap(new HashMap());
        this.prelayers = new Layer[0];
        this.postlayers = new Layer[0];
        this.objectShift = new Vector2Double();
        this.selectorDistance = new Vector1Double(1.0);
        this.selectCycle = 0;
        this.tryopengl = OPENGL;
        this.displayorder = null;
        this.name = this.getClass().getName();
        this.viewport = null;
        this.selectioncontroller = new SelectionController();
    }

    public Object getProperty(String name) {
        Object ret = super.getProperty(name);
        if (ret instanceof IParsedExpression) {
            ret = ((IParsedExpression)ret).getValue((IValueFetcher)this.getFetcher());
        }
        return ret;
    }

    public SimpleValueFetcher getFetcher() {
        if (this.fetcher == null) {
            this.fetcher = new SimpleValueFetcher((IValueFetcher)this.obscenter.getSpace().getFetcher());
            this.fetcher.setValue("$perspective", (Object)this);
        }
        return this.fetcher;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Object getSelectedObject() {
        return this.selectedobject;
    }

    @Override
    public void setSelectedObject(Object obj) {
        this.selectedobject = obj;
        this.obscenter.fireSelectedObjectChange();
    }

    @Override
    public void setObserverCenter(IObserverCenter obscenter) {
        this.obscenter = obscenter;
    }

    @Override
    public IObserverCenter getObserverCenter() {
        return this.obscenter;
    }

    @Override
    public void addVisual(Object id, Object visual) {
        this.visuals.put(id, visual);
    }

    @Override
    public void removeVisual(Object id) {
        this.visuals.remove(id);
    }

    public Layer[] getPrelayers() {
        return this.prelayers;
    }

    public void setPrelayers(Layer[] prelayers) {
        this.prelayers = prelayers;
    }

    public Layer[] getPostlayers() {
        return this.postlayers;
    }

    public void setPostlayers(Layer[] postlayers) {
        this.postlayers = postlayers;
    }

    public DrawableCombiner getMarkerDrawCombiner() {
        return this.marker;
    }

    public void setMarkerDrawCombiner(DrawableCombiner marker) {
        this.marker = marker;
    }

    @Override
    public Component getView() {
        if (this.viewport == null) {
            if (this.marker == null) {
                this.marker = new DrawableCombiner();
                TexturedRectangle markerPrimitive = new TexturedRectangle(this.getClass().getPackage().getName().replaceAll("perspective", "").concat("images.").replaceAll("\\.", "/").concat("selection_marker.png"));
                this.marker.addPrimitive(markerPrimitive, Integer.MAX_VALUE);
            }
            ClassLoader cl = this.obscenter.getClassLoader();
            this.viewport = Perspective2D.createViewport(this, cl, this.bgColor, this.tryopengl);
            AbstractEnvironmentSpace space = this.obscenter.getSpace();
            if (space instanceof Space2D) {
                this.viewport.setAreaSize(((Space2D)space).getAreaSize().copy());
            }
            this.viewport.addViewportListener(this.selectioncontroller);
            this.viewport.setZoomLimit(this.zoomlimit);
        }
        return this.viewport.getCanvas();
    }

    public IViewport getViewport() {
        if (this.viewport == null) {
            this.getView();
        }
        return this.viewport;
    }

    @Override
    public boolean getOpenGl() {
        return this.tryopengl;
    }

    @Override
    public boolean setOpenGl(boolean opengl) {
        this.tryopengl = opengl;
        if (this.viewport != null) {
            this.viewport = null;
            this.getView();
            try {
                if (!Class.forName("jadex.extension.envsupport.observer.graphics.opengl.ViewportJOGL", true, Thread.currentThread().getContextClassLoader()).isInstance(this.viewport)) {
                    return false;
                }
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }
        return true;
    }

    public boolean getInvertXAxis() {
        return this.invertxaxis;
    }

    public void setInvertXAxis(boolean invert) {
        this.invertxaxis = invert;
    }

    public boolean getInvertYAxis() {
        return this.invertyaxis;
    }

    public void setInvertYAxis(boolean invert) {
        this.invertyaxis = invert;
    }

    public void setBackground(Color bgColor) {
        if (bgColor == null) {
            bgColor = UIManager.getColor("Panel.background");
            if (bgColor == null) {
                bgColor = new JPanel().getBackground();
            }
            if (bgColor == null) {
                bgColor = Color.BLACK;
            }
        }
        this.bgColor = bgColor;
        if (this.viewport != null) {
            this.setBackground(bgColor);
        }
    }

    public synchronized void setSelectorDistance(IVector1 maxDist) {
        this.selectorDistance = maxDist;
    }

    public synchronized IVector1 getSelectorDistance() {
        return this.selectorDistance;
    }

    public synchronized Comparator getDisplayOrder() {
        return this.displayorder;
    }

    public synchronized void setDisplayOrder(Comparator order) {
        this.displayorder = order;
    }

    public synchronized IVector2 getObjectShift() {
        return this.objectShift.copy();
    }

    public synchronized void setObjectShift(IVector2 shift) {
        this.objectShift = shift.copy();
    }

    public double getZoomLimit() {
        return this.zoomlimit;
    }

    public void setZoomLimit(double zoomlimit) {
        this.zoomlimit = zoomlimit;
        if (this.viewport != null) {
            this.viewport.setZoomLimit(zoomlimit);
        }
    }

    public double getZoomStepping() {
        return this.viewport.getAreaSize().copy().divide(this.viewport.getSize().copy().multiply(0.9)).getMean().getAsDouble() - this.getZoom();
    }

    public double getZoom() {
        return this.viewport.getAreaSize().copy().divide(this.viewport.getSize()).getMean().getAsDouble();
    }

    public void setZoom(double zoom) {
        IVector2 newSize = this.viewport.getAreaSize().copy().divide(new Vector2Double(zoom));
        IVector2 oldSize = this.viewport.getSize().copy();
        IVector2 pos = this.viewport.getPosition();
        this.viewport.setSize(newSize);
        pos.add(oldSize.subtract(newSize).multiply(0.5));
        this.viewport.setPosition(pos);
    }

    public void shiftPosition(IVector2 shift) {
        if (this.invertxaxis) {
            shift.negateX();
        }
        if (this.invertyaxis) {
            shift.negateY();
        }
        IVector2 pos = this.viewport.getPosition().copy();
        pos.add(this.viewport.getSize().copy().multiply(shift));
        this.viewport.setPosition(pos);
    }

    @Override
    public void reset() {
        this.flushRenderInfo();
        this.resetZoomAndPosition();
    }

    @Override
    public void resetZoomAndPosition() {
        AbstractEnvironmentSpace space = this.obscenter.getSpace();
        if (space instanceof Space2D) {
            IVector2 tmpsize = ((Space2D)space).getAreaSize();
            this.viewport.setAreaSize(tmpsize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushRenderInfo() {
        int i;
        Map map = this.visuals;
        synchronized (map) {
            Iterator it = this.visuals.values().iterator();
            while (it.hasNext()) {
                ((DrawableCombiner)it.next()).flushRenderInfo();
            }
        }
        for (i = 0; i < this.prelayers.length; ++i) {
            this.prelayers[i].flushRenderInfo();
        }
        for (i = 0; i < this.postlayers.length; ++i) {
            this.postlayers[i].flushRenderInfo();
        }
    }

    @Override
    public void refresh() {
        if (!this.rendering) {
            this.rendering = true;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Perspective2D.this.rendering = false;
                    IDataView dataview = Perspective2D.this.obscenter.getSelectedDataView();
                    if (dataview == null) {
                        return;
                    }
                    Perspective2D.this.viewport.setInvertX(Perspective2D.this.invertxaxis);
                    Perspective2D.this.viewport.setInvertY(Perspective2D.this.invertyaxis);
                    Perspective2D.this.viewport.setObjectShift(Perspective2D.this.objectShift);
                    Perspective2D.this.viewport.setPreLayers(Perspective2D.this.prelayers);
                    Perspective2D.this.viewport.setPostLayers(Perspective2D.this.postlayers);
                    Object[] objects = dataview.getObjects();
                    ArrayList<Object[]> objectList = null;
                    objectList = new ArrayList<Object[]>(objects.length + 1);
                    for (int j = 0; j < objects.length; ++j) {
                        Object obj = objects[j];
                        DrawableCombiner d = (DrawableCombiner)Perspective2D.this.visuals.get(SObjectInspector.getType(obj));
                        if (d == null) continue;
                        Object[] viewObj = new Object[]{obj, d};
                        objectList.add(viewObj);
                    }
                    if (Perspective2D.this.selectedobject != null) {
                        DrawableCombiner dc = (DrawableCombiner)Perspective2D.this.visuals.get(SObjectInspector.getType(Perspective2D.this.selectedobject));
                        IVector2 size = (IVector2)dc.getBoundValue(Perspective2D.this.selectedobject, dc.getSize(), Perspective2D.this.viewport);
                        Object[] viewObj = new Object[2];
                        Perspective2D.this.marker.setSize(size);
                        viewObj[0] = Perspective2D.this.selectedobject;
                        viewObj[1] = Perspective2D.this.marker;
                        objectList.add(viewObj);
                    } else {
                        Perspective2D.this.setSelectedObject(null);
                    }
                    if (Perspective2D.this.displayorder != null) {
                        Collections.sort(objectList, Perspective2D.this.displayorder);
                    }
                    Perspective2D.this.viewport.setObjectList(objectList);
                    Perspective2D.this.viewport.refresh();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static final IViewport createViewport(IPerspective persp, ClassLoader cl, Color bgColor, boolean tryopengl) {
        frame = new JFrame("");
        frame.setLayout(new BorderLayout());
        frame.setUndecorated(true);
        frame.pack();
        frame.setSize(1, 1);
        if (tryopengl && Perspective2D.OPENGL) {
            try {
                con = Class.forName("jadex.extension.envsupport.observer.graphics.opengl.ViewportJOGL", true, Thread.currentThread().getContextClassLoader()).getConstructor(new Class[]{IPerspective.class, ClassLoader.class});
                vp = (IViewport)con.newInstance(new Object[]{persp, cl});
                frame.add(vp.getCanvas());
                frame.setVisible(true);
                if (!Boolean.FALSE.equals(vp.getClass().getMethod("isValid", new Class[0]).invoke((Object)vp, new Object[0]))) ** GOTO lbl46
                System.err.println("OpenGL support insufficient, using Java2D fallback...");
                tryopengl = false;
            }
            catch (ClassNotFoundException e) {
                tryopengl = false;
            }
            catch (NoSuchMethodException e) {
                tryopengl = false;
            }
            catch (InvocationTargetException e) {
                tryopengl = false;
            }
            catch (IllegalAccessException e) {
                tryopengl = false;
            }
            catch (InstantiationException e) {
                tryopengl = false;
            }
            catch (RuntimeException e) {
                System.err.println("OpenGL initialization failed, using Java2D fallback...");
                System.err.println(e);
                tryopengl = false;
            }
            catch (Error e) {
                System.err.println("OpenGL initialization failed, using Java2D fallback...");
                System.err.println(e);
                tryopengl = false;
            }
            finally {
                frame.dispose();
            }
        } else {
            frame.dispose();
        }
lbl46:
        // 10 sources

        viewport = null;
        if (tryopengl && Perspective2D.OPENGL) {
            try {
                con = Class.forName("jadex.extension.envsupport.observer.graphics.opengl.ViewportJOGL", true, Thread.currentThread().getContextClassLoader()).getConstructor(new Class[]{IPerspective.class, ClassLoader.class});
                viewport = (IViewport)con.newInstance(new Object[]{persp, cl});
            }
            catch (Exception var6_14) {
                // empty catch block
            }
        }
        if (viewport == null) {
            viewport = new ViewportJ2D(persp, cl);
        }
        viewport.setBackground(bgColor);
        return viewport;
    }

    class SelectionController
    implements IViewportListener {
        SelectionController() {
        }

        @Override
        public void leftClicked(IVector2 position) {
            IDataView dataview = Perspective2D.this.obscenter.getSelectedDataView();
            if (dataview == null) {
                return;
            }
            position = position.copy().subtract(Perspective2D.this.objectShift);
            IVector1 minDist = null;
            LinkedList<Object> closest = new LinkedList<Object>();
            Object[] objects = dataview.getObjects();
            for (int i = 0; i < objects.length; ++i) {
                IVector2 objPos;
                DrawableCombiner dc = (DrawableCombiner)Perspective2D.this.visuals.get(SObjectInspector.getType(objects[i]));
                if (dc == null || (objPos = (IVector2)dc.getBoundValue(objects[i], dc.getPosition(), Perspective2D.this.viewport)) == null) continue;
                if (closest.isEmpty() || position.getDistance(objPos).less(minDist)) {
                    closest.clear();
                    closest.add(objects[i]);
                    minDist = position.getDistance(objPos);
                    continue;
                }
                if (minDist == null || !position.getDistance(objPos).equals(minDist)) continue;
                closest.add(objects[i]);
            }
            if (!closest.isEmpty() && minDist.less(Perspective2D.this.selectorDistance)) {
                ++Perspective2D.this.selectCycle;
                Perspective2D.this.selectCycle %= closest.size();
                Perspective2D.this.setSelectedObject(closest.get(Perspective2D.this.selectCycle));
            }
        }
    }
}

