/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.rs.invoke;

import jadex.extension.rs.invoke.RestResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.util.FileCopyUtils;

public class RestResponseHTTPMessageConverter
extends AbstractHttpMessageConverter {
    public List getSupportedMediaTypes() {
        return Collections.singletonList(MediaType.ALL);
    }

    protected boolean supports(Class clazz) {
        return true;
    }

    protected Object readInternal(Class clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        RestResponse response = new RestResponse();
        HttpHeaders headers = inputMessage.getHeaders();
        response.setContentType(headers.getContentType().toString());
        response.setContentLength(headers.getContentLength());
        response.setDate(headers.getDate());
        long contentLength = headers.getContentLength();
        if (contentLength >= 0L) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream((int)contentLength);
            FileCopyUtils.copy((InputStream)inputMessage.getBody(), (OutputStream)bos);
            response.setTargetByteArray(bos.toByteArray());
        } else {
            response.setTargetByteArray(FileCopyUtils.copyToByteArray((InputStream)inputMessage.getBody()));
        }
        return response;
    }

    protected void writeInternal(Object t, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        if (t instanceof byte[]) {
            outputMessage.getBody().write((byte[])t);
        }
    }
}

