/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.rs.invoke;

import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IComponentStep;
import jadex.bridge.IExternalAccess;
import jadex.bridge.IInternalAccess;
import jadex.bridge.component.IExecutionFeature;
import jadex.bridge.service.annotation.Service;
import jadex.bridge.service.annotation.Value;
import jadex.bridge.service.search.SServiceProvider;
import jadex.bridge.service.types.cms.CreationInfo;
import jadex.bridge.service.types.cms.IComponentManagementService;
import jadex.commons.SUtil;
import jadex.commons.future.DelegationResultListener;
import jadex.commons.future.ExceptionDelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.extension.rs.RSAnnotationHelper;
import jadex.extension.rs.annotations.Consumes;
import jadex.extension.rs.annotations.DELETE;
import jadex.extension.rs.annotations.GET;
import jadex.extension.rs.annotations.HEAD;
import jadex.extension.rs.annotations.OPTIONS;
import jadex.extension.rs.annotations.POST;
import jadex.extension.rs.annotations.PUT;
import jadex.extension.rs.annotations.Path;
import jadex.extension.rs.annotations.Produces;
import jadex.extension.rs.invoke.RestResponse;
import jadex.extension.rs.invoke.RestResponseHTTPMessageConverter;
import jadex.extension.rs.invoke.annotation.ParameterMapper;
import jadex.extension.rs.invoke.annotation.ParameterMappers;
import jadex.extension.rs.invoke.annotation.ParametersInURL;
import jadex.extension.rs.publish.annotation.ParametersMapper;
import jadex.extension.rs.publish.annotation.ResultMapper;
import jadex.extension.rs.publish.mapper.IValueMapper;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.springframework.http.MediaType;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Service
public class RestServiceWrapperInvocationHandlerAndroid
implements InvocationHandler {
    public static String[] defaultimports = new String[]{"jadex.extension.rs.invoke.*", "jadex.extension.rs.invoke.annotation.*", "jadex.extension.rs.invoke.mapper.*"};
    protected IInternalAccess agent;
    protected Class<?> iface;

    public RestServiceWrapperInvocationHandlerAndroid(IInternalAccess agent, Class<?> iface) {
        if (agent == null) {
            throw new IllegalArgumentException("Agent must not null.");
        }
        if (iface == null) {
            throw new IllegalArgumentException("Rest interface must not be null.");
        }
        this.agent = agent;
        this.iface = iface;
    }

    @Override
    public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
        final Future ret = new Future();
        IFuture fut = SServiceProvider.getService((IInternalAccess)this.agent, IComponentManagementService.class, (String)"platform");
        fut.addResultListener(((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new ExceptionDelegationResultListener<IComponentManagementService, Object>(ret){

            public void customResultAvailable(final IComponentManagementService cms) {
                CreationInfo ci = new CreationInfo(RestServiceWrapperInvocationHandlerAndroid.this.agent.getComponentIdentifier());
                cms.createComponent(null, "jadex/extension/rs/invoke/RestServiceInvocationAgent.class", ci, null).addResultListener(((IExecutionFeature)RestServiceWrapperInvocationHandlerAndroid.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new ExceptionDelegationResultListener<IComponentIdentifier, Object>(ret){

                    public void customResultAvailable(IComponentIdentifier cid) {
                        cms.getExternalAccess(cid).addResultListener(((IExecutionFeature)RestServiceWrapperInvocationHandlerAndroid.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new ExceptionDelegationResultListener<IExternalAccess, Object>(ret){

                            public void customResultAvailable(IExternalAccess exta) {
                                exta.scheduleStep((IComponentStep)new IComponentStep<Object>(){

                                    public IFuture<Object> execute(IInternalAccess ia) {
                                        Future re = new Future();
                                        try {
                                            String baseuri = RestServiceWrapperInvocationHandlerAndroid.this.iface.getAnnotation(Path.class).value();
                                            Method m = RestServiceWrapperInvocationHandlerAndroid.this.iface.getMethod(method.getName(), method.getParameterTypes());
                                            Class<?> resttype = RSAnnotationHelper.getDeclaredRestType(m);
                                            String methodname = m.getAnnotation(Path.class).value();
                                            String[] consumes = SUtil.EMPTY_STRING_ARRAY;
                                            if (m.isAnnotationPresent(Consumes.class)) {
                                                consumes = m.getAnnotation(Consumes.class).value();
                                            }
                                            String[] produces = SUtil.EMPTY_STRING_ARRAY;
                                            if (m.isAnnotationPresent(Produces.class)) {
                                                produces = m.getAnnotation(Produces.class).value();
                                            }
                                            Value pmapper = null;
                                            if (m.isAnnotationPresent(ParametersMapper.class)) {
                                                pmapper = m.getAnnotation(ParametersMapper.class).value();
                                            }
                                            ArrayList<Object[]> pmappers = null;
                                            if (pmapper == null) {
                                                pmappers = new ArrayList<Object[]>();
                                                Annotation[][] anoss = m.getParameterAnnotations();
                                                for (int i = 0; i < anoss.length; ++i) {
                                                    Annotation[] anos = anoss[i];
                                                    for (int j = 0; j < anos.length; ++j) {
                                                        if (!(anos[j] instanceof ParameterMapper)) continue;
                                                        pmappers.add(new Object[]{anos[j], new int[]{i}});
                                                    }
                                                }
                                                if (m.isAnnotationPresent(ParameterMapper.class)) {
                                                    ParameterMapper qpm = m.getAnnotation(ParameterMapper.class);
                                                    pmappers.add(new Object[]{qpm, new int[]{-1}});
                                                }
                                                if (m.isAnnotationPresent(ParameterMappers.class)) {
                                                    ParameterMappers qpms = m.getAnnotation(ParameterMappers.class);
                                                    ParameterMapper[] mps = qpms.value();
                                                    for (int i = 0; i < mps.length; ++i) {
                                                        pmappers.add(new Object[]{mps[i], new int[]{-1}});
                                                    }
                                                }
                                            }
                                            Value rmapper = null;
                                            if (m.isAnnotationPresent(ResultMapper.class)) {
                                                rmapper = m.getAnnotation(ResultMapper.class).value();
                                            }
                                            RestTemplate restTemplate = new RestTemplate();
                                            HashMap converterMap = new HashMap();
                                            StringHttpMessageConverter stringConverter = new StringHttpMessageConverter();
                                            ByteArrayHttpMessageConverter byteConverter = new ByteArrayHttpMessageConverter();
                                            ArrayList<MediaType> supportedTypes = new ArrayList<MediaType>();
                                            supportedTypes.add(MediaType.TEXT_PLAIN);
                                            supportedTypes.add(MediaType.TEXT_XML);
                                            stringConverter.setSupportedMediaTypes(supportedTypes);
                                            RestResponseHTTPMessageConverter restResponseConverter = new RestResponseHTTPMessageConverter();
                                            ArrayList<RestResponseHTTPMessageConverter> converters = new ArrayList<RestResponseHTTPMessageConverter>();
                                            converters.add(restResponseConverter);
                                            restTemplate.setMessageConverters(converters);
                                            Object targetparams = args;
                                            if (pmapper != null) {
                                                IValueMapper pm = (IValueMapper)jadex.extension.rs.publish.Value.evaluate((Value)pmapper, (String[])defaultimports);
                                                targetparams = pm.convertValue((Object)args);
                                            } else if (pmappers != null) {
                                                LinkedMultiValueMap mv = new LinkedMultiValueMap();
                                                for (int i = 0; i < pmappers.size(); ++i) {
                                                    Object[] pm = (Object[])pmappers.get(i);
                                                    ParameterMapper qpm = (ParameterMapper)pm[0];
                                                    String name = qpm.value();
                                                    Value val = qpm.mapper();
                                                    int[] src = qpm.source().length > 0 ? qpm.source() : (int[])pm[1];
                                                    IValueMapper mapper = (IValueMapper)jadex.extension.rs.publish.Value.evaluate((Value)val, (String[])defaultimports);
                                                    ArrayList<Object> params = new ArrayList<Object>();
                                                    for (int j = 0; j < src.length; ++j) {
                                                        if (src[j] == -1) continue;
                                                        params.add(args[src[j]]);
                                                    }
                                                    String p = (String)mapper.convertValue(params.size() == 1 ? params.get(0) : params);
                                                    mv.add((Object)name, (Object)p);
                                                }
                                                targetparams = mv;
                                            }
                                            boolean inurl = GET.class.equals(resttype);
                                            if (!inurl && m.isAnnotationPresent(ParametersInURL.class)) {
                                                inurl = m.getAnnotation(ParametersInURL.class).value();
                                            }
                                            if (inurl) {
                                                // empty if block
                                            }
                                            Object res = null;
                                            String uri = RestServiceWrapperInvocationHandlerAndroid.this.buildUri(baseuri, methodname, targetparams);
                                            if (targetparams instanceof Map) {
                                                Map test = (Map)targetparams;
                                                targetparams = RestServiceWrapperInvocationHandlerAndroid.this.convertUriParamsToStringValues((Map)targetparams);
                                            }
                                            RestResponse restResult = new RestResponse();
                                            if (GET.class.equals(resttype)) {
                                                res = restTemplate.getForObject(uri, RestResponse.class, (Map)targetparams);
                                            } else if (POST.class.equals(resttype)) {
                                                res = restTemplate.postForObject(uri, inurl ? null : targetparams, RestResponse.class, new Object[]{targetparams});
                                            } else if (PUT.class.equals(resttype)) {
                                                restTemplate.put(uri, inurl ? null : targetparams, new Object[]{targetparams});
                                            } else if (HEAD.class.equals(resttype)) {
                                                res = restTemplate.headForHeaders(uri, new Object[]{targetparams});
                                            } else if (OPTIONS.class.equals(resttype)) {
                                                res = restTemplate.optionsForAllow(uri, new Object[]{targetparams});
                                            } else if (DELETE.class.equals(resttype)) {
                                                restTemplate.delete(uri, new Object[]{targetparams});
                                            }
                                            if (rmapper != null) {
                                                IValueMapper rm = (IValueMapper)jadex.extension.rs.publish.Value.evaluate((Value)rmapper, (String[])defaultimports);
                                                res = rm.convertValue(res);
                                            }
                                            re.setResult(res);
                                            ia.killComponent();
                                        }
                                        catch (RestClientException rce) {
                                            re.setException((Exception)((Object)rce));
                                        }
                                        catch (Exception e) {
                                            re.setException(e);
                                        }
                                        return re;
                                    }
                                }).addResultListener(((IExecutionFeature)RestServiceWrapperInvocationHandlerAndroid.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DelegationResultListener(ret)));
                            }
                        }));
                    }
                }));
            }
        }));
        return ret;
    }

    private Map<String, String> convertUriParamsToStringValues(Map<String, ?> targetparams) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, ?> entry : targetparams.entrySet()) {
            String sep;
            Object value = entry.getValue();
            StringBuilder resultValue = new StringBuilder();
            if (value instanceof Object[]) {
                sep = "";
                Object[] valueArr = (Object[])value;
                for (Object o : valueArr) {
                    resultValue.append(sep);
                    resultValue.append(o.toString());
                    sep = ",";
                }
            } else if (value instanceof Iterable) {
                sep = "";
                Iterable iterable = (Iterable)value;
                for (Object o : iterable) {
                    resultValue.append(sep);
                    resultValue.append(o.toString());
                    sep = ",";
                }
            } else {
                resultValue.append(entry.getValue().toString());
            }
            result.put(entry.getKey(), resultValue.toString());
        }
        return result;
    }

    private String buildUri(String baseuri, String methodname, Object params) {
        StringBuilder uriBuilder = new StringBuilder(baseuri);
        if (!baseuri.endsWith("/") && !methodname.startsWith("/")) {
            uriBuilder.append("/");
        }
        uriBuilder.append(methodname);
        if (params instanceof Map) {
            uriBuilder.append("?");
            Map paramMap = (Map)params;
            for (String key : paramMap.keySet()) {
                uriBuilder.append(key);
                uriBuilder.append("={");
                uriBuilder.append(key);
                uriBuilder.append("}&");
            }
            uriBuilder.deleteCharAt(uriBuilder.length() - 1);
        }
        return uriBuilder.toString();
    }
}

