/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.appstore;

import jadex.bridge.IExternalAccess;
import jadex.bridge.service.IService;
import jadex.bridge.service.search.SServiceProvider;
import jadex.bridge.service.types.appstore.AppMetaInfo;
import jadex.bridge.service.types.appstore.IAppGui;
import jadex.bridge.service.types.appstore.IAppProviderService;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.commons.future.ITerminableIntermediateFuture;
import jadex.commons.gui.SGUI;
import jadex.commons.gui.future.SwingDefaultResultListener;
import jadex.commons.gui.future.SwingIntermediateExceptionDelegationResultListener;
import jadex.commons.gui.future.SwingResultListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class AppStorePanel
extends JPanel {
    protected IExternalAccess access;
    protected JTable apptable;
    protected Map<IAppProviderService<?>, AppMetaInfo> apps;

    public AppStorePanel(IExternalAccess access) {
        this.access = access;
        this.apps = new HashMap();
        this.setLayout(new BorderLayout());
        this.apptable = new JTable(new AppTableModel());
        this.apptable.setRowHeight(40);
        this.apptable.addMouseListener(new AppMouseAdapter(this.apptable));
        JScrollPane apppan = new JScrollPane(this.apptable);
        DefaultTableCellRenderer apprend = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focus, int row, int column) {
                1 ret = this;
                super.getTableCellRendererComponent(table, value, selected, focus, row, column);
                Object[] val = (Object[])value;
                AppMetaInfo app = (AppMetaInfo)val[1];
                if (column == 0) {
                    this.setText("");
                    this.setToolTipText("");
                    this.setIcon(app.getImage() == null ? null : new ImageIcon(app.getImage()));
                } else if (column == 1) {
                    this.setText(app.getName());
                    this.setToolTipText(app.getDescription());
                    this.setIcon(null);
                } else if (column == 2) {
                    this.setText(app.getVersion());
                    this.setToolTipText("");
                    this.setIcon(null);
                } else if (column == 3) {
                    this.setText(app.getProvider());
                    this.setToolTipText("");
                    this.setIcon(null);
                }
                return ret;
            }
        };
        this.apptable.getColumnModel().getColumn(0).setCellRenderer(apprend);
        this.apptable.getColumnModel().getColumn(1).setCellRenderer(apprend);
        this.apptable.getColumnModel().getColumn(2).setCellRenderer(apprend);
        this.apptable.getColumnModel().getColumn(3).setCellRenderer(apprend);
        JButton buref = new JButton("Refresh");
        buref.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppStorePanel.this.refreshGui();
            }
        });
        JPanel psou = new JPanel(new FlowLayout());
        psou.add(buref);
        this.add((Component)apppan, "Center");
        this.add((Component)psou, "South");
    }

    protected IFuture<Void> searchAppProviders() {
        final Future ret = new Future();
        this.apps.clear();
        ITerminableIntermediateFuture fut = SServiceProvider.getServices((IExternalAccess)this.access, IAppProviderService.class, (String)"global");
        fut.addResultListener((IResultListener)new SwingIntermediateExceptionDelegationResultListener<IAppProviderService, Void>(ret){
            protected boolean fin;
            protected int cnt;
            {
                super(x0);
                this.fin = false;
                this.cnt = 0;
            }

            public void customIntermediateResultAvailable(final IAppProviderService ser) {
                ++this.cnt;
                ser.getAppMetaInfo().addResultListener((IResultListener)new SwingResultListener((IResultListener)new IResultListener<AppMetaInfo>(){

                    public void resultAvailable(AppMetaInfo ami) {
                        if (!AppStorePanel.this.apps.containsKey(ser)) {
                            AppStorePanel.this.apps.put(ser, ami);
                            AppStorePanel.this.refreshAppTable();
                        }
                        if (--cnt == 0 && fin) {
                            ret.setResult(null);
                        }
                    }

                    public void exceptionOccurred(Exception exception) {
                        if (--cnt == 0 && fin) {
                            ret.setResult(null);
                        }
                    }
                }));
            }

            public void customFinished() {
                if (this.cnt == 0) {
                    ret.setResult(null);
                } else {
                    this.fin = true;
                }
            }

            public void customResultAvailable(Collection<IAppProviderService> results) {
                if (results != null) {
                    for (IAppProviderService aps : results) {
                        this.intermediateResultAvailable(aps);
                    }
                }
                this.finished();
            }
        });
        return ret;
    }

    public void refreshGui() {
        this.searchAppProviders().addResultListener((IResultListener)new SwingDefaultResultListener<Void>(){

            public void customResultAvailable(Void result) {
                AppStorePanel.this.refreshAppTable();
            }
        });
    }

    protected void refreshAppTable() {
        ((DefaultTableModel)this.apptable.getModel()).fireTableDataChanged();
        this.apptable.getParent().invalidate();
        this.apptable.getParent().doLayout();
        this.apptable.repaint();
    }

    public class AppMouseAdapter
    extends MouseAdapter {
        protected JTable table;

        public AppMouseAdapter(JTable table) {
            this.table = table;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.trigger(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.trigger(e);
        }

        protected void trigger(MouseEvent e) {
            int row;
            if (e.isPopupTrigger() && (row = this.table.rowAtPoint(e.getPoint())) != -1) {
                Object[] vals = (Object[])((AppTableModel)this.table.getModel()).getValueAt(row, 0);
                this.createMenu((IAppProviderService)vals[0]).show(e.getComponent(), e.getX(), e.getY());
            }
        }

        protected JPopupMenu createMenu(IAppProviderService<?> aps) {
            final JPopupMenu menu = new JPopupMenu();
            IFuture fut = aps.getApplication();
            fut.addResultListener((IResultListener)new SwingDefaultResultListener<Object>(){

                public void customResultAvailable(final Object result) {
                    if (result != null) {
                        JMenuItem mi = new JMenuItem("Start");
                        mi.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                if (result instanceof IService) {
                                    IService appser = (IService)result;
                                    Map props = appser.getPropertyMap();
                                    Class guiclass = (Class)props.get("componentviewer.viewerclass");
                                    try {
                                        IAppGui gui = (IAppGui)guiclass.newInstance();
                                        if (gui instanceof JFrame) {
                                            JFrame fr = (JFrame)gui;
                                            fr.setLocation(SGUI.calculateMiddlePosition((Window)fr));
                                            fr.pack();
                                            fr.setVisible(true);
                                        } else if (gui instanceof JComponent) {
                                            JFrame fr = new JFrame();
                                            fr.setLayout(new BorderLayout());
                                            fr.add((Component)((JComponent)gui), "Center");
                                            fr.setLocation(SGUI.calculateMiddlePosition((Window)fr));
                                            fr.pack();
                                            fr.setVisible(true);
                                        } else {
                                            System.out.println("Unknown gui type: " + gui);
                                        }
                                        gui.init(AppStorePanel.this.access, appser).addResultListener((IResultListener)new SwingDefaultResultListener<Void>(){

                                            public void customResultAvailable(Void result) {
                                            }
                                        });
                                    }
                                    catch (Exception ex) {
                                        ex.printStackTrace();
                                    }
                                }
                            }
                        });
                        menu.add(mi);
                        menu.invalidate();
                        menu.doLayout();
                        menu.pack();
                        menu.repaint();
                    }
                }
            });
            return menu;
        }
    }

    public class AppTableModel
    extends DefaultTableModel {
        protected String[] columns = new String[]{"Image", "Name", "Version", "Provider"};

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public String getColumnName(int i) {
            return this.columns[i];
        }

        @Override
        public Class<?> getColumnClass(int i) {
            return String.class;
        }

        @Override
        public int getRowCount() {
            return AppStorePanel.this.apps.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            Object key = AppStorePanel.this.apps.keySet().toArray()[row];
            return new Object[]{key, AppStorePanel.this.apps.get(key)};
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public void setValueAt(Object val, int row, int column) {
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
        }
    }
}

