/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.awareness;

import jadex.base.gui.componentviewer.IComponentViewerPanel;
import jadex.base.gui.componentviewer.IServiceViewerPanel;
import jadex.base.gui.jtable.ComponentIdentifierRenderer;
import jadex.base.gui.plugin.IControlCenter;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IExternalAccess;
import jadex.bridge.ITransportComponentIdentifier;
import jadex.bridge.modelinfo.SubcomponentTypeInfo;
import jadex.bridge.service.IService;
import jadex.bridge.service.search.SServiceProvider;
import jadex.bridge.service.types.awareness.DiscoveryInfo;
import jadex.bridge.service.types.cms.IComponentManagementService;
import jadex.bridge.service.types.message.IMessageService;
import jadex.commons.Properties;
import jadex.commons.Property;
import jadex.commons.SUtil;
import jadex.commons.future.DelegationResultListener;
import jadex.commons.future.ExceptionDelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.commons.gui.EditableList;
import jadex.commons.gui.future.SwingDefaultResultListener;
import jadex.commons.gui.future.SwingExceptionDelegationResultListener;
import jadex.commons.gui.future.SwingResultListener;
import jadex.commons.gui.jtable.DateTimeRenderer;
import jadex.platform.service.awareness.management.AwarenessManagementAgent;
import jadex.platform.service.awareness.management.AwarenessManagementAgentHelper;
import jadex.platform.service.awareness.management.AwarenessSettingsData;
import jadex.platform.service.message.transport.httprelaymtp.RelayConnectionManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.sql.Date;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.Timer;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public class AwarenessAgentPanel
implements IComponentViewerPanel,
IServiceViewerPanel {
    public static final String PROPERTY_GUI_REFRESH = "gui-refresh";
    protected Timer timer;
    protected int timerdelay;
    protected AwarenessSettingsData settings;
    protected JTable jtdis;
    protected JSpinner spdelay;
    protected JCheckBox cbfast;
    protected JCheckBox cbautocreate;
    protected JCheckBox cbautodelete;
    protected JSpinner sprefresh;
    protected EditableList includes;
    protected EditableList excludes;
    protected JComponent panel;
    protected JButton buapply;
    protected JCheckBox[] cbmechanisms;
    protected AwarenessManagementAgentHelper helper;

    public IFuture<Void> init(final IControlCenter jcc, final IService service) {
        final Future ret = new Future();
        SServiceProvider.getService((IExternalAccess)jcc.getPlatformAccess(), IComponentManagementService.class, (String)"platform").addResultListener((IResultListener)new ExceptionDelegationResultListener<IComponentManagementService, Void>(ret){

            public void customResultAvailable(IComponentManagementService cms) {
                cms.getExternalAccess(service.getServiceIdentifier().getProviderId()).addResultListener((IResultListener)new ExceptionDelegationResultListener<IExternalAccess, Void>(ret){

                    public void customResultAvailable(IExternalAccess result) {
                        AwarenessAgentPanel.this.init(jcc, result).addResultListener((IResultListener)new DelegationResultListener(ret));
                    }
                });
            }
        });
        return ret;
    }

    public IFuture<Void> init(IControlCenter jcc, final IExternalAccess component) {
        this.helper = new AwarenessManagementAgentHelper(component);
        JPanel mainpanel = new JPanel(new GridBagLayout());
        final JLabel map = new JLabel("No map available.", 0);
        this.panel = new JTabbedPane();
        this.panel.add((Component)mainpanel, "Main");
        map.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                this.loadMap();
            }

            @Override
            public void componentShown(ComponentEvent e) {
                this.loadMap();
            }

            protected void loadMap() {
                map.setIcon(null);
                map.setText("Loading map. Please wait...");
                map.repaint();
                AwarenessAgentPanel.this.panel.setCursor(Cursor.getPredefinedCursor(3));
                SServiceProvider.getService((IExternalAccess)component, IMessageService.class, (String)"platform").addResultListener((IResultListener)new SwingResultListener((IResultListener)new IResultListener<IMessageService>(){

                    public void resultAvailable(IMessageService ms) {
                        ms.getAddresses().addResultListener((IResultListener)new SwingResultListener((IResultListener)new IResultListener<String[]>(){

                            public void resultAvailable(String[] addresses) {
                                boolean done = false;
                                for (String adr : addresses) {
                                    if (!adr.startsWith("relay-http")) continue;
                                    adr = RelayConnectionManager.httpAddress((String)adr) + "map?width=" + map.getWidth() + "&height=" + map.getHeight();
                                    try {
                                        map.setIcon(new ImageIcon(new URL(adr)));
                                        map.setText(null);
                                        map.repaint();
                                        done = true;
                                    }
                                    catch (Exception ex) {
                                        map.setIcon(null);
                                        map.setText("Error while loading map: " + ex.toString());
                                        map.repaint();
                                        done = true;
                                    }
                                    break;
                                }
                                if (!done) {
                                    map.setText("Could not load map.");
                                    map.repaint();
                                }
                                AwarenessAgentPanel.this.panel.setCursor(Cursor.getDefaultCursor());
                            }

                            public void exceptionOccurred(Exception exception) {
                                map.setIcon(null);
                                map.setText("Error while loading map: " + exception.toString());
                                map.repaint();
                                AwarenessAgentPanel.this.panel.setCursor(Cursor.getDefaultCursor());
                            }
                        }));
                    }

                    public void exceptionOccurred(Exception exception) {
                        map.setIcon(null);
                        map.setText("Error while loading map: " + exception.toString());
                        map.repaint();
                        AwarenessAgentPanel.this.panel.setCursor(Cursor.getDefaultCursor());
                    }
                }));
            }
        });
        this.timerdelay = 5000;
        SpinnerNumberModel spmdelay = new SpinnerNumberModel(0, 0, 100, 1);
        spmdelay.setMaximum(null);
        this.spdelay = new JSpinner(spmdelay);
        this.cbfast = new JCheckBox();
        this.cbautocreate = new JCheckBox();
        this.cbautodelete = new JCheckBox();
        this.includes = new EditableList("Includes");
        this.excludes = new EditableList("Excludes");
        JScrollPane pincludes = new JScrollPane((Component)this.includes);
        JScrollPane pexcludes = new JScrollPane((Component)this.excludes);
        pincludes.setMinimumSize(new Dimension(0, 0));
        pincludes.setPreferredSize(new Dimension(0, 0));
        pexcludes.setMinimumSize(new Dimension(0, 0));
        pexcludes.setPreferredSize(new Dimension(0, 0));
        this.spdelay.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AwarenessAgentPanel.this.buapply.setEnabled(true);
            }
        });
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AwarenessAgentPanel.this.applySettings();
            }
        };
        TableModelListener tml = new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                AwarenessAgentPanel.this.applySettings();
            }
        };
        this.cbfast.addActionListener(al);
        this.cbautocreate.addActionListener(al);
        this.cbautodelete.addActionListener(al);
        this.includes.getModel().addTableModelListener(tml);
        this.excludes.getModel().addTableModelListener(tml);
        this.buapply = new JButton("Apply");
        this.buapply.setMargin(new Insets(0, 0, 0, 0));
        this.buapply.setToolTipText("Apply setting changes to component.");
        this.buapply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                AwarenessAgentPanel.this.applySettings();
            }
        });
        this.buapply.setEnabled(false);
        Dimension dim = new Dimension(this.buapply.getMinimumSize().width, this.spdelay.getPreferredSize().height);
        this.buapply.setMinimumSize(dim);
        this.buapply.setPreferredSize(dim);
        JPanel pdissettings = new JPanel(new GridBagLayout());
        pdissettings.setBorder(new TitledBorder(new EtchedBorder(1), " Discovery Settings "));
        int y = 0;
        pdissettings.add((Component)new JLabel("Info send delay (0=off) [s]", 2), new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 18, 0, new Insets(1, 1, 1, 1), 0, 1));
        pdissettings.add((Component)this.spdelay, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 18, 2, new Insets(1, 1, 1, 1), 0, 0));
        pdissettings.add((Component)this.buapply, new GridBagConstraints(2, y, 0, 1, 0.0, 0.0, 18, 2, new Insets(1, 1, 1, 1), 0, 0));
        pdissettings.add((Component)new JLabel("Fast startup awareness", 2), new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 18, 0, new Insets(1, 1, 1, 1), 0, 1));
        pdissettings.add((Component)this.cbfast, new GridBagConstraints(1, y, 0, 1, 1.0, 0.0, 18, 2, new Insets(1, 1, 1, 1), 0, 0));
        ++y;
        JPanel pprosettings = new JPanel(new GridBagLayout());
        pprosettings.setBorder(new TitledBorder(new EtchedBorder(1), " Proxy Settings "));
        y = 0;
        pprosettings.add((Component)new JLabel("Create on discovery", 2), new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 18, 0, new Insets(1, 1, 1, 1), 0, 0));
        pprosettings.add((Component)this.cbautocreate, new GridBagConstraints(1, y, 2, 1, 1.0, 0.0, 18, 0, new Insets(1, 1, 1, 1), 0, 0));
        pprosettings.add((Component)new JLabel("Delete on disappearance", 2), new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 18, 0, new Insets(1, 1, 1, 1), 0, 0));
        pprosettings.add((Component)this.cbautodelete, new GridBagConstraints(1, y, 2, 1, 1.0, 0.0, 18, 0, new Insets(1, 1, 1, 1), 0, 0));
        ++y;
        JPanel pdisinfos = new JPanel(new BorderLayout());
        pdisinfos.setBorder(new TitledBorder(new EtchedBorder(1), " Discovery Infos "));
        final DiscoveryTableModel dismodel = new DiscoveryTableModel();
        this.jtdis = new JTable(dismodel);
        this.jtdis.setPreferredScrollableViewportSize(new Dimension(600, 120));
        this.jtdis.setSelectionMode(0);
        pdisinfos.add("Center", new JScrollPane(this.jtdis));
        this.jtdis.setDefaultRenderer(Date.class, (TableCellRenderer)new DateTimeRenderer());
        this.jtdis.setDefaultRenderer(IComponentIdentifier.class, (TableCellRenderer)new ComponentIdentifierRenderer());
        this.updateDiscoveryInfos(this.jtdis);
        this.jtdis.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.popup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.popup(e);
            }

            protected void popup(MouseEvent e) {
                int row;
                if (e.isPopupTrigger() && (row = AwarenessAgentPanel.this.jtdis.rowAtPoint(e.getPoint())) != -1) {
                    int i;
                    DiscoveryInfo info = dismodel.getList().get(row);
                    String name = info.getComponentIdentifier().getPlatformName();
                    String template = null;
                    if (name.length() > 4 && name.charAt(name.length() - 4) == '_') {
                        template = name.substring(0, name.length() - 4);
                    }
                    JPopupMenu menu = new JPopupMenu("Adjust includes/excludes");
                    String[] entries = AwarenessAgentPanel.this.includes.getEntries();
                    boolean found = false;
                    boolean foundt = false;
                    for (i = 0; i < entries.length; ++i) {
                        if (name.startsWith(entries[i])) {
                            menu.add(new AddRemoveAction(false, true, entries[i]));
                        }
                        found = found || entries[i].equals(name);
                        foundt = foundt || template != null && entries[i].equals(template);
                    }
                    if (!found) {
                        menu.add(new AddRemoveAction(true, true, name));
                    }
                    if (template != null && !foundt) {
                        menu.add(new AddRemoveAction(true, true, template));
                    }
                    menu.addSeparator();
                    entries = AwarenessAgentPanel.this.excludes.getEntries();
                    found = false;
                    foundt = false;
                    for (i = 0; i < entries.length; ++i) {
                        if (name.startsWith(entries[i])) {
                            menu.add(new AddRemoveAction(false, false, entries[i]));
                        }
                        found = found || entries[i].equals(name);
                        foundt = foundt || template != null && entries[i].equals(template);
                    }
                    if (!found) {
                        menu.add(new AddRemoveAction(true, false, name));
                    }
                    if (template != null && !foundt) {
                        menu.add(new AddRemoveAction(true, false, template));
                    }
                    menu.show(AwarenessAgentPanel.this.jtdis, e.getX(), e.getY());
                }
            }
        });
        this.timer = new Timer(this.timerdelay, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AwarenessAgentPanel.this.updateDiscoveryInfos(AwarenessAgentPanel.this.jtdis);
                AwarenessAgentPanel.this.updateDiscoveryMechanisms();
            }
        });
        SpinnerNumberModel spmrefresh = new SpinnerNumberModel(5, 0, 100, 1);
        spmrefresh.setMaximum(null);
        this.sprefresh = new JSpinner(spmrefresh);
        JButton burefresh = new JButton("Refresh");
        burefresh.setToolTipText("Refresh settings and discovery infos.");
        burefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AwarenessAgentPanel.this.refreshSettings();
                AwarenessAgentPanel.this.updateDiscoveryInfos(AwarenessAgentPanel.this.jtdis);
                AwarenessAgentPanel.this.updateDiscoveryMechanisms();
            }
        });
        JPanel prefresh = new JPanel();
        prefresh.add(this.sprefresh);
        prefresh.add(new JLabel("Gui refresh delay (0=off) [s]", 2));
        prefresh.add(burefresh);
        SubcomponentTypeInfo[] dis = component.getModel().getSubcomponentTypes();
        this.cbmechanisms = new JCheckBox[dis.length];
        for (int i = 0; i < dis.length; ++i) {
            this.cbmechanisms[i] = new JCheckBox(dis[i].getName());
            final JCheckBox cb = this.cbmechanisms[i];
            final String localtype = dis[i].getName();
            this.cbmechanisms[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean on = cb.isSelected();
                    AwarenessAgentPanel.this.helper.setDiscoveryMechanismState(localtype, on);
                }
            });
        }
        JPanel pdismechs = new JPanel(new GridBagLayout());
        pdismechs.setBorder(new TitledBorder(new EtchedBorder(1), " Discovery Mechanisms "));
        for (int i = 0; i < this.cbmechanisms.length; ++i) {
            pdismechs.add((Component)this.cbmechanisms[i], new GridBagConstraints(i, 0, 1, 1, i == this.cbmechanisms.length - 1 ? 1.0 : 0.0, 0.0, 17, 2, new Insets(1, 1, 1, 1), 0, 0));
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        mainpanel.add((Component)pprosettings, gbc);
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.gridwidth = 1;
        gbc.gridheight = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        mainpanel.add((Component)pincludes, gbc);
        mainpanel.add((Component)pexcludes, gbc);
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.gridheight = 1;
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.weightx = 0.0;
        mainpanel.add((Component)pdissettings, gbc);
        gbc.gridx = -1;
        gbc.gridwidth = 0;
        ++gbc.gridy;
        mainpanel.add((Component)pdismechs, gbc);
        ++gbc.gridy;
        gbc.weighty = 1.0;
        mainpanel.add((Component)pdisinfos, gbc);
        ++gbc.gridy;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridx = -1;
        gbc.fill = 0;
        gbc.anchor = 13;
        gbc.gridwidth = 0;
        mainpanel.add((Component)prefresh, gbc);
        this.updateDiscoveryMechanisms();
        this.timer.start();
        return this.refreshSettings();
    }

    public IFuture<Void> shutdown() {
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
        return IFuture.DONE;
    }

    public String getId() {
        return "awarenessviewer";
    }

    public JComponent getComponent() {
        return this.panel;
    }

    public IFuture<Void> setProperties(Properties ps) {
        Property settings = ps.getProperty(PROPERTY_GUI_REFRESH);
        if (settings != null) {
            this.sprefresh.setValue(Integer.valueOf(settings.getValue()));
        }
        return IFuture.DONE;
    }

    public IFuture<Properties> getProperties() {
        Properties props = new Properties();
        props.addProperty(new Property(PROPERTY_GUI_REFRESH, this.sprefresh.getValue().toString()));
        Future ret = new Future((Object)props);
        return ret;
    }

    protected IFuture<Void> refreshSettings() {
        final Future ret = new Future();
        this.helper.getSettings().addResultListener((IResultListener)new SwingExceptionDelegationResultListener<AwarenessSettingsData, Void>(ret){

            public void customResultAvailable(AwarenessSettingsData result) {
                AwarenessAgentPanel.this.updateSettings(result);
                ret.setResult(null);
            }
        });
        return ret;
    }

    protected void updateDiscoveryInfos(final JTable jtdis) {
        this.helper.getDiscoveryInfos().addResultListener((IResultListener)new SwingDefaultResultListener<DiscoveryInfo[]>((Component)jtdis){

            public void customResultAvailable(DiscoveryInfo[] ds) {
                int sel = jtdis.getSelectedRow();
                DiscoveryTableModel dtm = (DiscoveryTableModel)jtdis.getModel();
                List<DiscoveryInfo> disinfos = dtm.getList();
                disinfos.clear();
                for (int i = 0; i < ds.length; ++i) {
                    disinfos.add(ds[i]);
                }
                dtm.fireTableDataChanged();
                if (sel != -1 && sel < ds.length) {
                    ((DefaultListSelectionModel)jtdis.getSelectionModel()).setSelectionInterval(sel, sel);
                }
            }

            public void customExceptionOccurred(Exception exception) {
                exception.printStackTrace();
                AwarenessAgentPanel.this.sprefresh.setValue(0);
            }
        });
    }

    protected void updateDiscoveryMechanisms() {
        this.helper.getActiveDiscoveryMechanisms().addResultListener((IResultListener)new SwingDefaultResultListener<Set<String>>(){

            public void customResultAvailable(Set<String> localtypes) {
                for (int i = 0; i < AwarenessAgentPanel.this.cbmechanisms.length; ++i) {
                    AwarenessAgentPanel.this.cbmechanisms[i].setSelected(localtypes.contains(AwarenessAgentPanel.this.cbmechanisms[i].getText()));
                }
            }

            public void customExceptionOccurred(Exception exception) {
                AwarenessAgentPanel.this.sprefresh.setValue(0);
            }
        });
    }

    protected void applySettings() {
        try {
            AwarenessSettingsData settings = new AwarenessSettingsData();
            settings.delay = ((Number)this.spdelay.getValue()).longValue() * 1000L;
            settings.fast = this.cbfast.isSelected();
            settings.autocreate = this.cbautocreate.isSelected();
            settings.autodelete = this.cbautodelete.isSelected();
            settings.includes = this.includes.getEntries();
            settings.excludes = this.excludes.getEntries();
            this.settings = settings;
            this.helper.setSettings(settings).addResultListener((IResultListener)new SwingDefaultResultListener<Void>((Component)this.panel){

                public void customResultAvailable(Void result) {
                    AwarenessAgentPanel.this.buapply.setEnabled(false);
                }
            });
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.panel, "Could not parse value: " + e, "Settings not applied", 0);
        }
        int timerdelay = ((Number)this.sprefresh.getValue()).intValue() * 1000;
        if (timerdelay != this.timerdelay) {
            this.timerdelay = timerdelay;
            if (timerdelay == 0) {
                this.timer.stop();
            } else {
                this.timer.setDelay(timerdelay);
                if (!this.timer.isRunning()) {
                    this.timer.start();
                }
            }
        }
    }

    protected void updateSettings(AwarenessSettingsData settings) {
        this.settings = settings;
        this.spdelay.setValue(settings.delay / 1000L);
        this.cbfast.setSelected(settings.fast);
        this.cbautocreate.setSelected(settings.autocreate);
        this.cbautodelete.setSelected(settings.autodelete);
        this.includes.setEntries(settings.includes);
        this.excludes.setEntries(settings.excludes);
    }

    class DiscoveryTableModel
    extends AbstractTableModel {
        protected List<DiscoveryInfo> list;

        public DiscoveryTableModel() {
            this(new ArrayList<DiscoveryInfo>());
        }

        public DiscoveryTableModel(List<DiscoveryInfo> list) {
            this.list = list;
        }

        public List<DiscoveryInfo> getList() {
            return this.list;
        }

        @Override
        public int getRowCount() {
            return this.list.size();
        }

        @Override
        public int getColumnCount() {
            return 6;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Component Identifier";
                }
                case 1: {
                    return "Properties";
                }
                case 2: {
                    return "Time/Delay per Mechanism";
                }
                case 3: {
                    return "Has a Proxy";
                }
                case 4: {
                    return "Remote Excluded";
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 4;
        }

        @Override
        public Object getValueAt(int row, int column) {
            Object value = null;
            DiscoveryInfo dif = this.list.get(row);
            if (column == 0) {
                value = dif.getComponentIdentifier();
            } else if (column == 1) {
                value = "" + dif.getProperties();
            } else if (column == 2) {
                StringBuffer buf = new StringBuffer();
                Map tds = dif.getTimeDelays();
                for (String key : tds.keySet()) {
                    long[] vals = (long[])tds.get(key);
                    buf.append(key).append("=[").append(((DateFormat)SUtil.SDF3.get()).format(vals[0])).append(" ").append(vals[1]).append("], ");
                }
                value = buf.toString();
            } else if (column == 3) {
                value = dif.getProxy() != null && dif.getProxy().isDone() && dif.getProxy().getException() == null ? Boolean.TRUE : Boolean.FALSE;
            } else if (column == 4) {
                value = dif.isRemoteExcluded() ? Boolean.TRUE : Boolean.FALSE;
            }
            return value;
        }

        @Override
        public void setValueAt(Object val, int row, int column) {
            IComponentIdentifier proxy;
            DiscoveryInfo dif = this.list.get(row);
            boolean create = (Boolean)val;
            ITransportComponentIdentifier cid = dif.getComponentIdentifier();
            IComponentIdentifier iComponentIdentifier = proxy = dif.getProxy() != null && dif.getProxy().isDone() && dif.getProxy().getException() == null ? (IComponentIdentifier)dif.getProxy().get() : null;
            if (create && dif.getProxy() == null || !create && proxy != null) {
                boolean proceed = true;
                if (!create && AwarenessManagementAgent.isIncluded((ITransportComponentIdentifier)cid, (String[])AwarenessAgentPanel.this.includes.getEntries(), (String[])AwarenessAgentPanel.this.excludes.getEntries())) {
                    String name = cid.getPlatformName();
                    String template = null;
                    if (name.length() > 4 && name.charAt(name.length() - 4) == '_') {
                        template = name.substring(0, name.length() - 4);
                    }
                    JPanel pmsg = new JPanel(new GridBagLayout());
                    GridBagConstraints gbc = new GridBagConstraints();
                    gbc.gridy = 0;
                    gbc.anchor = 17;
                    JTextArea msg = new JTextArea("Add entry to the excludes list?");
                    msg.setEditable(false);
                    msg.setCursor(null);
                    msg.setOpaque(false);
                    pmsg.add((Component)msg, gbc);
                    ++gbc.gridy;
                    gbc.insets = new Insets(1, 10, 1, 1);
                    JRadioButton rbname = new JRadioButton(name);
                    JRadioButton rbtmp = new JRadioButton(template);
                    ButtonGroup bg = new ButtonGroup();
                    bg.add(rbname);
                    bg.add(rbtmp);
                    rbtmp.setSelected(true);
                    if (template == null) {
                        pmsg.add((Component)new JLabel(name), gbc);
                    } else {
                        pmsg.add((Component)rbname, gbc);
                        ++gbc.gridy;
                        pmsg.add((Component)rbtmp, gbc);
                    }
                    int res = JOptionPane.showConfirmDialog(AwarenessAgentPanel.this.panel, pmsg, "Delete Proxy", 1);
                    if (res == 2) {
                        proceed = false;
                    } else if (res == 0) {
                        String entry = template != null && rbtmp.isSelected() ? template : name;
                        AwarenessAgentPanel.this.excludes.addEntry(entry);
                        AwarenessAgentPanel.this.applySettings();
                    }
                }
                if (proceed) {
                    AwarenessAgentPanel.this.panel.setCursor(Cursor.getPredefinedCursor(3));
                    AwarenessAgentPanel.this.helper.createOrDeleteProxy((IComponentIdentifier)cid, create).addResultListener((IResultListener)new SwingDefaultResultListener<Void>((Component)AwarenessAgentPanel.this.panel){

                        public void customResultAvailable(Void result) {
                            AwarenessAgentPanel.this.panel.setCursor(Cursor.getDefaultCursor());
                            AwarenessAgentPanel.this.updateDiscoveryInfos(AwarenessAgentPanel.this.jtdis);
                        }

                        public void customExceptionOccurred(Exception exception) {
                            AwarenessAgentPanel.this.panel.setCursor(Cursor.getDefaultCursor());
                            super.customExceptionOccurred(exception);
                        }
                    });
                }
            }
        }

        @Override
        public Class<?> getColumnClass(int column) {
            Class<Object> ret = Object.class;
            if (column == 0) {
                ret = IComponentIdentifier.class;
            } else if (column == 1) {
                ret = String.class;
            } else if (column == 2) {
                ret = String.class;
            } else if (column == 3) {
                ret = Boolean.class;
            } else if (column == 4) {
                ret = Boolean.class;
            }
            return ret;
        }
    }

    public class AddRemoveAction
    extends AbstractAction {
        protected boolean add;
        protected boolean includes;
        protected String entry;

        public AddRemoveAction(boolean add, boolean includes, String entry) {
            super(add ? "Add '" + entry + "' to " + (includes ? "includes" : "excludes") : "Remove '" + entry + "' from " + (includes ? "includes" : "excludes"));
            this.add = add;
            this.includes = includes;
            this.entry = entry;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.includes && this.add) {
                AwarenessAgentPanel.this.includes.addEntry(this.entry);
            } else if (this.includes && !this.add) {
                AwarenessAgentPanel.this.includes.removeEntry(this.entry);
            } else if (!this.includes && this.add) {
                AwarenessAgentPanel.this.excludes.addEntry(this.entry);
            } else if (!this.includes && !this.add) {
                AwarenessAgentPanel.this.excludes.removeEntry(this.entry);
            }
            AwarenessAgentPanel.this.applySettings();
        }
    }
}

