/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.chat;

import jadex.base.SRemoteGui;
import jadex.base.gui.RemoteFileChooser;
import jadex.base.gui.componentviewer.AbstractServiceViewerPanel;
import jadex.base.gui.plugin.IControlCenter;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IExternalAccess;
import jadex.bridge.service.IService;
import jadex.bridge.service.search.SServiceProvider;
import jadex.bridge.service.types.chat.ChatEvent;
import jadex.bridge.service.types.chat.IChatGuiService;
import jadex.bridge.service.types.chat.IChatService;
import jadex.bridge.service.types.chat.TransferInfo;
import jadex.bridge.service.types.clock.IClockService;
import jadex.bridge.service.types.filetransfer.FileData;
import jadex.commons.Properties;
import jadex.commons.Property;
import jadex.commons.SUtil;
import jadex.commons.Tuple2;
import jadex.commons.future.DelegationResultListener;
import jadex.commons.future.ExceptionDelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.commons.future.ISubscriptionIntermediateFuture;
import jadex.commons.future.IntermediateDefaultResultListener;
import jadex.commons.gui.JSplitPanel;
import jadex.commons.gui.PropertiesPanel;
import jadex.commons.gui.SGUI;
import jadex.commons.gui.future.SwingDelegationResultListener;
import jadex.commons.gui.future.SwingExceptionDelegationResultListener;
import jadex.commons.gui.future.SwingIntermediateDefaultResultListener;
import jadex.commons.gui.future.SwingResultListener;
import jadex.commons.transformation.traverser.ImageProcessor;
import jadex.tools.chat.ChatPlugin;
import jadex.tools.chat.ChatUser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.UIDefaults;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class ChatPanel
extends AbstractServiceViewerPanel<IChatGuiService> {
    protected static final UIDefaults icons = new UIDefaults(new Object[]{"play", SGUI.makeIcon(ChatPanel.class, (String)"/jadex/tools/common/images/arrowright.png"), ":-)", SGUI.makeIcon(ChatPanel.class, (String)"/jadex/tools/chat/images/smi/smile.png"), ":D", SGUI.makeIcon(ChatPanel.class, (String)"/jadex/tools/chat/images/smi/happy.png"), ":-(", SGUI.makeIcon(ChatPanel.class, (String)"/jadex/tools/chat/images/smi/unhappy.png"), ";-)", SGUI.makeIcon(ChatPanel.class, (String)"/jadex/tools/chat/images/smi/wink.png"), ":-p", SGUI.makeIcon(ChatPanel.class, (String)"/jadex/tools/chat/images/smi/tongue.png"), ":o", SGUI.makeIcon(ChatPanel.class, (String)"/jadex/tools/chat/images/smi/surprised.png"), ">-)", SGUI.makeIcon(ChatPanel.class, (String)"/jadex/tools/chat/images/smi/evilgrin.png"), ">)", SGUI.makeIcon(ChatPanel.class, (String)"/jadex/tools/chat/images/smi/grin.png"), ":>", SGUI.makeIcon(ChatPanel.class, (String)"/jadex/tools/chat/images/smi/waii.png")});
    protected static final List<String> smileys = SUtil.createArrayList((Object[])new String[]{":-)", ":D", ":-(", ";-)", ":-p", ":o", ">-)", ">)", ":>"});
    public static final String lf = System.getProperty("line.separator");
    public final DateFormat df = new SimpleDateFormat("HH:mm:ss");
    public static final String NOTIFICATION_NEW_USER = "new user";
    public static final String NOTIFICATION_NEW_MSG = "new msg";
    public static final String NOTIFICATION_MSG_FAILED = "msg failed";
    public static final String NOTIFICATION_NEW_FILE = "new file";
    public static final String NOTIFICATION_FILE_COMPLETE = "file complete";
    public static final String NOTIFICATION_FILE_ABORT = "file abort";
    protected static final Map<String, String> NOTIFICATION_SOUNDS = new HashMap<String, String>();
    protected JPanel panel;
    protected JTextPane chatarea;
    protected JTable usertable;
    protected UserTableModel usermodel;
    protected boolean typing;
    protected boolean away;
    protected JTable dtable;
    protected JTable utable;
    protected JTabbedPane tpane;
    protected ISubscriptionIntermediateFuture<ChatEvent> subscription;
    protected Timer refreshtimer;
    protected Timer awaytimer;
    protected JSplitPanel listpan;
    protected JSplitPanel horsplit;
    protected boolean sound;
    protected boolean autorefresh;
    protected Map<String, String> notificationsounds;
    protected JFileChooser filechooser;
    protected RemoteFileChooser rfilechooser;
    protected Map<TransferInfo, JComponent> dialogs;
    protected int reqcnt;
    protected Timer icontimer;
    protected boolean playing;

    public IFuture<Void> init(IControlCenter jcc, IService service) {
        this.sound = true;
        this.autorefresh = true;
        this.notificationsounds = new HashMap<String, String>();
        this.dialogs = new HashMap<TransferInfo, JComponent>();
        this.usermodel = new UserTableModel();
        final Future ret = new Future();
        super.init(jcc, service).addResultListener((IResultListener)new DelegationResultListener<Void>(ret){
            JFileChooser jfil;

            public void customResultAvailable(Void result) {
                DefaultTableCellRenderer userrend = new DefaultTableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focus, int row, int column) {
                        super.getTableCellRendererComponent(table, value, selected, focus, row, column);
                        ChatUser cu = (ChatUser)value;
                        this.setText(cu.getNick() + " [" + cu.getComponentIdentifier() + "]");
                        if (cu.getComponentIdentifier() == null) {
                            System.out.println("CU.CID is null");
                        }
                        if (ChatPanel.this.getService() == null) {
                            System.out.println("service is null");
                        }
                        if (((IService)ChatPanel.this.getService()).getServiceIdentifier() == null) {
                            System.out.println("service.SID is null");
                        }
                        if (!cu.getComponentIdentifier().equals(((IService)ChatPanel.this.getService()).getServiceIdentifier().getProviderId())) {
                            this.setToolTipText("Select to send private message.\nRight-click to send file.");
                        }
                        Icon icon = cu.getIcon();
                        this.setIcon(icon);
                        return this;
                    }
                };
                DefaultTableCellRenderer cidrend = new DefaultTableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focus, int row, int column) {
                        super.getTableCellRendererComponent(table, value, selected, focus, row, column);
                        IComponentIdentifier cid = (IComponentIdentifier)value;
                        this.setText(cid.getName());
                        return this;
                    }
                };
                DefaultTableCellRenderer byterend = new DefaultTableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focus, int row, int column) {
                        super.getTableCellRendererComponent(table, value, selected, focus, row, column);
                        long bytes = ((Number)value).longValue();
                        this.setText(SUtil.bytesToString((long)bytes));
                        this.setToolTipText(bytes + " bytes");
                        return this;
                    }
                };
                DefaultTableCellRenderer stringrend = new DefaultTableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focus, int row, int column) {
                        super.getTableCellRendererComponent(table, value, selected, focus, row, column);
                        if (value != null) {
                            this.setToolTipText(value.toString());
                        }
                        return this;
                    }
                };
                DefaultTableCellRenderer progressrend = new DefaultTableCellRenderer(){
                    JProgressBar bar = new JProgressBar(0, 100);
                    {
                        this.bar.setStringPainted(true);
                    }

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focus, int row, int column) {
                        this.bar.setValue((int)((Double)value * 100.0));
                        return this.bar;
                    }
                };
                DefaultTableCellRenderer speedrend = new DefaultTableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focus, int row, int column) {
                        super.getTableCellRendererComponent(table, value, selected, focus, row, column);
                        TransferInfo info = (TransferInfo)value;
                        if ("Transferring".equals(info.getState())) {
                            double bytes = info.getSpeed();
                            this.setText(SUtil.bytesToString((long)((long)bytes)) + "/sec.");
                            this.setToolTipText(bytes + " bytes/sec.");
                        } else {
                            this.setText("");
                            this.setToolTipText("");
                        }
                        return this;
                    }
                };
                ChatPanel.this.chatarea = new JTextPane(){};
                ChatPanel.this.chatarea.setEditable(false);
                JScrollPane main = new JScrollPane(ChatPanel.this.chatarea);
                final JLabel lto = new JLabel("To: all");
                ChatPanel.this.usertable = new JTable(ChatPanel.this.usermodel);
                ChatPanel.this.usertable.setRowHeight(40);
                ChatPanel.this.usertable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e) {
                        int[] sels = ChatPanel.this.usertable.getSelectedRows();
                        StringBuffer buf = new StringBuffer("To: ");
                        for (int i = 0; i < sels.length; ++i) {
                            ChatUser cu = (ChatUser)ChatPanel.this.usertable.getModel().getValueAt(sels[i], 0);
                            buf.append(cu.getNick());
                            if (i + 1 >= sels.length) continue;
                            buf.append(", ");
                        }
                        if (sels.length == 0) {
                            buf.append("all");
                        }
                        lto.setText(buf.toString());
                    }
                });
                JScrollPane userpan = new JScrollPane(ChatPanel.this.usertable);
                ChatPanel.this.usertable.getColumnModel().getColumn(0).setCellRenderer(userrend);
                ChatPanel.this.usertable.setTransferHandler(new TransferHandler(){

                    @Override
                    public boolean canImport(TransferHandler.TransferSupport support) {
                        boolean ret = false;
                        if (support.isDrop() && support.isDataFlavorSupported(DataFlavor.javaFileListFlavor) && (support.getSourceDropActions() & 1) != 0 && ChatPanel.this.isLocal()) {
                            JTable.DropLocation droploc = (JTable.DropLocation)support.getDropLocation();
                            ChatUser cu = (ChatUser)ChatPanel.this.usertable.getModel().getValueAt(droploc.getRow(), 0);
                            if (!cu.getComponentIdentifier().equals(((IService)ChatPanel.this.getService()).getServiceIdentifier().getProviderId())) {
                                try {
                                    boolean nodirs = true;
                                    if (nodirs) {
                                        ret = true;
                                        support.setDropAction(1);
                                    }
                                }
                                catch (Exception e) {
                                    System.err.println("Drop error: " + e);
                                }
                            }
                        }
                        return ret;
                    }

                    @Override
                    public boolean importData(TransferHandler.TransferSupport support) {
                        boolean success;
                        try {
                            JTable.DropLocation droploc = (JTable.DropLocation)support.getDropLocation();
                            ChatUser cu = (ChatUser)ChatPanel.this.usertable.getModel().getValueAt(droploc.getRow(), 0);
                            List files = (List)support.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                            for (Object file : files) {
                                ((IChatGuiService)ChatPanel.this.getService()).sendFile(((File)file).getAbsolutePath(), cu.getComponentIdentifier());
                            }
                            success = true;
                        }
                        catch (Exception e) {
                            System.err.println("Drop error: " + e);
                            success = false;
                        }
                        return success;
                    }
                });
                MouseAdapter lis = new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        this.trigger(e);
                    }

                    @Override
                    public void mouseReleased(MouseEvent e) {
                        this.trigger(e);
                    }

                    protected void trigger(MouseEvent e) {
                        if (e.isPopupTrigger()) {
                            int row = ChatPanel.this.usertable.rowAtPoint(e.getPoint());
                            ChatPanel.this.usertable.setRowSelectionInterval(row, row);
                            ChatUser cu = (ChatUser)((UserTableModel)ChatPanel.this.usertable.getModel()).getValueAt(row, 0);
                            if (!cu.getComponentIdentifier().equals(((IService)ChatPanel.this.getService()).getServiceIdentifier().getProviderId())) {
                                this.createMenu(cu.getComponentIdentifier()).show(e.getComponent(), e.getX(), e.getY());
                            }
                        }
                    }

                    protected JPopupMenu createMenu(final IComponentIdentifier cid) {
                        JPopupMenu menu = new JPopupMenu();
                        JMenuItem mi = new JMenuItem("Send file ...");
                        mi.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                if (ChatPanel.this.isLocal()) {
                                    File file;
                                    if (ChatPanel.this.filechooser == null) {
                                        ChatPanel.this.filechooser = new JFileChooser(".");
                                        ChatPanel.this.filechooser.setFileSelectionMode(0);
                                    }
                                    if (0 == ChatPanel.this.filechooser.showOpenDialog(ChatPanel.this.panel) && (file = ChatPanel.this.filechooser.getSelectedFile()) != null) {
                                        ((IChatGuiService)ChatPanel.this.getService()).sendFile(file.getAbsolutePath(), cid);
                                    }
                                } else {
                                    ChatPanel.this.getServiceAccess().addResultListener((IResultListener)new SwingResultListener((IResultListener)new IResultListener<IExternalAccess>(){

                                        public void resultAvailable(IExternalAccess ea) {
                                            if (ChatPanel.this.rfilechooser == null) {
                                                ChatPanel.this.rfilechooser = new RemoteFileChooser(ea);
                                            }
                                            ChatPanel.this.rfilechooser.chooseFile(null, ".", (JComponent)ChatPanel.this.panel, 2, null).addResultListener((IResultListener)new SwingResultListener((IResultListener)new IResultListener<FileData>(){

                                                public void resultAvailable(FileData file) {
                                                    if (file != null) {
                                                        ((IChatGuiService)ChatPanel.this.getService()).sendFile(file.getPath(), cid);
                                                    }
                                                }

                                                public void exceptionOccurred(Exception exception) {
                                                }
                                            }));
                                        }

                                        public void exceptionOccurred(Exception exception) {
                                        }
                                    }));
                                }
                            }
                        });
                        menu.add(mi);
                        return menu;
                    }
                };
                ChatPanel.this.usertable.addMouseListener(lis);
                ChatPanel.this.usertable.getTableHeader().addMouseListener(lis);
                Insets binsets = new Insets(1, 3, 1, 3);
                PropertiesPanel pp = new PropertiesPanel("Settings");
                final JTextField tfnick = new JTextField();
                JButton bunick = new JButton("Set");
                bunick.setMargin(binsets);
                JPanel ppan = new JPanel(new BorderLayout());
                ppan.add((Component)tfnick, "Center");
                ppan.add((Component)bunick, "East");
                pp.addComponent("Nickname: ", (JComponent)ppan);
                bunick.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ((IChatGuiService)ChatPanel.this.getService()).setNickName(tfnick.getText());
                    }
                });
                tfnick.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ((IChatGuiService)ChatPanel.this.getService()).setNickName(tfnick.getText());
                    }
                });
                ((IChatGuiService)ChatPanel.this.getService()).getNickName().addResultListener((IResultListener)new SwingResultListener((IResultListener)new IResultListener<String>(){

                    public void resultAvailable(String result) {
                        tfnick.setText(result);
                    }

                    public void exceptionOccurred(Exception exception) {
                    }
                }));
                final JTextField tfava = new JTextField();
                tfava.setEditable(false);
                JButton buava = new JButton("...");
                buava.setMinimumSize(bunick.getMinimumSize());
                buava.setMaximumSize(bunick.getMaximumSize());
                buava.setPreferredSize(bunick.getPreferredSize());
                JPanel apan = new JPanel(new BorderLayout());
                apan.add((Component)tfava, "Center");
                apan.add((Component)buava, "East");
                pp.addComponent("Image: ", (JComponent)apan);
                buava.addActionListener(new ActionListener(){
                    JFileChooser fcava;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (this.fcava == null) {
                            this.fcava = new JFileChooser(".");
                            this.fcava.setFileFilter(new FileFilter(){

                                @Override
                                public String getDescription() {
                                    return "*.jpg, *.png";
                                }

                                @Override
                                public boolean accept(File f) {
                                    return f.isDirectory() || f.getName().endsWith(".jpg") || f.getName().endsWith(".png");
                                }
                            });
                        }
                        this.fcava.showOpenDialog(ChatPanel.this.panel);
                        File sel = this.fcava.getSelectedFile();
                        if (sel != null && sel.exists()) {
                            try {
                                FileInputStream fis = new FileInputStream(sel);
                                byte[] data = new byte[fis.available()];
                                for (int read = 0; read < data.length; read += fis.read(data, read, data.length - read)) {
                                }
                                fis.close();
                                double twh = 40.0;
                                BufferedImage src = ImageIO.read(new ByteArrayInputStream(data));
                                int sw = src.getWidth();
                                int sh = src.getHeight();
                                int tw = sw;
                                int th = sh;
                                double fac = (double)Math.max(sw, sh) / twh;
                                if (fac > 1.0) {
                                    tw = (int)((double)tw / fac);
                                    th = (int)((double)th / fac);
                                    BufferedImage target = SGUI.scaleImage((Image)src, (int)tw, (int)th, (int)2);
                                    data = ImageProcessor.imageToStandardBytes((Image)target, (String)"image/png");
                                }
                                ((IChatGuiService)ChatPanel.this.getService()).setImage(data);
                                tfava.setText(SUtil.convertPathToRelative((String)sel.getAbsolutePath()));
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                });
                final JComboBox<String> jcom = new JComboBox<String>(new String[]{ChatPanel.NOTIFICATION_NEW_MSG, ChatPanel.NOTIFICATION_NEW_USER, ChatPanel.NOTIFICATION_MSG_FAILED, ChatPanel.NOTIFICATION_NEW_FILE, ChatPanel.NOTIFICATION_FILE_ABORT, ChatPanel.NOTIFICATION_FILE_COMPLETE});
                final JTextField jtxt = new JTextField();
                jtxt.setEditable(false);
                jtxt.setText(ChatPanel.this.getNotificationSound((String)jcom.getSelectedItem()));
                JButton jbut = new JButton("...");
                jbut.setMinimumSize(bunick.getMinimumSize());
                jbut.setMaximumSize(bunick.getMaximumSize());
                jbut.setPreferredSize(bunick.getPreferredSize());
                JButton playbut = new JButton(icons.getIcon("play"));
                playbut.setMinimumSize(bunick.getMinimumSize());
                playbut.setMaximumSize(bunick.getMaximumSize());
                playbut.setPreferredSize(bunick.getPreferredSize());
                jcom.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        String sel;
                        if (jfil == null) {
                            jfil = new JFileChooser(".");
                            jfil.setFileFilter(new FileFilter(){

                                @Override
                                public String getDescription() {
                                    return "*.wav";
                                }

                                @Override
                                public boolean accept(File f) {
                                    return f.isDirectory() || f.getName().endsWith(".wav");
                                }
                            });
                        }
                        if ((sel = (String)jcom.getSelectedItem()) != null) {
                            jtxt.setText(ChatPanel.this.getNotificationSound(sel));
                        } else {
                            jtxt.setText("");
                        }
                    }
                });
                jbut.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (jfil == null) {
                            jfil = new JFileChooser(".");
                            jfil.setFileFilter(new FileFilter(){

                                @Override
                                public String getDescription() {
                                    return "*.wav";
                                }

                                @Override
                                public boolean accept(File f) {
                                    return f.isDirectory() || f.getName().endsWith(".wav");
                                }
                            });
                        }
                        try {
                            jfil.showOpenDialog(ChatPanel.this.panel);
                            File sel = jfil.getSelectedFile();
                            if (sel != null) {
                                String txt = SUtil.convertPathToRelative((String)sel.getAbsolutePath());
                                ChatPanel.this.notificationsounds.put((String)jcom.getSelectedItem(), txt);
                                jtxt.setText(txt);
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                });
                playbut.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ChatPanel.this.playSound((String)jcom.getSelectedItem(), true);
                    }
                });
                JPanel pan = new JPanel(new GridBagLayout());
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.fill = 1;
                gbc.weightx = 1.0;
                pan.add(jcom, gbc);
                gbc.weightx = 0.0;
                gbc.gridwidth = 0;
                pan.add((Component)playbut, gbc);
                gbc.weightx = 1.0;
                gbc.gridwidth = -1;
                pan.add((Component)jtxt, gbc);
                gbc.weightx = 0.0;
                gbc.gridwidth = 0;
                pan.add((Component)jbut, gbc);
                pp.addComponent("Sound files: ", (JComponent)pan);
                final JCheckBox cb = pp.createCheckBox("Sound enabled: ", ChatPanel.this.sound, true, 0.0);
                cb.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ChatPanel.this.sound = cb.isSelected();
                    }
                });
                final JCheckBox cbar = pp.createCheckBox("Users auto refresh: ", ChatPanel.this.autorefresh, true, 0.0);
                cbar.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ChatPanel.this.autorefresh = cbar.isSelected();
                        ChatPanel.this.updateRefreshTimer();
                    }
                });
                JButton rsb = pp.createButton("Reset sounds: ", "Reset");
                rsb.setMargin(binsets);
                rsb.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ChatPanel.this.notificationsounds.clear();
                        jtxt.setText(ChatPanel.this.getNotificationSound((String)jcom.getSelectedItem()));
                    }
                });
                JButton b = pp.createButton("Reset receivers: ", "Reset");
                b.setMargin(binsets);
                b.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ChatPanel.this.usertable.getSelectionModel().clearSelection();
                        lto.setText("To: all");
                    }
                });
                ChatPanel.this.listpan = new JSplitPanel(0, (Component)userpan, (Component)new JScrollPane((Component)pp));
                ChatPanel.this.listpan.setDividerLocation(0.5);
                ChatPanel.this.listpan.setOneTouchExpandable(true);
                ChatPanel.this.listpan.setResizeWeight(1.0);
                JPanel south = new JPanel(new BorderLayout(2, 0));
                final JTextField tf = new JTextField();
                JButton send = new JButton("Send");
                final JButton smi = new JButton(icons.getIcon(":-)"));
                smi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        final String[] smiley = new String[1];
                        final JDialog dia = new JDialog((Frame)null, "Smiley Selection", false);
                        JPanel pan = new JPanel(new FlowLayout());
                        for (final String key : smileys) {
                            JButton but = new JButton(icons.getIcon(key));
                            but.setMargin(new Insets(0, 0, 0, 0));
                            but.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    smiley[0] = key;
                                    dia.dispose();
                                    if (smiley[0] != null) {
                                        tf.setText(tf.getText() + smiley[0]);
                                    }
                                }
                            });
                            pan.add(but);
                        }
                        dia.getContentPane().add((Component)pan, "Center");
                        dia.setUndecorated(true);
                        dia.addWindowFocusListener(new WindowFocusListener(){

                            @Override
                            public void windowLostFocus(WindowEvent e) {
                                dia.dispose();
                            }

                            @Override
                            public void windowGainedFocus(WindowEvent e) {
                            }
                        });
                        dia.pack();
                        dia.setLocationRelativeTo(smi);
                        Point loc = dia.getLocation();
                        dia.setLocation(new Point((int)loc.getX(), (int)(loc.getY() - 30.0)));
                        dia.setVisible(true);
                    }
                });
                smi.setMargin(new Insets(0, 0, 0, 0));
                JPanel bp = new JPanel(new BorderLayout(2, 0));
                bp.add((Component)smi, "West");
                bp.add((Component)send, "East");
                south.add((Component)lto, "West");
                south.add((Component)tf, "Center");
                south.add((Component)bp, "East");
                tf.getDocument().addDocumentListener(new DocumentListener(){

                    @Override
                    public void removeUpdate(DocumentEvent e) {
                        this.update();
                    }

                    @Override
                    public void insertUpdate(DocumentEvent e) {
                        this.update();
                    }

                    @Override
                    public void changedUpdate(DocumentEvent e) {
                        this.update();
                    }

                    public void update() {
                        boolean newtyping;
                        ChatPanel.this.setAway(false);
                        boolean bl = newtyping = tf.getText().length() != 0;
                        if (newtyping != ChatPanel.this.typing) {
                            ChatPanel.this.typing = newtyping;
                            ChatPanel.this.postStatus();
                        }
                    }
                });
                ActionListener al = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String msg = tf.getText();
                        tf.setText("");
                        ChatPanel.this.typing = false;
                        ChatPanel.this.tell(msg);
                    }
                };
                tf.addActionListener(al);
                send.addActionListener(al);
                ChatPanel.this.horsplit = new JSplitPanel(1, (Component)ChatPanel.this.listpan, (Component)main);
                ChatPanel.this.horsplit.setOneTouchExpandable(true);
                ChatPanel.this.horsplit.setDividerLocation(0.3);
                JPanel msgpane = new JPanel(new BorderLayout());
                msgpane.add((Component)ChatPanel.this.horsplit, "Center");
                msgpane.add((Component)south, "South");
                ChatPanel.this.dtable = new JTable(new FileTableModel(true));
                ChatPanel.this.utable = new JTable(new FileTableModel(false));
                final JScrollPane dtpan = new JScrollPane(ChatPanel.this.dtable);
                final JScrollPane utpan = new JScrollPane(ChatPanel.this.utable);
                ChatPanel.this.usertable.addHierarchyListener(new HierarchyListener(){

                    @Override
                    public void hierarchyChanged(HierarchyEvent e) {
                        if ((e.getChangeFlags() & 4L) != 0L) {
                            ChatPanel.this.updateRefreshTimer();
                        }
                    }
                });
                dtpan.addHierarchyListener(new HierarchyListener(){
                    Timer timer;

                    @Override
                    public void hierarchyChanged(HierarchyEvent e) {
                        if (dtpan.isShowing() && this.timer == null) {
                            this.timer = new Timer(1000, new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    ChatPanel.this.dtable.repaint();
                                }
                            });
                            this.timer.start();
                        } else if (!dtpan.isShowing() && this.timer != null) {
                            this.timer.stop();
                            this.timer = null;
                        }
                    }
                });
                utpan.addHierarchyListener(new HierarchyListener(){
                    Timer timer;

                    @Override
                    public void hierarchyChanged(HierarchyEvent e) {
                        if (utpan.isShowing() && this.timer == null) {
                            this.timer = new Timer(1000, new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    ChatPanel.this.utable.repaint();
                                }
                            });
                            this.timer.start();
                        } else if (!utpan.isShowing() && this.timer != null) {
                            this.timer.stop();
                            this.timer = null;
                        }
                    }
                });
                ChatPanel.this.dtable.getColumnModel().getColumn(0).setCellRenderer(stringrend);
                ChatPanel.this.dtable.getColumnModel().getColumn(1).setCellRenderer(stringrend);
                ChatPanel.this.dtable.getColumnModel().getColumn(2).setCellRenderer(cidrend);
                ChatPanel.this.dtable.getColumnModel().getColumn(3).setCellRenderer(byterend);
                ChatPanel.this.dtable.getColumnModel().getColumn(4).setCellRenderer(byterend);
                ChatPanel.this.dtable.getColumnModel().getColumn(5).setCellRenderer(progressrend);
                ChatPanel.this.dtable.getColumnModel().getColumn(7).setCellRenderer(speedrend);
                ChatPanel.this.utable.getColumnModel().getColumn(0).setCellRenderer(stringrend);
                ChatPanel.this.utable.getColumnModel().getColumn(1).setCellRenderer(stringrend);
                ChatPanel.this.utable.getColumnModel().getColumn(2).setCellRenderer(cidrend);
                ChatPanel.this.utable.getColumnModel().getColumn(3).setCellRenderer(byterend);
                ChatPanel.this.utable.getColumnModel().getColumn(4).setCellRenderer(byterend);
                ChatPanel.this.utable.getColumnModel().getColumn(5).setCellRenderer(progressrend);
                ChatPanel.this.utable.getColumnModel().getColumn(7).setCellRenderer(speedrend);
                FileTransferMouseAdapter dlis = new FileTransferMouseAdapter(ChatPanel.this.dtable);
                FileTransferMouseAdapter ulis = new FileTransferMouseAdapter(ChatPanel.this.utable);
                ChatPanel.this.dtable.addMouseListener(dlis);
                ChatPanel.this.dtable.getTableHeader().addMouseListener(dlis);
                ChatPanel.this.utable.addMouseListener(ulis);
                ChatPanel.this.utable.getTableHeader().addMouseListener(ulis);
                ChatPanel.this.tpane = new JTabbedPane();
                ChatPanel.this.tpane.add("Messaging", msgpane);
                ChatPanel.this.tpane.add("Downloads", dtpan);
                ChatPanel.this.tpane.add("Uploads", utpan);
                ChatPanel.this.panel = new JPanel(new BorderLayout());
                ChatPanel.this.panel.add((Component)ChatPanel.this.tpane, "Center");
                ChatPanel.this.subscription = ((IChatGuiService)ChatPanel.this.getService()).subscribeToEvents();
                ChatPanel.this.subscription.addResultListener((IResultListener)new SwingIntermediateDefaultResultListener<ChatEvent>(){

                    public void customIntermediateResultAvailable(ChatEvent ce) {
                        if ("message".equals(ce.getType())) {
                            ChatPanel.this.addMessage(ce.getComponentIdentifier(), (String)ce.getValue(), ce.getNick(), ce.isPrivateMessage(), false);
                        } else if ("statechange".equals(ce.getType())) {
                            ChatPanel.this.setUserState(ce.getComponentIdentifier(), !"dead".equals(ce.getValue()) ? Boolean.TRUE : Boolean.FALSE, "typing".equals(ce.getValue()) ? Boolean.TRUE : Boolean.FALSE, "away".equals(ce.getValue()) ? Boolean.TRUE : Boolean.FALSE, ce.getNick(), ce.getImage());
                        } else if ("file".equals(ce.getType())) {
                            final TransferInfo ti = (TransferInfo)ce.getValue();
                            ChatPanel.this.updateTransfer(ti);
                            if (ti.isDownload() && "Waiting".equals(ti.getState())) {
                                ChatPanel.this.notifyChatEvent(ChatPanel.NOTIFICATION_NEW_FILE, ti.getOther(), ti, false);
                                ChatPanel.this.acceptFile(ti).addResultListener((IResultListener)new IResultListener<String>(){

                                    public void resultAvailable(String filepath) {
                                        ((IChatGuiService)ChatPanel.this.getService()).acceptFile(ti.getId(), filepath);
                                    }

                                    public void exceptionOccurred(Exception exception) {
                                        ((IChatGuiService)ChatPanel.this.getService()).rejectFile(ti.getId());
                                    }
                                });
                            }
                        }
                    }

                    public void customExceptionOccurred(Exception exception) {
                        ret.setExceptionIfUndone(exception);
                    }
                });
                ret.setResultIfUndone(null);
                ((IChatGuiService)ChatPanel.this.getService()).findUsers().addResultListener((IResultListener)new SwingIntermediateDefaultResultListener<IChatService>(){

                    public void customIntermediateResultAvailable(IChatService chat) {
                        IComponentIdentifier cid = ((IService)chat).getServiceIdentifier().getProviderId();
                        ChatPanel.this.updateChatUser(cid, chat);
                    }

                    public void customExceptionOccurred(Exception exception) {
                    }
                });
                ((IChatGuiService)ChatPanel.this.getService()).getFileTransfers().addResultListener((IResultListener)new SwingIntermediateDefaultResultListener<TransferInfo>(){

                    public void customIntermediateResultAvailable(TransferInfo ti) {
                        ChatPanel.this.updateTransfer(ti);
                    }

                    public void customExceptionOccurred(Exception exception) {
                    }
                });
                ChatPanel.this.updateRefreshTimer();
            }
        });
        return ret;
    }

    protected void updateRefreshTimer() {
        this.setAway(!this.usertable.isShowing());
        if (this.usertable.isShowing() && this.autorefresh && this.refreshtimer == null) {
            this.refreshtimer = new Timer(10000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ChatPanel.this.autorefresh) {
                        for (IComponentIdentifier cu : ChatPanel.this.usermodel.getUserIDs()) {
                            ChatPanel.this.setUserState(cu, null, null, null, null, null);
                        }
                        ((IChatGuiService)ChatPanel.this.getService()).findUsers().addResultListener((IResultListener)new SwingIntermediateDefaultResultListener<IChatService>(){

                            public void customIntermediateResultAvailable(IChatService chat) {
                                IComponentIdentifier cid = ((IService)chat).getServiceIdentifier().getProviderId();
                                ChatPanel.this.updateChatUser(cid, chat);
                            }

                            public void customExceptionOccurred(Exception exception) {
                            }
                        });
                    }
                }
            });
            this.refreshtimer.setInitialDelay(0);
            this.refreshtimer.start();
        } else if (!(this.autorefresh && this.usertable.isShowing() || this.refreshtimer == null)) {
            this.refreshtimer.stop();
            this.refreshtimer = null;
        }
    }

    protected void setAway(boolean away) {
        if (away != this.away) {
            this.away = away;
            this.postStatus();
        }
        if (this.awaytimer != null) {
            this.awaytimer.stop();
        }
        if (!away) {
            if (this.awaytimer == null) {
                this.awaytimer = new Timer(300000, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ChatPanel.this.setAway(true);
                    }
                });
                this.awaytimer.setRepeats(false);
            }
            this.awaytimer.start();
        }
    }

    protected void updateChatUser(final IComponentIdentifier cid, IChatService cs) {
        this.setUserState(cid, Boolean.TRUE, null, null, null, null);
        ChatUser cu = this.usermodel.getUser(cid);
        if (cu == null || cu.isNickUnknown()) {
            cs.getNickName().addResultListener((IResultListener)new SwingResultListener((IResultListener)new IResultListener<String>(){

                public void resultAvailable(String nick) {
                    ChatPanel.this.setUserState(cid, Boolean.TRUE, null, null, nick, null);
                }

                public void exceptionOccurred(Exception exception) {
                }
            }));
        }
        if (cu == null || cu.isAvatarUnknown()) {
            cs.getImage().addResultListener((IResultListener)new SwingResultListener((IResultListener)new IResultListener<byte[]>(){

                public void resultAvailable(byte[] img) {
                    ChatPanel.this.setUserState(cid, Boolean.TRUE, null, null, null, img);
                }

                public void exceptionOccurred(Exception exception) {
                }
            }));
        }
        cs.getStatus().addResultListener((IResultListener)new SwingResultListener((IResultListener)new IResultListener<String>(){

            public void resultAvailable(String status) {
                ChatPanel.this.setUserState(cid, Boolean.TRUE, "typing".equals(status) ? Boolean.TRUE : Boolean.FALSE, "away".equals(status) ? Boolean.TRUE : Boolean.FALSE, null, null);
            }

            public void exceptionOccurred(Exception exception) {
            }
        }));
    }

    public JComponent getComponent() {
        return this.panel;
    }

    public IFuture<Void> shutdown() {
        Future ret = new Future();
        if (this.refreshtimer != null) {
            this.refreshtimer.stop();
        }
        if (this.awaytimer != null) {
            this.awaytimer.stop();
        }
        if (this.icontimer != null) {
            this.icontimer.stop();
            this.icontimer = null;
        }
        super.shutdown().addResultListener((IResultListener)new DelegationResultListener<Void>(ret){

            public void customResultAvailable(Void result) {
                ChatPanel.this.subscription.terminate();
            }
        });
        return ret;
    }

    public IFuture<Void> tell(final String text) {
        final Future ret = new Future();
        final HashSet<ChatUser> sendusers = new HashSet<ChatUser>();
        final int id = ++this.reqcnt;
        int[] sels = this.usertable.getSelectedRows();
        IComponentIdentifier[] recs = new IComponentIdentifier[sels.length];
        if (sels.length > 0) {
            for (int i = 0; i < sels.length; ++i) {
                ChatUser cu = (ChatUser)this.usertable.getModel().getValueAt(sels[i], 0);
                cu.addMessage(id);
                sendusers.add(cu);
                recs[i] = cu.getComponentIdentifier();
            }
        } else {
            for (ChatUser cu : this.usermodel.getUsers()) {
                cu.addMessage(id);
                sendusers.add(cu);
            }
        }
        this.usertable.repaint();
        ((IChatGuiService)this.getService()).message(text, recs, true).addResultListener((IResultListener)new SwingIntermediateDefaultResultListener<IChatService>(){

            public void customIntermediateResultAvailable(IChatService chat) {
                ChatUser cu = ChatPanel.this.usermodel.getUser(((IService)chat).getServiceIdentifier().getProviderId());
                if (cu != null) {
                    sendusers.remove(cu);
                    cu.removeMessage(id);
                    ChatPanel.this.usertable.repaint();
                }
            }

            public void customFinished() {
                ret.setResult(null);
                this.printFailures();
            }

            public void customExceptionOccurred(Exception exception) {
                ret.setException(exception);
                this.printFailures();
            }

            protected void printFailures() {
                if (!sendusers.isEmpty()) {
                    StringBuffer nick = new StringBuffer();
                    nick.append("failed to deliver message to");
                    for (ChatUser cu : sendusers) {
                        nick.append(" ");
                        nick.append(cu.getNick());
                        nick.append(",");
                        cu.removeMessage(id);
                    }
                    ChatPanel.this.usertable.repaint();
                    ChatPanel.this.addMessage(((IService)ChatPanel.this.getService()).getServiceIdentifier().getProviderId(), text, nick.substring(0, nick.length() - 1), false, true);
                }
            }
        });
        return ret;
    }

    public IFuture<Void> postStatus() {
        final Future ret = new Future();
        String status = this.typing ? "typing" : (this.away ? "away" : "idle");
        ((IChatGuiService)this.getService()).status(status, null, new IComponentIdentifier[0]).addResultListener((IResultListener)new IntermediateDefaultResultListener<IChatService>(){

            public void intermediateResultAvailable(IChatService chat) {
            }

            public void finished() {
                ret.setResult(null);
            }

            public void exceptionOccurred(Exception exception) {
            }
        });
        return ret;
    }

    public void addMessage(final IComponentIdentifier cid, final String text, final String nick, final boolean privatemessage, final boolean sendfailure) {
        SServiceProvider.getService((IExternalAccess)this.getJCC().getJCCAccess(), IClockService.class, (String)"platform").addResultListener((IResultListener)new SwingResultListener((IResultListener)new IResultListener<IClockService>(){

            public void resultAvailable(IClockService clock) {
                StringBuffer buf = new StringBuffer();
                buf.append("[").append(ChatPanel.this.df.format(new Date(clock.getTime()))).append(", ").append(nick).append("]: ").append(text).append(lf);
                ChatPanel.append(sendfailure ? Color.GRAY : (privatemessage ? Color.RED : Color.BLACK), buf.toString(), ChatPanel.this.chatarea);
                ChatPanel.this.notifyChatEvent(sendfailure ? ChatPanel.NOTIFICATION_MSG_FAILED : ChatPanel.NOTIFICATION_NEW_MSG, cid, text, false);
                ChatPanel.this.setUserState(cid, Boolean.TRUE, null, null, null, null);
            }

            public void exceptionOccurred(Exception exception) {
            }
        }));
    }

    public void setUserState(final IComponentIdentifier cid, final Boolean online, final Boolean typing, final Boolean away, final String nickname, final byte[] image) {
        if (cid == null) {
            throw new NullPointerException();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean isnew = false;
                boolean isdead = false;
                ChatUser cu = ChatPanel.this.usermodel.getUser(cid);
                if (cu == null && online != null && online.booleanValue()) {
                    cu = new ChatUser(cid);
                    ChatPanel.this.usermodel.addUser(cid, cu);
                    isnew = true;
                }
                if (cu != null) {
                    isdead = cu.setOnline(online);
                    if (isdead) {
                        ChatPanel.this.usermodel.removeUser(cid);
                    } else {
                        if (away != null) {
                            cu.setAway(away);
                        }
                        if (typing != null) {
                            cu.setTyping(typing);
                        }
                        if (nickname != null) {
                            cu.setNick(nickname);
                        }
                        if (image != null) {
                            cu.setAvatar(new ImageIcon(image));
                        }
                        if (isnew) {
                            ChatPanel.this.notifyChatEvent(ChatPanel.NOTIFICATION_NEW_USER, cid, null, false);
                        }
                    }
                    ((DefaultTableModel)ChatPanel.this.usertable.getModel()).fireTableDataChanged();
                    ChatPanel.this.usertable.getParent().invalidate();
                    ChatPanel.this.usertable.getParent().doLayout();
                    ChatPanel.this.usertable.repaint();
                }
            }
        });
    }

    public IFuture<String> acceptFile(final TransferInfo ti) {
        final Future ret = new Future();
        final Future initial = new Future();
        if (this.isLocal()) {
            File file = new File(".", ti.getFileName());
            initial.setResult((Object)new Tuple2((Object)file.getAbsolutePath(), (Object)(file.exists() ? Boolean.TRUE : Boolean.FALSE)));
        } else {
            this.getServiceAccess().addResultListener((IResultListener)new SwingExceptionDelegationResultListener<IExternalAccess, Tuple2<String, Boolean>>(initial){

                public void customResultAvailable(IExternalAccess ea) {
                    SRemoteGui.getFileData((IExternalAccess)ea, (String)ti.getFileName()).addResultListener((IResultListener)new SwingExceptionDelegationResultListener<FileData, Tuple2<String, Boolean>>(initial){

                        public void customResultAvailable(FileData file) {
                            initial.setResult((Object)new Tuple2((Object)file.getPath(), (Object)(file.isExists() ? Boolean.TRUE : Boolean.FALSE)));
                        }
                    });
                }
            });
        }
        final boolean[] exists = new boolean[1];
        final PropertiesPanel pp = new PropertiesPanel();
        JPanel fnp = new JPanel(new GridBagLayout());
        final JTextField tfpath = new JTextField(ti.getFileName(), 15);
        JButton bupath = new JButton("...");
        bupath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ChatPanel.this.isLocal()) {
                    File file;
                    if (ChatPanel.this.filechooser == null) {
                        ChatPanel.this.filechooser = new JFileChooser();
                        ChatPanel.this.filechooser.setFileSelectionMode(0);
                    }
                    ChatPanel.this.filechooser.setSelectedFile(new File(tfpath.getText()));
                    if (0 == ChatPanel.this.filechooser.showDialog(ChatPanel.this.panel, "Save file") && (file = ChatPanel.this.filechooser.getSelectedFile()) != null) {
                        tfpath.setText(file.getAbsolutePath());
                        exists[0] = file.exists();
                    }
                } else {
                    ChatPanel.this.getServiceAccess().addResultListener((IResultListener)new SwingResultListener((IResultListener)new IResultListener<IExternalAccess>(){

                        public void resultAvailable(IExternalAccess ea) {
                            if (ChatPanel.this.rfilechooser == null) {
                                ChatPanel.this.rfilechooser = new RemoteFileChooser(ea);
                            }
                            ChatPanel.this.rfilechooser.chooseFile("Save file", tfpath.getText(), (JComponent)ChatPanel.this.panel, 2, null).addResultListener((IResultListener)new SwingResultListener((IResultListener)new IResultListener<FileData>(){

                                public void resultAvailable(FileData file) {
                                    if (file != null) {
                                        tfpath.setText(file.getPath());
                                        exists[0] = file.isExists();
                                    }
                                }

                                public void exceptionOccurred(Exception exception) {
                                }
                            }));
                        }

                        public void exceptionOccurred(Exception exception) {
                        }
                    }));
                }
            }
        });
        bupath.setMargin(new Insets(0, 0, 0, 0));
        fnp.add((Component)tfpath, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 2), 0, 0));
        fnp.add((Component)bupath, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 0), 0, 0));
        pp.addComponent("File path: ", (JComponent)fnp);
        pp.createTextField("Size: ", SUtil.bytesToString((long)ti.getSize()));
        pp.createTextField("Sender: ", "" + (ti.getOther() == null ? ti.getOther() : ti.getOther().getName()));
        pp.createTextField("Time left: ", "", false);
        initial.addResultListener((IResultListener)new ExceptionDelegationResultListener<Tuple2<String, Boolean>, String>(ret){

            public void customResultAvailable(Tuple2<String, Boolean> result) {
                tfpath.setText((String)result.getFirstEntity());
                exists[0] = (Boolean)result.getSecondEntity();
                ChatPanel.this.dialogs.put(ti, (JComponent)pp);
                Timer timer = new Timer(1000, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        pp.getTextField("Time left: ").setText(Long.toString(Math.max(0L, (ti.getTimeout() - System.currentTimeMillis()) / 1000L)));
                    }
                });
                timer.start();
                int res = JOptionPane.showOptionDialog(ChatPanel.this.panel, pp, "Incoming File Transfer", 1, 3, null, new Object[]{"Accept", "Reject", "Cancel"}, "Accept");
                timer.stop();
                ChatPanel.this.dialogs.remove(ti);
                if (0 == res) {
                    if (exists[0] && 1 == JOptionPane.showConfirmDialog(ChatPanel.this.panel, "File already exists. Are you sure you want to overwrite it?")) {
                        ChatPanel.this.acceptFile(ti).addResultListener((IResultListener)new SwingDelegationResultListener(ret));
                    } else {
                        ret.setResult((Object)tfpath.getText());
                    }
                } else if (1 == res) {
                    ret.setException((Exception)new RuntimeException("Rejected"));
                }
            }
        });
        return ret;
    }

    protected void notifyChatEvent(String type, IComponentIdentifier source, Object value, boolean quiet) {
        if (!((IService)this.getService()).getServiceIdentifier().getProviderId().equals(source) || NOTIFICATION_MSG_FAILED.equals(type)) {
            int tab;
            String text = null;
            if (NOTIFICATION_NEW_MSG.equals(type)) {
                text = "New chat message from " + source + ": " + value;
            } else if (NOTIFICATION_MSG_FAILED.equals(type)) {
                text = "Chat message failed: " + value;
            } else if (NOTIFICATION_NEW_USER.equals(type)) {
                text = "New chat user online: " + source;
            } else if (NOTIFICATION_NEW_FILE.equals(type)) {
                text = "New file upload request from " + source + ": " + ((TransferInfo)value).getFileName();
            } else if (NOTIFICATION_FILE_COMPLETE.equals(type)) {
                text = ((TransferInfo)value).isDownload() ? "Completed downloading '" + ((TransferInfo)value).getFileName() + "' from " + source : "Completed uploading '" + ((TransferInfo)value).getFileName() + "' to " + source;
            } else if (NOTIFICATION_FILE_ABORT.equals(type)) {
                String string = text = ((TransferInfo)value).isDownload() ? "Problem while downloading '" + ((TransferInfo)value).getFileName() + "' from " + source : "Problem while uploading '" + ((TransferInfo)value).getFileName() + "' to " + source;
            }
            if (text != null) {
                if (!this.tpane.isShowing() && (NOTIFICATION_NEW_MSG.equals(type) || NOTIFICATION_NEW_FILE.equals(type))) {
                    String tip;
                    JComponent scomp = this.getJCC().getStatusComponent((Object)"chat-status-comp");
                    if (scomp == null) {
                        final JButton but = new JButton(ChatPlugin.getStatusIcon(false));
                        scomp = but;
                        assert (this.icontimer == null);
                        this.icontimer = new Timer(500, new ActionListener(){
                            boolean star;

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                this.star = !this.star;
                                but.setIcon(ChatPlugin.getStatusIcon(this.star));
                            }
                        });
                        this.icontimer.setRepeats(true);
                        this.icontimer.start();
                        but.setMargin(new Insets(0, 0, 0, 0));
                        but.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                ChatPanel.this.getJCC().showPlugin("Chat");
                            }
                        });
                        this.getJCC().addStatusComponent((Object)"chat-status-comp", scomp);
                        this.tpane.addHierarchyListener(new HierarchyListener(){

                            @Override
                            public void hierarchyChanged(HierarchyEvent e) {
                                if (ChatPanel.this.tpane.isShowing()) {
                                    ChatPanel.this.getJCC().removeStatusComponent((Object)"chat-status-comp");
                                    ChatPanel.this.icontimer.stop();
                                    ChatPanel.this.icontimer = null;
                                    ChatPanel.this.tpane.removeHierarchyListener(this);
                                }
                            }
                        });
                    }
                    if ((tip = scomp.getToolTipText()) == null || !tip.contains(text)) {
                        tip = tip == null || tip.length() == 0 ? "<html>" + text + "</html>" : tip.substring(0, tip.length() - 7) + "<br/>" + text + "</html>";
                        scomp.setToolTipText(tip);
                    }
                }
                this.getJCC().setStatusText(text);
            }
            int n = value instanceof TransferInfo ? (((TransferInfo)value).isDownload() ? 1 : 2) : (tab = NOTIFICATION_NEW_MSG.equals(type) ? 0 : -1);
            if (tab != -1 && !this.tpane.getComponentAt(tab).isShowing()) {
                this.tpane.setIconAt(tab, ChatPlugin.getTabIcon());
                this.tpane.getComponentAt(tab).addHierarchyListener(new HierarchyListener(){

                    @Override
                    public void hierarchyChanged(HierarchyEvent e) {
                        if (ChatPanel.this.tpane.getComponentAt(tab).isShowing()) {
                            ChatPanel.this.tpane.setIconAt(tab, null);
                            ChatPanel.this.tpane.getComponentAt(tab).removeHierarchyListener(this);
                        }
                    }
                });
            }
            if (!quiet && this.sound) {
                this.playSound(type, false);
            }
        }
    }

    protected void playSound(final String type, final boolean verbose) {
        assert (SwingUtilities.isEventDispatchThread());
        if (!this.playing) {
            this.playing = true;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        File f;
                        String filename = ChatPanel.this.getNotificationSound(type);
                        URL url = this.getClass().getResource(filename);
                        if (url == null && (f = new File(filename)).exists()) {
                            url = f.toURI().toURL();
                        }
                        final AudioInputStream ais = AudioSystem.getAudioInputStream(url);
                        AudioFormat format = ais.getFormat();
                        DataLine.Info info = new DataLine.Info(Clip.class, format);
                        Clip clip = (Clip)AudioSystem.getLine(info);
                        clip.open(ais);
                        clip.addLineListener(new LineListener(){

                            @Override
                            public void update(LineEvent event) {
                                if (event.getType() == LineEvent.Type.STOP) {
                                    event.getLine().close();
                                    try {
                                        ais.close();
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            ChatPanel.this.playing = false;
                                        }
                                    });
                                }
                            }
                        });
                        clip.start();
                    }
                    catch (Throwable e) {
                        if (verbose) {
                            System.err.println("Couldn't play notification sound '" + type + "': " + e);
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ChatPanel.this.playing = false;
                            }
                        });
                    }
                }
            }).start();
        }
    }

    public void updateTransfer(TransferInfo fi) {
        if (this.dialogs.containsKey(fi)) {
            SGUI.getWindowParent((Component)this.dialogs.get(fi)).dispose();
        }
        if ("Completed".equals(fi.getState())) {
            this.notifyChatEvent(NOTIFICATION_FILE_COMPLETE, fi.getOther(), fi, false);
        } else if (fi.isFinished()) {
            this.notifyChatEvent(NOTIFICATION_FILE_ABORT, fi.getOther(), fi, false);
        }
        ((FileTableModel)(fi.isDownload() ? this.dtable : this.utable).getModel()).updateFile(fi);
    }

    public static void append(Color c, String s, JTextPane p) {
        String next;
        String found = null;
        for (String key : smileys) {
            if (!s.startsWith(key)) continue;
            found = key;
            break;
        }
        if (found != null) {
            ChatPanel.doAppend(c, found, p);
            if (s.length() > found.length()) {
                next = s.substring(found.length(), s.length());
                ChatPanel.append(c, next, p);
            }
        } else {
            next = s.substring(0, 1);
            ChatPanel.doAppend(c, next, p);
            if (s.length() > 1) {
                next = s.substring(1, s.length());
                ChatPanel.append(c, next, p);
            }
        }
    }

    public static void doAppend(Color c, String s, JTextPane p) {
        p.setEditable(true);
        SimpleAttributeSet aset = new SimpleAttributeSet();
        if (smileys.contains(s)) {
            StyleConstants.setIcon(aset, icons.getIcon(s));
        } else {
            StyleConstants.setForeground(aset, c);
        }
        StyledDocument doc = p.getStyledDocument();
        aset.addAttribute("dummy", doc.getLength());
        p.setCaretPosition(doc.getLength());
        p.setCharacterAttributes(aset, false);
        p.replaceSelection(s);
        p.setEditable(false);
    }

    public String getNotificationSound(String type) {
        String ret = this.notificationsounds.get(type);
        if (ret == null) {
            ret = NOTIFICATION_SOUNDS.get(type);
        }
        return ret;
    }

    public IFuture<Void> setProperties(Properties props) {
        double hs;
        double lp;
        String snd;
        String ar = props.getStringProperty("autorefresh");
        if (ar != null) {
            this.autorefresh = Boolean.parseBoolean(ar);
            this.updateRefreshTimer();
        }
        if ((snd = props.getStringProperty("sound")) != null) {
            this.sound = Boolean.parseBoolean(snd);
        }
        if ((lp = props.getDoubleProperty("listpan")) != 0.0) {
            this.listpan.setDividerLocation(lp);
        }
        if ((hs = props.getDoubleProperty("horsplit")) != 0.0) {
            this.horsplit.setDividerLocation(hs);
        }
        if ((snd = props.getStringProperty(NOTIFICATION_FILE_ABORT)) != null) {
            this.notificationsounds.put(NOTIFICATION_FILE_ABORT, snd);
        }
        if ((snd = props.getStringProperty(NOTIFICATION_FILE_COMPLETE)) != null) {
            this.notificationsounds.put(NOTIFICATION_FILE_COMPLETE, snd);
        }
        if ((snd = props.getStringProperty(NOTIFICATION_NEW_FILE)) != null) {
            this.notificationsounds.put(NOTIFICATION_NEW_FILE, snd);
        }
        if ((snd = props.getStringProperty(NOTIFICATION_NEW_MSG)) != null) {
            this.notificationsounds.put(NOTIFICATION_NEW_MSG, snd);
        }
        if ((snd = props.getStringProperty(NOTIFICATION_NEW_USER)) != null) {
            this.notificationsounds.put(NOTIFICATION_NEW_USER, snd);
        }
        return IFuture.DONE;
    }

    public IFuture<Properties> getProperties() {
        double hs;
        Properties props = new Properties();
        props.addProperty(new Property("autorefresh", "" + this.autorefresh));
        props.addProperty(new Property("sound", "" + this.sound));
        double lp = this.listpan.getProportionalDividerLocation();
        if (lp > 0.0) {
            props.addProperty(new Property("listpan", "" + lp));
        }
        if ((hs = this.horsplit.getProportionalDividerLocation()) > 0.0) {
            props.addProperty(new Property("horsplit", "" + hs));
        }
        for (String key : this.notificationsounds.keySet()) {
            props.addProperty(new Property(key, this.notificationsounds.get(key)));
        }
        return new Future((Object)props);
    }

    static {
        NOTIFICATION_SOUNDS.put(NOTIFICATION_NEW_USER, "sounds/pling.wav");
        NOTIFICATION_SOUNDS.put(NOTIFICATION_NEW_MSG, "sounds/ping.wav");
        NOTIFICATION_SOUNDS.put(NOTIFICATION_NEW_FILE, "sounds/cuckoo_clock.wav");
        NOTIFICATION_SOUNDS.put(NOTIFICATION_FILE_COMPLETE, "sounds/music_box.wav");
        NOTIFICATION_SOUNDS.put(NOTIFICATION_MSG_FAILED, "sounds/blurps.wav");
        NOTIFICATION_SOUNDS.put(NOTIFICATION_FILE_ABORT, "sounds/blurps.wav");
    }

    public class FileTableModel
    extends AbstractTableModel {
        protected boolean down;
        protected String[] columns;
        protected Map<String, TransferInfo> data;
        boolean dorefresh;

        public FileTableModel(boolean down) {
            this.down = down;
            this.columns = new String[]{"Name", "Path", down ? "Sender" : "Receiver", "Size", "Done", "%", "State", "Speed", "Remaining Time"};
            this.data = new LinkedHashMap<String, TransferInfo>();
        }

        protected JTable getTable() {
            return this.down ? ChatPanel.this.dtable : ChatPanel.this.utable;
        }

        protected Map<String, TransferInfo> getDataMap() {
            return this.data;
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public String getColumnName(int i) {
            return this.columns[i];
        }

        @Override
        public Class<?> getColumnClass(int i) {
            return String.class;
        }

        @Override
        public int getRowCount() {
            return this.getDataMap().size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            Object ret;
            TransferInfo[] files = this.getDataMap().values().toArray(new TransferInfo[this.getDataMap().size()]);
            if (column == 0) {
                ret = files[row].getFileName();
            } else if (column == 1) {
                ret = files[row].getFilePath() != null ? files[row].getFilePath() : "n/a";
            } else if (column == 2) {
                ret = files[row].getOther();
            } else if (column == 3) {
                ret = files[row].getSize();
            } else if (column == 4) {
                ret = files[row].getDone();
            } else if (column == 5) {
                ret = files[row].getSize() == 0L ? 1.0 : Double.valueOf((double)files[row].getDone() / (double)files[row].getSize());
            } else if (column == 6) {
                ret = files[row].getState();
            } else if (column == 7) {
                ret = files[row];
            } else if (column == 8) {
                if ("Transferring".equals(files[row].getState())) {
                    long time = (long)((double)(files[row].getSize() - files[row].getDone()) / files[row].getSpeed());
                    long hrs = time / 3600L;
                    long min = time % 3600L / 60L;
                    long sec = time % 60L;
                    ret = hrs + ":" + (min < 10L ? "0" + min : Long.valueOf(min)) + ":" + (sec < 10L ? "0" + sec : Long.valueOf(sec));
                } else {
                    long time;
                    ret = files[row].getTimeout() > 0L ? ((time = (files[row].getTimeout() - System.currentTimeMillis()) / 1000L) > 0L ? Long.toString(time) : "0") : "";
                }
            } else {
                throw new RuntimeException("Unknown column");
            }
            return ret;
        }

        public TransferInfo getValueAt(int row) {
            TransferInfo[] files = this.getDataMap().values().toArray(new TransferInfo[this.getDataMap().size()]);
            return files[row];
        }

        public void removeRow(int row) {
            TransferInfo[] files = this.getDataMap().values().toArray(new TransferInfo[this.getDataMap().size()]);
            this.getDataMap().remove(files[row].getId());
            this.fireTableRowsDeleted(row, row);
            this.refresh();
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public void setValueAt(Object val, int row, int column) {
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
        }

        public void updateFile(TransferInfo fi) {
            this.getDataMap().put(fi.getId(), fi);
            this.refresh();
        }

        public void refresh() {
            if (!this.dorefresh) {
                this.dorefresh = true;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FileTableModel.this.dorefresh = false;
                        FileTableModel.this.fireTableDataChanged();
                        FileTableModel.this.getTable().getParent().invalidate();
                        FileTableModel.this.getTable().getParent().doLayout();
                        FileTableModel.this.getTable().repaint();
                    }
                });
            }
        }
    }

    public class UserTableModel
    extends DefaultTableModel {
        protected Map<IComponentIdentifier, ChatUser> users = new LinkedHashMap<IComponentIdentifier, ChatUser>();
        protected String[] columns = new String[]{"Users"};
        protected List<ChatUser> sels;

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public String getColumnName(int i) {
            return this.columns[i];
        }

        @Override
        public Class<?> getColumnClass(int i) {
            return String.class;
        }

        @Override
        public int getRowCount() {
            return this.users == null ? 0 : this.users.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            IComponentIdentifier[] cids = this.users.keySet().toArray(new IComponentIdentifier[this.users.size()]);
            ChatUser cu = this.users.get(cids[row]);
            return cu;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public ChatUser getUser(IComponentIdentifier cid) {
            return this.users.get(cid);
        }

        public Collection<ChatUser> getUsers() {
            return this.users.values();
        }

        public Collection<IComponentIdentifier> getUserIDs() {
            return this.users.keySet();
        }

        public void addUser(IComponentIdentifier cid, ChatUser user) {
            this.saveUserSelection();
            this.users.put(cid, user);
            this.fireTableRowsInserted(this.users.size() - 1, this.users.size() - 1);
            this.restoreUserSelection();
        }

        public void removeUser(IComponentIdentifier cid) {
            this.saveUserSelection();
            Iterator<IComponentIdentifier> it = this.users.keySet().iterator();
            int row = -1;
            int i = 0;
            while (it.hasNext()) {
                IComponentIdentifier key = it.next();
                if (key.equals(cid)) {
                    row = i;
                }
                ++i;
            }
            if (row != -1) {
                this.users.remove(cid);
                this.fireTableRowsDeleted(row, row);
            }
            this.restoreUserSelection();
        }

        @Override
        public void setValueAt(Object val, int row, int column) {
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
        }

        protected void saveUserSelection() {
            int[] rows = ChatPanel.this.usertable.getSelectedRows();
            ChatUser[] users = ChatPanel.this.usermodel.getUsers().toArray(new ChatUser[0]);
            this.sels = new ArrayList<ChatUser>();
            for (int i = 0; i < rows.length; ++i) {
                this.sels.add(users[rows[i]]);
            }
        }

        protected void restoreUserSelection() {
            ChatPanel.this.usertable.clearSelection();
            if (this.sels != null && !this.sels.isEmpty()) {
                ArrayList<ChatUser> users = new ArrayList<ChatUser>();
                users.addAll(ChatPanel.this.usermodel.getUsers());
                for (ChatUser cu : this.sels) {
                    int idx = users.indexOf(cu);
                    if (idx < 0) continue;
                    ChatPanel.this.usertable.addRowSelectionInterval(idx, idx);
                }
            }
        }
    }

    public class FileTransferMouseAdapter
    extends MouseAdapter {
        protected JTable table;

        public FileTransferMouseAdapter(JTable table) {
            this.table = table;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.trigger(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.trigger(e);
        }

        protected void trigger(MouseEvent e) {
            int row;
            if (e.isPopupTrigger() && (row = this.table.rowAtPoint(e.getPoint())) != -1) {
                TransferInfo fi = ((FileTableModel)this.table.getModel()).getValueAt(row);
                this.createMenu(row, fi).show(e.getComponent(), e.getX(), e.getY());
            }
        }

        protected JPopupMenu createMenu(final int row, final TransferInfo fi) {
            JMenuItem mi;
            JPopupMenu menu = new JPopupMenu();
            if (!fi.isFinished()) {
                if (fi.isDownload() && "Waiting".equals(fi.getState())) {
                    mi = new JMenuItem("Accept/reject transfer...");
                    mi.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ChatPanel.this.acceptFile(fi).addResultListener((IResultListener)new IResultListener<String>(){

                                public void resultAvailable(String filepath) {
                                    ((IChatGuiService)ChatPanel.this.getService()).acceptFile(fi.getId(), filepath);
                                }

                                public void exceptionOccurred(Exception exception) {
                                    ((IChatGuiService)ChatPanel.this.getService()).rejectFile(fi.getId());
                                }
                            });
                        }
                    });
                    menu.add(mi);
                }
                mi = new JMenuItem("Cancel transfer");
                mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ((IChatGuiService)ChatPanel.this.getService()).cancelTransfer(fi.getId());
                    }
                });
                menu.add(mi);
                if (this.table.getRowCount() > 1) {
                    mi = new JMenuItem("Cancel all transfers");
                    mi.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            TransferInfo[] infos = ((FileTableModel)FileTransferMouseAdapter.this.table.getModel()).getDataMap().values().toArray(new TransferInfo[0]);
                            for (int i = 0; i < infos.length; ++i) {
                                if (infos[i].isFinished()) continue;
                                ((IChatGuiService)ChatPanel.this.getService()).cancelTransfer(infos[i].getId());
                            }
                        }
                    });
                    menu.add(mi);
                }
            }
            if (fi.isFinished()) {
                if (ChatPanel.this.isLocal()) {
                    mi = new JMenuItem("Open");
                    mi.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            try {
                                Desktop.getDesktop().open(new File(fi.getFilePath()).getCanonicalFile());
                            }
                            catch (IOException ex) {
                                SGUI.showError((Component)FileTransferMouseAdapter.this.table, (String)"Error Opening File", (String)("File '" + new File(fi.getFilePath()).getName() + "' could not be opened."), (Exception)ex);
                            }
                        }
                    });
                    menu.add(mi);
                    mi = new JMenuItem("Open folder");
                    mi.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            try {
                                Desktop.getDesktop().open(new File(fi.getFilePath()).getParentFile().getCanonicalFile());
                            }
                            catch (IOException ex) {
                                SGUI.showError((Component)FileTransferMouseAdapter.this.table, (String)"Error Opening Folder", (String)("Folder '" + new File(fi.getFilePath()).getParentFile().getName() + "'could not be opened."), (Exception)ex);
                            }
                        }
                    });
                    menu.add(mi);
                }
                mi = new JMenuItem("Remove");
                mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ((FileTableModel)FileTransferMouseAdapter.this.table.getModel()).removeRow(row);
                    }
                });
                menu.add(mi);
                if (this.table.getRowCount() > 1) {
                    mi = new JMenuItem("Remove all finished");
                    mi.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            TransferInfo[] infos = ((FileTableModel)FileTransferMouseAdapter.this.table.getModel()).getDataMap().values().toArray(new TransferInfo[0]);
                            for (int i = infos.length - 1; i >= 0; --i) {
                                if (!infos[i].isFinished()) continue;
                                ((FileTableModel)FileTransferMouseAdapter.this.table.getModel()).removeRow(i);
                            }
                        }
                    });
                    menu.add(mi);
                }
            }
            return menu;
        }
    }
}

