/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.chat;

import jadex.base.gui.componentviewer.IAbstractViewerPanel;
import jadex.bridge.service.IService;
import jadex.bridge.service.types.chat.IChatGuiService;
import jadex.commons.future.ExceptionDelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.commons.gui.SGUI;
import jadex.tools.chat.ChatPanel;
import jadex.tools.generic.AbstractServicePlugin;
import javax.swing.Icon;

public class ChatPlugin
extends AbstractServicePlugin {
    public static final String PLUGIN_NAME = "Chat";

    public static Icon getStatusIcon(boolean star) {
        return star ? icons.getIcon("chat_small_star") : icons.getIcon("chat_small");
    }

    public static Icon getTabIcon() {
        return icons.getIcon("star");
    }

    public boolean isLazy() {
        return false;
    }

    @Override
    public Class<?> getServiceType() {
        return IChatGuiService.class;
    }

    @Override
    public IFuture<IAbstractViewerPanel> createServicePanel(IService service) {
        final Future ret = new Future();
        final ChatPanel panel = new ChatPanel();
        panel.init(this.getJCC(), service).addResultListener((IResultListener)new ExceptionDelegationResultListener<Void, IAbstractViewerPanel>(ret){

            public void customResultAvailable(Void result) {
                ret.setResult((Object)panel);
            }
        });
        return ret;
    }

    @Override
    public Icon getToolIcon(boolean selected) {
        return selected ? icons.getIcon("chat_sel") : icons.getIcon("chat");
    }

    @Override
    public String getName() {
        return PLUGIN_NAME;
    }

    static {
        icons.put("chat", SGUI.makeIcon(ChatPlugin.class, (String)"images/chat.png"));
        icons.put("chat_sel", SGUI.makeIcon(ChatPlugin.class, (String)"images/chat.png"));
        icons.put("chat_small", SGUI.makeIcon(ChatPlugin.class, (String)"images/chat_small.png"));
        icons.put("chat_small_star", SGUI.makeIcon(ChatPlugin.class, (String)"images/chat_small_star.png"));
        icons.put("star", SGUI.makeIcon(ChatPlugin.class, (String)"images/star.png"));
    }
}

