/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.chat;

import jadex.bridge.IComponentIdentifier;
import jadex.commons.gui.CombiIcon;
import jadex.commons.gui.SGUI;
import jadex.tools.chat.ChatPanel;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIDefaults;

public class ChatUser {
    protected static final UIDefaults icons = new UIDefaults(new Object[]{"overlay_away", SGUI.makeIcon(ChatPanel.class, (String)"images/overlay_away.png"), "overlay_typing", SGUI.makeIcon(ChatPanel.class, (String)"images/overlay_typing.png"), "overlay_sending", SGUI.makeIcon(ChatPanel.class, (String)"images/overlay_sending.png"), "default_avatar", SGUI.makeIcon(ChatPanel.class, (String)"images/user_anon.png")});
    protected IComponentIdentifier cid;
    protected boolean typing;
    protected boolean away;
    protected Set<Integer> messages;
    protected String nick;
    protected Icon avatar;
    protected long lastupdate;

    public ChatUser(IComponentIdentifier cid) {
        if (cid == null) {
            throw new NullPointerException();
        }
        this.cid = cid;
        this.nick = "unknown";
        this.messages = new HashSet<Integer>();
        this.lastupdate = System.currentTimeMillis();
    }

    public Icon getIcon() {
        Icon ret;
        Icon icon = ret = this.avatar != null ? this.avatar : icons.getIcon("default_avatar");
        if (System.currentTimeMillis() - this.lastupdate > 15000L) {
            BufferedImage image = new BufferedImage(ret.getIconWidth(), ret.getIconHeight(), 2);
            ret.paintIcon(null, image.getGraphics(), 0, 0);
            ret = new ImageIcon(GrayFilter.createDisabledImage(image));
        }
        ArrayList<Icon> ics = new ArrayList<Icon>();
        ics.add(ret);
        if (this.away) {
            ics.add(icons.getIcon("overlay_away"));
        }
        if (this.typing) {
            ics.add(icons.getIcon("overlay_typing"));
        }
        if (!this.messages.isEmpty()) {
            ics.add(icons.getIcon("overlay_sending"));
        }
        if (icons.size() > 1) {
            ret = new CombiIcon(ics.toArray(new Icon[ics.size()]));
        }
        return ret;
    }

    public void setTyping(boolean typing) {
        this.typing = typing;
        this.lastupdate = System.currentTimeMillis();
    }

    public boolean isTyping() {
        return this.typing;
    }

    public void setAway(boolean away) {
        this.away = away;
        this.lastupdate = System.currentTimeMillis();
    }

    public boolean isAway() {
        return this.away;
    }

    public String getNick() {
        return this.nick;
    }

    public void setNick(String nick) {
        this.nick = nick;
        this.lastupdate = System.currentTimeMillis();
    }

    public boolean isNickUnknown() {
        return "unknown".equals(this.nick);
    }

    public boolean isAvatarUnknown() {
        return this.avatar == null;
    }

    public void setAvatar(Icon avatar) {
        this.avatar = avatar;
        this.lastupdate = System.currentTimeMillis();
    }

    public IComponentIdentifier getComponentIdentifier() {
        return this.cid;
    }

    public void addMessage(int id) {
        this.messages.add(id);
        this.lastupdate = System.currentTimeMillis();
    }

    public void removeMessage(int id) {
        this.messages.remove(id);
        this.lastupdate = System.currentTimeMillis();
    }

    public boolean setOnline(Boolean online) {
        if (online != null && online.booleanValue()) {
            this.lastupdate = System.currentTimeMillis();
        } else if (online != null) {
            this.lastupdate = 0L;
        }
        return System.currentTimeMillis() - this.lastupdate > 45000L;
    }
}

