/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.convcenter;

import jadex.base.gui.CMSUpdateHandler;
import jadex.base.gui.componenttree.ComponentIconCache;
import jadex.bridge.IComponentStep;
import jadex.bridge.IExternalAccess;
import jadex.bridge.IInternalAccess;
import jadex.bridge.IMessageAdapter;
import jadex.bridge.component.IExecutionFeature;
import jadex.bridge.service.search.SServiceProvider;
import jadex.bridge.service.types.message.IMessageService;
import jadex.bridge.service.types.message.MessageType;
import jadex.commons.Properties;
import jadex.commons.Property;
import jadex.commons.SUtil;
import jadex.commons.future.DelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.commons.gui.SGUI;
import jadex.commons.gui.future.SwingDefaultResultListener;
import jadex.commons.transformation.annotations.Classname;
import jadex.tools.convcenter.FipaMessagePanel;
import jadex.xml.bean.JavaReader;
import jadex.xml.bean.JavaWriter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class ConversationPanel
extends JSplitPane {
    protected static final UIDefaults icons = new UIDefaults(new Object[]{"new_message", SGUI.makeIcon(ConversationPanel.class, (String)"/jadex/tools/common/images/new_new_message.png"), "sent_message", SGUI.makeIcon(ConversationPanel.class, (String)"/jadex/tools/common/images/new_sent_message.png"), "received_message", SGUI.makeIcon(ConversationPanel.class, (String)"/jadex/tools/common/images/new_received_message.png")});
    protected static final String MESSAGE_TYPE = "FipaConversationPanel-message-type";
    protected IExternalAccess agent;
    protected IExternalAccess jccaccess;
    protected MessageType defaulttype;
    protected JTabbedPane tabs;
    protected FipaMessagePanel sendpanel;
    protected JList sentmsgs;
    protected JList receivedmsgs;

    public ConversationPanel(final IExternalAccess agent, final IExternalAccess jccaccess, final CMSUpdateHandler cmshandler, final ComponentIconCache iconcache, Component comptree, MessageType defaulttype) {
        super(1, true);
        this.setOneTouchExpandable(true);
        this.agent = agent;
        this.defaulttype = defaulttype;
        HashMap<String, Object> msg = new HashMap<String, Object>();
        msg.put(MESSAGE_TYPE, defaulttype);
        msg.put(defaulttype.getSenderIdentifier(), agent.getComponentIdentifier());
        this.sendpanel = new FipaMessagePanel(msg, agent, jccaccess, cmshandler, iconcache, comptree);
        JButton send = new JButton("Send");
        send.setToolTipText("Send the specified message");
        send.putClientProperty("auto-adjust", Boolean.TRUE);
        send.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                String ri;
                Map msg = ConversationPanel.this.sendpanel.getMessage();
                MessageType mt = (MessageType)msg.get(ConversationPanel.MESSAGE_TYPE);
                MessageType.ParameterSpecification ris = mt.getParameter(ri = mt.getReceiverIdentifier());
                if (ris.isSet()) {
                    Object value = msg.get(ri);
                    if (value == null || value instanceof Object[] && ((Object[])value).length == 0) {
                        ConversationPanel.this.noReceiverSpecified();
                    } else {
                        ConversationPanel.this.sendMessage(msg);
                    }
                } else if (msg.get(ri) == null) {
                    ConversationPanel.this.noReceiverSpecified();
                } else {
                    ConversationPanel.this.sendMessage(msg);
                }
            }
        });
        JButton reset = new JButton("Reset");
        reset.setToolTipText("Reset all specified message values");
        reset.putClientProperty("auto-adjust", Boolean.TRUE);
        reset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ConversationPanel.this.resetMessage();
            }
        });
        JPanel sendcont = new JPanel(new BorderLayout());
        sendcont.add("Center", this.sendpanel);
        JPanel south = new JPanel(new FlowLayout(2));
        south.add(send);
        south.add(reset);
        sendcont.add("South", south);
        final JScrollPane sendtab = new JScrollPane(sendcont);
        sendtab.setBorder(null);
        JPanel lists = new JPanel(new GridBagLayout());
        GridBagConstraints gbcons = new GridBagConstraints(0, 0, 0, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0);
        this.sentmsgs = new JList(new DefaultListModel());
        this.sentmsgs.setCellRenderer(new MessageListCellRenderer());
        this.sentmsgs.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && ConversationPanel.this.sentmsgs.locationToIndex(e.getPoint()) != -1) {
                    final Map msg = (Map)ConversationPanel.this.sentmsgs.getModel().getElementAt(ConversationPanel.this.sentmsgs.locationToIndex(e.getPoint()));
                    JPanel msgtab = new JPanel(new BorderLayout());
                    FipaMessagePanel msgpanel = new FipaMessagePanel(msg, agent, jccaccess, cmshandler, iconcache, null);
                    msgpanel.setEditable(false);
                    final JScrollPane scroll = new JScrollPane(msgtab);
                    scroll.setBorder(null);
                    JButton edit = new JButton("Edit");
                    edit.setToolTipText("Edit this sent message");
                    edit.putClientProperty("auto-adjust", Boolean.TRUE);
                    edit.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            ConversationPanel.this.sendpanel.setMessage(new HashMap(msg));
                            ConversationPanel.this.tabs.setSelectedComponent(sendtab);
                        }
                    });
                    JButton send = new JButton("Resend");
                    send.setMargin(new Insets(2, 2, 2, 2));
                    send.setToolTipText("Send this message again");
                    send.putClientProperty("auto-adjust", Boolean.TRUE);
                    send.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            ConversationPanel.this.sendMessage(msg);
                        }
                    });
                    JButton reset = new JButton("Close");
                    reset.setToolTipText("Close displayed message");
                    reset.putClientProperty("auto-adjust", Boolean.TRUE);
                    reset.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            ConversationPanel.this.tabs.remove(scroll);
                        }
                    });
                    msgtab.add("Center", msgpanel);
                    JPanel south = new JPanel(new FlowLayout(2));
                    south.add(edit);
                    south.add(send);
                    south.add(reset);
                    msgtab.add("South", south);
                    ConversationPanel.this.tabs.addTab(ConversationPanel.this.getMessageTitle(msg), icons.getIcon("sent_message"), scroll);
                    ConversationPanel.this.tabs.setSelectedComponent(scroll);
                    SGUI.adjustComponentSizes((Container)ConversationPanel.this);
                }
            }
        });
        JPanel cpane = new JPanel(new BorderLayout());
        cpane.add("Center", new JScrollPane(this.sentmsgs));
        cpane.setBorder(new TitledBorder(new EtchedBorder(1), " Sent Messages "));
        lists.add((Component)cpane, gbcons);
        ++gbcons.gridy;
        this.receivedmsgs = new JList(new DefaultListModel());
        this.receivedmsgs.setCellRenderer(new MessageListCellRenderer());
        this.receivedmsgs.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int idx;
                if (e.getClickCount() == 2 && (idx = ConversationPanel.this.receivedmsgs.locationToIndex(e.getPoint())) != -1) {
                    final Map msg = (Map)ConversationPanel.this.receivedmsgs.getModel().getElementAt(idx);
                    JPanel msgtab = new JPanel(new BorderLayout());
                    FipaMessagePanel msgpanel = new FipaMessagePanel(msg, agent, jccaccess, cmshandler, iconcache, null);
                    msgpanel.setEditable(false);
                    final JScrollPane scroll = new JScrollPane(msgtab);
                    scroll.setBorder(null);
                    JButton reply = new JButton("Reply");
                    reply.setToolTipText("Set up a reply message");
                    reply.putClientProperty("auto-adjust", Boolean.TRUE);
                    reply.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            MessageType mt = (MessageType)msg.get(ConversationPanel.MESSAGE_TYPE);
                            Map replymsg = mt.createReply(msg);
                            replymsg.put(ConversationPanel.MESSAGE_TYPE, mt);
                            replymsg.put(mt.getSenderIdentifier(), agent.getComponentIdentifier());
                            ConversationPanel.this.sendpanel.setMessage(replymsg);
                            ConversationPanel.this.tabs.setSelectedComponent(sendtab);
                        }
                    });
                    JButton reset = new JButton("Close");
                    reset.setToolTipText("Close this message view");
                    reset.putClientProperty("auto-adjust", Boolean.TRUE);
                    reset.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            ConversationPanel.this.tabs.remove(scroll);
                        }
                    });
                    msgtab.add("Center", msgpanel);
                    JPanel south = new JPanel(new FlowLayout(2));
                    south.add(reply);
                    south.add(reset);
                    msgtab.add("South", south);
                    ConversationPanel.this.tabs.addTab(ConversationPanel.this.getMessageTitle(msg), icons.getIcon("received_message"), scroll);
                    ConversationPanel.this.tabs.setSelectedComponent(scroll);
                    SGUI.adjustComponentSizes((Container)ConversationPanel.this);
                }
            }
        });
        cpane = new JPanel(new BorderLayout());
        cpane.add("Center", new JScrollPane(this.receivedmsgs));
        cpane.setBorder(new TitledBorder(new EtchedBorder(1), " Received Messages "));
        lists.add((Component)cpane, gbcons);
        ++gbcons.gridy;
        gbcons.weighty = 0.0;
        cpane = new JPanel(new FlowLayout(2));
        JButton clear = new JButton("Clear");
        clear.setToolTipText("Clear the lists of sent and received messages");
        clear.putClientProperty("auto-adjust", Boolean.TRUE);
        clear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((DefaultListModel)ConversationPanel.this.sentmsgs.getModel()).removeAllElements();
                ((DefaultListModel)ConversationPanel.this.receivedmsgs.getModel()).removeAllElements();
                while (ConversationPanel.this.tabs.getComponentCount() > 1) {
                    ConversationPanel.this.tabs.remove(1);
                }
            }
        });
        cpane.add(clear);
        lists.add((Component)cpane, gbcons);
        this.tabs = new JTabbedPane();
        this.tabs.addTab("Send", icons.getIcon("new_message"), sendtab);
        this.add(lists);
        this.add(this.tabs);
        SGUI.adjustComponentSizes((Container)this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConversationPanel.this.setDividerLocation(0.35);
            }
        });
    }

    protected void noReceiverSpecified() {
        String text = SUtil.wrapText((String)"Cannot not send message, no receiver specified.");
        JOptionPane.showMessageDialog(SGUI.getWindowParent((Component)this), text, "Message Error", 1);
    }

    protected String getMessageTitle(Map msg) {
        MessageType mt = (MessageType)msg.get(MESSAGE_TYPE);
        String ret = mt.getSimplifiedRepresentation(msg);
        if (ret.length() > 25) {
            ret = ret.substring(0, 21);
            ret = ret + "...)";
        }
        return ret;
    }

    public void addMessage(final IMessageAdapter msg) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HashMap<String, MessageType> msgmap = new HashMap<String, MessageType>(msg.getParameterMap());
                msgmap.put(ConversationPanel.MESSAGE_TYPE, msg.getMessageType());
                ((DefaultListModel)ConversationPanel.this.receivedmsgs.getModel()).addElement(msgmap);
            }
        });
    }

    public void reset() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConversationPanel.this.resetMessage();
                ConversationPanel.this.setSentMessages(new Map[0]);
                ConversationPanel.this.setReceivedMessages(new Map[0]);
                while (ConversationPanel.this.tabs.getTabCount() > 1) {
                    ConversationPanel.this.tabs.removeTabAt(ConversationPanel.this.tabs.getTabCount() - 1);
                }
            }
        });
    }

    public void resetMessage() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HashMap<String, Object> msg = new HashMap<String, Object>();
                msg.put(ConversationPanel.MESSAGE_TYPE, ConversationPanel.this.defaulttype);
                msg.put(ConversationPanel.this.defaulttype.getSenderIdentifier(), ConversationPanel.this.agent.getComponentIdentifier());
                ConversationPanel.this.sendpanel.setMessage(msg);
            }
        });
    }

    public FipaMessagePanel getMessagePanel() {
        return this.sendpanel;
    }

    public Map[] getSentMessages() {
        DefaultListModel model = (DefaultListModel)this.sentmsgs.getModel();
        Object[] ret = new Map[model.getSize()];
        model.copyInto(ret);
        return ret;
    }

    public void setSentMessages(final Map[] msgs) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultListModel model = (DefaultListModel)ConversationPanel.this.sentmsgs.getModel();
                model.removeAllElements();
                for (int i = 0; i < msgs.length; ++i) {
                    model.addElement(msgs[i]);
                }
            }
        });
    }

    public void setReceivedMessages(final Map[] msgs) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultListModel model = (DefaultListModel)ConversationPanel.this.receivedmsgs.getModel();
                model.removeAllElements();
                for (int i = 0; i < msgs.length; ++i) {
                    model.addElement(msgs[i]);
                }
            }
        });
    }

    public void setProperties(Properties props) {
        try {
            String msg = props.getStringProperty("lastmessage");
            if (msg != null) {
                final Map message = this.decodeMessage(msg);
                MessageType mt = (MessageType)message.get(MESSAGE_TYPE);
                message.put(mt.getSenderIdentifier(), this.agent.getComponentIdentifier());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ConversationPanel.this.getMessagePanel().setMessage(message);
                    }
                });
            } else {
                this.resetMessage();
            }
            ArrayList<Map> sentmsgs = new ArrayList<Map>();
            Property[] sents = props.getProperties("sentmessage");
            for (int i = 0; i < sents.length; ++i) {
                boolean last = i == sents.length - 1;
                Map message = this.decodeMessage(sents[i].getValue());
                MessageType mt = (MessageType)message.get(MESSAGE_TYPE);
                message.put(mt.getSenderIdentifier(), this.agent.getComponentIdentifier());
                sentmsgs.add(0, message);
                if (!last) continue;
                this.setSentMessages(sentmsgs.toArray(new Map[sentmsgs.size()]));
            }
        }
        catch (Exception e) {
            final String text = SUtil.wrapText((String)("Could not decode stored message: " + e.getMessage()));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(SGUI.getWindowParent((Component)ConversationPanel.this), text, "Message problem", 1);
                }
            });
        }
    }

    public Map decodeMessage(String msg) {
        Map map = (Map)JavaReader.objectFromXML((String)msg, null);
        return map;
    }

    public Properties getProperties() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException("Can only save properties from swing thread");
        }
        Properties props = new Properties();
        Map message = this.getMessagePanel().getMessage();
        String msg = this.encodeMessage(message);
        props.addProperty(new Property("lastmessage", msg));
        Map[] msgs = this.getSentMessages();
        HashSet<String> saved = new HashSet<String>();
        for (int i = msgs.length - 1; i >= 0 && saved.size() < 5; --i) {
            msg = this.encodeMessage(msgs[i]);
            if (saved.contains(msg)) continue;
            props.addProperty(new Property("sentmessage", msg));
            saved.add(msg);
        }
        return props;
    }

    public String encodeMessage(Map message) {
        String msg = JavaWriter.objectToXML((Object)message, null);
        return msg;
    }

    protected void sendMessage(Map msg) {
        final HashMap sendmsg = new HashMap(msg);
        final MessageType mt = (MessageType)sendmsg.remove(MESSAGE_TYPE);
        this.agent.scheduleStep((IComponentStep)new IComponentStep<Void>(){

            @Classname(value="sendM")
            public IFuture<Void> execute(final IInternalAccess ia) {
                final Future ret = new Future();
                SServiceProvider.getService((IInternalAccess)ia, IMessageService.class, (String)"platform").addResultListener(((IExecutionFeature)ia.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DelegationResultListener(ret){

                    public void customResultAvailable(Object result) {
                        IMessageService ms = (IMessageService)result;
                        ms.sendMessage(sendmsg, mt, ia.getComponentIdentifier(), ia.getModel().getResourceIdentifier(), null, null).addResultListener(((IExecutionFeature)ia.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DelegationResultListener(ret)));
                    }
                }));
                return ret;
            }
        }).addResultListener((IResultListener)new SwingDefaultResultListener(this){

            public void customResultAvailable(Object result) {
                sendmsg.put(ConversationPanel.MESSAGE_TYPE, mt);
                ((DefaultListModel)ConversationPanel.this.sentmsgs.getModel()).addElement(sendmsg);
            }
        });
    }

    class MessageListCellRenderer
    extends DefaultListCellRenderer {
        MessageListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean sel, boolean hasfocus) {
            assert (value instanceof Map);
            value = ConversationPanel.this.getMessageTitle((Map)value);
            return super.getListCellRendererComponent((JList<?>)list, value, index, sel, hasfocus);
        }
    }
}

