/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.convcenter;

import jadex.base.gui.asynctree.ISwingNodeHandler;
import jadex.base.gui.asynctree.ISwingTreeNode;
import jadex.base.gui.asynctree.ITreeNode;
import jadex.base.gui.componenttree.ComponentTreePanel;
import jadex.base.gui.componenttree.IActiveComponentTreeNode;
import jadex.base.gui.plugin.AbstractJCCPlugin;
import jadex.bridge.BasicComponentIdentifier;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IComponentStep;
import jadex.bridge.IInternalAccess;
import jadex.bridge.IMessageAdapter;
import jadex.bridge.IRemoteMessageListener;
import jadex.bridge.component.IExecutionFeature;
import jadex.bridge.fipa.SFipa;
import jadex.bridge.service.search.SServiceProvider;
import jadex.bridge.service.types.message.IMessageListener;
import jadex.bridge.service.types.message.IMessageService;
import jadex.bridge.service.types.message.MessageType;
import jadex.commons.IFilter;
import jadex.commons.Properties;
import jadex.commons.SReflect;
import jadex.commons.future.DefaultResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.commons.gui.SGUI;
import jadex.commons.transformation.annotations.Classname;
import jadex.tools.convcenter.ConversationPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.UIDefaults;
import javax.swing.tree.TreePath;

public class ConversationPlugin
extends AbstractJCCPlugin {
    public static final String LAST_MESSAGE = "lastmessage";
    public static final String SENT_MESSAGE = "sentmessage";
    protected static final UIDefaults icons = new UIDefaults(new Object[]{"conversation", SGUI.makeIcon(ConversationPlugin.class, (String)"/jadex/tools/common/images/new_conversation.png"), "message", SGUI.makeIcon(ConversationPlugin.class, (String)"/jadex/tools/common/images/message_small.png"), "message_overlay", SGUI.makeIcon(ConversationPlugin.class, (String)"/jadex/tools/common/images/overlay_message.png"), "conversation_sel", SGUI.makeIcon(ConversationPlugin.class, (String)"/jadex/tools/common/images/new_conversation_sel.png"), "help", SGUI.makeIcon(ConversationPlugin.class, (String)"/jadex/tools/common/images/help.png")});
    protected ComponentTreePanel comptree;
    protected ConversationPanel convcenter;
    final AbstractAction SEND_MESSAGE = new AbstractAction("Send Message", icons.getIcon("conversation")){

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath[] paths = ConversationPlugin.this.comptree.getTree().getSelectionPaths();
            for (int i = 0; paths != null && i < paths.length; ++i) {
                ArrayList<IComponentIdentifier> lrecs;
                MessageType mt;
                if (!(paths[i].getLastPathComponent() instanceof IActiveComponentTreeNode)) continue;
                IActiveComponentTreeNode node = (IActiveComponentTreeNode)paths[i].getLastPathComponent();
                IComponentIdentifier rec = node.getDescription().getName();
                BasicComponentIdentifier receiver = new BasicComponentIdentifier(rec.getName());
                Map message = ConversationPlugin.this.convcenter.getMessagePanel().getMessage();
                IComponentIdentifier[] recs = (IComponentIdentifier[])message.get((mt = (MessageType)message.get("FipaConversationPanel-message-type")).getReceiverIdentifier());
                ArrayList<Object> arrayList = lrecs = recs != null ? new ArrayList<IComponentIdentifier>(Arrays.asList(recs)) : new ArrayList();
                if (lrecs.contains(receiver)) {
                    lrecs.remove(receiver);
                } else {
                    lrecs.add((IComponentIdentifier)receiver);
                }
                message.put(mt.getReceiverIdentifier(), lrecs.toArray(new IComponentIdentifier[lrecs.size()]));
                ConversationPlugin.this.convcenter.getMessagePanel().setMessage(message);
                ConversationPlugin.this.comptree.getModel().fireNodeChanged((ITreeNode)node);
            }
        }
    };

    public String getName() {
        return "Conversation Center";
    }

    public boolean isLazy() {
        return false;
    }

    public Icon getToolIcon(boolean selected) {
        return selected ? icons.getIcon("conversation_sel") : icons.getIcon("conversation");
    }

    public JComponent createView() {
        JSplitPane split = new JSplitPane(1, true);
        split.setOneTouchExpandable(true);
        this.comptree = new ComponentTreePanel(this.getJCC().getPlatformAccess(), this.getJCC().getJCCAccess(), this.getJCC().getCMSHandler(), this.getJCC().getPropertyHandler(), this.getJCC().getIconCache());
        this.comptree.setMinimumSize(new Dimension(0, 0));
        split.add((Component)this.comptree);
        this.convcenter = new ConversationPanel(this.getJCC().getPlatformAccess(), this.getJCC().getJCCAccess(), this.getJCC().getCMSHandler(), this.getJCC().getIconCache(), (Component)this.comptree, SFipa.FIPA_MESSAGE_TYPE);
        this.comptree.addNodeHandler((ISwingNodeHandler)new AbstractJCCPlugin.ShowRemoteControlCenterHandler(this.getJCC(), (Component)this.getView()));
        this.comptree.addNodeHandler(new ISwingNodeHandler(){

            public Action[] getPopupActions(ISwingTreeNode[] nodes) {
                Action[] ret = null;
                boolean allcomp = true;
                for (int i = 0; allcomp && i < nodes.length; ++i) {
                    allcomp = nodes[i] instanceof IActiveComponentTreeNode;
                }
                if (allcomp) {
                    AbstractAction a = new AbstractAction((String)ConversationPlugin.this.SEND_MESSAGE.getValue("Name"), icons.getIcon("message")){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ConversationPlugin.this.SEND_MESSAGE.actionPerformed(e);
                        }
                    };
                    ret = new Action[]{a};
                }
                return ret;
            }

            public byte[] getOverlay(ITreeNode node) {
                return null;
            }

            public Icon getSwingOverlay(ISwingTreeNode node) {
                Icon ret = null;
                if (node instanceof IActiveComponentTreeNode) {
                    IComponentIdentifier id = ((IActiveComponentTreeNode)node).getDescription().getName();
                    IComponentIdentifier[] recs = ConversationPlugin.this.convcenter.getMessagePanel().getReceivers();
                    if (recs != null && Arrays.asList(recs).contains(id)) {
                        ret = icons.getIcon("message_overlay");
                    }
                }
                return ret;
            }

            public Action getDefaultAction(ISwingTreeNode node) {
                AbstractAction a = null;
                if (node instanceof IActiveComponentTreeNode) {
                    a = ConversationPlugin.this.SEND_MESSAGE;
                }
                return a;
            }
        });
        split.add(this.convcenter);
        split.setDividerLocation(150);
        IRemoteMessageListener listener = new IRemoteMessageListener(){

            public IFuture messageReceived(IMessageAdapter msg) {
                ConversationPlugin.this.convcenter.addMessage(msg);
                return IFuture.DONE;
            }

            public IFuture messageSent(IMessageAdapter msg) {
                return IFuture.DONE;
            }
        };
        this.getJCC().getPlatformAccess().scheduleStep((IComponentStep)new IComponentStep<Void>((IMessageListener)listener){
            final /* synthetic */ IMessageListener val$listener;
            {
                this.val$listener = iMessageListener;
            }

            @Classname(value="installListener")
            public IFuture<Void> execute(final IInternalAccess ia) {
                SServiceProvider.getService((IInternalAccess)ia, IMessageService.class, (String)"platform").addResultListener(((IExecutionFeature)ia.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DefaultResultListener(ia.getLogger()){

                    public void resultAvailable(Object result) {
                        IMessageService ms = (IMessageService)result;
                        ms.addMessageListener(val$listener, new IFilter(){

                            public boolean filter(Object obj) {
                                IMessageAdapter msg = (IMessageAdapter)obj;
                                boolean tojcc = false;
                                Object rec = msg.getValue(msg.getMessageType().getReceiverIdentifier());
                                if (SReflect.isIterable((Object)rec)) {
                                    Iterator it = SReflect.getIterator((Object)rec);
                                    while (!tojcc && it.hasNext()) {
                                        tojcc = ia.getComponentIdentifier().equals(it.next());
                                    }
                                } else {
                                    tojcc = ia.getComponentIdentifier().equals(rec);
                                }
                                return tojcc;
                            }
                        });
                    }
                }));
                return IFuture.DONE;
            }
        });
        return split;
    }

    public JComponent[] createToolBar() {
        ArrayList<JButton> components = new ArrayList<JButton>();
        JButton b = new JButton(this.SEND_MESSAGE);
        b.setBorder(null);
        b.setToolTipText(b.getText());
        b.setText(null);
        b.setEnabled(true);
        components.add(b);
        return components.toArray(new JComponent[components.size()]);
    }

    public IFuture setProperties(Properties props) {
        Properties ps = props.getSubproperty("convcenter");
        if (ps != null) {
            this.convcenter.setProperties(ps);
        }
        return IFuture.DONE;
    }

    public IFuture getProperties() {
        Properties props = new Properties();
        props.addSubproperties("convcenter", this.convcenter.getProperties());
        return new Future((Object)props);
    }

    public IFuture<Void> shutdown() {
        this.comptree.dispose();
        return super.shutdown();
    }
}

