/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.convcenter;

import jadex.base.gui.CMSUpdateHandler;
import jadex.base.gui.ComponentSelectorDialog;
import jadex.base.gui.componenttree.ComponentIconCache;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IExternalAccess;
import jadex.bridge.fipa.SFipa;
import jadex.commons.SUtil;
import jadex.commons.gui.SGUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIDefaults;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class FipaMessagePanel
extends JPanel {
    protected static final UIDefaults icons = new UIDefaults(new Object[]{"edit", SGUI.makeIcon(FipaMessagePanel.class, (String)"/jadex/tools/common/images/dots_small.png"), "delete", SGUI.makeIcon(FipaMessagePanel.class, (String)"/jadex/tools/common/images/delete_small.png")});
    protected static final int DEFCOLS = 20;
    protected Map message;
    protected boolean editable = true;
    protected JComboBox performative = new JComboBox<String>((String[])SUtil.joinArrays((Object)new String[]{""}, (Object)SFipa.PERFORMATIVES.toArray()));
    protected JTextField tfsender = new JTextField(20);
    protected JButton setsender;
    protected JButton clearsender;
    protected JTextField tfreceivers;
    protected JButton editreceivers;
    protected JButton clearreceivers;
    protected JTextField tfreplyto;
    protected JButton setreplyto;
    protected JButton clearreplyto;
    protected JTextField encoding;
    protected JTextField language;
    protected JTextField ontology;
    protected JComboBox protocol;
    protected JTextField convid;
    protected JTextField inreplyto;
    protected JTextField replywith;
    protected JFormattedTextField replyby;
    protected JTextArea content;
    protected IComponentIdentifier sender;
    protected IComponentIdentifier replyto;
    protected IComponentIdentifier[] receivers;

    public FipaMessagePanel(Map message, IExternalAccess access, IExternalAccess jccaccess, CMSUpdateHandler cmshandler, ComponentIconCache iconcache, final Component comptree) {
        super(new GridBagLayout());
        this.tfsender.setEditable(false);
        this.setsender = new JButton(icons.getIcon("edit"));
        this.setsender.setMargin(new Insets(0, 0, 0, 0));
        this.setsender.setToolTipText("Set sender agent identifier");
        this.clearsender = new JButton(icons.getIcon("delete"));
        this.clearsender.setMargin(new Insets(0, 0, 0, 0));
        this.clearsender.setToolTipText("Remove sender agent identifier");
        this.tfreceivers = new JTextField(20);
        this.tfreceivers.setEditable(false);
        this.editreceivers = new JButton(icons.getIcon("edit"));
        this.editreceivers.setMargin(new Insets(0, 0, 0, 0));
        this.editreceivers.setToolTipText("Edit receiver agent identifiers");
        this.clearreceivers = new JButton(icons.getIcon("delete"));
        this.clearreceivers.setMargin(new Insets(0, 0, 0, 0));
        this.clearreceivers.setToolTipText("Clear receiver agent identifiers");
        this.tfreplyto = new JTextField(20);
        this.tfreplyto.setEditable(false);
        this.setreplyto = new JButton(icons.getIcon("edit"));
        this.setreplyto.setMargin(new Insets(0, 0, 0, 0));
        this.setreplyto.setToolTipText("Set reply-to agent identifier");
        this.clearreplyto = new JButton(icons.getIcon("delete"));
        this.clearreplyto.setMargin(new Insets(0, 0, 0, 0));
        this.clearreplyto.setToolTipText("Remove reply-to agent identifier");
        this.language = new JTextField(20);
        this.encoding = new JTextField(20);
        this.ontology = new JTextField(20);
        this.protocol = new JComboBox<Object>(SFipa.PROTOCOLS.toArray());
        this.protocol.setEditable(true);
        this.convid = new JTextField(20);
        this.inreplyto = new JTextField(20);
        this.replywith = new JTextField(20);
        this.replyby = new JFormattedTextField(DateFormat.getDateInstance());
        this.content = new JTextArea(3, 20);
        Dimension labeldim = new JLabel("Conversation-id ").getPreferredSize();
        GridBagConstraints boxcons = new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0);
        GridBagConstraints leftcons = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(1, 1, 1, 1), 0, 0);
        GridBagConstraints rightcons = new GridBagConstraints(1, 0, 0, 1, 1.0, 0.0, 17, 2, new Insets(1, 1, 1, 1), 0, 0);
        GridBagConstraints butcons1 = new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(1, 1, 1, 1), 0, 0);
        GridBagConstraints butcons2 = new GridBagConstraints(3, 0, 0, 1, 0.0, 0.0, 17, 1, new Insets(1, 1, 1, 1), 0, 0);
        int box = 0;
        boxcons.gridy = box++;
        JPanel participants = new JPanel(new GridBagLayout());
        participants.setBorder(new TitledBorder(new EtchedBorder(1), " Message Properties "));
        this.add((Component)participants, boxcons);
        int row = 0;
        rightcons.gridy = row++;
        leftcons.gridy = rightcons.gridy;
        JLabel label = new JLabel("Performative");
        label.setMinimumSize(labeldim);
        label.setPreferredSize(labeldim);
        participants.add((Component)label, leftcons);
        participants.add((Component)this.performative, rightcons);
        butcons2.gridy = row++;
        butcons1.gridy = butcons2.gridy;
        rightcons.gridy = butcons2.gridy;
        leftcons.gridy = butcons2.gridy;
        label = new JLabel("Sender");
        label.setMinimumSize(labeldim);
        label.setPreferredSize(labeldim);
        participants.add((Component)label, leftcons);
        rightcons.gridwidth = 1;
        participants.add((Component)this.tfsender, rightcons);
        rightcons.gridwidth = 0;
        participants.add((Component)this.setsender, butcons1);
        participants.add((Component)this.clearsender, butcons2);
        butcons2.gridy = row++;
        butcons1.gridy = butcons2.gridy;
        rightcons.gridy = butcons2.gridy;
        leftcons.gridy = butcons2.gridy;
        label = new JLabel("Receivers");
        label.setMinimumSize(labeldim);
        label.setPreferredSize(labeldim);
        participants.add((Component)label, leftcons);
        rightcons.gridwidth = 1;
        participants.add((Component)this.tfreceivers, rightcons);
        rightcons.gridwidth = 0;
        participants.add((Component)this.editreceivers, butcons1);
        participants.add((Component)this.clearreceivers, butcons2);
        butcons2.gridy = row++;
        butcons1.gridy = butcons2.gridy;
        rightcons.gridy = butcons2.gridy;
        leftcons.gridy = butcons2.gridy;
        label = new JLabel("Reply_to");
        label.setMinimumSize(labeldim);
        label.setPreferredSize(labeldim);
        participants.add((Component)label, leftcons);
        rightcons.gridwidth = 1;
        participants.add((Component)this.tfreplyto, rightcons);
        rightcons.gridwidth = 0;
        participants.add((Component)this.setreplyto, butcons1);
        participants.add((Component)this.clearreplyto, butcons2);
        boxcons.gridy = box++;
        JPanel convcontrol = new JPanel(new GridBagLayout());
        convcontrol.setBorder(new TitledBorder(new EtchedBorder(1), " Conversation Control "));
        this.add((Component)convcontrol, boxcons);
        row = 0;
        rightcons.gridy = row++;
        leftcons.gridy = rightcons.gridy;
        label = new JLabel("Protocol");
        label.setMinimumSize(labeldim);
        label.setPreferredSize(labeldim);
        convcontrol.add((Component)label, leftcons);
        convcontrol.add((Component)this.protocol, rightcons);
        rightcons.gridy = row++;
        leftcons.gridy = rightcons.gridy;
        label = new JLabel("Conversation_id");
        label.setMinimumSize(labeldim);
        label.setPreferredSize(labeldim);
        convcontrol.add((Component)label, leftcons);
        convcontrol.add((Component)this.convid, rightcons);
        rightcons.gridy = row++;
        leftcons.gridy = rightcons.gridy;
        label = new JLabel("Reply_with");
        label.setMinimumSize(labeldim);
        label.setPreferredSize(labeldim);
        convcontrol.add((Component)label, leftcons);
        convcontrol.add((Component)this.replywith, rightcons);
        rightcons.gridy = row++;
        leftcons.gridy = rightcons.gridy;
        label = new JLabel("In_reply_to");
        label.setMinimumSize(labeldim);
        label.setPreferredSize(labeldim);
        convcontrol.add((Component)label, leftcons);
        convcontrol.add((Component)this.inreplyto, rightcons);
        rightcons.gridy = row++;
        leftcons.gridy = rightcons.gridy;
        label = new JLabel("Reply_by");
        label.setMinimumSize(labeldim);
        label.setPreferredSize(labeldim);
        convcontrol.add((Component)label, leftcons);
        convcontrol.add((Component)this.replyby, rightcons);
        boxcons.gridy = box++;
        JPanel contentdesc = new JPanel(new GridBagLayout());
        contentdesc.setBorder(new TitledBorder(new EtchedBorder(1), " Content Description "));
        this.add((Component)contentdesc, boxcons);
        row = 0;
        rightcons.gridy = row++;
        leftcons.gridy = rightcons.gridy;
        label = new JLabel("Language");
        label.setMinimumSize(labeldim);
        label.setPreferredSize(labeldim);
        contentdesc.add((Component)label, leftcons);
        contentdesc.add((Component)this.language, rightcons);
        rightcons.gridy = row++;
        leftcons.gridy = rightcons.gridy;
        label = new JLabel("Encoding");
        label.setMinimumSize(labeldim);
        label.setPreferredSize(labeldim);
        contentdesc.add((Component)label, leftcons);
        contentdesc.add((Component)this.encoding, rightcons);
        rightcons.gridy = row++;
        leftcons.gridy = rightcons.gridy;
        label = new JLabel("Ontology");
        label.setMinimumSize(labeldim);
        label.setPreferredSize(labeldim);
        contentdesc.add((Component)label, leftcons);
        contentdesc.add((Component)this.ontology, rightcons);
        JPanel cpane = new JPanel(new GridBagLayout());
        cpane.add((Component)new JScrollPane(this.content), new GridBagConstraints(0, 0, 0, 1, 1.0, 1.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        cpane.setBorder(new TitledBorder(new EtchedBorder(1), " Content "));
        this.add((Component)cpane, new GridBagConstraints(0, box++, 0, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setMessage(message);
        final ComponentSelectorDialog agentselector = new ComponentSelectorDialog((Component)this, access, jccaccess, cmshandler, null, iconcache);
        this.setsender.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IComponentIdentifier aid = agentselector.selectAgent(FipaMessagePanel.this.sender);
                if (aid != null) {
                    FipaMessagePanel.this.sender = aid;
                    FipaMessagePanel.this.tfsender.setText(aid.toString());
                    FipaMessagePanel.this.tfsender.setCaretPosition(0);
                }
            }
        });
        this.clearsender.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FipaMessagePanel.this.sender = null;
                FipaMessagePanel.this.tfsender.setText("");
            }
        });
        this.setreplyto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IComponentIdentifier aid = agentselector.selectAgent(FipaMessagePanel.this.replyto);
                if (aid != null) {
                    FipaMessagePanel.this.replyto = aid;
                    FipaMessagePanel.this.tfreplyto.setText(aid.toString());
                    FipaMessagePanel.this.tfreplyto.setCaretPosition(0);
                }
            }
        });
        this.clearreplyto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FipaMessagePanel.this.replyto = null;
                FipaMessagePanel.this.tfreplyto.setText("");
            }
        });
        this.editreceivers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IComponentIdentifier[] aids = agentselector.selectAgents(FipaMessagePanel.this.receivers);
                if (aids != null) {
                    if (aids.length > 0) {
                        FipaMessagePanel.this.receivers = aids;
                        FipaMessagePanel.this.tfreceivers.setText(SUtil.arrayToString((Object)FipaMessagePanel.this.receivers));
                        FipaMessagePanel.this.tfreceivers.setCaretPosition(0);
                    } else {
                        FipaMessagePanel.this.receivers = null;
                        FipaMessagePanel.this.tfreceivers.setText("");
                    }
                }
                if (comptree != null) {
                    comptree.repaint();
                }
            }
        });
        this.clearreceivers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FipaMessagePanel.this.receivers = null;
                FipaMessagePanel.this.tfreceivers.setText("");
                FipaMessagePanel.this.message.remove("receivers");
                if (comptree != null) {
                    comptree.repaint();
                }
            }
        });
    }

    public void setMessage(Map message) {
        this.message = message;
        this.performative.setSelectedItem(this.getParameter("performative"));
        this.tfsender.setText(this.getParameter("sender"));
        this.tfreplyto.setText(this.getParameter("reply_to"));
        this.tfreceivers.setText(this.getParameter("receivers"));
        this.content.setText(this.getParameter("content"));
        this.language.setText(this.getParameter("language"));
        this.encoding.setText(this.getParameter("encoding"));
        this.ontology.setText(this.getParameter("ontology"));
        this.protocol.setSelectedItem(this.getParameter("protocol"));
        this.convid.setText(this.getParameter("conversation_id"));
        this.inreplyto.setText(this.getParameter("in_reply_to"));
        this.replywith.setText(this.getParameter("reply_with"));
        this.replyby.setText(this.getParameter("reply_by"));
        this.tfsender.setCaretPosition(0);
        this.tfreplyto.setCaretPosition(0);
        this.content.setCaretPosition(0);
        this.language.setCaretPosition(0);
        this.encoding.setCaretPosition(0);
        this.ontology.setCaretPosition(0);
        this.convid.setCaretPosition(0);
        this.inreplyto.setCaretPosition(0);
        this.replywith.setCaretPosition(0);
        this.replyby.setCaretPosition(0);
        this.sender = (IComponentIdentifier)message.get("sender");
        this.replyto = (IComponentIdentifier)message.get("reply_to");
        Object recs = message.get("receivers");
        if (recs instanceof IComponentIdentifier) {
            this.receivers = new IComponentIdentifier[]{(IComponentIdentifier)recs};
        } else if (recs instanceof IComponentIdentifier[]) {
            this.receivers = (IComponentIdentifier[])recs;
        } else if (recs instanceof Collection) {
            this.receivers = ((Collection)recs).toArray(new IComponentIdentifier[((Collection)recs).size()]);
        }
    }

    public Map getMessage() {
        if (!this.editable) {
            return this.message;
        }
        this.message = new HashMap(this.message);
        this.setParameter("performative", (String)this.performative.getSelectedItem());
        this.setParameter("content", this.content.getText());
        this.setParameter("language", this.language.getText());
        this.setParameter("encoding", this.encoding.getText());
        this.setParameter("ontology", this.ontology.getText());
        this.setParameter("protocol", (String)this.protocol.getSelectedItem());
        this.setParameter("conversation_id", this.convid.getText());
        this.setParameter("in_reply_to", this.inreplyto.getText());
        this.setParameter("reply_with", this.replywith.getText());
        this.setParameter("sender", this.sender);
        this.setParameter("reply_to", this.replyto);
        this.setParameterSet("receivers", this.receivers);
        Object replybyval = null;
        if (this.replyby.getText() != null && !this.replyby.getText().equals("")) {
            try {
                this.replyby.commitEdit();
                replybyval = this.replyby.getValue();
            }
            catch (ParseException e) {
                throw new RuntimeException("Error parsing reply-by date: " + e);
            }
        } else {
            replybyval = null;
        }
        this.setParameter("reply_by", replybyval);
        return this.message;
    }

    public void setEditable(boolean editable) {
        if (editable != this.editable) {
            if (!editable) {
                this.message = this.getMessage();
            }
            this.editable = editable;
            this.performative.setEnabled(editable);
            this.setsender.setEnabled(editable);
            this.clearsender.setEnabled(editable);
            this.editreceivers.setEnabled(editable);
            this.clearreceivers.setEnabled(editable);
            this.setreplyto.setEnabled(editable);
            this.clearreplyto.setEnabled(editable);
            this.content.setEditable(editable);
            this.language.setEditable(editable);
            this.encoding.setEditable(editable);
            this.ontology.setEditable(editable);
            this.protocol.setEnabled(editable);
            this.convid.setEditable(editable);
            this.replywith.setEditable(editable);
            this.inreplyto.setEditable(editable);
            this.replyby.setEditable(editable);
        }
    }

    protected String getParameter(String name) {
        Object val = this.message.get(name);
        return val != null ? SUtil.arrayToString(val) : "";
    }

    protected void setParameter(String name, Object value) {
        Object oval = value == null || value.equals("") ? null : value;
        this.message.put(name, oval);
    }

    protected void setParameterSet(String name, Object[] values) {
        this.message.put(name, values);
    }

    public IComponentIdentifier[] getReceivers() {
        return this.receivers;
    }
}

