/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.daemon;

import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IExternalAccess;
import jadex.bridge.service.search.SServiceProvider;
import jadex.bridge.service.types.daemon.IDaemonService;
import jadex.bridge.service.types.daemon.StartOptions;
import jadex.commons.IRemoteChangeListener;
import jadex.commons.future.ExceptionDelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.commons.gui.PropertiesPanel;
import jadex.commons.gui.SGUI;
import jadex.commons.gui.future.SwingDefaultResultListener;
import jadex.commons.gui.jtable.ObjectTableModel;
import jadex.tools.daemon.DaemonChangeListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class DaemonPanel
extends JPanel {
    protected IExternalAccess agent;
    protected DaemonChangeListener listener;

    public DaemonPanel(final IExternalAccess agent) {
        this.agent = agent;
        this.setLayout(new BorderLayout());
        JPanel p = new JPanel(new BorderLayout());
        final PropertiesPanel stop = new PropertiesPanel("Start Options");
        stop.createTextField("Java command", "java", true, 0.0);
        stop.createTextField("VM arguments", null, true, 0.0);
        stop.createTextField("Classpath", null, true, 0.0);
        stop.createTextField("Main class", "jadex.base.Starter", true, 0.0);
        stop.createTextField("Program arguments", null, true, 0.0);
        stop.createTextField("Start directory", ".", true, 0.0);
        JButton[] stobuts = stop.createButtons("stobuts", new String[]{"Start", "Reset"}, 1.0);
        stobuts[0].setToolTipText("Start a new platform.");
        stobuts[0].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SServiceProvider.getService((IExternalAccess)agent, IDaemonService.class, (String)"platform").addResultListener((IResultListener)new SwingDefaultResultListener<IDaemonService>(){

                    public void customResultAvailable(IDaemonService result) {
                        IDaemonService ds = result;
                        StartOptions so = new StartOptions();
                        so.setJavaCommand(stop.getTextField("Java command").getText());
                        so.setVMArguments(stop.getTextField("VM arguments").getText());
                        so.setClassPath(stop.getTextField("Classpath").getText());
                        so.setMain(stop.getTextField("Main class").getText());
                        so.setProgramArguments(stop.getTextField("Program arguments").getText());
                        so.setStartDirectory(stop.getTextField("Start directory").getText());
                        ds.startPlatform(so);
                    }
                });
            }
        });
        stobuts[1].setToolTipText("Reset the start settings.");
        stobuts[1].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                stop.getTextField("Java command").setText("java");
                stop.getTextField("VM arguments").setText("");
                stop.getTextField("Classpath").setText("");
                stop.getTextField("Main class").setText("jadex.base.Starter");
                stop.getTextField("Program arguments").setText("");
                stop.getTextField("Start directory").setText("");
            }
        });
        final ObjectTableModel ptm = new ObjectTableModel(new String[]{"Platform Name"});
        final JTable platformt = new JTable((TableModel)ptm);
        platformt.setPreferredScrollableViewportSize(new Dimension(600, 120));
        this.listener = new DaemonChangeListener(platformt);
        SServiceProvider.getService((IExternalAccess)agent, IDaemonService.class, (String)"platform").addResultListener((IResultListener)new SwingDefaultResultListener<IDaemonService>(){

            public void customResultAvailable(IDaemonService result) {
                IDaemonService ds = result;
                ds.addChangeListener((IRemoteChangeListener)DaemonPanel.this.listener);
            }
        });
        PropertiesPanel suop = new PropertiesPanel("Shutdown Options");
        suop.addFullLineComponent("platformtable", (JComponent)new JScrollPane(platformt), 1.0);
        JButton[] suobuts = suop.createButtons("suobuts", new String[]{"Shutdown"}, 0.0);
        suobuts[0].setToolTipText("Start a new platform.");
        suobuts[0].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SServiceProvider.getService((IExternalAccess)agent, IDaemonService.class, (String)"platform").addResultListener((IResultListener)new SwingDefaultResultListener<IDaemonService>(){

                    public void customResultAvailable(IDaemonService result) {
                        IDaemonService ds = result;
                        int[] rows = platformt.getSelectedRows();
                        for (int i = 0; i < rows.length; ++i) {
                            IComponentIdentifier cid = (IComponentIdentifier)ptm.getObjectForRow(rows[i]);
                            ds.shutdownPlatform(cid);
                        }
                    }
                });
            }
        });
        p.add((Component)stop, "North");
        p.add((Component)suop, "Center");
        this.add((Component)p, "Center");
    }

    public IFuture<Void> shutdown() {
        final Future ret = new Future();
        SServiceProvider.getService((IExternalAccess)this.agent, IDaemonService.class, (String)"platform").addResultListener((IResultListener)new ExceptionDelegationResultListener<IDaemonService, Void>(ret){

            public void customResultAvailable(IDaemonService ds) {
                ds.removeChangeListener((IRemoteChangeListener)DaemonPanel.this.listener);
                ret.setResult(null);
            }

            public void exceptionOccurred(Exception exception) {
                ret.setException(exception);
            }
        });
        return ret;
    }

    protected void finalize() throws Throwable {
        this.shutdown();
        super.finalize();
    }

    public static void createGui(final IExternalAccess agent) {
        JFrame f = new JFrame();
        f.add(new DaemonPanel(agent));
        f.pack();
        f.setLocation(SGUI.calculateMiddlePosition((Window)f));
        f.setVisible(true);
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                agent.killComponent();
            }
        });
    }
}

