/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.debugger;

import jadex.base.gui.CMSUpdateHandler;
import jadex.bridge.IExternalAccess;
import jadex.bridge.service.search.SServiceProvider;
import jadex.bridge.service.types.cms.ICMSComponentListener;
import jadex.bridge.service.types.cms.IComponentDescription;
import jadex.bridge.service.types.cms.IComponentManagementService;
import jadex.commons.ChangeEvent;
import jadex.commons.IBreakpointPanel;
import jadex.commons.IChangeListener;
import jadex.commons.SUtil;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.commons.gui.SGUI;
import jadex.commons.gui.future.SwingDefaultResultListener;
import jadex.commons.gui.jtable.TableSorter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class BreakpointPanel
extends JPanel
implements IBreakpointPanel {
    protected static final UIDefaults icons = new UIDefaults(new Object[]{"breakpoint", SGUI.makeIcon(BreakpointPanel.class, (String)"/jadex/tools/common/images/lockoverlay.png")});
    protected List<String> breakpoints;
    protected IComponentDescription description;
    protected IExternalAccess access;
    protected JTable list;
    protected List listeners;

    public BreakpointPanel(String[] breakpointsa, IComponentDescription description, IExternalAccess access, CMSUpdateHandler cmshandler) {
        this.breakpoints = SUtil.arrayToList((Object)breakpointsa);
        this.description = description;
        this.access = access;
        cmshandler.addCMSListener(access.getComponentIdentifier(), new ICMSComponentListener(){

            public IFuture<Void> componentRemoved(IComponentDescription desc, Map<String, Object> results) {
                return IFuture.DONE;
            }

            public IFuture<Void> componentChanged(IComponentDescription desc) {
                BreakpointPanel.this.description = desc;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ((AbstractTableModel)BreakpointPanel.this.list.getModel()).fireTableDataChanged();
                    }
                });
                return IFuture.DONE;
            }

            public IFuture<Void> componentAdded(IComponentDescription desc) {
                return IFuture.DONE;
            }
        });
        AbstractTableModel lm = new AbstractTableModel(){

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public int getRowCount() {
                return BreakpointPanel.this.breakpoints.size();
            }

            @Override
            public Object getValueAt(int row, int column) {
                return column == 1 ? BreakpointPanel.this.breakpoints.get(row) : null;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 0;
            }

            public Class getColumnClass(int column) {
                return column == 0 ? JToggleButton.class : String.class;
            }
        };
        this.list = new JTable((TableModel)new TableSorter((TableModel)lm));
        TableSorter sorter = (TableSorter)this.list.getModel();
        sorter.setTableHeader(this.list.getTableHeader());
        this.setLayout(new BorderLayout());
        JScrollPane sp = new JScrollPane(this.list);
        this.add((Component)sp, "Center");
        this.list.getTableHeader().setPreferredSize(this.list.getTableHeader().getPreferredSize());
        this.list.getColumnModel().getColumn(0).setHeaderRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object obj, boolean selected, boolean focus, int row, int column) {
                this.setIcon(icons.getIcon("breakpoint"));
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                this.setHorizontalAlignment(0);
                this.setToolTipText("Use checkbox to enable/disable breakpoint on a rule.");
                return this;
            }
        });
        this.list.getColumnModel().getColumn(1).setHeaderValue("Breakpoints");
        this.list.setDefaultRenderer(JToggleButton.class, new ButtonCellManager());
        this.list.setDefaultEditor(JToggleButton.class, new ButtonCellManager());
        JCheckBox but = new JCheckBox();
        but.setMargin(new Insets(0, 0, 0, 0));
        this.list.getColumnModel().getColumn(0).setMaxWidth(but.getPreferredSize().width + 4);
        this.list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting() && BreakpointPanel.this.listeners != null) {
                    ChangeEvent ce = new ChangeEvent((Object)this, "event-type-selected");
                    for (int i = 0; i < BreakpointPanel.this.listeners.size(); ++i) {
                        ((IChangeListener)BreakpointPanel.this.listeners.get(i)).changeOccurred(ce);
                    }
                }
            }
        });
    }

    public void dispose() {
    }

    public String[] getSelectedBreakpoints() {
        ArrayList<String> selected = new ArrayList<String>();
        TableSorter sorter = (TableSorter)this.list.getModel();
        for (int i = 0; i < this.list.getRowCount(); ++i) {
            if (!this.list.isRowSelected(i)) continue;
            selected.add(this.breakpoints.get(sorter.modelIndex(i)));
        }
        return selected.toArray(new String[selected.size()]);
    }

    public void setSelectedBreakpoints(String[] breakpoints) {
        this.list.clearSelection();
        for (int i = 0; i < breakpoints.length; ++i) {
            int index = this.breakpoints.indexOf(breakpoints[i]);
            if (index == -1) continue;
            this.list.getSelectionModel().addSelectionInterval(index, index);
        }
    }

    public void addBreakpointListener(IChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
    }

    public void removeBreakpointListener(IChangeListener listener) {
        this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            this.listeners = null;
        }
    }

    public class ButtonCellManager
    extends AbstractCellEditor
    implements TableCellRenderer,
    TableCellEditor {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int column) {
            TableSorter sorter = (TableSorter)BreakpointPanel.this.list.getModel();
            boolean selected = SUtil.arrayContains((Object)BreakpointPanel.this.description.getBreakpoints(), (Object)BreakpointPanel.this.breakpoints.get(sorter.modelIndex(rowIndex)));
            JPanel ret = new JPanel(new BorderLayout());
            JCheckBox but = new JCheckBox((String)null, selected);
            ret.add((Component)but, "Center");
            ret.setToolTipText("Enable/disable breakpoint.");
            return ret;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, final int rowIndex, int column) {
            final TableSorter sorter = (TableSorter)BreakpointPanel.this.list.getModel();
            boolean selected = SUtil.arrayContains((Object)BreakpointPanel.this.description.getBreakpoints(), (Object)BreakpointPanel.this.breakpoints.get(sorter.modelIndex(rowIndex)));
            JPanel ret = new JPanel(new BorderLayout());
            final JCheckBox but = new JCheckBox((String)null, selected);
            ret.add((Component)but, "Center");
            ret.setToolTipText("Enable/disable breakpoint.");
            but.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    final ArrayList<String> bps = new ArrayList<String>(Arrays.asList(BreakpointPanel.this.description.getBreakpoints()));
                    if (but.isSelected()) {
                        bps.add(BreakpointPanel.this.breakpoints.get(sorter.modelIndex(rowIndex)));
                    } else {
                        bps.remove(BreakpointPanel.this.breakpoints.get(sorter.modelIndex(rowIndex)));
                    }
                    SServiceProvider.getService((IExternalAccess)BreakpointPanel.this.access, IComponentManagementService.class, (String)"platform").addResultListener((IResultListener)new SwingDefaultResultListener(BreakpointPanel.this){

                        public void customResultAvailable(Object result) {
                            ((IComponentManagementService)result).setComponentBreakpoints(BreakpointPanel.this.description.getName(), bps.toArray(new String[bps.size()]));
                        }
                    });
                }
            });
            return ret;
        }

        @Override
        public Object getCellEditorValue() {
            return "";
        }
    }
}

