/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.debugger;

import jadex.base.gui.plugin.AbstractJCCPlugin;
import jadex.base.gui.plugin.IControlCenter;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IExternalAccess;
import jadex.bridge.service.search.SServiceProvider;
import jadex.bridge.service.types.cms.ICMSComponentListener;
import jadex.bridge.service.types.cms.IComponentDescription;
import jadex.bridge.service.types.cms.IComponentManagementService;
import jadex.bridge.service.types.factory.SComponentFactory;
import jadex.commons.SReflect;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.commons.gui.future.SwingDefaultResultListener;
import jadex.commons.gui.future.SwingResultListener;
import jadex.tools.debugger.BreakpointPanel;
import jadex.tools.debugger.IDebuggerPanel;
import jadex.tools.debugger.common.ObjectInspectorDebuggerPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class DebuggerMainPanel
extends JSplitPane {
    public static final String KEY_DEBUGGER_PANELS = "debugger.panels";
    protected IControlCenter jcc;
    protected IComponentDescription desc;
    protected JButton step;
    protected JButton run;
    protected JButton pause;
    protected List<IDebuggerPanel> debuggerpanels;
    protected ICMSComponentListener listener;

    public DebuggerMainPanel(final IControlCenter jcc, final IComponentDescription desc) {
        super(1, new JPanel(), new JPanel());
        this.jcc = jcc;
        this.desc = desc;
        this.debuggerpanels = new ArrayList<IDebuggerPanel>();
        this.setOneTouchExpandable(true);
        this.setDividerLocation(0.3);
        SServiceProvider.getService((IExternalAccess)jcc.getPlatformAccess(), IComponentManagementService.class, (String)"platform").addResultListener((IResultListener)new SwingDefaultResultListener<IComponentManagementService>((Component)this){

            public void customResultAvailable(IComponentManagementService cms) {
                JPanel rightpanel = new JPanel();
                DebuggerMainPanel.this.setRightComponent(rightpanel);
                rightpanel.setLayout(new GridBagLayout());
                final JTabbedPane tabs = new JTabbedPane();
                cms.getExternalAccess(desc.getName()).addResultListener((IResultListener)new SwingResultListener((IResultListener)new IResultListener<IExternalAccess>(){

                    public void resultAvailable(final IExternalAccess exta) {
                        final BreakpointPanel[] leftpanel = new BreakpointPanel[1];
                        String[] bps = exta.getModel().getBreakpoints();
                        if (bps != null && bps.length > 0) {
                            leftpanel[0] = new BreakpointPanel(bps, desc, jcc.getPlatformAccess(), jcc.getCMSHandler());
                            DebuggerMainPanel.this.setLeftComponent(leftpanel[0]);
                            DebuggerMainPanel.this.setDividerLocation(0);
                        } else {
                            JPanel nobreakpoints = new JPanel();
                            nobreakpoints.add(new JLabel("no breakpoints"));
                            DebuggerMainPanel.this.setLeftComponent(nobreakpoints);
                            DebuggerMainPanel.this.setDividerLocation(0);
                        }
                        SComponentFactory.getProperty((IExternalAccess)exta, (String)DebuggerMainPanel.this.desc.getType(), (String)DebuggerMainPanel.KEY_DEBUGGER_PANELS).addResultListener((IResultListener)new SwingDefaultResultListener<Object>((Component)DebuggerMainPanel.this){

                            public void customResultAvailable(Object result) {
                                final String panels = (String)result;
                                if (panels != null) {
                                    AbstractJCCPlugin.getClassLoader((IComponentIdentifier)desc.getName(), (IControlCenter)jcc).addResultListener((IResultListener)new SwingDefaultResultListener<ClassLoader>((Component)DebuggerMainPanel.this){

                                        public void customResultAvailable(ClassLoader cl) {
                                            StringTokenizer stok = new StringTokenizer(panels, ", \t\n\r\f");
                                            while (stok.hasMoreTokens()) {
                                                String classname = stok.nextToken();
                                                try {
                                                    Class clazz = SReflect.classForName((String)classname, (ClassLoader)cl);
                                                    IDebuggerPanel panel = (IDebuggerPanel)clazz.newInstance();
                                                    panel.init(DebuggerMainPanel.this.jcc, leftpanel[0], DebuggerMainPanel.this.desc.getName(), exta);
                                                    DebuggerMainPanel.this.debuggerpanels.add(panel);
                                                    tabs.addTab(panel.getTitle(), panel.getIcon(), panel.getComponent(), panel.getTooltipText());
                                                }
                                                catch (Exception e) {
                                                    DebuggerMainPanel.this.jcc.displayError("Error initializing debugger panel.", "Debugger panel class: " + classname, e);
                                                }
                                            }
                                        }
                                    });
                                } else {
                                    ObjectInspectorDebuggerPanel panel = new ObjectInspectorDebuggerPanel();
                                    panel.init(DebuggerMainPanel.this.jcc, leftpanel[0], DebuggerMainPanel.this.desc.getName(), exta);
                                    DebuggerMainPanel.this.debuggerpanels.add(panel);
                                    tabs.addTab(panel.getTitle(), panel.getIcon(), panel.getComponent(), panel.getTooltipText());
                                }
                            }
                        });
                    }

                    public void exceptionOccurred(Exception exception) {
                        DebuggerMainPanel.this.jcc.displayError("Error initializing debugger panels.", null, exception);
                    }
                }));
                DebuggerMainPanel.this.pause = new JButton("Pause");
                DebuggerMainPanel.this.pause.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DebuggerMainPanel.this.pause.setEnabled(false);
                        SServiceProvider.getService((IExternalAccess)DebuggerMainPanel.this.jcc.getPlatformAccess(), IComponentManagementService.class, (String)"platform").addResultListener((IResultListener)new SwingDefaultResultListener<IComponentManagementService>((Component)DebuggerMainPanel.this){

                            public void customResultAvailable(IComponentManagementService ces) {
                                ces.suspendComponent(DebuggerMainPanel.this.desc.getName());
                            }
                        });
                    }
                });
                DebuggerMainPanel.this.step = new JButton("Step");
                DebuggerMainPanel.this.step.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DebuggerMainPanel.this.step.setEnabled(false);
                        DebuggerMainPanel.this.run.setEnabled(false);
                        SServiceProvider.getService((IExternalAccess)DebuggerMainPanel.this.jcc.getPlatformAccess(), IComponentManagementService.class, (String)"platform").addResultListener((IResultListener)new SwingDefaultResultListener<IComponentManagementService>((Component)DebuggerMainPanel.this){

                            public void customResultAvailable(final IComponentManagementService cms) {
                                IFuture ret = cms.stepComponent(DebuggerMainPanel.this.desc.getName(), DebuggerMainPanel.this.getStepInfo());
                                ret.addResultListener((IResultListener)new IResultListener<Void>(){

                                    public void resultAvailable(Void result) {
                                        cms.getComponentDescription(DebuggerMainPanel.this.desc.getName()).addResultListener((IResultListener)new IResultListener<IComponentDescription>(){

                                            public void resultAvailable(IComponentDescription result) {
                                                DebuggerMainPanel.this.updatePanel(result);
                                            }

                                            public void exceptionOccurred(Exception exception) {
                                                DebuggerMainPanel.this.error();
                                            }
                                        });
                                    }

                                    public void exceptionOccurred(Exception exception) {
                                        DebuggerMainPanel.this.error();
                                    }
                                });
                            }
                        });
                    }
                });
                DebuggerMainPanel.this.run = new JButton("Run");
                DebuggerMainPanel.this.run.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DebuggerMainPanel.this.step.setEnabled(false);
                        DebuggerMainPanel.this.run.setEnabled(false);
                        DebuggerMainPanel.this.pause.setEnabled(true);
                        SServiceProvider.getService((IExternalAccess)DebuggerMainPanel.this.jcc.getPlatformAccess(), IComponentManagementService.class, (String)"platform").addResultListener((IResultListener)new SwingDefaultResultListener<IComponentManagementService>((Component)DebuggerMainPanel.this){

                            public void customResultAvailable(final IComponentManagementService ces) {
                                IFuture ret = ces.resumeComponent(DebuggerMainPanel.this.desc.getName());
                                ret.addResultListener((IResultListener)new IResultListener<Void>(){

                                    public void resultAvailable(Void result) {
                                        ces.getComponentDescription(DebuggerMainPanel.this.desc.getName()).addResultListener((IResultListener)new IResultListener<IComponentDescription>(){

                                            public void resultAvailable(IComponentDescription result) {
                                                DebuggerMainPanel.this.updatePanel(result);
                                            }

                                            public void exceptionOccurred(Exception exception) {
                                                DebuggerMainPanel.this.error();
                                            }
                                        });
                                    }

                                    public void exceptionOccurred(Exception exception) {
                                        DebuggerMainPanel.this.error();
                                    }
                                });
                            }
                        });
                    }
                });
                Dimension msize = DebuggerMainPanel.this.pause.getMinimumSize();
                Dimension psize = DebuggerMainPanel.this.pause.getPreferredSize();
                DebuggerMainPanel.this.run.setMinimumSize(msize);
                DebuggerMainPanel.this.run.setPreferredSize(psize);
                DebuggerMainPanel.this.step.setMinimumSize(msize);
                DebuggerMainPanel.this.step.setPreferredSize(psize);
                int row = 0;
                int col = 0;
                rightpanel.add((Component)tabs, new GridBagConstraints(col++, row, 0, 1, 1.0, 1.0, 22, 1, new Insets(1, 1, 1, 1), 0, 0));
                col = 0;
                rightpanel.add((Component)DebuggerMainPanel.this.pause, new GridBagConstraints(col++, ++row, 1, 1, 1.0, 0.0, 22, 0, new Insets(1, 1, 1, 1), 0, 0));
                rightpanel.add((Component)DebuggerMainPanel.this.step, new GridBagConstraints(col++, row, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
                rightpanel.add((Component)DebuggerMainPanel.this.run, new GridBagConstraints(col, row++, 0, 1, 0.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
                DebuggerMainPanel.this.updatePanel(desc);
                DebuggerMainPanel.this.listener = new ICMSComponentListener(){

                    public IFuture<Void> componentChanged(IComponentDescription desc) {
                        if (desc.getName().equals(DebuggerMainPanel.this.desc.getName())) {
                            DebuggerMainPanel.this.updatePanel(desc);
                        }
                        return IFuture.DONE;
                    }

                    public IFuture<Void> componentRemoved(IComponentDescription desc, Map results) {
                        return IFuture.DONE;
                    }

                    public IFuture<Void> componentAdded(IComponentDescription desc) {
                        return IFuture.DONE;
                    }
                };
                jcc.getCMSHandler().addCMSListener(desc.getName().getRoot(), DebuggerMainPanel.this.listener);
            }
        });
    }

    public void dispose() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < DebuggerMainPanel.this.debuggerpanels.size(); ++i) {
                    IDebuggerPanel panel = DebuggerMainPanel.this.debuggerpanels.get(i);
                    panel.dispose();
                }
                if (DebuggerMainPanel.this.listener != null) {
                    DebuggerMainPanel.this.jcc.getCMSHandler().removeCMSListener(DebuggerMainPanel.this.desc.getName().getRoot(), DebuggerMainPanel.this.listener);
                }
            }
        });
    }

    protected void updatePanel(final IComponentDescription desc) {
        if (desc == null) {
            System.out.println("asfhsfhakfhk");
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DebuggerMainPanel.this.pause.setEnabled(!"suspended".equals(desc.getState()));
                DebuggerMainPanel.this.step.setEnabled("suspended".equals(desc.getState()));
                DebuggerMainPanel.this.run.setEnabled("suspended".equals(desc.getState()));
            }
        });
    }

    protected void error() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DebuggerMainPanel.this.step.setEnabled(true);
                DebuggerMainPanel.this.run.setEnabled(true);
                DebuggerMainPanel.this.pause.setEnabled(false);
            }
        });
    }

    public String getStepInfo() {
        String ret;
        block1: {
            IDebuggerPanel pan;
            ret = null;
            if (this.debuggerpanels == null) break block1;
            Iterator<IDebuggerPanel> iterator = this.debuggerpanels.iterator();
            while (iterator.hasNext() && (ret = (pan = iterator.next()).getStepInfo()) == null) {
            }
        }
        return ret;
    }
}

