/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.debugger;

import jadex.base.gui.asynctree.INodeListener;
import jadex.base.gui.asynctree.ISwingNodeHandler;
import jadex.base.gui.asynctree.ISwingTreeNode;
import jadex.base.gui.asynctree.ITreeNode;
import jadex.base.gui.componenttree.ComponentTreePanel;
import jadex.base.gui.componenttree.IActiveComponentTreeNode;
import jadex.base.gui.plugin.AbstractJCCPlugin;
import jadex.bridge.service.types.cms.IComponentDescription;
import jadex.commons.Properties;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.gui.CombiIcon;
import jadex.commons.gui.ObjectCardLayout;
import jadex.commons.gui.SGUI;
import jadex.tools.debugger.DebuggerMainPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.UIDefaults;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class DebuggerPlugin
extends AbstractJCCPlugin {
    protected static final UIDefaults icons = new UIDefaults(new Object[]{"debugger", SGUI.makeIcon(DebuggerPlugin.class, (String)"/jadex/tools/common/images/new_introspector.png"), "debugger_sel", SGUI.makeIcon(DebuggerPlugin.class, (String)"/jadex/tools/common/images/new_introspector_sel.png"), "debug_component", SGUI.makeIcon(DebuggerPlugin.class, (String)"/jadex/tools/common/images/new_introspector.png"), "close_debugger", SGUI.makeIcon(DebuggerPlugin.class, (String)"/jadex/tools/common/images/close_introspector.png"), "component_debugged", SGUI.makeIcon(DebuggerPlugin.class, (String)"/jadex/tools/common/images/overlay_introspected.png"), "stop_debugger", SGUI.makeIcon(DebuggerPlugin.class, (String)"/jadex/tools/common/images/overlay_notintrospected.png"), "debugger_empty", SGUI.makeIcon(DebuggerPlugin.class, (String)"/jadex/tools/common/images/introspector_empty.png")});
    protected JSplitPane split;
    protected ComponentTreePanel comptree;
    protected JPanel detail;
    protected ObjectCardLayout cards;
    final AbstractAction START_DEBUGGER = new AbstractAction("Debug Component", icons.getIcon("debug_component")){

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath[] paths = DebuggerPlugin.this.comptree.getTree().getSelectionPaths();
            for (int i = 0; paths != null && i < paths.length; ++i) {
                if (!(paths[i].getLastPathComponent() instanceof IActiveComponentTreeNode)) continue;
                IActiveComponentTreeNode node = (IActiveComponentTreeNode)paths[i].getLastPathComponent();
                IComponentDescription desc = node.getDescription();
                DebuggerMainPanel panel = new DebuggerMainPanel(DebuggerPlugin.this.getJCC(), desc);
                DebuggerPlugin.this.detail.add((Component)panel, desc.getName());
                DebuggerPlugin.this.comptree.getModel().fireNodeChanged((ITreeNode)node);
            }
        }
    };
    final AbstractAction STOP_DEBUGGER = new AbstractAction("Close Debugger", icons.getIcon("close_debugger")){

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath[] paths = DebuggerPlugin.this.comptree.getTree().getSelectionPaths();
            for (int i = 0; paths != null && i < paths.length; ++i) {
                if (!(paths[i].getLastPathComponent() instanceof IActiveComponentTreeNode)) continue;
                IActiveComponentTreeNode node = (IActiveComponentTreeNode)paths[i].getLastPathComponent();
                DebuggerMainPanel panel = (DebuggerMainPanel)DebuggerPlugin.this.cards.getComponent(node.getId());
                panel.dispose();
                DebuggerPlugin.this.detail.remove(panel);
                DebuggerPlugin.this.comptree.getModel().fireNodeChanged((ITreeNode)node);
            }
        }
    };

    public IFuture<Properties> getProperties() {
        return new Future((Object)null);
    }

    public IFuture<Void> setProperties(Properties props) {
        return IFuture.DONE;
    }

    public String getName() {
        return "Debugger";
    }

    public Icon getToolIcon(boolean selected) {
        return selected ? icons.getIcon("debugger_sel") : icons.getIcon("debugger");
    }

    public JComponent[] createToolBar() {
        JButton b1 = new JButton(this.START_DEBUGGER);
        b1.setBorder(null);
        b1.setToolTipText(b1.getText());
        b1.setText(null);
        b1.setEnabled(true);
        JButton b2 = new JButton(this.STOP_DEBUGGER);
        b2.setBorder(null);
        b2.setToolTipText(b2.getText());
        b2.setText(null);
        b2.setEnabled(true);
        return new JComponent[]{b1, b2};
    }

    public JMenu[] createMenuBar() {
        return null;
    }

    public JComponent createView() {
        this.split = new JSplitPane(1, true);
        this.split.setOneTouchExpandable(true);
        this.comptree = new ComponentTreePanel(this.getJCC().getPlatformAccess(), this.getJCC().getJCCAccess(), this.getJCC().getCMSHandler(), this.getJCC().getPropertyHandler(), this.getJCC().getIconCache());
        this.comptree.setMinimumSize(new Dimension(0, 0));
        this.split.add((Component)this.comptree);
        this.comptree.getTree().getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                Object node;
                JTree tree = DebuggerPlugin.this.comptree.getTree();
                if (tree.getSelectionPath() != null && (node = tree.getSelectionPath().getLastPathComponent()) instanceof IActiveComponentTreeNode) {
                    DebuggerPlugin.this.cards.show(((IActiveComponentTreeNode)node).getId());
                }
            }
        });
        this.comptree.addNodeHandler((ISwingNodeHandler)new AbstractJCCPlugin.ShowRemoteControlCenterHandler(this.getJCC(), (Component)this.getView()));
        this.comptree.addNodeHandler(new ISwingNodeHandler(){

            public Action[] getPopupActions(ISwingTreeNode[] nodes) {
                Action[] ret = null;
                boolean allcomp = true;
                for (int i = 0; allcomp && i < nodes.length; ++i) {
                    allcomp = nodes[i] instanceof IActiveComponentTreeNode;
                }
                if (allcomp) {
                    boolean allob = true;
                    for (int i = 0; allob && i < nodes.length; ++i) {
                        allob = DebuggerPlugin.this.cards.getComponent(nodes[i].getId()) != null;
                    }
                    boolean allig = true;
                    for (int i = 0; allig && i < nodes.length; ++i) {
                        allig = DebuggerPlugin.this.cards.getComponent(nodes[i].getId()) == null;
                    }
                    if (allig) {
                        Icon base = nodes[0].getSwingIcon();
                        AbstractAction a = new AbstractAction((String)DebuggerPlugin.this.START_DEBUGGER.getValue("Name"), (Icon)(base != null ? new CombiIcon(new Icon[]{base, icons.getIcon("component_debugged")}) : (Icon)DebuggerPlugin.this.START_DEBUGGER.getValue("SmallIcon"))){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                DebuggerPlugin.this.START_DEBUGGER.actionPerformed(e);
                            }
                        };
                        ret = new Action[]{a};
                    } else if (allob) {
                        Icon base = nodes[0].getSwingIcon();
                        AbstractAction a = new AbstractAction((String)DebuggerPlugin.this.STOP_DEBUGGER.getValue("Name"), (Icon)(base != null ? new CombiIcon(new Icon[]{base, icons.getIcon("stop_debugger")}) : (Icon)DebuggerPlugin.this.STOP_DEBUGGER.getValue("SmallIcon"))){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                DebuggerPlugin.this.STOP_DEBUGGER.actionPerformed(e);
                            }
                        };
                        ret = new Action[]{a};
                    }
                }
                return ret;
            }

            public byte[] getOverlay(ITreeNode node) {
                return null;
            }

            public Icon getSwingOverlay(ISwingTreeNode node) {
                Icon ret = null;
                if (node instanceof IActiveComponentTreeNode && DebuggerPlugin.this.cards.getComponent(node.getId()) != null) {
                    ret = icons.getIcon("component_debugged");
                }
                return ret;
            }

            public Action getDefaultAction(ISwingTreeNode node) {
                AbstractAction a = null;
                if (node instanceof IActiveComponentTreeNode) {
                    a = DebuggerPlugin.this.cards.getComponent(node.getId()) != null ? DebuggerPlugin.this.STOP_DEBUGGER : DebuggerPlugin.this.START_DEBUGGER;
                }
                return a;
            }
        });
        this.comptree.getModel().addNodeListener(new INodeListener(){

            public void nodeRemoved(ITreeNode node) {
                if (node instanceof IActiveComponentTreeNode && DebuggerPlugin.this.cards.getComponent(node.getId()) != null) {
                    DebuggerMainPanel panel = (DebuggerMainPanel)DebuggerPlugin.this.cards.getComponent(node.getId());
                    panel.dispose();
                    DebuggerPlugin.this.detail.remove(panel);
                }
            }

            public void nodeAdded(ITreeNode node) {
            }
        });
        JLabel emptylabel = new JLabel("Select components to activate the debugger", icons.getIcon("debugger_empty"), 0);
        emptylabel.setVerticalAlignment(0);
        emptylabel.setHorizontalTextPosition(0);
        emptylabel.setVerticalTextPosition(3);
        emptylabel.setFont(emptylabel.getFont().deriveFont((float)emptylabel.getFont().getSize() * 1.3f));
        this.cards = new ObjectCardLayout();
        this.detail = new JPanel((LayoutManager)this.cards);
        this.detail.setMinimumSize(new Dimension(0, 0));
        this.detail.add("jtc_ocl_default_component", emptylabel);
        this.split.add(this.detail);
        this.split.setDividerLocation(150);
        return this.split;
    }

    public IFuture<Void> shutdown() {
        this.comptree.dispose();
        return super.shutdown();
    }
}

