/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.debugger.micro;

import jadex.bridge.BulkMonitoringEvent;
import jadex.bridge.IExternalAccess;
import jadex.bridge.service.types.monitoring.IMonitoringEvent;
import jadex.bridge.service.types.monitoring.IMonitoringService;
import jadex.commons.IBreakpointPanel;
import jadex.commons.IFilter;
import jadex.commons.future.FutureTerminatedException;
import jadex.commons.future.IIntermediateResultListener;
import jadex.commons.future.IResultListener;
import jadex.commons.future.ISubscriptionIntermediateFuture;
import jadex.commons.future.IntermediateDefaultResultListener;
import jadex.commons.gui.JSplitPanel;
import jadex.commons.gui.future.SwingIntermediateResultListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MicroAgentViewPanel
extends JPanel {
    protected IExternalAccess agent;
    protected ISubscriptionIntermediateFuture<IMonitoringEvent> sub;
    protected DefaultListModel steps;
    protected JTextArea step;
    protected IMonitoringEvent laststep;
    protected DefaultListModel history;

    public MicroAgentViewPanel(IExternalAccess agent, IBreakpointPanel bpp, boolean verticallayout) {
        this.agent = agent;
        this.steps = new DefaultListModel();
        final JList<Object> sl = new JList<Object>(this.steps);
        DefaultListCellRenderer eventrenderer = new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                value = ((IMonitoringEvent)value).getProperty("sourcename");
                return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
        };
        sl.setCellRenderer(eventrenderer);
        JPanel ul = new JPanel(new BorderLayout());
        ul.add(new JScrollPane(sl));
        ul.setBorder(BorderFactory.createTitledBorder("Steps"));
        this.history = new DefaultListModel();
        final JList<Object> hl = new JList<Object>(this.history);
        hl.setCellRenderer(eventrenderer);
        JPanel ur = new JPanel(new BorderLayout());
        JScrollPane sp = new JScrollPane(hl);
        ur.add(sp);
        ur.setBorder(BorderFactory.createTitledBorder("History"));
        this.step = new JTextArea();
        JPanel down = new JPanel(new BorderLayout());
        down.add(new JScrollPane(this.step));
        down.setBorder(BorderFactory.createTitledBorder("Step Detail"));
        sl.setSelectionModel(new DefaultListSelectionModel(){

            @Override
            public void setSelectionInterval(int index0, int index1) {
                if (this.isSelectedIndex(index0)) {
                    super.removeSelectionInterval(index0, index1);
                } else {
                    super.setSelectionInterval(index0, index1);
                }
            }
        });
        sl.setSelectionMode(0);
        sl.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int idx = sl.getSelectedIndex();
                if (idx != -1) {
                    IMonitoringEvent cce = (IMonitoringEvent)MicroAgentViewPanel.this.steps.get(idx);
                    if (cce != null && cce != MicroAgentViewPanel.this.laststep) {
                        Object det = cce.getProperty("details");
                        if (det instanceof Map) {
                            StringBuilder sb = new StringBuilder();
                            Iterator iter = ((Map)det).entrySet().iterator();
                            while (iter.hasNext()) {
                                Map.Entry entry = iter.next();
                                sb.append(entry.getKey());
                                sb.append(" = ");
                                sb.append(entry.getValue());
                                if (!iter.hasNext()) continue;
                                sb.append('\n');
                            }
                            det = sb.toString();
                        }
                        MicroAgentViewPanel.this.step.setText(det.toString());
                        MicroAgentViewPanel.this.laststep = cce;
                    }
                } else if (MicroAgentViewPanel.this.laststep != null && MicroAgentViewPanel.this.steps.contains(MicroAgentViewPanel.this.laststep)) {
                    MicroAgentViewPanel.this.step.setText("");
                    MicroAgentViewPanel.this.laststep = null;
                }
            }
        });
        hl.setSelectionModel(new DefaultListSelectionModel(){

            @Override
            public void setSelectionInterval(int index0, int index1) {
                if (this.isSelectedIndex(index0)) {
                    super.removeSelectionInterval(index0, index1);
                } else {
                    super.setSelectionInterval(index0, index1);
                }
            }
        });
        hl.setSelectionMode(0);
        hl.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int idx = hl.getSelectedIndex();
                if (idx != -1) {
                    IMonitoringEvent cce = (IMonitoringEvent)MicroAgentViewPanel.this.history.get(idx);
                    if (cce != null && cce != MicroAgentViewPanel.this.laststep) {
                        MicroAgentViewPanel.this.step.setText(cce.getProperty("details").toString());
                        MicroAgentViewPanel.this.laststep = cce;
                    }
                } else if (MicroAgentViewPanel.this.laststep != null && MicroAgentViewPanel.this.history.contains(MicroAgentViewPanel.this.laststep)) {
                    MicroAgentViewPanel.this.step.setText("");
                    MicroAgentViewPanel.this.laststep = null;
                }
            }
        });
        final JCheckBox hon = new JCheckBox("Store History");
        hon.setSelected(true);
        this.sub = agent.subscribeToEvents((IFilter)new IFilter<IMonitoringEvent>(){

            public boolean filter(IMonitoringEvent ev) {
                return ev.getType().endsWith("step");
            }
        }, true, IMonitoringService.PublishEventLevel.FINE);
        this.sub.addResultListener((IResultListener)new SwingIntermediateResultListener((IIntermediateResultListener)new IntermediateDefaultResultListener<IMonitoringEvent>(){

            public void intermediateResultAvailable(IMonitoringEvent event) {
                try {
                    if (event instanceof BulkMonitoringEvent) {
                        BulkMonitoringEvent bev = (BulkMonitoringEvent)event;
                        if (bev.getBulkEvents().length > 0) {
                            IMonitoringEvent[] events = bev.getBulkEvents();
                            for (int i = 0; i < events.length; ++i) {
                                this.intermediateResultAvailable(events[i]);
                            }
                        }
                    } else if (event.getType().startsWith("created") && event.getType().endsWith("step")) {
                        MicroAgentViewPanel.this.steps.addElement(event);
                        if (MicroAgentViewPanel.this.laststep == null && MicroAgentViewPanel.this.steps.size() == 1) {
                            sl.setSelectedIndex(0);
                        }
                    } else if (event.getType().startsWith("disposed") && event.getType().endsWith("step")) {
                        for (int i = 0; i < MicroAgentViewPanel.this.steps.size(); ++i) {
                            IMonitoringEvent tmp = (IMonitoringEvent)MicroAgentViewPanel.this.steps.get(i);
                            if (!event.getProperty("id").equals(tmp.getProperty("id"))) continue;
                            MicroAgentViewPanel.this.steps.removeElementAt(i);
                            if (MicroAgentViewPanel.this.laststep == null || !MicroAgentViewPanel.this.laststep.getProperty("id").equals(tmp.getProperty("id"))) break;
                            MicroAgentViewPanel.this.laststep = null;
                            break;
                        }
                        if (MicroAgentViewPanel.this.laststep == null) {
                            sl.setSelectedIndex(0);
                        }
                        if (hon.isSelected()) {
                            MicroAgentViewPanel.this.history.addElement(event);
                            hl.ensureIndexIsVisible(MicroAgentViewPanel.this.history.size() - 1);
                            hl.invalidate();
                            hl.repaint();
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public void exceptionOccurred(Exception exception) {
                if (!(exception instanceof FutureTerminatedException)) {
                    super.exceptionOccurred(exception);
                }
            }
        }));
        JButton clear = new JButton("Clear");
        clear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MicroAgentViewPanel.this.history.removeAllElements();
            }
        });
        JPanel buts = new JPanel(new FlowLayout(2));
        buts.add(hon);
        buts.add(clear);
        down.add((Component)buts, "South");
        if (!verticallayout) {
            JSplitPanel up = new JSplitPanel(1, (Component)ul, (Component)ur);
            up.setDividerLocation(0.5);
            JSplitPanel tmp = new JSplitPanel(0);
            tmp.setDividerLocation(0.7);
            tmp.add((Component)up);
            tmp.add((Component)down);
            tmp.setDividerLocation(200);
            tmp.setOneTouchExpandable(true);
            this.setLayout(new BorderLayout());
            this.add((Component)tmp, "Center");
        } else {
            JSplitPanel up = new JSplitPanel(0, (Component)ul, (Component)ur);
            up.setDividerLocation(0.5);
            up.setOneTouchExpandable(true);
            JSplitPanel tmp = new JSplitPanel(0);
            tmp.setDividerLocation(1.0);
            tmp.add((Component)up);
            tmp.add((Component)down);
            tmp.setOneTouchExpandable(true);
            this.setLayout(new BorderLayout());
            this.add((Component)tmp, "Center");
        }
    }

    public String getStepInfo() {
        return this.laststep != null ? "" + this.laststep.getProperties().get("id") : null;
    }

    public void dispose() {
        this.sub.terminate();
    }
}

