/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.dfbrowser;

import jadex.base.gui.componentviewer.IServiceViewerPanel;
import jadex.base.gui.plugin.IControlCenter;
import jadex.bridge.fipa.DFComponentDescription;
import jadex.bridge.service.IService;
import jadex.bridge.service.types.df.IDF;
import jadex.bridge.service.types.df.IDFComponentDescription;
import jadex.bridge.service.types.df.IDFServiceDescription;
import jadex.commons.Properties;
import jadex.commons.Property;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.commons.gui.SGUI;
import jadex.commons.gui.future.SwingDefaultResultListener;
import jadex.tools.dfbrowser.DFComponentTable;
import jadex.tools.dfbrowser.DFServiceTable;
import jadex.tools.dfbrowser.ServiceDescriptionPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.Timer;
import javax.swing.UIDefaults;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DFBrowserPanel
extends JPanel
implements IServiceViewerPanel {
    protected static final UIDefaults icons = new UIDefaults(new Object[]{"refresh", SGUI.makeIcon(DFBrowserPanel.class, (String)"/jadex/tools/common/images/new_refresh_anim00.png")});
    protected IDF df;
    protected DFComponentTable component_table;
    protected DFServiceTable service_table;
    protected ServiceDescriptionPanel service_panel;
    protected JSplitPane split2;
    protected JSplitPane split3;
    protected IDFComponentDescription[] old_ads;
    protected Timer timer;
    protected int defrefresh;
    protected JRadioButton[] rb_refresh;
    protected JCheckBox remotecb;

    public IFuture<Void> init(IControlCenter jcc, IService service) {
        this.df = (IDF)service;
        this.service_panel = new ServiceDescriptionPanel();
        this.service_table = new DFServiceTable();
        JScrollPane stscroll = new JScrollPane(this.service_table);
        stscroll.setBorder(new TitledBorder(new EtchedBorder(1), "Registered Services"));
        this.component_table = new DFComponentTable(this);
        JScrollPane atscroll = new JScrollPane(this.component_table);
        atscroll.setBorder(new TitledBorder(new EtchedBorder(1), "Registered Component Descriptions"));
        this.component_table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                IDFComponentDescription[] selcomponents = DFBrowserPanel.this.component_table.getSelectedComponents();
                DFBrowserPanel.this.service_table.setComponentDescriptions(selcomponents);
            }
        });
        this.service_table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DFBrowserPanel.this.updateDetailedService();
            }
        });
        this.setLayout(new BorderLayout());
        this.split3 = new JSplitPane(0);
        this.split3.setDividerLocation(130);
        this.split3.setOneTouchExpandable(true);
        this.split3.add(stscroll);
        this.split3.add(this.service_panel);
        this.split3.setResizeWeight(1.0);
        this.split2 = new JSplitPane(0);
        this.split2.setDividerLocation(130);
        this.split2.add(atscroll);
        this.split2.add(this.split3);
        this.split2.setResizeWeight(0.5);
        this.add((Component)this.split2, "Center");
        this.timer = new Timer(this.defrefresh, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DFBrowserPanel.this.refresh();
            }
        });
        int[] refreshs = new int[]{0, 1000, 5000, 30000};
        JPanel settings = new JPanel(new GridBagLayout());
        settings.setBorder(new TitledBorder(new EtchedBorder(1), "Settings"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        this.remotecb = new JCheckBox("Remote search");
        settings.add((Component)this.remotecb, gbc);
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.anchor = 13;
        ButtonGroup group = new ButtonGroup();
        this.rb_refresh = new JRadioButton[refreshs.length];
        for (int i = 0; i < this.rb_refresh.length; ++i) {
            final int refresh = refreshs[i];
            this.rb_refresh[i] = new JRadioButton(refresh > 0 ? Integer.toString(refresh / 1000) + " s" : "No refresh");
            this.rb_refresh[i].putClientProperty("refresh", refresh);
            group.add(this.rb_refresh[i]);
            settings.add((Component)this.rb_refresh[i], gbc);
            this.rb_refresh[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DFBrowserPanel.this.defrefresh = refresh;
                    if (refresh > 0) {
                        DFBrowserPanel.this.timer.setDelay(refresh);
                        DFBrowserPanel.this.timer.setInitialDelay(refresh);
                        DFBrowserPanel.this.timer.restart();
                    } else {
                        DFBrowserPanel.this.timer.stop();
                    }
                }
            });
        }
        this.rb_refresh[2].setSelected(true);
        JButton button = new JButton("Refresh", icons.getIcon("refresh"));
        button.setMargin(new Insets(2, 2, 2, 2));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DFBrowserPanel.this.refresh();
            }
        });
        settings.add((Component)button, gbc);
        this.add((Component)settings, "North");
        this.refresh();
        return IFuture.DONE;
    }

    public IFuture<Void> shutdown() {
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
        return IFuture.DONE;
    }

    public JComponent getComponent() {
        return this;
    }

    public String getId() {
        return "dfbrowser";
    }

    public IFuture<Void> setProperties(Properties ps) {
        int refresh = 5000;
        if (ps != null) {
            refresh = ps.getIntProperty("defrefresh");
            this.remotecb.setSelected(ps.getBooleanProperty("dfremote"));
        }
        for (int i = 0; i < this.rb_refresh.length; ++i) {
            if ((Integer)this.rb_refresh[i].getClientProperty("refresh") != refresh) continue;
            this.rb_refresh[i].doClick();
        }
        return IFuture.DONE;
    }

    public IFuture<Properties> getProperties() {
        Future ret = new Future();
        Properties props = new Properties();
        props.addProperty(new Property("defrefresh", Integer.toString(this.defrefresh)));
        props.addProperty(new Property("dfremote", Boolean.toString(this.remotecb.isSelected())));
        ret.setResult((Object)props);
        return ret;
    }

    protected void refresh() {
        this.df.search((IDFComponentDescription)new DFComponentDescription(null), null, this.remotecb.isSelected()).addResultListener((IResultListener)new SwingDefaultResultListener(this){

            public void customResultAvailable(Object result) {
                Object[] ads = (IDFComponentDescription[])result;
                if (DFBrowserPanel.this.old_ads == null || !Arrays.equals(DFBrowserPanel.this.old_ads, ads)) {
                    DFBrowserPanel.this.component_table.setComponentDescriptions((IDFComponentDescription[])ads);
                    DFBrowserPanel.this.updateServices((IDFComponentDescription[])ads);
                    DFBrowserPanel.this.updateDetailedService();
                    DFBrowserPanel.this.old_ads = ads;
                }
            }
        });
    }

    public void updateServices(IDFComponentDescription[] ads) {
        IDFComponentDescription[] selcomponents = this.component_table.getSelectedComponents();
        if (selcomponents.length == 0) {
            this.service_table.setComponentDescriptions(ads);
        }
    }

    public void updateDetailedService() {
        Object[] sdescs = this.service_table.getSelectedServices();
        this.service_panel.setService((IDFComponentDescription)sdescs[1], (IDFServiceDescription)sdescs[0]);
    }

    protected void removeComponentRegistration(IDFComponentDescription description) {
        this.df.deregister(description).addResultListener((IResultListener)new SwingDefaultResultListener(this){

            public void customResultAvailable(Object result) {
                DFBrowserPanel.this.refresh();
            }
        });
    }
}

