/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.dfbrowser;

import jadex.base.gui.jtable.ComponentIdentifierRenderer;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.service.types.df.IDFComponentDescription;
import jadex.bridge.service.types.df.IDFServiceDescription;
import jadex.bridge.service.types.df.IProperty;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class ServiceDescriptionPanel
extends JPanel {
    protected JTextField name;
    protected JTextField type;
    protected JTextField owner;
    protected JTextField component;
    protected JList onto;
    protected JList lang;
    protected JList proto;
    protected JList props;

    public ServiceDescriptionPanel() {
        super(new GridBagLayout());
        this.setBorder(new TitledBorder(new EtchedBorder(1), "Service Properties"));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(1, 1, 1, 1);
        this.name = this.addTextField(c, "Name", "", "Service name");
        this.type = this.addTextField(c, "Type", "", "Service type");
        this.owner = this.addTextField(c, "Ownership", "", "Service ownership");
        this.component = this.addTextField(c, "Component", "", "The component providing this service");
        JPanel panel = new JPanel(new GridLayout(1, 4));
        this.onto = this.addList(panel, "Ontologies", "Ontologies understood by this service");
        this.lang = this.addList(panel, "Languages", "Languages understood by this service");
        this.proto = this.addList(panel, "Protocols", "Protocols utilized by this service");
        this.props = this.addList(panel, "Properties", "Properties of this service");
        c.anchor = 10;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = -1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 0;
        this.add((Component)panel, c);
    }

    void setService(IDFComponentDescription ad, IDFServiceDescription sd) {
        this.name.setText(sd == null ? "" : sd.getName());
        this.name.setToolTipText(sd == null ? "" : sd.getName());
        this.type.setText(sd == null ? "" : sd.getType());
        this.type.setToolTipText(sd == null ? "" : sd.getType());
        this.owner.setText(sd == null ? "" : sd.getOwnership());
        this.owner.setToolTipText(sd == null ? "" : sd.getOwnership());
        this.component.setText(ad == null ? "" : ad.getName().getName());
        if (ad != null) {
            this.component.setToolTipText(ComponentIdentifierRenderer.getTooltipText((IComponentIdentifier)ad.getName()));
        }
        this.update(this.onto, sd == null ? new String[]{} : sd.getOntologies());
        this.update(this.lang, sd == null ? new String[]{} : sd.getLanguages());
        this.update(this.proto, sd == null ? new String[]{} : sd.getProtocols());
        DefaultListModel model = (DefaultListModel)this.props.getModel();
        model.clear();
        IProperty[] items = sd == null ? new IProperty[]{} : sd.getProperties();
        for (int i = 0; i < items.length; ++i) {
            model.addElement(items[i].getName() + '=' + items[i].getValue());
        }
    }

    protected void update(JList list, String[] items) {
        DefaultListModel model = (DefaultListModel)list.getModel();
        model.clear();
        for (int i = 0; i < items.length; ++i) {
            model.addElement(items[i]);
        }
    }

    protected JList addList(JPanel panel, String name, String tooltip) {
        DefaultListModel model = new DefaultListModel();
        JList list = new JList(model);
        JPanel tp = new JPanel(new BorderLayout());
        tp.setBorder(new TitledBorder(new EtchedBorder(1), name));
        list.setToolTipText(tooltip);
        JScrollPane scroll = new JScrollPane(list);
        tp.add("Center", scroll);
        panel.add(tp);
        return list;
    }

    protected JTextField addTextField(GridBagConstraints c, String label, String value, String tooltip) {
        c.anchor = 13;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = -1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        JLabel l = new JLabel(label + ':');
        this.add((Component)l, c);
        c.anchor = 17;
        c.fill = 2;
        c.gridx = -1;
        c.weightx = 1.0;
        c.gridwidth = 0;
        JTextField tf = new JTextField(value, value.length());
        tf.setEditable(false);
        this.add((Component)tf, c);
        l.setLabelFor(tf);
        tf.setToolTipText(tooltip);
        return tf;
    }
}

