/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.dfbrowser;

import jadex.bridge.IComponentIdentifier;
import jadex.bridge.service.types.df.IDFComponentDescription;
import jadex.bridge.service.types.df.IDFServiceDescription;
import jadex.bridge.service.types.df.IProperty;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

class ServiceTableModel
extends AbstractTableModel {
    IDFComponentDescription[] ad;
    IDFServiceDescription[] sd;

    ServiceTableModel() {
    }

    @Override
    public int getColumnCount() {
        return 8;
    }

    public void setComponentDescriptions(IDFComponentDescription[] ads) {
        ArrayList<IDFComponentDescription> ad_list = new ArrayList<IDFComponentDescription>();
        ArrayList<IDFServiceDescription> svd_list = new ArrayList<IDFServiceDescription>();
        for (int a = 0; a < ads.length; ++a) {
            IDFComponentDescription ad = ads[a];
            IDFServiceDescription[] sd = ads[a].getServices();
            for (int s = 0; s < sd.length; ++s) {
                ad_list.add(ad);
                svd_list.add(sd[s]);
            }
        }
        this.ad = ad_list.toArray(new IDFComponentDescription[ad_list.size()]);
        this.sd = svd_list.toArray(new IDFServiceDescription[svd_list.size()]);
        this.fireTableDataChanged();
    }

    public void setComponentDescription(IDFComponentDescription ad) {
        IDFServiceDescription[] sd = ad.getServices();
        IDFComponentDescription[] aid = new IDFComponentDescription[sd.length];
        for (int s = 0; s < sd.length; ++s) {
            aid[s] = ad;
        }
        this.ad = aid;
        this.sd = sd;
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.sd != null ? this.sd.length : 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.sd == null || rowIndex < 0 || rowIndex >= this.sd.length) {
            return null;
        }
        switch (columnIndex) {
            case 0: {
                return this.sd[rowIndex].getName();
            }
            case 1: {
                return this.sd[rowIndex].getType();
            }
            case 2: {
                return this.sd[rowIndex].getOwnership();
            }
            case 3: {
                return this.ad[rowIndex].getName();
            }
            case 4: {
                return this.sd[rowIndex].getOntologies();
            }
            case 5: {
                return this.sd[rowIndex].getLanguages();
            }
            case 6: {
                return this.sd[rowIndex].getProtocols();
            }
            case 7: {
                return this.sd[rowIndex].getProperties();
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Name";
            }
            case 1: {
                return "Type";
            }
            case 2: {
                return "Ownership";
            }
            case 3: {
                return "Component";
            }
            case 4: {
                return "Ontologies";
            }
            case 5: {
                return "Languages";
            }
            case 6: {
                return "Protocols";
            }
            case 7: {
                return "Properties";
            }
        }
        return null;
    }

    public Class getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return IComponentIdentifier.class;
            }
            case 4: {
                return String[].class;
            }
            case 5: {
                return String[].class;
            }
            case 6: {
                return String[].class;
            }
            case 7: {
                return IProperty[].class;
            }
        }
        return null;
    }

    public IDFServiceDescription getServiceDescription(int i) {
        return this.sd == null || i < 0 || i >= this.sd.length ? null : this.sd[i];
    }

    public IDFComponentDescription getComponentDescription(int i) {
        return this.ad == null || i < 0 || i >= this.ad.length ? null : this.ad[i];
    }
}

