/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.email;

import jadex.base.gui.plugin.IControlCenter;
import jadex.bridge.IExternalAccess;
import jadex.bridge.service.search.SServiceProvider;
import jadex.bridge.service.types.security.DefaultAuthorizable;
import jadex.bridge.service.types.security.IAuthorizable;
import jadex.bridge.service.types.security.ISecurityService;
import jadex.commons.Base64;
import jadex.commons.SUtil;
import jadex.commons.future.DefaultResultListener;
import jadex.commons.future.IResultListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class EmailClientPluginPanel
extends JPanel {
    public EmailClientPluginPanel(final IControlCenter jcc) {
        final JTextArea tain = new JTextArea(20, 20);
        JButton bugen = new JButton("Generate");
        bugen.setToolTipText("Click to generate a signed version of the email.");
        final JTextArea taout = new JTextArea(20, 20);
        taout.setEditable(false);
        JSplitPane sp = new JSplitPane(0);
        sp.setOneTouchExpandable(true);
        JScrollPane usp = new JScrollPane(tain);
        usp.setBorder(new TitledBorder(new EtchedBorder(), "Email Command Text"));
        JScrollPane lsp = new JScrollPane(taout);
        lsp.setBorder(new TitledBorder(new EtchedBorder(), "Generated Command Text"));
        sp.add(usp);
        sp.add(lsp);
        long min = 10L;
        final JTextField tfvd = new JTextField("" + min);
        final JLabel lvd = new JLabel("( = " + min * 60L * 1000L + " ms )");
        tfvd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    long mil = Long.parseLong(tfvd.getText()) * 60L * 1000L;
                    lvd.setText("( = " + mil + " ms )");
                }
                catch (Exception ex) {
                    lvd.setText("( = err ms )");
                }
            }
        });
        tfvd.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    long mil = Long.parseLong(tfvd.getText()) * 60L * 1000L;
                    lvd.setText("( = " + mil + " ms )");
                }
                catch (Exception ex) {
                    lvd.setText("( = err ms )");
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        JPanel so = new JPanel(new GridBagLayout());
        so.add((Component)new JLabel("Validity duration [mins]: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 3, new Insets(2, 2, 2, 2), 0, 0));
        so.add((Component)tfvd, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 13, 1, new Insets(2, 2, 2, 2), 0, 0));
        so.add((Component)lvd, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(2, 2, 2, 2), 0, 0));
        so.add((Component)bugen, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 3, new Insets(2, 2, 2, 2), 0, 0));
        this.setLayout(new BorderLayout());
        this.add((Component)sp, "Center");
        this.add((Component)so, "South");
        bugen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final String intxt = tain.getText();
                final String modintxt = intxt.replaceAll("\\r|\\n", "");
                long mil = 600000L;
                try {
                    mil = Long.parseLong(tfvd.getText()) * 60L * 1000L;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                final long vd = mil;
                SServiceProvider.getService((IExternalAccess)jcc.getPlatformAccess(), ISecurityService.class, (String)"platform").addResultListener((IResultListener)new DefaultResultListener<ISecurityService>(){

                    public void resultAvailable(ISecurityService sser) {
                        final DefaultAuthorizable da = new DefaultAuthorizable();
                        da.setDigestContent(modintxt);
                        da.setValidityDuration(vd);
                        sser.preprocessRequest((IAuthorizable)da, null).addResultListener((IResultListener)new DefaultResultListener<Void>(){

                            public void resultAvailable(Void result) {
                                final StringBuffer buf = new StringBuffer();
                                buf.append(intxt).append(SUtil.LF);
                                buf.append("#").append(da.getTimestamp()).append("#").append(SUtil.LF);
                                buf.append("#").append(da.getValidityDuration()).append("#").append(SUtil.LF);
                                List dgs = da.getAuthenticationData();
                                for (byte[] dg : dgs) {
                                    String txt = new String(Base64.encode((byte[])dg));
                                    buf.append("#");
                                    buf.append(txt).append("#").append(SUtil.LF);
                                }
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        taout.setText(buf.toString());
                                    }
                                });
                            }
                        });
                    }
                });
            }
        });
    }

    public void dispose() {
    }
}

