/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.filetransfer;

import jadex.base.JarAsDirectory;
import jadex.base.gui.asynctree.ISwingNodeHandler;
import jadex.base.gui.asynctree.ISwingTreeNode;
import jadex.base.gui.asynctree.ITreeNode;
import jadex.base.gui.filetree.FileNode;
import jadex.base.gui.filetree.RemoteFileNode;
import jadex.base.gui.plugin.IControlCenter;
import jadex.bridge.service.types.filetransfer.IFileTransferService;
import jadex.commons.IPropertiesProvider;
import jadex.commons.Properties;
import jadex.commons.Property;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.commons.gui.future.SwingDefaultResultListener;
import jadex.commons.gui.future.SwingDelegationResultListener;
import jadex.tools.filetransfer.FileTransferServiceSelectorPanel;
import jadex.tools.filetransfer.FileTransferServiceViewerPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.tree.TreePath;

public class FileTransferPanel
extends JPanel
implements IPropertiesProvider {
    protected IControlCenter jcc;
    protected JSplitPane splitpanel;
    protected FileTransferServiceSelectorPanel p1;
    protected FileTransferServiceSelectorPanel p2;

    public FileTransferPanel(IControlCenter jcc) {
        this.jcc = jcc;
        this.splitpanel = new JSplitPane(1);
        this.setLayout(new BorderLayout());
        this.add((Component)this.splitpanel, "Center");
        DeployerNodeHandler nh1 = new DeployerNodeHandler();
        DeployerNodeHandler nh2 = new DeployerNodeHandler();
        this.p1 = new FileTransferServiceSelectorPanel(jcc, jcc.getJCCAccess(), nh1, "Local Platform");
        this.p2 = new FileTransferServiceSelectorPanel(jcc, jcc.getPlatformAccess(), nh2, "Remote Platform");
        nh1.setFirstPanel(this.p1);
        nh1.setSecondPanel(this.p2);
        nh2.setFirstPanel(this.p2);
        nh2.setSecondPanel(this.p1);
        this.p1.setMinimumSize(new Dimension(1, 1));
        this.p2.setMinimumSize(new Dimension(1, 1));
        this.splitpanel.add((Component)((Object)this.p1));
        this.splitpanel.add((Component)((Object)this.p2));
        this.splitpanel.setOneTouchExpandable(true);
        this.p1.refreshCombo();
        this.p2.refreshCombo();
    }

    public IFuture<Properties> getProperties() {
        final Future ret = new Future();
        final Properties props = new Properties();
        props.addProperty(new Property("split_location", "" + this.splitpanel.getDividerLocation()));
        FileTransferServiceViewerPanel dsvp1 = (FileTransferServiceViewerPanel)this.p1.getCurrentPanel();
        FileTransferServiceViewerPanel dsvp2 = (FileTransferServiceViewerPanel)this.p2.getCurrentPanel();
        IFuture<Properties> p1props = dsvp1 != null && !dsvp1.getFileTreePanel().isRemote() ? this.p1.getProperties() : new IFuture<Properties>((Object)null);
        final IFuture<Properties> p2props = dsvp2 != null && !dsvp2.getFileTreePanel().isRemote() ? this.p2.getProperties() : new IFuture<Properties>((Object)null);
        p1props.addResultListener((IResultListener)new SwingDelegationResultListener<Properties>(ret){

            public void customResultAvailable(Properties result) {
                if (result != null) {
                    props.addSubproperties("first", result);
                }
                p2props.addResultListener((IResultListener)new SwingDelegationResultListener<Properties>(ret){

                    public void customResultAvailable(Properties result) {
                        if (result != null) {
                            props.addSubproperties("second", result);
                        }
                        ret.setResult((Object)props);
                    }
                });
            }
        });
        return ret;
    }

    public IFuture<Void> setProperties(Properties props) {
        Properties secondprops;
        Properties firstprops = props.getSubproperty("first");
        if (firstprops != null) {
            this.p1.setProperties(firstprops);
        }
        if ((secondprops = props.getSubproperty("second")) != null) {
            this.p2.setProperties(secondprops);
        }
        this.splitpanel.setDividerLocation(props.getIntProperty("split_location"));
        return IFuture.DONE;
    }

    class DeployerNodeHandler
    implements ISwingNodeHandler {
        protected FileTransferServiceSelectorPanel first;
        protected FileTransferServiceSelectorPanel second;
        AbstractAction copy = new AbstractAction("Copy file"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DeployerNodeHandler.this.first != null && DeployerNodeHandler.this.second != null) {
                    FileTransferServiceViewerPanel.copy((FileTransferServiceViewerPanel)DeployerNodeHandler.this.first.getCurrentPanel(), (FileTransferServiceViewerPanel)DeployerNodeHandler.this.second.getCurrentPanel(), DeployerNodeHandler.this.second.getSelectedTreePath(), FileTransferPanel.this.jcc);
                }
            }

            @Override
            public boolean isEnabled() {
                return DeployerNodeHandler.this.first != null && DeployerNodeHandler.this.second != null && DeployerNodeHandler.this.first.getSelectedPath() != null && DeployerNodeHandler.this.second.getSelectedPath() != null;
            }
        };
        AbstractAction del = new AbstractAction("Delete file"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DeployerNodeHandler.this.first != null) {
                    final TreePath tp = DeployerNodeHandler.this.first.getSelectedTreePath();
                    final String sel = DeployerNodeHandler.this.first.getSelectedPath();
                    if (sel != null) {
                        IFileTransferService ds = DeployerNodeHandler.this.first.getDeploymentService();
                        ds.deleteFile(sel).addResultListener((IResultListener)new SwingDefaultResultListener<Void>(){

                            public void customResultAvailable(Void result) {
                                DeployerNodeHandler.this.first.refreshTreePaths(new TreePath[]{tp.getParentPath()});
                                FileTransferPanel.this.jcc.setStatusText("Deleted: " + sel);
                            }

                            public void customExceptionOccurred(Exception exception) {
                                FileTransferPanel.this.jcc.setStatusText("Could not delete: " + sel);
                            }
                        });
                    }
                }
            }

            @Override
            public boolean isEnabled() {
                boolean ret = false;
                if (DeployerNodeHandler.this.first != null && DeployerNodeHandler.this.first.getSelectedTreePath() != null) {
                    Object node = DeployerNodeHandler.this.first.getSelectedTreePath().getLastPathComponent();
                    if (node instanceof FileNode) {
                        File file = ((FileNode)node).getFile();
                        ret = !file.isDirectory() || file instanceof JarAsDirectory && ((JarAsDirectory)file).isRoot();
                    } else if (node instanceof RemoteFileNode) {
                        ret = !((RemoteFileNode)node).getRemoteFile().isDirectory();
                    }
                }
                return ret;
            }
        };
        AbstractAction rename = new AbstractAction("Rename file"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DeployerNodeHandler.this.first != null) {
                    final TreePath tp = DeployerNodeHandler.this.first.getSelectedTreePath();
                    final String sel = DeployerNodeHandler.this.first.getSelectedPath();
                    if (sel != null) {
                        String name = JOptionPane.showInputDialog("New name: ");
                        if (name == null || name.length() == 0) {
                            FileTransferPanel.this.jcc.setStatusText("Cannot rename to empty name.");
                        } else {
                            IFileTransferService ds = DeployerNodeHandler.this.first.getDeploymentService();
                            ds.renameFile(sel, name).addResultListener((IResultListener)new SwingDefaultResultListener<String>(){

                                public void customResultAvailable(String result) {
                                    DeployerNodeHandler.this.first.refreshTreePaths(new TreePath[]{tp.getParentPath()});
                                    FileTransferPanel.this.jcc.setStatusText("Renamed: " + sel);
                                }

                                public void customExceptionOccurred(Exception exception) {
                                    FileTransferPanel.this.jcc.setStatusText("Could not rename: " + sel + " reason: " + exception.getMessage());
                                }
                            });
                        }
                    }
                }
            }

            @Override
            public boolean isEnabled() {
                return DeployerNodeHandler.this.first != null && DeployerNodeHandler.this.first.getSelectedTreePath() != null;
            }
        };
        AbstractAction open = new AbstractAction("Open file"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DeployerNodeHandler.this.first != null) {
                    final TreePath tp = DeployerNodeHandler.this.first.getSelectedTreePath();
                    final String sel = DeployerNodeHandler.this.first.getSelectedPath();
                    if (sel != null) {
                        IFileTransferService ds = DeployerNodeHandler.this.first.getDeploymentService();
                        ds.openFile(sel).addResultListener((IResultListener)new SwingDefaultResultListener<Void>(){

                            public void customResultAvailable(Void result) {
                                DeployerNodeHandler.this.first.refreshTreePaths(new TreePath[]{tp.getParentPath()});
                                FileTransferPanel.this.jcc.setStatusText("Opened: " + sel);
                            }

                            public void customExceptionOccurred(Exception exception) {
                                FileTransferPanel.this.jcc.setStatusText("Could not open: " + sel + " reason: " + exception.getMessage());
                            }
                        });
                    }
                }
            }

            @Override
            public boolean isEnabled() {
                return DeployerNodeHandler.this.first != null && DeployerNodeHandler.this.first.getSelectedTreePath() != null;
            }
        };

        DeployerNodeHandler() {
        }

        public Icon getSwingOverlay(ISwingTreeNode node) {
            return null;
        }

        public byte[] getOverlay(ITreeNode node) {
            return null;
        }

        public Action[] getPopupActions(ISwingTreeNode[] nodes) {
            return new Action[]{this.copy, this.del, this.rename, this.open};
        }

        public Action getDefaultAction(ISwingTreeNode node) {
            return null;
        }

        public void setFirstPanel(FileTransferServiceSelectorPanel first) {
            this.first = first;
        }

        public void setSecondPanel(FileTransferServiceSelectorPanel second) {
            this.second = second;
        }
    }
}

