/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.filetransfer;

import jadex.base.DefaultFileFilter;
import jadex.base.SRemoteGui;
import jadex.base.gui.asynctree.ISwingNodeHandler;
import jadex.base.gui.asynctree.ITreeNode;
import jadex.base.gui.componentviewer.IAbstractViewerPanel;
import jadex.base.gui.filetree.DefaultFileFilterMenuItemConstructor;
import jadex.base.gui.filetree.DefaultNodeFactory;
import jadex.base.gui.filetree.DefaultNodeHandler;
import jadex.base.gui.filetree.FileTreePanel;
import jadex.base.gui.filetree.IFileNode;
import jadex.base.gui.filetree.INodeFactory;
import jadex.base.gui.plugin.IControlCenter;
import jadex.bridge.IExternalAccess;
import jadex.bridge.service.types.filetransfer.IFileTransferService;
import jadex.commons.IAsyncFilter;
import jadex.commons.Properties;
import jadex.commons.SUtil;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.commons.gui.IMenuItemConstructor;
import jadex.commons.gui.PopupBuilder;
import jadex.commons.gui.future.SwingIntermediateDefaultResultListener;
import jadex.tools.filetransfer.RefreshAllAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.InputEvent;
import java.io.File;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.TreePath;

public class FileTransferServiceViewerPanel
implements IAbstractViewerPanel {
    protected JPanel panel;
    protected FileTreePanel ftp;
    protected IFileTransferService service;
    protected IControlCenter jcc;

    public FileTransferServiceViewerPanel(IExternalAccess exta, IControlCenter jcc, boolean remote, IFileTransferService service, ISwingNodeHandler nodehandler, String title) {
        this.jcc = jcc;
        this.service = service;
        this.ftp = new FileTreePanel(exta, remote, true);
        RefreshAllAction ra = new RefreshAllAction(this.ftp, service);
        final DefaultFileFilterMenuItemConstructor mic = new DefaultFileFilterMenuItemConstructor(this.ftp.getModel(), true);
        this.ftp.setPopupBuilder(new PopupBuilder(new Object[]{ra, mic}));
        this.ftp.setMenuItemConstructor((IMenuItemConstructor)mic);
        this.ftp.setNodeFactory((INodeFactory)new DefaultNodeFactory(){

            public IAsyncFilter getFileFilter() {
                return new DefaultFileFilter(mic.isAll(), mic.getSelectedComponentTypes());
            }
        });
        this.ftp.addNodeHandler((ISwingNodeHandler)new DefaultNodeHandler(this.ftp.getTree()));
        if (nodehandler != null) {
            this.ftp.addNodeHandler(nodehandler);
        }
        this.ftp.getTree().getSelectionModel().setSelectionMode(1);
        this.ftp.getTree().setDragEnabled(true);
        this.ftp.getTree().setDropMode(DropMode.ON);
        this.ftp.getTree().setTransferHandler(new TreeTransferHandler());
        ra.actionPerformed(null);
        this.panel = new JPanel(new BorderLayout());
        this.panel.add((Component)this.ftp, "Center");
        this.panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), title + " (" + exta.getComponentIdentifier().getPlatformName() + ")"));
    }

    public IFuture<Void> setProperties(Properties props) {
        return this.ftp.setProperties(props);
    }

    public IFuture<Properties> getProperties() {
        return this.ftp.getProperties();
    }

    public IFuture<Void> shutdown() {
        return IFuture.DONE;
    }

    public String getId() {
        return "" + this.ftp.hashCode();
    }

    public JComponent getComponent() {
        return this.panel;
    }

    public String getSelectedPath() {
        String[] sels = this.ftp.getSelectionPaths();
        return sels.length > 0 ? sels[0] : null;
    }

    public IFileTransferService getDeploymentService() {
        return this.service;
    }

    public FileTreePanel getFileTreePanel() {
        return this.ftp;
    }

    public static void copy(FileTransferServiceViewerPanel pan1, FileTransferServiceViewerPanel pan2, TreePath sp2, IControlCenter jcc) {
        String sel1 = pan1.getSelectedPath();
        IExternalAccess exta1 = pan1.getFileTreePanel().getExternalAccess();
        FileTransferServiceViewerPanel.copy(sel1, exta1, pan2, sp2, jcc);
    }

    public static void copy(final String sel1, IExternalAccess exta1, FileTransferServiceViewerPanel pan2, final TreePath sp2, final IControlCenter jcc) {
        IFileNode fn = (IFileNode)sp2.getLastPathComponent();
        final String sel2 = fn.getFilePath();
        IFileTransferService ds = pan2.getDeploymentService();
        if (sel1 != null && sel2 != null) {
            SRemoteGui.copy((String)sel1, (IExternalAccess)exta1, (String)sel2, (IFileTransferService)ds).addResultListener((IResultListener)new SwingIntermediateDefaultResultListener<String>((Component)pan2.getComponent()){

                public void customIntermediateResultAvailable(String result) {
                    jcc.setStatusText(result);
                }

                public void customFinished() {
                    jcc.setStatusText("Copied: " + sel1 + " to " + sel2);
                    ((ITreeNode)sp2.getLastPathComponent()).refresh(true);
                }

                public void customExceptionOccurred(Exception exception) {
                    jcc.setStatusText("Copy error: " + sel1 + " to: " + sel2 + " exception: " + exception.getMessage());
                    ((ITreeNode)sp2.getLastPathComponent()).refresh(true);
                }
            });
        }
    }

    public static boolean isRealDirectory(IFileNode fn) {
        String name = fn.getFileName().toLowerCase();
        return !name.endsWith(".zip") && !name.endsWith(".jar") && fn.isDirectory();
    }

    class TreeTransferHandler
    extends TransferHandler {
        protected DataFlavor flavor;
        protected DataFlavor[] flavors = new DataFlavor[2];

        public TreeTransferHandler() {
            try {
                String mimeType = "application/x-java-jvm-local-objectref;class=\"" + TransferInfo.class.getName() + "\"";
                this.flavors[0] = this.flavor = new DataFlavor(mimeType);
                this.flavors[1] = DataFlavor.javaFileListFlavor;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            boolean ret = false;
            if (support.isDrop()) {
                support.setShowDropLocation(true);
                if (support.isDataFlavorSupported(this.flavor)) {
                    try {
                        TransferInfo ti = (TransferInfo)support.getTransferable().getTransferData(this.flavor);
                        JTree.DropLocation dl = (JTree.DropLocation)support.getDropLocation();
                        IFileNode fn = (IFileNode)dl.getPath().getLastPathComponent();
                        ret = !support.getComponent().equals(ti.getSource().getFileTreePanel().getTree()) && FileTransferServiceViewerPanel.isRealDirectory(fn);
                    }
                    catch (Exception ti) {}
                } else if (support.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    JTree.DropLocation dl = (JTree.DropLocation)support.getDropLocation();
                    IFileNode fn = (IFileNode)dl.getPath().getLastPathComponent();
                    ret = FileTransferServiceViewerPanel.isRealDirectory(fn);
                }
            }
            return ret;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            Object o;
            NodesTransferable ret = null;
            JTree tree = (JTree)c;
            TreePath path = tree.getSelectionPath();
            Object object = o = path != null ? path.getLastPathComponent() : null;
            if (o instanceof IFileNode && (((ITreeNode)o).isLeaf() || !FileTransferServiceViewerPanel.isRealDirectory((IFileNode)o))) {
                ret = new NodesTransferable(new TransferInfo(FileTransferServiceViewerPanel.this));
            }
            return ret;
        }

        @Override
        protected void exportDone(JComponent source, Transferable data, int action) {
            if (data != null) {
                if (data.isDataFlavorSupported(this.flavor)) {
                    try {
                        TransferInfo ti = (TransferInfo)data.getTransferData(this.flavor);
                        FileTransferServiceViewerPanel second = ti.getTarget();
                        FileTransferServiceViewerPanel.copy(FileTransferServiceViewerPanel.this, second, ti.getSelection(), FileTransferServiceViewerPanel.this.jcc);
                    }
                    catch (Exception exception) {}
                } else if (data.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    System.out.println("jlf");
                }
            }
        }

        @Override
        public void exportAsDrag(JComponent comp, InputEvent e, int action) {
            super.exportAsDrag(comp, e, action);
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            boolean ret = false;
            if (this.canImport(support)) {
                try {
                    Transferable t = support.getTransferable();
                    if (t.isDataFlavorSupported(this.flavor)) {
                        Object to = t.getTransferData(this.flavor);
                        if (to instanceof TransferInfo) {
                            TransferInfo ti = (TransferInfo)to;
                            JTree.DropLocation dl = (JTree.DropLocation)support.getDropLocation();
                            TreePath dest = dl.getPath();
                            Object n = dest.getLastPathComponent();
                            if (n instanceof IFileNode && ((IFileNode)n).isDirectory()) {
                                ti.setSelection(dest);
                                ti.setTarget(FileTransferServiceViewerPanel.this);
                            }
                        }
                    } else if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                        List files = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                        JTree.DropLocation dl = (JTree.DropLocation)support.getDropLocation();
                        TreePath dest = dl.getPath();
                        Object n = dest.getLastPathComponent();
                        if (n instanceof IFileNode && ((IFileNode)n).isDirectory()) {
                            for (File file : files) {
                                if (!file.exists()) continue;
                                String sel1 = file.getAbsolutePath();
                                FileTransferServiceViewerPanel.copy(sel1, FileTransferServiceViewerPanel.this.jcc.getJCCAccess(), FileTransferServiceViewerPanel.this, dest, FileTransferServiceViewerPanel.this.jcc);
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return ret;
        }

        public String toString() {
            return this.getClass().getName();
        }

        public class TransferInfo {
            protected FileTransferServiceViewerPanel source;
            protected FileTransferServiceViewerPanel target;
            protected TreePath selection;

            public TransferInfo(FileTransferServiceViewerPanel source) {
                this.source = source;
            }

            public FileTransferServiceViewerPanel getSource() {
                return this.source;
            }

            public void setSource(FileTransferServiceViewerPanel source) {
                this.source = source;
            }

            public FileTransferServiceViewerPanel getTarget() {
                return this.target;
            }

            public void setTarget(FileTransferServiceViewerPanel target) {
                this.target = target;
            }

            public TreePath getSelection() {
                return this.selection;
            }

            public void setSelection(TreePath selection) {
                this.selection = selection;
            }
        }

        public class NodesTransferable
        implements Transferable {
            protected TransferInfo content;

            public NodesTransferable(TransferInfo content) {
                this.content = content;
            }

            @Override
            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
                if (!this.isDataFlavorSupported(flavor)) {
                    throw new UnsupportedFlavorException(flavor);
                }
                if (flavor.equals(TreeTransferHandler.this.flavor)) {
                    return this.content;
                }
                if (flavor.equals(DataFlavor.javaFileListFlavor)) {
                    System.out.println("getTransferData: " + flavor);
                    return Collections.EMPTY_LIST;
                }
                return this.content;
            }

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return TreeTransferHandler.this.flavors;
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return SUtil.arrayToSet((Object)TreeTransferHandler.this.flavors).contains(flavor);
            }
        }
    }
}

