/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.filetransfer;

import jadex.base.gui.asynctree.ITreeNode;
import jadex.base.gui.filetree.FileNode;
import jadex.base.gui.filetree.FileTreePanel;
import jadex.base.gui.filetree.RemoteFileNode;
import jadex.base.gui.filetree.RootNode;
import jadex.bridge.service.types.filetransfer.FileData;
import jadex.bridge.service.types.filetransfer.IFileTransferService;
import jadex.commons.future.Future;
import jadex.commons.future.IResultListener;
import jadex.commons.gui.SGUI;
import jadex.commons.gui.future.SwingDefaultResultListener;
import jadex.commons.gui.future.SwingDelegationResultListener;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.UIDefaults;

public class RefreshAllAction
extends AbstractAction {
    protected static final UIDefaults icons = new UIDefaults(new Object[]{"overlay_refresh", SGUI.makeIcon(FileTreePanel.class, (String)"/jadex/base/gui/images/overlay_refresh.png")});
    protected FileTreePanel ftp;
    protected IFileTransferService service;

    public RefreshAllAction(FileTreePanel ftp, IFileTransferService service) {
        super("Refresh all", icons.getIcon("overlay_refresh"));
        this.ftp = ftp;
        this.service = service;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Future entries = new Future();
        if (!this.ftp.isRemote()) {
            entries.setResult((Object)File.listRoots());
        } else {
            this.service.getRoots().addResultListener((IResultListener)new SwingDelegationResultListener(entries));
        }
        entries.addResultListener((IResultListener)new SwingDefaultResultListener((Component)this.ftp){

            public void customResultAvailable(Object result) {
                Object[] entries = (Object[])result;
                RootNode root = (RootNode)RefreshAllAction.this.ftp.getTree().getModel().getRoot();
                ArrayList<Object> newchildren = new ArrayList<Object>();
                for (int i = 0; i < entries.length; ++i) {
                    for (int j = 0; newchildren.size() == i && j < root.getCachedChildren().size(); ++j) {
                        ITreeNode node = (ITreeNode)root.getCachedChildren().get(j);
                        if ((!(node instanceof FileNode) || !node.getId().equals(entries[i])) && (!(node instanceof RemoteFileNode) || !node.getId().equals(entries[i].toString()))) continue;
                        newchildren.add(node);
                    }
                    if (newchildren.size() != i) continue;
                    if (entries[i] instanceof File) {
                        RefreshAllAction.this.ftp.addTopLevelNode((File)entries[i]);
                    } else {
                        RefreshAllAction.this.ftp.addTopLevelNode((FileData)entries[i]);
                    }
                    newchildren.add(root.getCachedChildren().get(root.getCachedChildren().size() - 1));
                }
                root.setChildren(newchildren);
                root.refresh(true);
            }
        });
    }

    public static String getName() {
        return "Refresh all";
    }
}

