/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.generic;

import jadex.base.gui.componentviewer.IAbstractViewerPanel;
import jadex.commons.IPropertiesProvider;
import jadex.commons.Properties;
import jadex.commons.future.DelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.commons.gui.JSplitPanel;
import jadex.commons.gui.ObjectCardLayout;
import jadex.commons.gui.SGUI;
import jadex.commons.gui.future.SwingDefaultResultListener;
import jadex.commons.gui.future.SwingDelegationResultListener;
import jadex.commons.gui.future.SwingResultListener;
import jadex.tools.generic.AbstractGenericPlugin;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.UIDefaults;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

public abstract class AbstractSelectorPanel<E>
extends JSplitPanel
implements IPropertiesProvider {
    protected static final UIDefaults icons = new UIDefaults(new Object[]{"viewer_empty", SGUI.makeIcon(AbstractGenericPlugin.class, (String)"/jadex/tools/common/images/viewer_empty.png")});
    public static final String PANELPROPERTIES = "panelproperties";
    protected JComboBox selcb;
    protected JCheckBox remotecb;
    protected JPanel centerp;
    protected ObjectCardLayout ocl;
    protected Map<E, IAbstractViewerPanel> panels;
    protected Properties props;

    public AbstractSelectorPanel() {
        this.setOrientation(0);
        this.setOneTouchExpandable(true);
        this.setDividerLocation(0);
        this.setDividerLocation(0.0);
        this.panels = new HashMap<E, IAbstractViewerPanel>();
        this.ocl = new ObjectCardLayout();
        this.centerp = new JPanel((LayoutManager)this.ocl);
        JLabel emptylabel = new JLabel("Select instance that should be viewed", icons.getIcon("viewer_empty"), 0);
        emptylabel.setVerticalAlignment(0);
        emptylabel.setHorizontalTextPosition(0);
        emptylabel.setVerticalTextPosition(3);
        emptylabel.setFont(emptylabel.getFont().deriveFont((float)emptylabel.getFont().getSize() * 1.3f));
        this.centerp.add("jtc_ocl_default_component", emptylabel);
        this.selcb = new JComboBox();
        this.selcb.setRenderer(new BasicComboBoxRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String val = value != null ? AbstractSelectorPanel.this.convertToString(value) : null;
                return super.getListCellRendererComponent((JList<?>)list, val, index, isSelected, cellHasFocus);
            }
        });
        this.remotecb = new JCheckBox("Remote");
        JPanel northp = new JPanel(new GridBagLayout());
        northp.setBorder(new TitledBorder(new EtchedBorder(1), "Instance Settings "));
        JButton closeb = new JButton("Close");
        JButton refreshb = new JButton("Refresh");
        closeb.setMaximumSize(refreshb.getMaximumSize());
        closeb.setPreferredSize(refreshb.getPreferredSize());
        closeb.setMinimumSize(refreshb.getMinimumSize());
        int x = 0;
        JLabel instl = new JLabel("Instance");
        instl.setToolTipText("Use the combo box to select the instance to be presented below.");
        this.selcb.setToolTipText("Use the combo box to select the instance to be presented below.");
        refreshb.setToolTipText("Refresh the list of available instances.");
        closeb.setToolTipText("Close the currently selected instance.");
        northp.add((Component)instl, new GridBagConstraints(x++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0));
        northp.add((Component)this.selcb, new GridBagConstraints(x++, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 2, 0, 2), 0, 0));
        northp.add((Component)this.remotecb, new GridBagConstraints(x++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0));
        northp.add((Component)refreshb, new GridBagConstraints(x++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0));
        northp.add((Component)closeb, new GridBagConstraints(x++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0));
        refreshb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractSelectorPanel.this.refreshCombo();
            }
        });
        closeb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object sel;
                Object v0 = sel = AbstractSelectorPanel.this.selcb.getSelectedIndex() != -1 ? AbstractSelectorPanel.this.selcb.getModel().getElementAt(AbstractSelectorPanel.this.selcb.getSelectedIndex()) : null;
                if (sel != null) {
                    AbstractSelectorPanel.this.removePanel(sel);
                }
            }
        });
        this.selcb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String sel;
                String string = sel = AbstractSelectorPanel.this.selcb.getSelectedIndex() != -1 ? (String)AbstractSelectorPanel.this.selcb.getModel().getElementAt(AbstractSelectorPanel.this.selcb.getSelectedIndex()) : null;
                if (sel == null || AbstractSelectorPanel.this.ocl.isAvailable(sel)) {
                    AbstractSelectorPanel.this.ocl.show((Object)(sel != null ? sel : "jtc_ocl_default_component"));
                } else {
                    AbstractSelectorPanel.this.createPanel(sel).addResultListener((IResultListener)new SwingResultListener((IResultListener)new IResultListener<IAbstractViewerPanel>(){

                        public void resultAvailable(final IAbstractViewerPanel panel) {
                            IFuture propsdone = AbstractSelectorPanel.this.props != null && AbstractSelectorPanel.this.props.getSubproperty(AbstractSelectorPanel.PANELPROPERTIES) != null ? panel.setProperties(AbstractSelectorPanel.this.props.getSubproperty(AbstractSelectorPanel.PANELPROPERTIES)) : IFuture.DONE;
                            propsdone.addResultListener((IResultListener)new SwingDefaultResultListener<Void>(){

                                public void customResultAvailable(Void result) {
                                    AbstractSelectorPanel.this.panels.put(sel, panel);
                                    AbstractSelectorPanel.this.centerp.add((Component)panel.getComponent(), sel);
                                    AbstractSelectorPanel.this.ocl.show(sel);
                                }
                            });
                        }

                        public void exceptionOccurred(Exception exception) {
                            System.err.println("Error: " + this);
                            Thread.dumpStack();
                            exception.printStackTrace();
                        }
                    }));
                }
            }
        });
        this.setTopComponent(northp);
        this.setBottomComponent(this.centerp);
    }

    public void removePanel(Object key) {
        IAbstractViewerPanel panel = this.panels.remove(key);
        if (panel != null) {
            this.centerp.remove(panel.getComponent());
            panel.shutdown();
            boolean found = false;
            for (int i = 0; !found && i < this.selcb.getModel().getSize(); ++i) {
                if (!this.selcb.getModel().getElementAt(i).equals(this.ocl.getCurrentKey())) continue;
                found = true;
                this.selcb.setSelectedItem(this.ocl.getCurrentKey());
            }
        }
    }

    public abstract void refreshCombo();

    public abstract IFuture<IAbstractViewerPanel> createPanel(E var1);

    public abstract String convertToString(E var1);

    public JComboBox getSelectionComboBox() {
        return this.selcb;
    }

    public JPanel getCenterPanel() {
        return this.centerp;
    }

    public boolean isRemote() {
        return this.remotecb.isSelected();
    }

    public IAbstractViewerPanel getCurrentPanel() {
        IAbstractViewerPanel ret = null;
        Object key = this.ocl.getCurrentKey();
        if (key != null) {
            ret = this.panels.get(key);
        }
        return ret;
    }

    public IFuture<Void> setProperties(Properties props) {
        Future ret = new Future();
        this.props = props;
        if (this.selcb.getSelectedItem() != null && this.panels.containsKey(this.selcb.getSelectedItem())) {
            IAbstractViewerPanel panel = this.panels.get(this.selcb.getSelectedItem());
            panel.setProperties(props.getSubproperty(PANELPROPERTIES)).addResultListener((IResultListener)new DelegationResultListener(ret));
        } else {
            ret.setResult(null);
        }
        return ret;
    }

    public IFuture<Properties> getProperties() {
        final Future ret = new Future();
        final Properties props = new Properties(null, this.getName(), null);
        if (this.selcb.getSelectedItem() != null && this.panels.containsKey(this.selcb.getSelectedItem())) {
            IAbstractViewerPanel panel = this.panels.get(this.selcb.getSelectedItem());
            panel.getProperties().addResultListener((IResultListener)new SwingDelegationResultListener<Properties>(ret){

                public void customResultAvailable(Properties subprops) {
                    props.addSubproperties(AbstractSelectorPanel.PANELPROPERTIES, subprops != null ? subprops : new Properties());
                    ret.setResult((Object)props);
                }
            });
        } else {
            ret.setResult(null);
        }
        return ret;
    }

    public void shutdown() {
        Iterator<IAbstractViewerPanel> it = this.panels.values().iterator();
        while (it.hasNext()) {
            it.next().shutdown();
        }
    }
}

