/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.generic;

import jadex.bridge.IExternalAccess;
import jadex.bridge.service.IService;
import jadex.bridge.service.search.SServiceProvider;
import jadex.commons.future.IIntermediateResultListener;
import jadex.commons.future.IResultListener;
import jadex.commons.gui.future.SwingIntermediateResultListener;
import jadex.tools.generic.AbstractSelectorPanel;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JComboBox;

public abstract class AbstractServiceSelectorPanel
extends AbstractSelectorPanel<IService> {
    protected IExternalAccess platform;
    protected Class<?> servicetype;

    public AbstractServiceSelectorPanel(IExternalAccess platform, Class<?> servicetype) {
        this.platform = platform;
        this.servicetype = servicetype;
    }

    @Override
    public void refreshCombo() {
        Class<?> type = this.servicetype;
        String scope = this.isRemote() ? "global" : "platform";
        SServiceProvider.getServices((IExternalAccess)this.platform, type, (String)scope).addResultListener((IResultListener)new SwingIntermediateResultListener((IIntermediateResultListener)new IIntermediateResultListener<IService>(){
            boolean first = true;

            public void intermediateResultAvailable(IService result) {
                this.reset();
                AbstractServiceSelectorPanel.this.selcb.addItem(result);
            }

            public void finished() {
                this.reset();
            }

            public void resultAvailable(Collection<IService> result) {
                this.reset();
                Iterator<IService> it = result.iterator();
                while (it.hasNext()) {
                    AbstractServiceSelectorPanel.this.selcb.addItem(it.next());
                }
            }

            public void exceptionOccurred(Exception exception) {
            }

            protected void reset() {
                if (this.first) {
                    this.first = false;
                    JComboBox selcb = AbstractServiceSelectorPanel.this.getSelectionComboBox();
                    for (int i = 0; i < selcb.getItemCount(); ++i) {
                        Object oldservice = selcb.getItemAt(i);
                        AbstractServiceSelectorPanel.this.removePanel(oldservice);
                    }
                    selcb.removeAllItems();
                }
            }
        }));
    }

    @Override
    public String convertToString(IService element) {
        return element.getServiceIdentifier().toString();
    }

    public IExternalAccess getPlatformAccess() {
        return this.platform;
    }
}

