/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.generic;

import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.commons.gui.PropertiesPanel;
import jadex.commons.gui.SGUI;
import jadex.commons.gui.future.SwingDefaultResultListener;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIDefaults;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AutoRefreshPanel
extends JSplitPane {
    protected static final UIDefaults icons = new UIDefaults(new Object[]{"refresh_counter_0", SGUI.makeIcon(AutoRefreshPanel.class, (String)"/jadex/tools/common/images/refresh_counter_0_20.png"), "refresh_counter_1", SGUI.makeIcon(AutoRefreshPanel.class, (String)"/jadex/tools/common/images/refresh_counter_1_20.png"), "refresh_counter_2", SGUI.makeIcon(AutoRefreshPanel.class, (String)"/jadex/tools/common/images/refresh_counter_2_20.png"), "refresh_counter_3", SGUI.makeIcon(AutoRefreshPanel.class, (String)"/jadex/tools/common/images/refresh_counter_3_20.png"), "refresh_counter_4", SGUI.makeIcon(AutoRefreshPanel.class, (String)"/jadex/tools/common/images/refresh_counter_4_20.png"), "refresh_counter_5", SGUI.makeIcon(AutoRefreshPanel.class, (String)"/jadex/tools/common/images/refresh_counter_5_20.png"), "refresh_counter_6", SGUI.makeIcon(AutoRefreshPanel.class, (String)"/jadex/tools/common/images/refresh_counter_6_20.png"), "refresh_counter_7", SGUI.makeIcon(AutoRefreshPanel.class, (String)"/jadex/tools/common/images/refresh_counter_7_20.png"), "refresh_auto", SGUI.makeIcon(AutoRefreshPanel.class, (String)"/jadex/tools/common/images/refresh_auto_20.png"), "refresh_0", SGUI.makeIcon(AutoRefreshPanel.class, (String)"/jadex/tools/common/images/refresh.png")});
    protected boolean autorefresh = true;
    protected int delay = 5000;
    protected long waited;
    protected long etime;
    protected JButton refresh;
    protected Timer timer;
    protected boolean refreshing;

    public AutoRefreshPanel() {
        super(0);
        this.setOneTouchExpandable(true);
        this.createInnerPanel().addResultListener((IResultListener)new SwingDefaultResultListener<JComponent>((Component)this){

            public void customResultAvailable(JComponent result) {
                AutoRefreshPanel.this.refresh = new JButton(icons.getIcon("refresh_counter_0"));
                AutoRefreshPanel.this.refresh.setMargin(new Insets(0, 0, 0, 0));
                AutoRefreshPanel.this.refresh.setPreferredSize(AutoRefreshPanel.this.refresh.getPreferredSize());
                AutoRefreshPanel.this.refresh.setMinimumSize(AutoRefreshPanel.this.refresh.getMinimumSize());
                AutoRefreshPanel.this.refresh.setMaximumSize(AutoRefreshPanel.this.refresh.getMaximumSize());
                AutoRefreshPanel.this.refresh.setToolTipText("Refresh the panel.");
                SpinnerNumberModel spmdelay = new SpinnerNumberModel(AutoRefreshPanel.this.delay / 1000, 1, 100, 1);
                final JSpinner spdelay = new JSpinner(spmdelay);
                spdelay.setPreferredSize(spdelay.getPreferredSize());
                spmdelay.setMaximum(null);
                spdelay.setEnabled(AutoRefreshPanel.this.autorefresh);
                final JLabel ldelay = new JLabel("delay (sec.)");
                final JCheckBox cbauto = new JCheckBox("autorefresh");
                cbauto.setSelected(AutoRefreshPanel.this.autorefresh);
                JPanel options = new JPanel(new GridBagLayout());
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.insets = new Insets(3, 3, 3, 3);
                gbc.gridy = 0;
                gbc.anchor = 17;
                gbc.fill = 0;
                options.add((Component)AutoRefreshPanel.this.refresh, gbc);
                options.add((Component)ldelay, gbc);
                options.add((Component)spdelay, gbc);
                gbc.weightx = 1.0;
                options.add((Component)cbauto, gbc);
                AutoRefreshPanel.this.setTopComponent(options);
                AutoRefreshPanel.this.setBottomComponent(result);
                AutoRefreshPanel.this.timer = new Timer(0, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AutoRefreshPanel.this.waited += (System.nanoTime() - AutoRefreshPanel.this.etime) / 1000000L;
                        AutoRefreshPanel.this.etime = System.nanoTime();
                        if (AutoRefreshPanel.this.waited < (long)AutoRefreshPanel.this.delay) {
                            AutoRefreshPanel.this.refresh.setIcon(icons.getIcon("refresh_counter_" + AutoRefreshPanel.this.waited * 8L / (long)AutoRefreshPanel.this.delay));
                        } else {
                            AutoRefreshPanel.this.doRefresh();
                        }
                    }
                });
                AutoRefreshPanel.this.resetTimer();
                AutoRefreshPanel.this.refresh.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AutoRefreshPanel.this.refresh.setEnabled(false);
                        AutoRefreshPanel.this.doRefresh().addResultListener((IResultListener)new SwingDefaultResultListener<Void>((Component)AutoRefreshPanel.this){

                            public void customResultAvailable(Void result) {
                                AutoRefreshPanel.this.refresh.setEnabled(true);
                            }
                        });
                    }
                });
                cbauto.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        AutoRefreshPanel.this.autorefresh = cbauto.isSelected();
                        spdelay.setEnabled(AutoRefreshPanel.this.autorefresh);
                        ldelay.setEnabled(AutoRefreshPanel.this.autorefresh);
                        AutoRefreshPanel.this.resetTimer();
                    }
                });
                spdelay.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        AutoRefreshPanel.this.delay = ((Number)spdelay.getValue()).intValue() * 1000;
                        if (AutoRefreshPanel.this.waited < (long)AutoRefreshPanel.this.delay) {
                            AutoRefreshPanel.this.timer.setDelay(AutoRefreshPanel.this.delay / 8);
                            AutoRefreshPanel.this.refresh.setIcon(icons.getIcon("refresh_counter_" + AutoRefreshPanel.this.waited * 8L / (long)AutoRefreshPanel.this.delay));
                        } else {
                            AutoRefreshPanel.this.doRefresh();
                        }
                    }
                });
                AutoRefreshPanel.this.addComponentListener(new ComponentListener(){

                    @Override
                    public void componentShown(ComponentEvent e) {
                        AutoRefreshPanel.this.resetTimer();
                    }

                    @Override
                    public void componentHidden(ComponentEvent e) {
                        AutoRefreshPanel.this.resetTimer();
                    }

                    @Override
                    public void componentMoved(ComponentEvent e) {
                    }

                    @Override
                    public void componentResized(ComponentEvent e) {
                    }
                });
            }
        });
    }

    protected void resetTimer() {
        if (this.autorefresh && this.isShowing()) {
            if (!this.refreshing && this.delay > 0) {
                this.waited = 0L;
                this.etime = System.nanoTime();
                this.refresh.setIcon(icons.getIcon("refresh_counter_0"));
                this.timer.setDelay(this.delay / 8);
                this.timer.start();
            }
        } else {
            this.timer.stop();
            if (!this.refreshing) {
                this.refresh.setIcon(icons.getIcon("refresh_0"));
            }
        }
    }

    protected IFuture<Void> doRefresh() {
        assert (SwingUtilities.isEventDispatchThread());
        final Future ret = new Future();
        if (!this.refreshing) {
            this.refreshing = true;
            this.timer.stop();
            this.refresh.setIcon(this.autorefresh ? icons.getIcon("refresh_auto") : icons.getIcon("refresh_0"));
            this.refresh().addResultListener((IResultListener)new SwingDefaultResultListener<Void>((Component)this){

                public void customResultAvailable(Void result) {
                    AutoRefreshPanel.this.refreshing = false;
                    AutoRefreshPanel.this.resetTimer();
                    ret.setResult(null);
                }

                public void customExceptionOccurred(Exception exception) {
                    AutoRefreshPanel.this.refreshing = false;
                    ret.setResult(null);
                    super.customExceptionOccurred(exception);
                }
            });
        } else {
            ret.setResult(null);
        }
        return ret;
    }

    public abstract IFuture<JComponent> createInnerPanel();

    public abstract IFuture<Void> refresh();

    public static void main(String[] args) {
        JFrame f = new JFrame("AutoRefreshPanel");
        JTabbedPane tabs = new JTabbedPane();
        f.getContentPane().add((Component)tabs, "Center");
        tabs.addTab("Refresh", new AutoRefreshPanel(){
            PropertiesPanel pp;

            @Override
            public IFuture<JComponent> createInnerPanel() {
                this.pp = new PropertiesPanel("test");
                this.pp.createTextField("date", new Date().toString(), false, 0.0);
                return new Future((Object)this.pp);
            }

            @Override
            public IFuture<Void> refresh() {
                final Future ret = new Future();
                this.pp.getTextField("date").setText(new Date().toString());
                final Timer timer = new Timer(1000, null);
                timer.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        timer.stop();
                        ret.setResult(null);
                    }
                });
                timer.start();
                return ret;
            }
        });
        tabs.add("Other Panel", new JLabel("other"));
        f.pack();
        f.setLocation(SGUI.calculateMiddlePosition((Window)f));
        f.setVisible(true);
    }
}

