/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.jcc;

import jadex.base.SRemoteGui;
import jadex.bridge.IExternalAccess;
import jadex.bridge.service.annotation.Security;
import jadex.commons.ChangeEvent;
import jadex.commons.IRemoteChangeListener;
import jadex.commons.SUtil;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.gui.SGUI;
import jadex.tools.jcc.StyledDocumentOutputStream;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public class ConsolePanel
extends JPanel {
    protected static final UIDefaults icons = new UIDefaults(new Object[]{"clear", SGUI.makeIcon(ConsolePanel.class, (String)"/jadex/tools/common/images/new_console_clear.png"), "on", SGUI.makeIcon(ConsolePanel.class, (String)"/jadex/tools/common/images/new_console_on.png"), "off", SGUI.makeIcon(ConsolePanel.class, (String)"/jadex/tools/common/images/new_console_off.png")});
    protected IExternalAccess platformaccess;
    protected IExternalAccess jccaccess;
    protected StyledDocument doc;
    protected StyledDocumentOutputStream sdout;
    protected StyledDocumentOutputStream sderr;
    protected JButton onoff;
    protected JTextPane console;
    protected JTextField in;
    protected JLabel label;

    public ConsolePanel(IExternalAccess platformaccess, IExternalAccess jccaccess) {
        this(platformaccess, jccaccess, "Console In- and Output");
    }

    public ConsolePanel(final IExternalAccess platformaccess, IExternalAccess jccaccess, String title) {
        this.platformaccess = platformaccess;
        this.jccaccess = jccaccess;
        this.console = new JTextPane();
        this.doc = this.console.getStyledDocument();
        this.label = new JLabel(title);
        this.in = new JTextField();
        this.in.setToolTipText("Use this text field to enter data in System.in");
        Style def = StyleContext.getDefaultStyleContext().getStyle("default");
        Style outstyle = this.doc.addStyle("out", def);
        Style errorstyle = this.doc.addStyle("error", def);
        StyleConstants.setForeground(errorstyle, Color.red);
        this.sdout = new StyledDocumentOutputStream(this.doc, outstyle);
        this.sderr = new StyledDocumentOutputStream(this.doc, errorstyle);
        final ArrayList history = new ArrayList();
        final int[] hpos = new int[1];
        this.in.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String txt = ConsolePanel.this.in.getText() + SUtil.LF;
                history.add(0, txt);
                if (history.size() > 100) {
                    history.remove(history.size() - 1);
                }
                hpos[0] = 0;
                ConsolePanel.this.in.setText("");
                SRemoteGui.redirectInput((IExternalAccess)platformaccess, (String)txt);
            }
        });
        this.in.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (38 == e.getKeyCode()) {
                    int hs = history.size();
                    if (hs > hpos[0]) {
                        ConsolePanel.this.in.setText((String)history.get(hpos[0]));
                        if (hs > hpos[0] + 1) {
                            hpos[0] = hpos[0] + 1;
                        }
                    }
                } else if (40 == e.getKeyCode() && hpos[0] - 1 > -1) {
                    hpos[0] = hpos[0] - 1;
                    ConsolePanel.this.in.setText((String)history.get(hpos[0]));
                }
            }
        });
        JButton clear = new JButton(icons.getIcon("clear"));
        clear.setMargin(new Insets(0, 0, 0, 0));
        clear.setToolTipText("Clear the console output");
        clear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ConsolePanel.this.clear();
            }
        });
        this.onoff = new JButton(icons.getIcon("off"));
        this.onoff.setMargin(new Insets(0, 0, 0, 0));
        this.onoff.setToolTipText("Turn off the console");
        this.onoff.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ConsolePanel.this.setConsoleEnabled(ConsolePanel.this.onoff.getIcon() == icons.getIcon("on"));
            }
        });
        final JScrollPane center = new JScrollPane(this.console);
        this.doc.addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JScrollBar bar = center.getVerticalScrollBar();
                        if (bar != null) {
                            bar.setValue(bar.getMaximum());
                        }
                    }
                });
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
            }
        });
        JPanel north = new JPanel(new GridBagLayout());
        north.add((Component)this.label, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        north.add((Component)this.onoff, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        north.add((Component)clear, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.setLayout(new BorderLayout());
        this.add((Component)center, "Center");
        this.add((Component)north, "North");
        this.add((Component)this.in, "South");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        try {
            StyledDocument styledDocument = this.doc;
            synchronized (styledDocument) {
                this.doc.remove(0, this.doc.getLength());
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void setConsoleEnabled(boolean enable) {
        String id = this.jccaccess.getComponentIdentifier().getPlatformName() + "#console@" + this.hashCode();
        if (!enable) {
            this.in.setEditable(false);
            this.onoff.setIcon(icons.getIcon("on"));
            this.onoff.setToolTipText("Turn on the console");
            if (!this.label.getText().endsWith(" (off)")) {
                this.label.setText(this.label.getText() + " (off)");
            }
            SRemoteGui.removeConsoleListener((IExternalAccess)this.platformaccess, (String)id);
        } else {
            this.in.setEditable(true);
            IRemoteChangeListener rcl = new IRemoteChangeListener(){
                static final String OUT_OCCURRED = "out_occurred";
                static final String ERR_OCCURRED = "err_occurred";

                @Security(value="security_unrestricted")
                public IFuture changeOccurred(ChangeEvent event) {
                    IFuture ret;
                    if (ConsolePanel.this.isConsoleEnabled()) {
                        this.handleEvent(event);
                        ret = IFuture.DONE;
                    } else {
                        ret = new Future((Exception)new RuntimeException("console off"));
                    }
                    return ret;
                }

                public void handleEvent(ChangeEvent event) {
                    if ("bulk_event".equals(event.getType())) {
                        Iterator it = ((Collection)event.getValue()).iterator();
                        while (it.hasNext()) {
                            this.handleEvent((ChangeEvent)it.next());
                        }
                    } else if (OUT_OCCURRED.equals(event.getType())) {
                        ConsolePanel.this.sdout.println(event.getValue());
                    } else if (ERR_OCCURRED.equals(event.getType())) {
                        ConsolePanel.this.sderr.println(event.getValue());
                    }
                }
            };
            SRemoteGui.addConsoleListener((IExternalAccess)this.platformaccess, (String)id, (IRemoteChangeListener)rcl);
            this.onoff.setIcon(icons.getIcon("off"));
            this.onoff.setToolTipText("Turn off the console");
            if (this.label.getText().endsWith(" (off)")) {
                this.label.setText(this.label.getText().substring(0, this.label.getText().length() - 6));
            }
        }
    }

    public boolean isConsoleEnabled() {
        return this.onoff.getIcon() == icons.getIcon("off");
    }

    public void close() {
        if (this.isConsoleEnabled()) {
            this.setConsoleEnabled(false);
        }
        this.sdout.close();
        this.sderr.close();
    }
}

