/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.jcc;

import jadex.base.gui.CMSUpdateHandler;
import jadex.base.gui.PropertyUpdateHandler;
import jadex.base.gui.RememberOptionMessage;
import jadex.base.gui.componenttree.ComponentIconCache;
import jadex.base.gui.plugin.SJCC;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IExternalAccess;
import jadex.commons.Properties;
import jadex.commons.Property;
import jadex.commons.future.CounterResultListener;
import jadex.commons.future.DelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.commons.gui.SGUI;
import jadex.commons.gui.future.SwingDefaultResultListener;
import jadex.commons.gui.future.SwingDelegationResultListener;
import jadex.commons.gui.future.SwingExceptionDelegationResultListener;
import jadex.tools.jcc.ControlCenterWindow;
import jadex.tools.jcc.PlatformControlCenter;
import jadex.xml.PropertiesXMLHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class ControlCenter {
    public static final String SETTINGS_EXTENSION = ".settings.xml";
    public static final String JCC_EXIT_SHUTDOWN = "shutdown";
    public static final String JCC_EXIT_KEEP = "keep";
    public static final String JCC_EXIT_ASK = "ask";
    protected IExternalAccess jccaccess;
    protected String[] plugin_classes;
    protected Map<IComponentIdentifier, PlatformControlCenter> pccs;
    protected PlatformControlCenter pcc;
    protected ControlCenterWindow window;
    protected boolean killed;
    protected String jccexit;
    protected CMSUpdateHandler cmshandler;
    protected PropertyUpdateHandler prophandler;
    protected ComponentIconCache iconcache;
    protected boolean saveonexit;

    public IFuture<Void> init(IExternalAccess jccaccess, IExternalAccess platformaccess, String[] plugin_classes, boolean saveonexit) {
        final Future ret = new Future();
        this.jccaccess = jccaccess;
        this.plugin_classes = plugin_classes;
        this.pccs = new HashMap<IComponentIdentifier, PlatformControlCenter>();
        this.saveonexit = saveonexit;
        this.window = new ControlCenterWindow(this);
        this.pcc = new PlatformControlCenter();
        this.pccs.put(platformaccess.getComponentIdentifier(), this.pcc);
        this.pcc.init(platformaccess, this, plugin_classes).addResultListener((IResultListener)new DelegationResultListener<Void>(ret){

            public void customResultAvailable(Void result) {
                ControlCenter.this.loadSettings().addResultListener((IResultListener)new SwingDelegationResultListener<Void>(ret){

                    public void customResultAvailable(Void result) {
                        ControlCenter.this.window.showPlatformPanel(ControlCenter.this.pcc);
                        ControlCenter.this.window.setVisible(true);
                        ret.setResult(null);
                    }
                });
            }
        });
        return ret;
    }

    public IFuture<Void> loadSettings() {
        return this.loadSettings(new File(this.jccaccess.getComponentIdentifier().getLocalName() + SETTINGS_EXTENSION));
    }

    public IFuture<Void> loadSettings(final File file) {
        final Future ret = new Future();
        this.getPCC().getClassLoader(null).addResultListener((IResultListener)new SwingExceptionDelegationResultListener<ClassLoader, Void>(ret){

            public void customResultAvailable(ClassLoader cl) {
                Properties props;
                try {
                    FileInputStream fis = new FileInputStream(file);
                    props = (Properties)PropertiesXMLHelper.read((InputStream)fis, (ClassLoader)cl);
                    fis.close();
                    Properties windowprops = props.getSubproperty("window");
                    if (windowprops != null) {
                        int w = windowprops.getIntProperty("width");
                        int h = windowprops.getIntProperty("height");
                        int x = windowprops.getIntProperty("x");
                        int y = windowprops.getIntProperty("y");
                        ControlCenter.this.window.setBounds(x, y, w, h);
                        ControlCenter.this.window.setVisible(true);
                        int es = windowprops.getIntProperty("extendedState");
                        ControlCenter.this.window.setExtendedState(es);
                        ControlCenter.this.jccexit = windowprops.getStringProperty("jccexit");
                        ControlCenter.this.saveonexit = ControlCenter.this.saveonexit && windowprops.getBooleanProperty("saveonexit");
                    }
                }
                catch (Exception e) {
                    props = new Properties();
                    Dimension screendim = Toolkit.getDefaultToolkit().getScreenSize();
                    Dimension windim = new Dimension(Math.min(Math.max((int)((double)screendim.width * 0.6), 800), screendim.width), Math.min(Math.max((int)((double)screendim.height * 0.6), 650), screendim.height));
                    ControlCenter.this.window.setSize(windim);
                    ControlCenter.this.window.setLocation(SGUI.calculateMiddlePosition((Window)ControlCenter.this.window));
                }
                ControlCenter.this.pcc.setProperties(props).addResultListener((IResultListener)new SwingDelegationResultListener(ret));
            }
        });
        return ret;
    }

    public IFuture<Void> saveSettings() {
        final Future ret = new Future();
        this.saveSettings(new File(this.jccaccess.getComponentIdentifier().getLocalName() + SETTINGS_EXTENSION)).addResultListener((IResultListener)new SwingDelegationResultListener<Void>(ret){

            public void customResultAvailable(Void result) {
                ControlCenter.this.pcc.savePlatformProperties().addResultListener((IResultListener)new SwingDelegationResultListener<Void>(ret){

                    public void customResultAvailable(Void result) {
                        super.customResultAvailable((Object)result);
                    }

                    public void customExceptionOccurred(Exception exception) {
                        super.customExceptionOccurred(exception);
                    }
                });
            }
        });
        return ret;
    }

    public IFuture<Void> saveSettings(final File file) {
        final Future ret = new Future();
        if (this.pcc == null) {
            ret.setResult(null);
        } else {
            ret.addResultListener((IResultListener)new IResultListener<Void>(){

                public void resultAvailable(Void result) {
                }

                public void exceptionOccurred(Exception exception) {
                    System.out.println("Could not save settings: " + exception);
                }
            });
            this.pcc.getProperties().addResultListener((IResultListener)new SwingDelegationResultListener(ret){

                public void customResultAvailable(Object result) {
                    final Properties props = (Properties)result;
                    Properties windowprops = new Properties();
                    windowprops.addProperty(new Property("width", Integer.toString(ControlCenter.this.window.getWidth())));
                    windowprops.addProperty(new Property("height", Integer.toString(ControlCenter.this.window.getHeight())));
                    windowprops.addProperty(new Property("x", Integer.toString(ControlCenter.this.window.getX())));
                    windowprops.addProperty(new Property("y", Integer.toString(ControlCenter.this.window.getY())));
                    windowprops.addProperty(new Property("extendedState", Integer.toString(ControlCenter.this.window.getCachedState())));
                    windowprops.addProperty(new Property("jccexit", ControlCenter.this.jccexit != null ? ControlCenter.this.jccexit : ControlCenter.JCC_EXIT_ASK));
                    windowprops.addProperty(new Property("saveonexit", Boolean.toString(ControlCenter.this.saveonexit)));
                    props.removeSubproperties("window");
                    props.addSubproperties("window", windowprops);
                    ControlCenter.this.getPCC().getClassLoader(null).addResultListener((IResultListener)new SwingDelegationResultListener(ret){

                        public void customResultAvailable(Object result) {
                            ClassLoader cl = (ClassLoader)result;
                            try {
                                FileOutputStream os = new FileOutputStream(file);
                                PropertiesXMLHelper.write((Object)props, (OutputStream)os, (ClassLoader)cl);
                                os.close();
                                ControlCenter.this.window.getStatusBar().setText("Settings saved successfully: " + file.getAbsolutePath());
                                ret.setResult(null);
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        }
                    });
                }
            });
        }
        return ret;
    }

    public void exit() {
        assert (SwingUtilities.isEventDispatchThread());
        if (!this.killed) {
            int choice;
            RememberOptionMessage msg = null;
            if (this.jccexit == null || this.jccexit.equals(JCC_EXIT_ASK)) {
                msg = new RememberOptionMessage("You requested to close the JCC GUI.\n Do you also want to shutdown the local platform?\n");
                choice = JOptionPane.showConfirmDialog(this.window, msg, "Exit Question", 1, 3);
            } else {
                choice = this.jccexit.equals(JCC_EXIT_KEEP) ? 1 : 0;
            }
            if (0 == choice) {
                if (msg != null && msg.isRemember()) {
                    this.jccexit = JCC_EXIT_SHUTDOWN;
                }
                SJCC.killPlattform((IExternalAccess)this.jccaccess, (Component)this.window);
            } else if (1 == choice) {
                if (msg != null && msg.isRemember()) {
                    this.jccexit = JCC_EXIT_KEEP;
                }
                this.jccaccess.killComponent();
            }
        }
    }

    public IFuture<Void> shutdown() {
        final Future ret = new Future();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                assert (!ControlCenter.this.killed);
                ControlCenter.this.killed = true;
                IFuture<Void> saved = ControlCenter.this.saveonexit ? ControlCenter.this.saveSettings() : IFuture.DONE;
                saved.addResultListener((IResultListener)new SwingDelegationResultListener<Void>(ret){

                    public void customResultAvailable(Void result) {
                        CounterResultListener lis = new CounterResultListener(ControlCenter.this.pccs.size(), true, (IResultListener)new SwingDelegationResultListener<Void>(ret){

                            public void customResultAvailable(Void result) {
                                IFuture handlerdisposed = ControlCenter.this.cmshandler != null ? ControlCenter.this.cmshandler.dispose() : IFuture.DONE;
                                if (ControlCenter.this.prophandler != null) {
                                    ControlCenter.this.prophandler.dispose();
                                }
                                handlerdisposed.addResultListener((IResultListener)new SwingDelegationResultListener<Void>(ret){

                                    public void customResultAvailable(Void result) {
                                        ControlCenter.this.window.setVisible(false);
                                        ControlCenter.this.window.dispose();
                                        ret.setResult(null);
                                    }
                                });
                            }
                        });
                        Iterator<IComponentIdentifier> it = ControlCenter.this.pccs.keySet().iterator();
                        while (it.hasNext()) {
                            ControlCenter.this.pccs.get(it.next()).dispose().addResultListener((IResultListener)lis);
                        }
                    }
                });
            }
        };
        SwingUtilities.invokeLater(runnable);
        return ret;
    }

    public boolean isSaveOnExit() {
        return this.saveonexit;
    }

    public void setSaveOnExit(boolean saveonexit) {
        this.saveonexit = saveonexit;
    }

    public CMSUpdateHandler getCMSHandler() {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.cmshandler == null) {
            this.cmshandler = new CMSUpdateHandler(this.jccaccess);
        }
        return this.cmshandler;
    }

    public PropertyUpdateHandler getPropertyHandler() {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.prophandler == null) {
            this.prophandler = new PropertyUpdateHandler(this.jccaccess);
        }
        return this.prophandler;
    }

    public ComponentIconCache getIconCache() {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.iconcache == null) {
            this.iconcache = new ComponentIconCache(this.jccaccess);
        }
        return this.iconcache;
    }

    public ControlCenterWindow getWindow() {
        return this.window;
    }

    public IExternalAccess getJCCAccess() {
        return this.jccaccess;
    }

    public void showPlatform(IExternalAccess platformaccess) {
        final Future newpcc = new Future();
        if (this.pccs.containsKey(platformaccess.getComponentIdentifier())) {
            newpcc.setResult((Object)this.pccs.get(platformaccess.getComponentIdentifier()));
        } else {
            final PlatformControlCenter tmp = new PlatformControlCenter();
            this.pccs.put(platformaccess.getComponentIdentifier(), tmp);
            tmp.init(platformaccess, this, this.plugin_classes).addResultListener((IResultListener)new SwingDelegationResultListener(newpcc){

                public void customResultAvailable(Object result) {
                    newpcc.setResult((Object)tmp);
                }
            });
        }
        newpcc.addResultListener((IResultListener)new SwingDefaultResultListener(this.window){

            public void customResultAvailable(Object result) {
                final PlatformControlCenter pcc2 = (PlatformControlCenter)result;
                ControlCenter.this.pcc.getProperties().addResultListener((IResultListener)new SwingDefaultResultListener(ControlCenter.this.window){

                    public void customResultAvailable(Object result) {
                        pcc2.setProperties((Properties)result).addResultListener((IResultListener)new SwingDefaultResultListener(ControlCenter.this.window){

                            public void customResultAvailable(Object result) {
                                ControlCenter.this.pcc = pcc2;
                                ControlCenter.this.window.showPlatformPanel(ControlCenter.this.pcc);
                            }
                        });
                    }
                });
            }
        });
    }

    public void closePlatform(final PlatformControlCenter pcc) {
        this.pccs.remove(pcc.getPlatformAccess().getComponentIdentifier());
        this.window.getStatusBar().setText("Saving platform settings for: " + pcc.getPlatformAccess().getComponentIdentifier().getPlatformName());
        this.window.closePlatformPanel(pcc);
        boolean allowed = pcc.getPlatformAccess().getComponentIdentifier().getRoot().equals(this.jccaccess.getComponentIdentifier().getRoot());
        IFuture<Void> saved = this.isSaveOnExit() && allowed ? pcc.savePlatformProperties() : IFuture.DONE;
        saved.addResultListener((IResultListener)new SwingDefaultResultListener(){

            public void customResultAvailable(Object result) {
                ControlCenter.this.window.getStatusBar().setText("Saved platform settings for: " + pcc.getPlatformAccess().getComponentIdentifier().getPlatformName());
                pcc.dispose();
            }

            public void customExceptionOccurred(Exception exception) {
                ControlCenter.this.window.getStatusBar().setText("Could not save platform settings: " + exception);
                pcc.dispose();
            }
        });
    }

    public PlatformControlCenter getPCC() {
        return this.pcc;
    }
}

