/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.jcc;

import jadex.base.gui.AboutDialog;
import jadex.base.gui.StatusBar;
import jadex.bridge.IExternalAccess;
import jadex.bridge.VersionInfo;
import jadex.bridge.service.search.SServiceProvider;
import jadex.bridge.service.types.settings.ISettingsService;
import jadex.commons.SUtil;
import jadex.commons.future.IResultListener;
import jadex.commons.gui.BrowserLauncher;
import jadex.commons.gui.SGUI;
import jadex.tools.jcc.ControlCenter;
import jadex.tools.jcc.PlatformControlCenter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;

public class ControlCenterWindow
extends JFrame {
    protected static final Dimension BUTTON_DIM = new Dimension(32, 32);
    protected static final UIDefaults icons = new UIDefaults(new Object[]{"close_0", SGUI.makeIcon(ControlCenterWindow.class, (String)"/jadex/tools/common/images/close_0.png"), "close_1", SGUI.makeIcon(ControlCenterWindow.class, (String)"/jadex/tools/common/images/close_1.png"), "close_2", SGUI.makeIcon(ControlCenterWindow.class, (String)"/jadex/tools/common/images/close_2.png")});
    protected ControlCenter controlcenter;
    protected JFileChooser filechooser;
    protected StatusBar statusbar;
    protected JTabbedPane tabs;
    protected PlatformControlCenter first;
    protected int cachedstate;
    final Action EXIT = new AbstractAction("Exit"){

        @Override
        public void actionPerformed(ActionEvent e) {
            ControlCenterWindow.this.controlcenter.exit();
        }
    };
    final Action SAVE_SETTINGS = new AbstractAction("Save Settings"){

        @Override
        public void actionPerformed(ActionEvent e) {
            ControlCenterWindow.this.controlcenter.saveSettings();
        }
    };
    final Action SAVE_SETTINGS_AS = new AbstractAction("Save Settings As..."){

        @Override
        public void actionPerformed(ActionEvent e) {
            ControlCenterWindow.this.saveSettingsAs();
        }
    };
    final Action LOAD_SETTINGS = new AbstractAction("Load Settings from File..."){

        @Override
        public void actionPerformed(ActionEvent e) {
            ControlCenterWindow.this.loadSettings();
        }
    };
    final Action ABOUT = new AbstractAction("About..."){

        @Override
        public void actionPerformed(ActionEvent ae) {
            new AboutDialog((Frame)ControlCenterWindow.this);
        }
    };
    final Action ONLINE_DOC = new AbstractAction("WWW..."){

        @Override
        public void actionPerformed(ActionEvent ae) {
            try {
                BrowserLauncher.openURL((String)"http://www.activecomponents.org/bin/view/Documentation/Overview");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    };

    public ControlCenterWindow(ControlCenter main) {
        this.controlcenter = main;
        this.setTitle("Jadex Control Center " + VersionInfo.getInstance().getVersion() + " (" + VersionInfo.getInstance().getTextDateString() + "): " + this.controlcenter.getJCCAccess().getComponentIdentifier().getName());
        this.getContentPane().setLayout(new BorderLayout());
        this.statusbar = new StatusBar();
        this.getContentPane().add("South", (Component)this.statusbar);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ControlCenterWindow.this.controlcenter.exit();
            }
        });
        this.addWindowStateListener(new WindowStateListener(){

            @Override
            public void windowStateChanged(WindowEvent e) {
                ControlCenterWindow.this.cachedstate = e.getNewState();
            }
        });
    }

    public void displayError(final String errortitle, final String errormessage, final Exception exception) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SGUI.showError((Component)ControlCenterWindow.this, (String)errortitle, (String)errormessage, (Exception)exception);
            }
        });
    }

    public StatusBar getStatusBar() {
        return this.statusbar;
    }

    public JMenuBar createMenuBar(JMenu[] pluginbar) {
        JMenuBar menubar = new JMenuBar();
        final JCheckBoxMenuItem soe = new JCheckBoxMenuItem("Save Settings on Exit", this.controlcenter.isSaveOnExit());
        soe.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                final boolean sel = soe.isSelected();
                ControlCenterWindow.this.controlcenter.setSaveOnExit(sel);
                SServiceProvider.getService((IExternalAccess)ControlCenterWindow.this.controlcenter.getPCC().getPlatformAccess(), ISettingsService.class, (String)"platform").addResultListener((IResultListener)new IResultListener<ISettingsService>(){

                    public void resultAvailable(ISettingsService setser) {
                        setser.setSaveOnExit(sel);
                    }

                    public void exceptionOccurred(Exception exception) {
                    }
                });
            }
        });
        JMenu file = new JMenu("File");
        file.add(soe);
        file.add(new JMenuItem(this.SAVE_SETTINGS));
        file.addSeparator();
        file.add(new JMenuItem(this.LOAD_SETTINGS));
        file.add(new JMenuItem(this.SAVE_SETTINGS_AS));
        file.addSeparator();
        file.add(new JMenuItem(this.EXIT));
        menubar.add((Component)file, 0);
        JMenu help = new JMenu("Help");
        help.add(new JMenuItem(this.ONLINE_DOC));
        help.add(new JMenuItem(this.ABOUT));
        menubar.add(help);
        for (int i = 0; pluginbar != null && i < pluginbar.length; ++i) {
            menubar.add((Component)pluginbar[i], i + 1);
        }
        return menubar;
    }

    public int getCachedState() {
        return this.cachedstate;
    }

    protected void saveSettingsAs() {
        if (this.getFileChooser().showDialog(this, "Save Settings As") == 0) {
            final File f = this.getFileChooser().getSelectedFile();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    File file = f;
                    if (file != null) {
                        if (file.exists()) {
                            String msg = SUtil.wrapText((String)("The file: " + file.getAbsolutePath() + " exists.\n Do you want to overwrite the file?"));
                            int o = JOptionPane.showConfirmDialog(ControlCenterWindow.this, msg, "Overwrite Warning", 0, 2);
                            if (1 == o) {
                                return;
                            }
                        } else if (!file.getName().toLowerCase().endsWith(".settings.xml")) {
                            file = new File(file.getAbsolutePath() + ".settings.xml");
                            ControlCenterWindow.this.getFileChooser().setSelectedFile(file);
                        }
                        ControlCenterWindow.this.controlcenter.saveSettings(file);
                    }
                }
            });
        }
    }

    protected void loadSettings() {
        if (this.getFileChooser().showDialog(this, "Load Settings") == 0) {
            File file = this.getFileChooser().getSelectedFile();
            this.controlcenter.loadSettings(file);
        }
    }

    protected JFileChooser getFileChooser() {
        this.filechooser = new JFileChooser(".");
        this.filechooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase().endsWith(".settings.xml");
            }

            @Override
            public String getDescription() {
                return "JCC Settings Files";
            }
        });
        return this.filechooser;
    }

    public void showPlatformPanel(PlatformControlCenter pcc) {
        if (this.tabs == null) {
            if (this.first == null) {
                this.first = pcc;
                this.getContentPane().add((Component)pcc.getPanel(), "Center");
                this.repaint();
            } else if (this.first != pcc) {
                this.getContentPane().remove(this.first.getPanel());
                this.tabs = new JTabbedPane();
                this.tabs.addTab(this.first.getPanel().getName(), this.first.getPanel());
                this.tabs.setTabComponentAt(this.tabs.indexOfComponent(this.first.getPanel()), new TabHeader(this.first));
                this.first = null;
                this.tabs.addTab(pcc.getPanel().getName(), pcc.getPanel());
                this.tabs.setTabComponentAt(this.tabs.indexOfComponent(pcc.getPanel()), new TabHeader(pcc));
                this.tabs.setSelectedComponent(pcc.getPanel());
                this.getContentPane().add((Component)this.tabs, "Center");
                this.repaint();
            }
        } else {
            int index = this.tabs.indexOfComponent(pcc.getPanel());
            if (index != -1) {
                this.tabs.setSelectedIndex(index);
            } else {
                this.tabs.addTab(pcc.getPanel().getName(), pcc.getPanel());
                this.tabs.setTabComponentAt(this.tabs.indexOfComponent(pcc.getPanel()), new TabHeader(pcc));
                this.tabs.setSelectedComponent(pcc.getPanel());
            }
            this.repaint();
        }
    }

    public void closePlatformPanel(PlatformControlCenter pcc) {
        if (this.tabs.indexOfComponent(pcc.getPanel()) != -1) {
            this.tabs.removeTabAt(this.tabs.indexOfComponent(pcc.getPanel()));
            if (this.tabs.getTabCount() == 1) {
                TabHeader header = (TabHeader)this.tabs.getTabComponentAt(0);
                this.first = header.getPlatformControlCenter();
                this.getContentPane().remove(this.tabs);
                this.tabs = null;
                this.getContentPane().add((Component)this.first.getPanel(), "Center");
            }
            this.repaint();
        }
    }

    public class TabHeader
    extends JPanel {
        protected PlatformControlCenter pcc;

        public TabHeader(final PlatformControlCenter pcc) {
            this.pcc = pcc;
            this.setOpaque(false);
            JLabel label = new JLabel(pcc.getPanel().getName());
            final JLabel close = new JLabel(icons.getIcon("close_0"));
            close.addMouseListener(new MouseAdapter(){
                boolean in;
                boolean down;

                @Override
                public void mouseEntered(MouseEvent e) {
                    this.in = true;
                    this.updateIcon(e);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    this.in = false;
                    this.updateIcon(e);
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    this.down = this.in;
                    this.updateIcon(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (this.down && this.in) {
                        ControlCenterWindow.this.controlcenter.closePlatform(pcc);
                    }
                    this.down = false;
                    this.updateIcon(e);
                }

                protected void updateIcon(MouseEvent e) {
                    close.setIcon(this.down ? (this.in ? icons.getIcon("close_2") : icons.getIcon("close_1")) : ((e.getModifiers() & 0x10) == 0 && this.in ? icons.getIcon("close_1") : icons.getIcon("close_0")));
                    close.repaint();
                }
            });
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 0;
            gbc.anchor = 10;
            this.add((Component)label, gbc);
            gbc.insets = new Insets(2, 2, 0, 0);
            this.add((Component)close, gbc);
        }

        public PlatformControlCenter getPlatformControlCenter() {
            return this.pcc;
        }
    }
}

