/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.jcc;

import jadex.base.gui.componentviewer.ComponentViewerPlugin;
import jadex.base.gui.plugin.SJCC;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IComponentStep;
import jadex.bridge.IExternalAccess;
import jadex.bridge.IInternalAccess;
import jadex.bridge.TimeoutIntermediateResultListener;
import jadex.bridge.component.IExecutionFeature;
import jadex.bridge.nonfunctional.annotation.NameValue;
import jadex.bridge.service.IService;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.bridge.service.types.cms.IComponentManagementService;
import jadex.commons.concurrent.TimeoutException;
import jadex.commons.future.DelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IIntermediateResultListener;
import jadex.commons.future.IResultListener;
import jadex.commons.future.IntermediateExceptionDelegationResultListener;
import jadex.commons.gui.future.SwingExceptionDelegationResultListener;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentArgument;
import jadex.micro.annotation.AgentCreated;
import jadex.micro.annotation.AgentKilled;
import jadex.micro.annotation.Argument;
import jadex.micro.annotation.Arguments;
import jadex.micro.annotation.Description;
import jadex.micro.annotation.Properties;
import jadex.tools.awareness.AwarenessServicePlugin;
import jadex.tools.chat.ChatPlugin;
import jadex.tools.debugger.DebuggerPlugin;
import jadex.tools.jcc.ControlCenter;
import jadex.tools.security.SecurityServicePlugin;
import jadex.tools.simcenter.SimulationServicePlugin;
import jadex.tools.starter.StarterPlugin;
import jadex.tools.testcenter.TestCenterPlugin;

@Description(value="Micro component for opening the JCC gui.")
@Arguments(value={@Argument(name="saveonexit", clazz=boolean.class, defaultvalue="true", description="Save settings on exit?"), @Argument(name="platforms", clazz=String.class, defaultvalue="null", description="Show JCC for platforms matching this name.")})
@Agent
@Properties(value={@NameValue(name="system", value="true")})
public class JCCAgent
implements IComponentStep<Void> {
    public static final int MAX_TRIES = 10;
    public static final int RETRY_DELAY = 1000;
    @AgentArgument
    protected boolean saveonexit;
    @AgentArgument
    protected String platforms;
    protected ControlCenter cc;
    protected int tries;
    protected boolean connected;

    @AgentCreated
    public IFuture<Void> execute(final IInternalAccess agent) {
        final Future ret = new Future();
        if (this.platforms == null) {
            SJCC.getRootAccess((IExternalAccess)agent.getExternalAccess()).addResultListener((IResultListener)new SwingExceptionDelegationResultListener<IExternalAccess, Void>(ret){

                public void customResultAvailable(IExternalAccess platform) {
                    JCCAgent.this.initControlCenter(agent, platform).addResultListener((IResultListener)new DelegationResultListener(ret));
                }
            });
        } else {
            ++this.tries;
            if (this.tries > 10) {
                agent.getLogger().info("No platforms found matching '" + this.platforms + "'.");
                agent.killComponent();
                ret.setResultIfUndone(null);
            } else {
                agent.getLogger().info("Searching for platforms matching '" + this.platforms + "'.");
                ((IRequiredServicesFeature)agent.getComponentFeature(IRequiredServicesFeature.class)).searchServices(IComponentManagementService.class, "global").addResultListener((IResultListener)new TimeoutIntermediateResultListener(1000L, agent.getExternalAccess(), (IIntermediateResultListener)new IntermediateExceptionDelegationResultListener<IComponentManagementService, Void>(ret){

                    public void intermediateResultAvailable(IComponentManagementService cms) {
                        IComponentIdentifier cid = ((IService)cms).getServiceIdentifier().getProviderId().getRoot();
                        if (cid.getName().startsWith(JCCAgent.this.platforms)) {
                            JCCAgent.this.connected = true;
                            cms.getExternalAccess(cid).addResultListener((IResultListener)new IResultListener<IExternalAccess>(){

                                public void resultAvailable(IExternalAccess platform) {
                                    JCCAgent.this.initControlCenter(agent, platform).addResultListener((IResultListener)new IResultListener<Void>(){

                                        public void resultAvailable(Void result) {
                                            ret.setResultIfUndone(null);
                                        }

                                        public void exceptionOccurred(Exception exception) {
                                            ret.setExceptionIfUndone(exception);
                                        }
                                    });
                                }

                                public void exceptionOccurred(Exception exception) {
                                    ret.setExceptionIfUndone(exception);
                                }
                            });
                        }
                    }

                    public void finished() {
                        if (!JCCAgent.this.connected) {
                            ((IExecutionFeature)agent.getComponentFeature(IExecutionFeature.class)).waitForDelay(1000L, (IComponentStep)JCCAgent.this, true).addResultListener((IResultListener)new DelegationResultListener(ret));
                        }
                    }

                    public void exceptionOccurred(Exception exception) {
                        if (!JCCAgent.this.connected) {
                            ((IExecutionFeature)agent.getComponentFeature(IExecutionFeature.class)).waitForDelay(exception instanceof TimeoutException ? 0L : 1000L, (IComponentStep)JCCAgent.this, true).addResultListener((IResultListener)new DelegationResultListener(ret));
                        }
                    }
                }));
            }
        }
        return ret;
    }

    @AgentKilled
    public IFuture<Void> agentKilled(IInternalAccess agent) {
        Future ret = new Future();
        if (this.cc != null) {
            this.cc.shutdown().addResultListener(((IExecutionFeature)agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DelegationResultListener(ret)));
        } else {
            ret.setResult(null);
        }
        return ret;
    }

    public ControlCenter getControlCenter() {
        return this.cc;
    }

    protected IFuture<Void> initControlCenter(IInternalAccess agent, IExternalAccess platform) {
        Future ret = new Future();
        if (this.cc == null) {
            this.cc = new ControlCenter();
            this.cc.init(agent.getExternalAccess(), platform, new String[]{StarterPlugin.class.getName(), ChatPlugin.class.getName(), TestCenterPlugin.class.getName(), SimulationServicePlugin.class.getName(), DebuggerPlugin.class.getName(), AwarenessServicePlugin.class.getName(), ComponentViewerPlugin.class.getName(), SecurityServicePlugin.class.getName()}, this.saveonexit).addResultListener(((IExecutionFeature)agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DelegationResultListener(ret)));
        } else {
            this.cc.showPlatform(platform);
            ret.setResult(null);
        }
        return ret;
    }
}

