/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.jcc;

import jadex.base.gui.CMSUpdateHandler;
import jadex.base.gui.PropertyUpdateHandler;
import jadex.base.gui.componenttree.ComponentIconCache;
import jadex.base.gui.plugin.IControlCenter;
import jadex.base.gui.plugin.IControlCenterPlugin;
import jadex.bridge.IExternalAccess;
import jadex.bridge.IResourceIdentifier;
import jadex.bridge.TimeoutResultListener;
import jadex.bridge.service.search.SServiceProvider;
import jadex.bridge.service.types.library.ILibraryService;
import jadex.bridge.service.types.settings.ISettingsService;
import jadex.commons.IPropertiesProvider;
import jadex.commons.Properties;
import jadex.commons.Property;
import jadex.commons.SReflect;
import jadex.commons.Tuple2;
import jadex.commons.future.CounterResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.commons.gui.future.SwingDelegationResultListener;
import jadex.commons.gui.future.SwingExceptionDelegationResultListener;
import jadex.commons.gui.future.SwingResultListener;
import jadex.tools.jcc.ControlCenter;
import jadex.tools.jcc.PlatformControlCenterPanel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class PlatformControlCenter
implements IControlCenter,
IPropertiesProvider {
    protected IExternalAccess platformaccess;
    protected List<Tuple2<IControlCenterPlugin, JComponent>> plugins;
    protected Map<IControlCenterPlugin, Boolean> toolbarvis;
    protected ControlCenter controlcenter;
    protected PlatformControlCenterPanel pccpanel;
    protected Properties props;
    protected ILibraryService libservice;

    public IFuture<Void> init(IExternalAccess platformaccess, final ControlCenter controlcenter, final String[] plugin_classes) {
        this.platformaccess = platformaccess;
        this.controlcenter = controlcenter;
        this.plugins = new ArrayList<Tuple2<IControlCenterPlugin, JComponent>>();
        this.toolbarvis = new HashMap<IControlCenterPlugin, Boolean>();
        this.props = new Properties();
        this.pccpanel = new PlatformControlCenterPanel(this);
        final Future ret = new Future();
        SServiceProvider.getService((IExternalAccess)controlcenter.getJCCAccess(), ILibraryService.class, (String)"platform").addResultListener((IResultListener)new SwingExceptionDelegationResultListener<ILibraryService, Void>(ret){

            public void customResultAvailable(ILibraryService result) {
                PlatformControlCenter.this.libservice = result;
                PlatformControlCenter.this.libservice.getClassLoader(controlcenter.getJCCAccess().getModel().getResourceIdentifier()).addResultListener((IResultListener)new SwingExceptionDelegationResultListener<ClassLoader, Void>(ret){

                    public void customResultAvailable(ClassLoader cl) {
                        CounterResultListener crl = new CounterResultListener(plugin_classes.length, (IResultListener)new SwingDelegationResultListener(ret));
                        for (int i = 0; i < plugin_classes.length; ++i) {
                            PlatformControlCenter.this.addPlugin(plugin_classes[i], cl).addResultListener((IResultListener)crl);
                        }
                    }
                });
            }
        });
        return ret;
    }

    protected IFuture<IControlCenterPlugin> addPlugin(String clname, ClassLoader cl) {
        assert (SwingUtilities.isEventDispatchThread());
        Class plclass = SReflect.classForName0((String)clname, (ClassLoader)cl);
        return this.addPlugin(plclass);
    }

    protected IFuture<IControlCenterPlugin> addPlugin(final Class<?> plclass) {
        assert (SwingUtilities.isEventDispatchThread());
        final Future ret = new Future();
        try {
            for (Tuple2<IControlCenterPlugin, JComponent> tup : this.plugins) {
                if (!((IControlCenterPlugin)tup.getFirstEntity()).getClass().equals(plclass)) continue;
                this.setStatusText("Plugin already loaded: " + plclass);
                ret.setResult(null);
            }
            final IControlCenterPlugin p = (IControlCenterPlugin)plclass.newInstance();
            this.addPluginComponent(p, null);
            if (p.isLazy()) {
                this.setStatusText("Plugin loaded successfully: " + p.getName());
                ret.setResult((Object)p);
            } else {
                this.initPlugin(p).addResultListener((IResultListener)new SwingResultListener((IResultListener)new IResultListener<Void>(){

                    public void resultAvailable(Void result) {
                        PlatformControlCenter.this.setStatusText("Plugin loaded successfully: " + p.getName());
                        ret.setResult((Object)p);
                    }

                    public void exceptionOccurred(Exception exception) {
                        PlatformControlCenter.this.setStatusText("Plugin error: " + plclass);
                        ret.setResult(null);
                    }
                }));
            }
            this.pccpanel.updateToolBar(null);
        }
        catch (Exception e) {
            this.setStatusText("Plugin error: " + plclass);
            ret.setResultIfUndone(null);
        }
        return ret;
    }

    protected JComponent getPluginComponent(IControlCenterPlugin pl) {
        JComponent ret = null;
        for (Tuple2<IControlCenterPlugin, JComponent> tup : this.plugins) {
            if (!((IControlCenterPlugin)tup.getFirstEntity()).equals(pl)) continue;
            ret = (JComponent)tup.getSecondEntity();
            break;
        }
        return ret;
    }

    protected Tuple2<IControlCenterPlugin, JComponent> getPluginTuple(IControlCenterPlugin pl) {
        Tuple2<IControlCenterPlugin, JComponent> ret = null;
        for (Tuple2<IControlCenterPlugin, JComponent> tup : this.plugins) {
            if (!((IControlCenterPlugin)tup.getFirstEntity()).equals(pl)) continue;
            ret = tup;
            break;
        }
        return ret;
    }

    protected void addPluginComponent(IControlCenterPlugin pl, JComponent comp) {
        int pos = -1;
        for (int i = 0; i < this.plugins.size(); ++i) {
            Tuple2<IControlCenterPlugin, JComponent> tup = this.plugins.get(i);
            if (!((IControlCenterPlugin)tup.getFirstEntity()).equals(pl)) continue;
            this.plugins.remove(tup);
            pos = i;
            break;
        }
        Tuple2 tup = new Tuple2((Object)pl, (Object)comp);
        if (pos != -1) {
            this.plugins.add(pos, (Tuple2<IControlCenterPlugin, JComponent>)tup);
        } else {
            this.plugins.add((Tuple2<IControlCenterPlugin, JComponent>)tup);
        }
    }

    protected void removePluginComponent(IControlCenterPlugin pl) {
        for (int i = 0; i < this.plugins.size(); ++i) {
            Tuple2<IControlCenterPlugin, JComponent> tup = this.plugins.get(i);
            if (!((IControlCenterPlugin)tup.getFirstEntity()).equals(pl)) continue;
            this.plugins.remove(tup);
            break;
        }
    }

    protected void moveLeftPlugin(IControlCenterPlugin pl) {
        IControlCenterPlugin[] pls = this.getToolbarPlugins(true);
        Tuple2<IControlCenterPlugin, JComponent> last = null;
        for (int i = 0; i < pls.length; ++i) {
            Tuple2<IControlCenterPlugin, JComponent> tup = this.getPluginTuple(pls[i]);
            if (((IControlCenterPlugin)tup.getFirstEntity()).equals(pl)) {
                if (last != null) {
                    int idx = this.getPluginIndex((IControlCenterPlugin)last.getFirstEntity());
                    this.plugins.remove(tup);
                    this.plugins.add(idx, tup);
                    break;
                }
                this.plugins.remove(tup);
                this.plugins.add(tup);
                break;
            }
            last = tup;
        }
    }

    protected void moveRightPlugin(IControlCenterPlugin pl) {
        IControlCenterPlugin[] pls = this.getToolbarPlugins(true);
        Object last = null;
        for (int i = 0; i < pls.length; ++i) {
            Tuple2<IControlCenterPlugin, JComponent> tup = this.getPluginTuple(pls[i]);
            if (!((IControlCenterPlugin)tup.getFirstEntity()).equals(pl)) continue;
            if (i + 1 < pls.length) {
                int idx = this.getPluginIndex(pls[i + 1]);
                this.plugins.remove(tup);
                this.plugins.add(idx, tup);
                break;
            }
            this.plugins.remove(tup);
            this.plugins.add(0, tup);
            break;
        }
    }

    protected int getPluginIndex(IControlCenterPlugin pl) {
        int ret = -1;
        for (int i = 0; i < this.plugins.size(); ++i) {
            if (!((IControlCenterPlugin)this.plugins.get(i).getFirstEntity()).equals(pl)) continue;
            ret = i;
            break;
        }
        return ret;
    }

    public IFuture<Void> dispose() {
        Future ret = new Future();
        assert (SwingUtilities.isEventDispatchThread());
        CounterResultListener lis = new CounterResultListener(this.plugins.size(), true, (IResultListener)new SwingDelegationResultListener(ret));
        for (Tuple2<IControlCenterPlugin, JComponent> tup : this.plugins) {
            IControlCenterPlugin plugin = (IControlCenterPlugin)tup.getFirstEntity();
            if (tup.getSecondEntity() != null) {
                try {
                    plugin.shutdown().addResultListener((IResultListener)lis);
                }
                catch (Exception e) {
                    System.err.println("Exception while closing JCC-Plug-In " + plugin.getName());
                    e.printStackTrace();
                    lis.exceptionOccurred(e);
                }
                continue;
            }
            lis.resultAvailable(null);
        }
        return ret;
    }

    public IFuture<ClassLoader> getClassLoader(IResourceIdentifier rid) {
        return this.libservice.getClassLoader(rid == null ? this.getJCCAccess().getModel().getResourceIdentifier() : rid);
    }

    public PlatformControlCenterPanel getPanel() {
        return this.pccpanel;
    }

    public IFuture<Void> savePlatformProperties() {
        final Future ret = new Future();
        IControlCenterPlugin[] aplugins = this.getPlugins();
        CounterResultListener crl = new CounterResultListener(aplugins.length, (IResultListener)new SwingDelegationResultListener<Void>(ret){

            public void customResultAvailable(Void result) {
                SServiceProvider.getService((IExternalAccess)PlatformControlCenter.this.getPlatformAccess(), ISettingsService.class, (String)"platform").addResultListener((IResultListener)new SwingExceptionDelegationResultListener<ISettingsService, Void>(ret){

                    public void customResultAvailable(ISettingsService settings) {
                        settings.saveProperties().addResultListener((IResultListener)new SwingDelegationResultListener(ret));
                    }

                    public void customExceptionOccurred(Exception exception) {
                        ret.setResult(null);
                    }
                });
            }
        });
        for (int i = 0; i < aplugins.length; ++i) {
            if (this.getPluginComponent(aplugins[i]) != null) {
                aplugins[i].pushPlatformSettings().addResultListener((IResultListener)crl);
                continue;
            }
            crl.resultAvailable(null);
        }
        return ret;
    }

    public boolean isPluginVisible(IControlCenterPlugin pl) {
        Boolean ret = this.toolbarvis.get(pl);
        return ret != null ? ret : true;
    }

    public void setPluginVisible(IControlCenterPlugin pl, boolean vis) {
        this.toolbarvis.put(pl, vis);
    }

    public IControlCenterPlugin[] getToolbarPlugins(boolean vis) {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (Tuple2<IControlCenterPlugin, JComponent> tup : this.plugins) {
            if (this.isPluginVisible((IControlCenterPlugin)tup.getFirstEntity()) != vis) continue;
            ret.add(tup.getFirstEntity());
        }
        return ret.toArray(new IControlCenterPlugin[ret.size()]);
    }

    public ControlCenter getControlCenter() {
        return this.controlcenter;
    }

    public IControlCenterPlugin[] getPlugins() {
        assert (SwingUtilities.isEventDispatchThread());
        IControlCenterPlugin[] ret = new IControlCenterPlugin[this.plugins.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (IControlCenterPlugin)this.plugins.get(i).getFirstEntity();
        }
        return ret;
    }

    public IControlCenterPlugin getPluginForName(String name) {
        assert (SwingUtilities.isEventDispatchThread());
        if (name == null) {
            throw new IllegalArgumentException("Name must not null.");
        }
        Iterator<Tuple2<IControlCenterPlugin, JComponent>> it = this.plugins.iterator();
        while (it.hasNext()) {
            IControlCenterPlugin plugin = (IControlCenterPlugin)it.next().getFirstEntity();
            if (!name.equals(plugin.getName())) continue;
            return plugin;
        }
        return null;
    }

    public IFuture<Void> activatePlugin(IControlCenterPlugin plugin) {
        assert (SwingUtilities.isEventDispatchThread());
        Future ret = new Future();
        if (this.getPluginComponent(plugin) == null) {
            this.initPlugin(plugin).addResultListener((IResultListener)new SwingDelegationResultListener(ret));
        } else {
            JComponent comp = plugin.getView();
            this.addPluginComponent(plugin, comp);
            if (this.props.getSubproperty(plugin.getName()) != null) {
                plugin.setProperties(this.props.getSubproperty(plugin.getName())).addResultListener((IResultListener)new SwingDelegationResultListener(ret));
            } else {
                ret.setResult(null);
            }
        }
        return ret;
    }

    protected IFuture<Void> initPlugin(final IControlCenterPlugin plugin) {
        final Future ret = new Future();
        try {
            plugin.init((IControlCenter)this).addResultListener((IResultListener)new SwingDelegationResultListener<Void>(ret){

                public void customResultAvailable(Void result) {
                    JComponent comp = plugin.getView();
                    PlatformControlCenter.this.addPluginComponent(plugin, comp);
                    if (PlatformControlCenter.this.props.getSubproperty(plugin.getName()) != null) {
                        plugin.setProperties(PlatformControlCenter.this.props.getSubproperty(plugin.getName())).addResultListener((IResultListener)new SwingDelegationResultListener(ret));
                    } else {
                        ret.setResult(null);
                    }
                }
            });
        }
        catch (Exception e) {
            ret.setException(e);
        }
        return ret;
    }

    public IFuture<Void> setProperties(final Properties props) {
        assert (SwingUtilities.isEventDispatchThread());
        final Future ret = new Future();
        this.props = props;
        final Future plugfut = new Future();
        Properties[] vis = props.getSubproperties("vis");
        if (vis != null && vis.length > 0) {
            final Property[] ps = vis[0].getProperties();
            if (ps != null) {
                this.libservice.getClassLoader(this.controlcenter.getJCCAccess().getModel().getResourceIdentifier()).addResultListener((IResultListener)new SwingExceptionDelegationResultListener<ClassLoader, Void>(plugfut){

                    public void customResultAvailable(ClassLoader cl) {
                        final ArrayList<Tuple2<IControlCenterPlugin, JComponent>> newpls = new ArrayList<Tuple2<IControlCenterPlugin, JComponent>>();
                        PlatformControlCenter.this.loadPlugins(ps, 0, newpls, cl).addResultListener((IResultListener)new SwingDelegationResultListener<Void>(plugfut){

                            public void customResultAvailable(Void result) {
                                PlatformControlCenter.this.plugins = newpls;
                                PlatformControlCenter.this.pccpanel.updateToolBar(null);
                                super.customResultAvailable((Object)result);
                            }
                        });
                    }
                });
            } else {
                plugfut.setResult(null);
            }
        } else {
            plugfut.setResult(null);
        }
        plugfut.addResultListener((IResultListener)new SwingDelegationResultListener<Void>(ret){

            public void customResultAvailable(Void result) {
                Properties ccprops = props.getSubproperty("controlcenter");
                if (ccprops == null) {
                    ccprops = new Properties();
                }
                PlatformControlCenter.this.pccpanel.setProperties(ccprops).addResultListener((IResultListener)new SwingDelegationResultListener<Void>(ret){

                    public void customResultAvailable(Void result) {
                        ArrayList<IControlCenterPlugin> plugs = new ArrayList<IControlCenterPlugin>();
                        Iterator<Tuple2<IControlCenterPlugin, JComponent>> it = PlatformControlCenter.this.plugins.iterator();
                        while (it.hasNext()) {
                            IControlCenterPlugin plugin = (IControlCenterPlugin)it.next().getFirstEntity();
                            if (PlatformControlCenter.this.getPluginComponent(plugin) == null || props.getSubproperty(plugin.getName()) == null) continue;
                            plugs.add(plugin);
                        }
                        CounterResultListener crl = new CounterResultListener(plugs.size(), (IResultListener)new SwingDelegationResultListener(ret));
                        for (int i = 0; i < plugs.size(); ++i) {
                            IControlCenterPlugin plugin = (IControlCenterPlugin)plugs.get(i);
                            plugin.setProperties(props.getSubproperty(plugin.getName())).addResultListener((IResultListener)crl);
                        }
                    }
                });
            }
        });
        return ret;
    }

    protected IFuture<Void> loadPlugins(final Property[] ps, final int i, final List<Tuple2<IControlCenterPlugin, JComponent>> newpls, final ClassLoader cl) {
        final Future ret = new Future();
        IControlCenterPlugin plg = this.getPluginForName(ps[i].getType());
        if (plg == null && ps[i].getName() != null) {
            this.addPlugin(ps[i].getName(), cl).addResultListener((IResultListener)new SwingExceptionDelegationResultListener<IControlCenterPlugin, Void>(ret){

                public void customResultAvailable(IControlCenterPlugin plg) {
                    if (plg != null) {
                        newpls.add(new Tuple2((Object)plg, (Object)PlatformControlCenter.this.getPluginComponent(plg)));
                        PlatformControlCenter.this.toolbarvis.put(plg, Boolean.valueOf(ps[i].getValue()));
                    }
                    if (i + 1 < ps.length) {
                        PlatformControlCenter.this.loadPlugins(ps, i + 1, newpls, cl).addResultListener((IResultListener)new SwingDelegationResultListener(ret));
                    } else {
                        ret.setResult(null);
                    }
                }
            });
        } else {
            if (plg != null) {
                newpls.add((Tuple2<IControlCenterPlugin, JComponent>)new Tuple2((Object)plg, (Object)this.getPluginComponent(plg)));
                this.toolbarvis.put(plg, Boolean.valueOf(ps[i].getValue()));
            }
            if (i + 1 < ps.length) {
                this.loadPlugins(ps, i + 1, newpls, cl).addResultListener((IResultListener)new SwingDelegationResultListener(ret));
            } else {
                ret.setResult(null);
            }
        }
        return ret;
    }

    public IFuture<Properties> getProperties() {
        assert (SwingUtilities.isEventDispatchThread());
        final Future ret = new Future();
        if (this.props == null) {
            ret.setException((Exception)new IllegalStateException("Properties not set."));
        } else {
            Properties vis = new Properties();
            Iterator<Tuple2<IControlCenterPlugin, JComponent>> it = this.plugins.iterator();
            while (it.hasNext()) {
                IControlCenterPlugin plg = (IControlCenterPlugin)it.next().getFirstEntity();
                vis.addProperty(new Property(plg.getClass().getName(), plg.getName(), "" + this.isPluginVisible(plg)));
            }
            this.props.removeSubproperties("vis");
            this.props.addSubproperties("vis", vis);
            this.pccpanel.getProperties().addResultListener((IResultListener)new SwingDelegationResultListener(ret){

                public void customResultAvailable(Object result) {
                    IControlCenterPlugin plugin;
                    PlatformControlCenter.this.props.removeSubproperties("controlcenter");
                    PlatformControlCenter.this.props.addSubproperties("controlcenter", (Properties)result);
                    ArrayList<IControlCenterPlugin> plugs = new ArrayList<IControlCenterPlugin>();
                    for (Tuple2<IControlCenterPlugin, JComponent> tup : PlatformControlCenter.this.plugins) {
                        plugin = (IControlCenterPlugin)tup.getFirstEntity();
                        if (tup.getSecondEntity() == null) continue;
                        plugs.add(plugin);
                    }
                    final CounterResultListener crl = new CounterResultListener(plugs.size(), (IResultListener)new SwingDelegationResultListener(ret){

                        public void customResultAvailable(Object result) {
                            ret.setResult((Object)PlatformControlCenter.this.props);
                        }
                    });
                    for (int i = 0; i < plugs.size(); ++i) {
                        plugin = (IControlCenterPlugin)plugs.get(i);
                        plugin.getProperties().addResultListener((IResultListener)new TimeoutResultListener(10000L, PlatformControlCenter.this.getJCCAccess(), (IResultListener)new SwingDelegationResultListener(ret){

                            public void customResultAvailable(Object result) {
                                if (result != null) {
                                    PlatformControlCenter.this.props.removeSubproperties(plugin.getName());
                                    PlatformControlCenter.this.props.addSubproperties(plugin.getName(), (Properties)result);
                                }
                                crl.resultAvailable(null);
                            }

                            public void customExceptionOccurred(Exception exception) {
                                PlatformControlCenter.this.setStatusText("Plugin propetry saving error: " + plugin.getName());
                                crl.resultAvailable(null);
                            }
                        }));
                    }
                }
            });
        }
        return ret;
    }

    public void showPlatform(IExternalAccess platformaccess) {
        this.controlcenter.showPlatform(platformaccess);
    }

    public void showPlugin(String name) {
        IControlCenterPlugin plugin = null;
        Iterator<Tuple2<IControlCenterPlugin, JComponent>> it = this.plugins.iterator();
        while (plugin == null && it.hasNext()) {
            IControlCenterPlugin next = (IControlCenterPlugin)it.next().getFirstEntity();
            if (!next.getName().equals(name)) continue;
            plugin = next;
        }
        if (plugin != null) {
            this.pccpanel.setPerspective(plugin);
        }
    }

    public void setStatusText(String text) {
        this.controlcenter.getWindow().getStatusBar().setText(text);
    }

    public JComponent getStatusComponent(Object id) {
        return (JComponent)this.controlcenter.getWindow().getStatusBar().getStatusComponent(id);
    }

    public void addStatusComponent(Object id, JComponent comp) {
        this.controlcenter.getWindow().getStatusBar().addStatusComponent(id, (Component)comp);
    }

    public void removeStatusComponent(Object id) {
        this.controlcenter.getWindow().getStatusBar().removeStatusComponent(id);
    }

    public void displayError(String errortitle, String errormessage, Exception exception) {
        this.controlcenter.getWindow().displayError(errortitle, errormessage, exception);
    }

    public IExternalAccess getPlatformAccess() {
        return this.platformaccess;
    }

    public IExternalAccess getJCCAccess() {
        return this.controlcenter.getJCCAccess();
    }

    public CMSUpdateHandler getCMSHandler() {
        return this.controlcenter.getCMSHandler();
    }

    public PropertyUpdateHandler getPropertyHandler() {
        return this.controlcenter.getPropertyHandler();
    }

    public ComponentIconCache getIconCache() {
        return this.controlcenter.getIconCache();
    }
}

