/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.jcc;

import jadex.base.gui.ClassChooserPanel;
import jadex.base.gui.JadexLogoButton;
import jadex.base.gui.plugin.IControlCenterPlugin;
import jadex.commons.IFilter;
import jadex.commons.IPropertiesProvider;
import jadex.commons.Properties;
import jadex.commons.Property;
import jadex.commons.SReflect;
import jadex.commons.SUtil;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.commons.gui.JSplitPanel;
import jadex.commons.gui.future.SwingDefaultResultListener;
import jadex.tools.jcc.ConsolePanel;
import jadex.tools.jcc.PlatformControlCenter;
import jadex.xml.bean.JavaReader;
import jadex.xml.bean.JavaWriter;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class PlatformControlCenterPanel
extends JPanel
implements IPropertiesProvider {
    protected static final Dimension BUTTON_DIM = new Dimension(32, 32);
    protected PlatformControlCenter controlcenter;
    protected IControlCenterPlugin currentperspective;
    protected CardLayout clayout;
    protected JPanel content;
    protected JToolBar toolbar;
    protected JSplitPanel sp;
    protected ConsolePanel console;
    protected Map consoleheights;
    protected boolean consoleenabled;

    public PlatformControlCenterPanel(PlatformControlCenter controlcenter) {
        super(new BorderLayout());
        this.controlcenter = controlcenter;
        this.consoleheights = new HashMap();
        this.clayout = new CardLayout();
        this.content = new JPanel(this.clayout);
        this.console = new ConsolePanel(controlcenter.getPlatformAccess(), controlcenter.getJCCAccess());
        this.console.setConsoleEnabled(false);
        this.sp = new JSplitPanel(0);
        this.sp.setOneTouchExpandable(true);
        this.sp.setDividerLocation(0.0);
        this.content.setMinimumSize(new Dimension(0, 0));
        this.console.setMinimumSize(new Dimension(0, 0));
        this.sp.add((Component)this.content);
        this.sp.add((Component)this.console);
        this.add("Center", (Component)this.sp);
        this.sp.setResizeWeight(1.0);
    }

    protected void updateToolBar(IControlCenterPlugin selplugin) {
        assert (SwingUtilities.isEventDispatchThread());
        if (selplugin == null) {
            selplugin = this.currentperspective;
        }
        if (this.toolbar == null) {
            this.toolbar = new JToolBar("Main Toolbar");
            JPanel tp = new JPanel(new BorderLayout());
            tp.add((Component)this.toolbar, "Center");
            this.add("North", tp);
            final JPopupMenu popup = new JPopupMenu();
            this.toolbar.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    this.mouseClicked(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.mouseClicked(e);
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        popup.removeAll();
                        popup.add(new JMenuItem(new AbstractAction("Add new plugin ..."){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                PlatformControlCenterPanel.this.controlcenter.libservice.getClassLoader(null).addResultListener((IResultListener)new SwingDefaultResultListener<ClassLoader>((Component)PlatformControlCenterPanel.this){

                                    public void customResultAvailable(final ClassLoader cl) {
                                        PlatformControlCenterPanel.this.controlcenter.libservice.getAllURLs().addResultListener((IResultListener)new SwingDefaultResultListener<List<URL>>((Component)PlatformControlCenterPanel.this){

                                            public void customResultAvailable(List<URL> urls) {
                                                Class plcl;
                                                IFilter ffil = new IFilter(){

                                                    public boolean filter(Object obj) {
                                                        String fn = "";
                                                        if (obj instanceof File) {
                                                            File f = (File)obj;
                                                            fn = f.getName();
                                                        } else if (obj instanceof JarEntry) {
                                                            JarEntry je = (JarEntry)obj;
                                                            fn = je.getName();
                                                        }
                                                        return fn.indexOf("Plugin") != -1 && fn.indexOf("$") == -1 && fn.indexOf("Panel") == -1;
                                                    }
                                                };
                                                IFilter cfil = new IFilter(){

                                                    public boolean filter(Object obj) {
                                                        boolean ret;
                                                        Class cl = (Class)obj;
                                                        boolean bl = ret = SReflect.isSupertype(IControlCenterPlugin.class, (Class)cl) && !cl.isInterface() && !Modifier.isAbstract(cl.getModifiers());
                                                        if (ret) {
                                                            IControlCenterPlugin[] pls;
                                                            for (IControlCenterPlugin pl : pls = PlatformControlCenterPanel.this.controlcenter.getPlugins()) {
                                                                if (!pl.getClass().equals(obj)) continue;
                                                                ret = false;
                                                                break;
                                                            }
                                                        }
                                                        return ret;
                                                    }
                                                };
                                                ClassChooserPanel pp = new ClassChooserPanel(ffil, cfil, urls.toArray(new URL[urls.size()]), cl);
                                                int res = JOptionPane.showOptionDialog(PlatformControlCenterPanel.this, pp, "", 1, 3, null, new Object[]{"OK", "Cancel"}, "OK");
                                                if (0 == res && (plcl = (Class)pp.getSelectedElement()) != null) {
                                                    PlatformControlCenterPanel.this.controlcenter.addPlugin(plcl);
                                                }
                                            }
                                        });
                                    }
                                });
                            }
                        }));
                        IControlCenterPlugin[] pls = PlatformControlCenterPanel.this.controlcenter.getToolbarPlugins(false);
                        for (int i = 0; i < pls.length; ++i) {
                            final IControlCenterPlugin pl = pls[i];
                            popup.add(new JMenuItem(new AbstractAction(pl.getName(), pl.getToolIcon(false)){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    PlatformControlCenterPanel.this.controlcenter.setPluginVisible(pl, true);
                                    PlatformControlCenterPanel.this.updateToolBar(null);
                                }
                            }));
                        }
                        popup.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            });
            this.toolbar.add(popup);
        }
        this.toolbar.removeAll();
        this.toolbar.add(Box.createGlue());
        this.toolbar.addSeparator();
        if (selplugin != null) {
            JComponent[] template = selplugin.getToolBar();
            for (int i = 0; template != null && i < template.length; ++i) {
                this.toolbar.add((Component)template[i], i);
            }
        }
        HashSet<IControlCenterPlugin> shown = new HashSet<IControlCenterPlugin>();
        for (int i = 0; i < this.toolbar.getComponentCount(); ++i) {
            JComponent comp = (JComponent)this.toolbar.getComponent(i);
            if (comp.getClientProperty("plugin") == null) continue;
            IControlCenterPlugin pl = (IControlCenterPlugin)comp.getClientProperty("plugin");
            shown.add(pl);
        }
        IControlCenterPlugin[] pls = this.controlcenter.getToolbarPlugins(true);
        List toshow = SUtil.arrayToList((Object)pls);
        for (IControlCenterPlugin pl : toshow) {
            this.addPlugin(pl, selplugin);
        }
        if (selplugin != null && !SUtil.arrayToSet((Object)pls).contains(selplugin)) {
            for (int i = 0; i < this.toolbar.getComponentCount(); ++i) {
                JComponent comp = (JComponent)this.toolbar.getComponent(i);
                if (comp.getClientProperty("plugin") == null) continue;
                IControlCenterPlugin pl = (IControlCenterPlugin)comp.getClientProperty("plugin");
                this.setPerspective(pl);
                break;
            }
        }
        String buttonclass = System.getProperty("jadex_logobutton", JadexLogoButton.class.getName());
        JButton jlb = null;
        try {
            jlb = (JButton)Class.forName(buttonclass).newInstance();
        }
        catch (Exception pl) {
            // empty catch block
        }
        if (jlb != null) {
            this.toolbar.addSeparator();
            this.toolbar.add(jlb);
        }
        this.toolbar.validate();
        this.toolbar.repaint();
        Container root = this.toolbar;
        while (root.getParent() != null && !(root instanceof Window)) {
            root = root.getParent();
        }
        if (root instanceof Window && !(root instanceof JFrame)) {
            ((Window)root).pack();
        }
    }

    protected void addPlugin(final IControlCenterPlugin pl, IControlCenterPlugin selplugin) {
        try {
            final JButton button = new JButton(new PluginAction(pl));
            Icon ic = pl.getToolIcon(selplugin != null ? selplugin.getName().equals(pl.getName()) : false);
            if (ic != null) {
                button.setIcon(ic);
            } else {
                button.setText(pl.getName());
            }
            button.setText("A");
            button.putClientProperty("plugin", pl);
            button.setBorder(null);
            button.setText(null);
            button.setMinimumSize(BUTTON_DIM);
            button.setHorizontalAlignment(0);
            button.setVerticalAlignment(0);
            button.setToolTipText(pl.getName());
            button.getModel().addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    button.setIcon(pl.getToolIcon(button.isSelected()));
                }
            });
            final JPopupMenu popup = new JPopupMenu();
            button.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    this.mouseClicked(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.mouseClicked(e);
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        popup.removeAll();
                        popup.add(new JMenuItem(new AbstractAction("Hide tool"){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                PlatformControlCenterPanel.this.controlcenter.setPluginVisible(pl, false);
                                PlatformControlCenterPanel.this.updateToolBar(null);
                            }
                        }));
                        IControlCenterPlugin[] pls = PlatformControlCenterPanel.this.controlcenter.getToolbarPlugins(true);
                        popup.add(new JMenuItem(new AbstractAction("Move left"){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                PlatformControlCenterPanel.this.controlcenter.moveLeftPlugin(pl);
                                PlatformControlCenterPanel.this.updateToolBar(null);
                            }
                        }));
                        popup.add(new JMenuItem(new AbstractAction("Move right"){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                PlatformControlCenterPanel.this.controlcenter.moveRightPlugin(pl);
                                PlatformControlCenterPanel.this.updateToolBar(null);
                            }
                        }));
                        popup.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            });
            this.toolbar.add(button);
        }
        catch (Exception e) {
            this.controlcenter.removePluginComponent(pl);
            this.controlcenter.setStatusText("Plugin error: " + e);
            pl.shutdown();
        }
    }

    public IFuture<Void> setPerspective(final IControlCenterPlugin plugin) {
        final Future ret = new Future();
        this.controlcenter.getControlCenter().getWindow().setCursor(Cursor.getPredefinedCursor(3));
        this.controlcenter.activatePlugin(plugin).addResultListener((IResultListener)new SwingDefaultResultListener(){

            public void customResultAvailable(Object result) {
                Double ch;
                IControlCenterPlugin oldperspective = PlatformControlCenterPanel.this.currentperspective;
                PlatformControlCenterPanel.this.currentperspective = plugin;
                if (oldperspective != plugin) {
                    PlatformControlCenterPanel.this.consoleheights.put(oldperspective.getName() + ".console.height", PlatformControlCenterPanel.this.getConsoleHeight());
                }
                if ((ch = (Double)PlatformControlCenterPanel.this.consoleheights.get(PlatformControlCenterPanel.this.currentperspective.getName() + ".console.height")) != null) {
                    PlatformControlCenterPanel.this.setConsoleHeight(ch);
                } else {
                    PlatformControlCenterPanel.this.setConsoleHeight(1.0);
                }
                try {
                    JMenu[] menu = plugin.getMenuBar();
                    PlatformControlCenterPanel.this.controlcenter.getControlCenter().getWindow().setJMenuBar(PlatformControlCenterPanel.this.controlcenter.getControlCenter().getWindow().createMenuBar(menu));
                    PlatformControlCenterPanel.this.updateToolBar(plugin);
                    if (!Arrays.asList(PlatformControlCenterPanel.this.content.getComponents()).contains(plugin.getView())) {
                        PlatformControlCenterPanel.this.content.add((Component)plugin.getView(), plugin.getName());
                    }
                    PlatformControlCenterPanel.this.clayout.show(PlatformControlCenterPanel.this.content, plugin.getName());
                    PlatformControlCenterPanel.this.controlcenter.getControlCenter().getWindow().validate();
                    PlatformControlCenterPanel.this.controlcenter.getControlCenter().getWindow().repaint();
                    ret.setResult(null);
                }
                catch (RuntimeException e) {
                    System.err.println("Error in plugin " + plugin.getName());
                    e.printStackTrace();
                    if (oldperspective != null) {
                        PlatformControlCenterPanel.this.setPerspective(oldperspective);
                    } else {
                        PlatformControlCenterPanel.this.controlcenter.getControlCenter().getWindow().setJMenuBar(PlatformControlCenterPanel.this.controlcenter.getControlCenter().getWindow().createMenuBar(null));
                        PlatformControlCenterPanel.this.updateToolBar(plugin);
                        PlatformControlCenterPanel.this.clayout.show(PlatformControlCenterPanel.this.content, plugin.getName());
                        PlatformControlCenterPanel.this.controlcenter.getControlCenter().getWindow().validate();
                        PlatformControlCenterPanel.this.controlcenter.getControlCenter().getWindow().repaint();
                    }
                    ret.setResult(null);
                }
                PlatformControlCenterPanel.this.controlcenter.getControlCenter().getWindow().setCursor(Cursor.getPredefinedCursor(0));
            }

            public void customExceptionOccurred(Exception exception) {
                PlatformControlCenterPanel.this.controlcenter.getControlCenter().getWindow().setCursor(Cursor.getPredefinedCursor(0));
                PlatformControlCenterPanel.this.controlcenter.displayError("Plugin Error", "Plugin could not be activated: " + plugin.getName(), exception);
                ret.setException(exception);
            }
        });
        return ret;
    }

    public void showConsole(boolean show) {
        int currentloc;
        boolean shown = this.isConsoleShown();
        Insets insets = this.sp.getInsets();
        int lastloc = this.sp.getLastDividerLocation();
        int newloc = currentloc = this.sp.getUI().getDividerLocation((JSplitPane)this.sp);
        BasicSplitPaneDivider divider = ((BasicSplitPaneUI)this.sp.getUI()).getDivider();
        if (show && !shown) {
            if (currentloc >= this.sp.getHeight() - insets.bottom - divider.getHeight()) {
                int maxloc = this.sp.getMaximumDividerLocation();
                newloc = lastloc < maxloc ? lastloc : maxloc * 2 / 3;
            }
        } else if (!show && shown) {
            newloc = this.sp.getMaximumDividerLocation();
        }
        if (currentloc != newloc) {
            this.sp.setDividerLocation(newloc);
            this.sp.setLastDividerLocation(currentloc);
        }
    }

    public boolean isConsoleShown() {
        return this.getConsoleHeight() != 0.0;
    }

    public void setConsoleHeight(final double height) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PlatformControlCenterPanel.this.sp.setDividerLocation(height);
            }
        });
    }

    public double getConsoleHeight() {
        return this.sp.getProportionalDividerLocation();
    }

    @Override
    public String getName() {
        return this.controlcenter == null ? null : this.controlcenter.getPlatformAccess().getComponentIdentifier().getName();
    }

    public IFuture<Properties> getProperties() {
        Properties props = new Properties();
        if (this.currentperspective != null) {
            props.addProperty(new Property("perspective", this.currentperspective.getName()));
            this.consoleheights.put(this.currentperspective.getName() + ".console.height", this.getConsoleHeight());
        }
        props.addProperty(new Property("consoleenabled", this.consoleenabled ? "true" : "false"));
        props.addProperty(new Property("consoleheights", JavaWriter.objectToXML((Object)this.consoleheights, (ClassLoader)this.getClass().getClassLoader())));
        return new Future((Object)props);
    }

    public IFuture<Void> setProperties(Properties props) {
        IControlCenterPlugin plugin;
        Property prop = props.getProperty("perspective");
        if (prop != null && (plugin = this.controlcenter.getPluginForName(prop.getValue())) != null) {
            this.currentperspective = plugin;
        }
        if ((prop = props.getProperty("consoleheights")) != null) {
            try {
                this.consoleheights = (Map)JavaReader.objectFromXML((String)prop.getValue(), (ClassLoader)this.getClass().getClassLoader());
            }
            catch (RuntimeException e) {
                System.err.println("Cannot load console settings: " + e.getClass().getName());
            }
        }
        if (this.currentperspective == null && this.controlcenter.getPlugins().length > 0) {
            this.currentperspective = this.controlcenter.getPlugins()[0];
        }
        this.setPerspective(this.currentperspective);
        if (this.controlcenter.getJCCAccess().getComponentIdentifier().getPlatformName().equals(this.controlcenter.getPlatformAccess().getComponentIdentifier().getPlatformName())) {
            this.consoleenabled = props.getBooleanProperty("consoleenabled");
            this.console.setConsoleEnabled(this.consoleenabled);
        }
        this.updateToolBar(null);
        return IFuture.DONE;
    }

    public IControlCenterPlugin getCurrentPerspective() {
        return this.currentperspective;
    }

    class PluginAction
    extends AbstractAction {
        final IControlCenterPlugin plugin;

        public PluginAction(IControlCenterPlugin plugin) {
            super(plugin.getName());
            this.plugin = plugin;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PlatformControlCenterPanel.this.setPerspective(this.plugin);
        }
    }
}

