/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.libtool;

import jadex.base.SRemoteGui;
import jadex.base.gui.componentviewer.IServiceViewerPanel;
import jadex.base.gui.modeltree.AddPathAction;
import jadex.base.gui.modeltree.AddRIDAction;
import jadex.base.gui.modeltree.AddRemotePathAction;
import jadex.base.gui.modeltree.ITreeAbstraction;
import jadex.base.gui.modeltree.RemovePathAction;
import jadex.base.gui.plugin.IControlCenter;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IExternalAccess;
import jadex.bridge.IGlobalResourceIdentifier;
import jadex.bridge.ILocalResourceIdentifier;
import jadex.bridge.IResourceIdentifier;
import jadex.bridge.LocalResourceIdentifier;
import jadex.bridge.ResourceIdentifier;
import jadex.bridge.service.IService;
import jadex.bridge.service.search.SServiceProvider;
import jadex.bridge.service.types.filetransfer.FileData;
import jadex.bridge.service.types.library.ILibraryService;
import jadex.bridge.service.types.library.ILibraryServiceListener;
import jadex.bridge.service.types.threadpool.IDaemonThreadPoolService;
import jadex.commons.Properties;
import jadex.commons.SUtil;
import jadex.commons.Tuple2;
import jadex.commons.concurrent.IThreadPool;
import jadex.commons.future.CounterResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.commons.gui.CombiIcon;
import jadex.commons.gui.SGUI;
import jadex.commons.gui.future.SwingDefaultResultListener;
import jadex.commons.gui.future.SwingResultListener;
import jadex.platform.service.library.LibraryService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIDefaults;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class LibServiceBrowser
extends JPanel
implements IServiceViewerPanel {
    protected static final String ROOTTEXT = "Platform resources";
    protected static final String SYSTEMTEXT = "System classpath";
    protected static final UIDefaults icons = new UIDefaults(new Object[]{"help", SGUI.makeIcon(LibServiceBrowser.class, (String)"/jadex/base/gui/images/help.gng"), "jar", SGUI.makeIcon(LibServiceBrowser.class, (String)"/jadex/base/gui/images/jar.png"), "global", SGUI.makeIcon(LibServiceBrowser.class, (String)"/jadex/base/gui/images/global.png"), "oglobal", SGUI.makeIcon(LibServiceBrowser.class, (String)"/jadex/base/gui/images/overlay_global.png"), "folder", SGUI.makeIcon(LibServiceBrowser.class, (String)"/jadex/base/gui/images/folder4.png"), "orem", SGUI.makeIcon(LibServiceBrowser.class, (String)"/jadex/base/gui/images/overlay_removable.png")});
    protected IControlCenter jcc;
    protected JTree ridtree;
    protected ILibraryService libservice;
    protected ILibraryServiceListener listener;
    protected IThreadPool tp;
    protected Map<IResourceIdentifier, List<IResourceIdentifier>> deps;
    protected Set<Tuple2<IResourceIdentifier, IResourceIdentifier>> remlinks;

    public IFuture<Void> init(final IControlCenter jcc, IService service) {
        this.jcc = jcc;
        this.libservice = (ILibraryService)service;
        final JPanel classview = new JPanel(new BorderLayout());
        this.ridtree = new JTree(new DefaultTreeModel(null));
        ToolTipManager.sharedInstance().registerComponent(this.ridtree);
        this.ridtree.getSelectionModel().setSelectionMode(1);
        this.ridtree.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                assert (SwingUtilities.isEventDispatchThread());
                if (value instanceof LazyNode) {
                    LazyNode node = (LazyNode)value;
                    Icon icon = node.getIcon();
                    String tooltip = node.getTooltipText();
                    if (icon != null) {
                        this.setOpenIcon(icon);
                        this.setClosedIcon(icon);
                        this.setLeafIcon(icon);
                    } else {
                        this.setOpenIcon(this.getDefaultOpenIcon());
                        this.setClosedIcon(this.getDefaultClosedIcon());
                        this.setLeafIcon(this.getDefaultLeafIcon());
                    }
                    if (tooltip != null) {
                        this.setToolTipText(tooltip);
                    }
                }
                JComponent comp = (JComponent)super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                return comp;
            }
        });
        this.ridtree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.popup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.popup(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                this.popup(e);
            }

            protected void popup(MouseEvent e) {
                Object node;
                int row;
                if (e.isPopupTrigger() && (row = LibServiceBrowser.this.ridtree.getRowForLocation(e.getX(), e.getY())) != -1 && (node = LibServiceBrowser.this.ridtree.getLastSelectedPathComponent()) instanceof LazyNode) {
                    LazyNode ln = (LazyNode)node;
                    Object o = ((LazyNode)node).getMyUserObject();
                    IResourceIdentifier parid = (IResourceIdentifier)(ln.getParent() != null ? ((LazyNode)ln.getParent()).getMyUserObject() : null);
                    boolean rem = !jcc.getJCCAccess().getComponentIdentifier().getRoot().equals(jcc.getPlatformAccess().getComponentIdentifier().getRoot());
                    JPopupMenu popup = new JPopupMenu();
                    if (LibraryService.SYSTEMCPRID.equals(parid)) {
                        if (ln.isRemovable()) {
                            LibTreeAbstraction tar = new LibTreeAbstraction(rem){

                                public void action(Object obj) {
                                    LazyNode child = (LazyNode)obj;
                                    final Object o = child.getUserObject();
                                    if (o instanceof IResourceIdentifier) {
                                        URL url = SUtil.toURL((Object)((IResourceIdentifier)o).getLocalIdentifier().getUri());
                                        LibServiceBrowser.this.libservice.removeTopLevelURL(url).addResultListener((IResultListener)new SwingResultListener((IResultListener)new IResultListener<Void>(){

                                            public void resultAvailable(Void result) {
                                                jcc.setStatusText("Removed resource: " + o);
                                            }

                                            public void exceptionOccurred(Exception exception) {
                                                exception.printStackTrace();
                                                jcc.setStatusText("Error removin resource: " + o + " " + exception.getMessage());
                                            }
                                        }));
                                    }
                                }
                            };
                            popup.add((Action)new RemovePathAction((ITreeAbstraction)tar));
                        }
                    } else if (LibraryService.SYSTEMCPRID.equals(o)) {
                        LibTreeAbstraction taa = new LibTreeAbstraction(rem){

                            public void action(Object obj) {
                                if (obj instanceof File) {
                                    try {
                                        final URL url = ((File)obj).getCanonicalFile().toURI().toURL();
                                        jcc.setStatusText("Started adding: " + url);
                                        LibServiceBrowser.this.libservice.addTopLevelURL(url).addResultListener((IResultListener)new SwingResultListener((IResultListener)new IResultListener<Void>(){

                                            public void resultAvailable(Void result) {
                                                jcc.setStatusText("Finished adding: " + url);
                                            }

                                            public void exceptionOccurred(Exception e) {
                                                jcc.setStatusText("Error adding: " + url + " " + e.getMessage());
                                            }
                                        }));
                                    }
                                    catch (Exception e) {
                                        jcc.setStatusText("Error adding: " + obj + " " + e.getMessage());
                                    }
                                } else if (obj instanceof FileData) {
                                    final String filename = ((FileData)obj).getPath();
                                    SRemoteGui.addRemoteURL(null, (String)filename, (boolean)true, (IExternalAccess)jcc.getPlatformAccess()).addResultListener((IResultListener)new IResultListener<Tuple2<URL, IResourceIdentifier>>(){

                                        public void resultAvailable(Tuple2<URL, IResourceIdentifier> result) {
                                            jcc.setStatusText("Finished adding: " + result.getSecondEntity());
                                        }

                                        public void exceptionOccurred(Exception exception) {
                                            jcc.setStatusText("Error adding: " + filename + " " + exception.getMessage());
                                        }
                                    });
                                }
                            }
                        };
                        if (!rem) {
                            popup.add((Action)new AddPathAction((ITreeAbstraction)taa));
                        } else {
                            popup.add((Action)new AddRemotePathAction((ITreeAbstraction)taa));
                        }
                    } else if (o instanceof IResourceIdentifier || o == null) {
                        final IResourceIdentifier selrid = (IResourceIdentifier)o;
                        LibTreeAbstraction taa = new LibTreeAbstraction(rem){

                            public void action(Object obj) {
                                try {
                                    IResourceIdentifier rid = null;
                                    if (obj instanceof File) {
                                        URL url = ((File)obj).getCanonicalFile().toURI().toURL();
                                        IComponentIdentifier cid = this.getExternalAccess().getComponentIdentifier().getRoot();
                                        LocalResourceIdentifier lid = new LocalResourceIdentifier(cid, url);
                                        rid = new ResourceIdentifier((ILocalResourceIdentifier)lid, null);
                                    } else if (obj instanceof IResourceIdentifier) {
                                        rid = (IResourceIdentifier)obj;
                                    } else if (obj instanceof FileData) {
                                        final String filename = ((FileData)obj).getPath();
                                        SRemoteGui.addRemoteURL((IResourceIdentifier)selrid, (String)filename, (boolean)false, (IExternalAccess)jcc.getPlatformAccess()).addResultListener((IResultListener)new IResultListener<Tuple2<URL, IResourceIdentifier>>(){

                                            public void resultAvailable(Tuple2<URL, IResourceIdentifier> result) {
                                                jcc.setStatusText("Finished adding: " + result.getSecondEntity());
                                            }

                                            public void exceptionOccurred(Exception exception) {
                                                jcc.setStatusText("Erro adding: " + filename + " " + exception.getMessage());
                                            }
                                        });
                                    }
                                    if (rid != null) {
                                        final IResourceIdentifier frid = rid;
                                        jcc.setStatusText("Started adding: " + frid);
                                        LibServiceBrowser.this.libservice.addResourceIdentifier(selrid, rid, true).addResultListener((IResultListener)new SwingResultListener((IResultListener)new IResultListener<IResourceIdentifier>(){

                                            public void resultAvailable(IResourceIdentifier result) {
                                                jcc.setStatusText("Finished adding: " + frid);
                                            }

                                            public void exceptionOccurred(Exception e) {
                                                jcc.setStatusText("Error adding: " + frid + " " + e.getMessage());
                                            }
                                        }));
                                    }
                                }
                                catch (Exception e) {
                                    jcc.setStatusText("Error adding: " + obj + " err: " + e.getMessage());
                                }
                            }
                        };
                        if (!rem) {
                            popup.add((Action)new AddPathAction((ITreeAbstraction)taa));
                        } else {
                            popup.add((Action)new AddRemotePathAction((ITreeAbstraction)taa));
                        }
                        popup.add((Action)new AddRIDAction((ITreeAbstraction)taa));
                        LibTreeAbstraction tar = new LibTreeAbstraction(rem){

                            public void action(Object obj) {
                                LazyNode child = (LazyNode)obj;
                                final Object o = child.getUserObject();
                                if (o instanceof IResourceIdentifier) {
                                    LazyNode parent = (LazyNode)child.getParent();
                                    Object parid = parent.getUserObject();
                                    if (!(parid instanceof IResourceIdentifier)) {
                                        parid = null;
                                    }
                                    LibServiceBrowser.this.libservice.removeResourceIdentifier((IResourceIdentifier)parid, (IResourceIdentifier)o).addResultListener((IResultListener)new SwingResultListener((IResultListener)new IResultListener<Void>(){

                                        public void resultAvailable(Void result) {
                                            jcc.setStatusText("Removed resource: " + o);
                                        }

                                        public void exceptionOccurred(Exception exception) {
                                            exception.printStackTrace();
                                            jcc.setStatusText("Error removin resource: " + o + " " + exception.getMessage());
                                        }
                                    }));
                                }
                            }
                        };
                        if (o != null && ln.isRemovable()) {
                            popup.add((Action)new RemovePathAction((ITreeAbstraction)tar));
                        }
                    }
                    if (popup.getSubElements().length > 0) {
                        popup.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            }
        });
        JScrollPane scroll = new JScrollPane(this.ridtree);
        JPanel buts = new JPanel(new GridBagLayout());
        JButton add = new JButton("Add ...");
        add.putClientProperty("auto-adjust", Boolean.TRUE);
        JButton remove = new JButton("Remove");
        remove.putClientProperty("auto-adjust", Boolean.TRUE);
        JButton ref = new JButton("Refresh");
        ref.putClientProperty("auto-adjust", Boolean.TRUE);
        add.setToolTipText("Add a class path entry");
        remove.setToolTipText("Remove one or more selected entries from the classpath");
        buts.add((Component)add, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(2, 4, 4, 2), 0, 0));
        buts.add((Component)remove, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 4, 4, 2), 0, 0));
        buts.add((Component)ref, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 4, 4, 2), 0, 0));
        add.addActionListener(new ActionListener(){
            JFileChooser cchooser;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.cchooser == null) {
                    this.cchooser = new JFileChooser(".");
                    this.cchooser.setFileSelectionMode(2);
                    this.cchooser.setFileFilter(new FileFilter(){

                        @Override
                        public boolean accept(File name) {
                            return name.isDirectory() || name.getName().endsWith(".jar");
                        }

                        @Override
                        public String getDescription() {
                            return "*.jar";
                        }
                    });
                    this.cchooser.setMultiSelectionEnabled(true);
                }
                if (this.cchooser.showDialog(SGUI.getWindowParent((Component)classview), "Add") == 0) {
                    final File[] files = this.cchooser.getSelectedFiles();
                    TreePath sel = LibServiceBrowser.this.ridtree.getSelectionPath();
                    LazyNode seln = (LazyNode)(sel != null ? sel.getLastPathComponent() : null);
                    Object uo = seln != null ? seln.getMyUserObject() : null;
                    IResourceIdentifier parid = uo instanceof IResourceIdentifier ? (IResourceIdentifier)uo : null;
                    CounterResultListener lis = new CounterResultListener(files.length, (IResultListener)new IResultListener<Void>(){

                        public void resultAvailable(Void result) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    LibServiceBrowser.this.refresh(false);
                                }
                            });
                        }

                        public void exceptionOccurred(Exception exception) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    jcc.setStatusText("Error while adding path: " + SUtil.arrayToString((Object)files));
                                }
                            });
                        }
                    });
                    for (int i = 0; i < files.length; ++i) {
                        try {
                            URL url = files[i].getCanonicalFile().toURI().toURL();
                            LibServiceBrowser.this.libservice.addURL(parid, url).addResultListener((IResultListener)lis);
                            continue;
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }
        });
        remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePath path = LibServiceBrowser.this.ridtree.getSelectionPath();
                Object uo = LibServiceBrowser.this.getUserObject(path);
                if (uo instanceof IResourceIdentifier) {
                    Object puo = LibServiceBrowser.this.getUserObject(path.getParentPath());
                    IResourceIdentifier parid = puo instanceof IResourceIdentifier ? (IResourceIdentifier)puo : null;
                    LibServiceBrowser.this.libservice.removeResourceIdentifier(parid, (IResourceIdentifier)uo).addResultListener((IResultListener)new SwingResultListener((IResultListener)new IResultListener<Void>(){

                        public void resultAvailable(Void result) {
                            LibServiceBrowser.this.refresh(false);
                        }

                        public void exceptionOccurred(Exception exception) {
                            jcc.displayError("Library error", "Could not remove url", exception);
                        }
                    }));
                }
            }
        });
        ref.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LibServiceBrowser.this.refresh(true);
            }
        });
        classview.add("Center", scroll);
        classview.add("South", buts);
        this.setLayout(new BorderLayout());
        this.add((Component)classview, "Center");
        this.listener = new ILibraryServiceListener(){

            public IFuture<Void> resourceIdentifierAdded(final IResourceIdentifier parid, final IResourceIdentifier rid, final boolean rem) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        List<IResourceIdentifier> mydeps = LibServiceBrowser.this.deps.get(parid);
                        if (mydeps == null) {
                            mydeps = new ArrayList<IResourceIdentifier>();
                            LibServiceBrowser.this.deps.put(parid, mydeps);
                        }
                        mydeps.add(rid);
                        if (rem) {
                            LibServiceBrowser.this.remlinks.add((Tuple2<IResourceIdentifier, IResourceIdentifier>)new Tuple2((Object)parid, (Object)rid));
                        }
                        LazyNode root = (LazyNode)LibServiceBrowser.this.ridtree.getModel().getRoot();
                        root.refresh();
                        LibServiceBrowser.this.ridtree.invalidate();
                        LibServiceBrowser.this.ridtree.doLayout();
                        LibServiceBrowser.this.ridtree.repaint();
                    }
                });
                return IFuture.DONE;
            }

            public IFuture<Void> resourceIdentifierRemoved(final IResourceIdentifier parid, final IResourceIdentifier rid) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        List<IResourceIdentifier> mydeps = LibServiceBrowser.this.deps.get(parid);
                        if (mydeps != null) {
                            mydeps.remove(rid);
                        }
                        LazyNode root = (LazyNode)LibServiceBrowser.this.ridtree.getModel().getRoot();
                        root.refresh();
                        LibServiceBrowser.this.ridtree.invalidate();
                        LibServiceBrowser.this.ridtree.doLayout();
                        LibServiceBrowser.this.ridtree.repaint();
                    }
                });
                return IFuture.DONE;
            }
        };
        this.libservice.addLibraryServiceListener(this.listener);
        this.refresh(false);
        return IFuture.DONE;
    }

    public Map<IResourceIdentifier, List<IResourceIdentifier>> getDependencies() {
        return this.deps;
    }

    public Set<Tuple2<IResourceIdentifier, IResourceIdentifier>> getRemlinks() {
        return this.remlinks;
    }

    public void refresh(final boolean force) {
        this.jcc.setStatusText("Refreshing resource tree started...");
        this.libservice.getResourceIdentifiers().addResultListener((IResultListener)new SwingDefaultResultListener<Tuple2<IResourceIdentifier, Map<IResourceIdentifier, List<IResourceIdentifier>>>>((Component)this){

            public void customResultAvailable(final Tuple2<IResourceIdentifier, Map<IResourceIdentifier, List<IResourceIdentifier>>> mydeps) {
                LibServiceBrowser.this.libservice.getRemovableLinks().addResultListener((IResultListener)new SwingDefaultResultListener<Set<Tuple2<IResourceIdentifier, IResourceIdentifier>>>((Component)LibServiceBrowser.this){

                    public void customResultAvailable(Set<Tuple2<IResourceIdentifier, IResourceIdentifier>> reml) {
                        LibServiceBrowser.this.jcc.setStatusText("Refreshing resource tree finished");
                        LibServiceBrowser.this.deps = (Map)mydeps.getSecondEntity();
                        LibServiceBrowser.this.remlinks = reml;
                        DefaultTreeModel mod = (DefaultTreeModel)LibServiceBrowser.this.ridtree.getModel();
                        if (!(mod.getRoot() instanceof LazyNode) || force) {
                            LibServiceBrowser.this.ridtree.removeAll();
                            LazyNode root = new LazyNode(LibServiceBrowser.ROOTTEXT);
                            mod.setRoot(root);
                        } else {
                            ((LazyNode)mod.getRoot()).refresh();
                        }
                    }
                });
            }
        });
    }

    public IFuture<Void> shutdown() {
        try {
            this.libservice.removeLibraryServiceListener(this.listener);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return IFuture.DONE;
    }

    public JComponent getComponent() {
        return this;
    }

    public String getId() {
        return "libservicebrowser";
    }

    public IFuture<Void> setProperties(Properties props) {
        return IFuture.DONE;
    }

    public IFuture<Properties> getProperties() {
        return Future.getEmptyFuture();
    }

    protected IFuture<IThreadPool> getThreadPool() {
        final Future ret = new Future();
        if (this.tp == null) {
            SServiceProvider.getService((IExternalAccess)this.jcc.getJCCAccess(), IDaemonThreadPoolService.class, (String)"platform").addResultListener((IResultListener)new SwingDefaultResultListener<IDaemonThreadPoolService>(){

                public void customResultAvailable(IDaemonThreadPoolService result) {
                    LibServiceBrowser.this.tp = result;
                    ret.setResult((Object)LibServiceBrowser.this.tp);
                }
            });
        } else {
            ret.setResult((Object)this.tp);
        }
        return ret;
    }

    protected Object getUserObject(TreePath path) {
        LazyNode seln = (LazyNode)(path != null ? path.getLastPathComponent() : null);
        Object uo = seln != null ? seln.getMyUserObject() : null;
        return uo;
    }

    protected abstract class LibTreeAbstraction
    implements ITreeAbstraction {
        protected boolean rem;

        public LibTreeAbstraction(boolean rem) {
            this.rem = rem;
        }

        public boolean isRemote() {
            return this.rem;
        }

        public JTree getTree() {
            return LibServiceBrowser.this.ridtree;
        }

        public IExternalAccess getExternalAccess() {
            return LibServiceBrowser.this.jcc.getPlatformAccess();
        }

        public IExternalAccess getGUIExternalAccess() {
            return LibServiceBrowser.this.jcc.getJCCAccess();
        }
    }

    class LazyNode
    extends DefaultMutableTreeNode {
        protected boolean childrencreated;
        protected int childcnt;

        public LazyNode(Object o) {
            super(o);
            this.childcnt = this.getChildCount();
        }

        protected boolean isRemovable() {
            Object myo;
            Object uo;
            boolean ret = false;
            LazyNode pa = (LazyNode)this.getParent();
            if (pa != null && ((uo = pa.getMyUserObject()) == null || uo instanceof IResourceIdentifier) && (myo = this.getMyUserObject()) instanceof IResourceIdentifier) {
                IResourceIdentifier p = (IResourceIdentifier)uo;
                IResourceIdentifier ch = (IResourceIdentifier)myo;
                ret = LibServiceBrowser.this.remlinks.contains(new Tuple2((Object)p, (Object)ch));
            }
            return ret;
        }

        public Icon getIcon() {
            CombiIcon ret = null;
            Object o = this.getUserObject();
            ArrayList<Icon> ilist = new ArrayList<Icon>();
            if (LibraryService.SYSTEMCPRID.equals(o)) {
                ilist.add(icons.getIcon("folder"));
            } else if (this.getParent() != null && LibraryService.SYSTEMCPRID.equals(((LazyNode)this.getParent()).getMyUserObject())) {
                if (((IResourceIdentifier)o).getLocalIdentifier().getUri().toString().indexOf(".jar") != -1) {
                    ilist.add(icons.getIcon("jar"));
                } else {
                    ilist.add(icons.getIcon("folder"));
                }
            } else if (o instanceof IResourceIdentifier) {
                if (((IResourceIdentifier)o).getGlobalIdentifier() != null && !ResourceIdentifier.isHashGid((IResourceIdentifier)((IResourceIdentifier)o))) {
                    ilist.add(icons.getIcon("global"));
                } else {
                    ILocalResourceIdentifier lrid = ((IResourceIdentifier)o).getLocalIdentifier();
                    if (lrid.getUri().toString().indexOf(".jar") != -1) {
                        ilist.add(icons.getIcon("jar"));
                    } else {
                        ilist.add(icons.getIcon("folder"));
                    }
                    if (!ResourceIdentifier.isLocal((IResourceIdentifier)((IResourceIdentifier)o), (IComponentIdentifier)LibServiceBrowser.this.jcc.getPlatformAccess().getComponentIdentifier().getRoot())) {
                        ilist.add(icons.getIcon("oglobal"));
                    }
                }
            } else if (o instanceof String && this.getChildCount() > 0) {
                ilist.add(icons.getIcon("folder"));
            }
            if (this.isRemovable()) {
                ilist.add(icons.getIcon("orem"));
            }
            ret = new CombiIcon(ilist.toArray(new Icon[ilist.size()]));
            return ret;
        }

        public String getTooltipText() {
            String ret = null;
            Object o = this.getUserObject();
            if (o instanceof IResourceIdentifier && ResourceIdentifier.isHashGid((IResourceIdentifier)((IResourceIdentifier)o))) {
                ret = ((IResourceIdentifier)o).getGlobalIdentifier().getResourceId();
            }
            return ret;
        }

        @Override
        public int getChildCount() {
            int ret = 0;
            if (this.childrencreated) {
                ret = super.getChildCount();
            } else {
                Object o = this.getMyUserObject();
                if (o == null || o instanceof IResourceIdentifier) {
                    List<IResourceIdentifier> cs = LibServiceBrowser.this.deps.get(o);
                    ret += cs == null ? 0 : cs.size();
                } else {
                    return super.getChildCount();
                }
            }
            return ret;
        }

        @Override
        public TreeNode getChildAt(int index) {
            this.createChildren();
            return super.getChildAt(index);
        }

        @Override
        public void add(MutableTreeNode child) {
            this.createChildren();
            super.add(child);
        }

        @Override
        public void insert(MutableTreeNode newChild, int childIndex) {
            this.createChildren();
            super.insert(newChild, childIndex);
        }

        protected void createChildren() {
            if (!this.childrencreated) {
                this.childrencreated = true;
                Object o = this.getMyUserObject();
                if (o == null || o instanceof IResourceIdentifier) {
                    List<IResourceIdentifier> cs = LibServiceBrowser.this.deps.get(o);
                    if (cs != null) {
                        for (IResourceIdentifier rid : cs) {
                            LazyNode n = new LazyNode(rid);
                            this.insertChild(n);
                        }
                    }
                    this.childrencreated = true;
                }
            }
        }

        protected int insertChild(LazyNode n) {
            int ret = -1;
            boolean issyscp = LibraryService.SYSTEMCPRID.equals(this.getMyUserObject());
            int cnt = this.getChildCount();
            boolean inserted = false;
            boolean nhasch = n.getChildCount() > 0 || issyscp && ((IResourceIdentifier)n.getMyUserObject()).getLocalIdentifier().getUri().toString().indexOf(".jar") == -1;
            for (int i = 0; i < cnt && !inserted; ++i) {
                boolean tmphasch;
                LazyNode tmp = (LazyNode)this.getChildAt(i);
                boolean bl = tmphasch = tmp.getChildCount() > 0 || issyscp && ((IResourceIdentifier)tmp.getMyUserObject()).getLocalIdentifier().getUri().toString().indexOf(".jar") == -1;
                if ((tmphasch || !nhasch) && (tmphasch != nhasch || n.toString().compareTo(tmp.toString()) >= 0)) continue;
                this.insert(n, i);
                inserted = true;
                ret = i;
            }
            if (!inserted) {
                ret = cnt;
                this.add(n);
            }
            return ret;
        }

        public void refresh() {
            if (this.childrencreated || this.childcnt != this.getChildCount()) {
                LazyNode node;
                this.childcnt = this.getChildCount();
                if (!this.childrencreated) {
                    this.createChildren();
                }
                List<IResourceIdentifier> cs = LibServiceBrowser.this.deps.get(this.getMyUserObject());
                ArrayList<IResourceIdentifier> toadd = new ArrayList<IResourceIdentifier>(cs);
                ArrayList<LazyNode> todel = new ArrayList<LazyNode>();
                ArrayList<LazyNode> toref = new ArrayList<LazyNode>();
                int cnt = this.getChildCount();
                for (int i = 0; i < cnt; ++i) {
                    LazyNode ch = (LazyNode)this.getChildAt(i);
                    Object uo = ch.getMyUserObject();
                    if (!(uo instanceof IResourceIdentifier)) continue;
                    toadd.remove(uo);
                    if (!cs.contains(uo)) {
                        todel.add(ch);
                        continue;
                    }
                    toref.add(ch);
                }
                if (!todel.isEmpty()) {
                    int[] remis = new int[todel.size()];
                    Object[] remns = new LazyNode[todel.size()];
                    for (int i = 0; i < todel.size(); ++i) {
                        node = (LazyNode)todel.get(i);
                        remis[i] = this.getIndex(node);
                        remns[i] = node;
                        this.remove(node);
                    }
                    ((DefaultTreeModel)LibServiceBrowser.this.ridtree.getModel()).nodesWereRemoved(this, remis, remns);
                }
                if (!toadd.isEmpty()) {
                    int[] addis = new int[toadd.size()];
                    for (int i = 0; i < toadd.size(); ++i) {
                        IResourceIdentifier rid = (IResourceIdentifier)toadd.get(i);
                        node = new LazyNode(rid);
                        addis[i] = this.insertChild(node);
                    }
                    ((DefaultTreeModel)LibServiceBrowser.this.ridtree.getModel()).nodesWereInserted(this, addis);
                }
                for (LazyNode node2 : toref) {
                    node2.refresh();
                }
            }
        }

        public Object getMyUserObject() {
            Object ret = this.getUserObject();
            if (LibServiceBrowser.ROOTTEXT.equals(ret)) {
                ret = null;
            }
            return ret;
        }

        @Override
        public String toString() {
            String ret = null;
            Object o = this.getUserObject();
            if (LibraryService.SYSTEMCPRID.equals(o)) {
                ret = LibServiceBrowser.SYSTEMTEXT;
            } else if (o instanceof IResourceIdentifier) {
                IGlobalResourceIdentifier grid = ((IResourceIdentifier)o).getGlobalIdentifier();
                if (grid != null && !ResourceIdentifier.isHashGid((IResourceIdentifier)((IResourceIdentifier)o))) {
                    ret = grid.getResourceId();
                } else {
                    ILocalResourceIdentifier lrid = ((IResourceIdentifier)o).getLocalIdentifier();
                    ret = lrid.getUri().toString();
                    if (!ResourceIdentifier.isLocal((IResourceIdentifier)((IResourceIdentifier)o), (IComponentIdentifier)LibServiceBrowser.this.jcc.getPlatformAccess().getComponentIdentifier().getRoot())) {
                        ret = ret + " (" + ((IResourceIdentifier)o).getLocalIdentifier().getComponentIdentifier() + ")";
                    }
                }
            } else {
                ret = super.toString();
            }
            return ret;
        }
    }
}

