/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.monitoring;

import jadex.base.gui.componentviewer.IServiceViewerPanel;
import jadex.base.gui.idtree.IdTreeCellRenderer;
import jadex.base.gui.idtree.IdTreeModel;
import jadex.base.gui.idtree.IdTreeNode;
import jadex.base.gui.plugin.IControlCenter;
import jadex.bridge.service.IService;
import jadex.bridge.service.types.monitoring.IMonitoringEvent;
import jadex.bridge.service.types.monitoring.IMonitoringService;
import jadex.commons.Properties;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IIntermediateResultListener;
import jadex.commons.future.IResultListener;
import jadex.commons.gui.future.SwingIntermediateResultListener;
import jadex.tools.monitoring.MyIdTreeNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class MonitoringPanel
implements IServiceViewerPanel {
    protected IMonitoringService monservice;
    protected JPanel inner;

    public IFuture<Void> init(IControlCenter jcc, IService service) {
        this.monservice = (IMonitoringService)service;
        this.inner = new JPanel(new BorderLayout());
        final IdTreeModel tm = new IdTreeModel();
        final IdTreeNode root = new IdTreeNode("root", null, tm, Boolean.valueOf(false), null, null, null);
        tm.setRoot((TreeNode)root);
        JTree tree = new JTree((TreeModel)tm);
        tree.setCellRenderer((TreeCellRenderer)new IdTreeCellRenderer());
        tree.setRootVisible(false);
        tree.getSelectionModel().setSelectionMode(1);
        ToolTipManager.sharedInstance().registerComponent(tree);
        this.monservice.subscribeToEvents(null).addResultListener((IResultListener)new SwingIntermediateResultListener((IIntermediateResultListener)new IIntermediateResultListener<IMonitoringEvent>(){

            public void intermediateResultAvailable(IMonitoringEvent event) {
                String name;
                String origin = event.getCause().getOrigin();
                IdTreeNode call = tm.getNode(origin);
                String string = name = event.getCause().getSourceId().equals(origin) ? event.getCause().getSourceId() + " (" + origin + ")" : origin;
                if (call == null) {
                    call = new IdTreeNode(origin, name, tm, null, null, null, null);
                    root.add((MutableTreeNode)call);
                } else if (origin.equals(call.getName()) && event.getCause().getSourceId().equals(origin)) {
                    call.setName(name);
                }
                String srcid = event.getCause().getSourceId();
                String trgid = event.getCause().getTargetId();
                MyIdTreeNode parent = tm.getNode(srcid);
                MyIdTreeNode child = tm.getNode(trgid);
                if (child == null) {
                    String desc = event.getSourceIdentifier().toString();
                    if (event.getSourceDescription() != null) {
                        desc = desc + event.getSourceDescription();
                    }
                    child = new MyIdTreeNode(trgid, desc, tm, null, null, null, new ArrayList());
                } else if (child.getParent().equals(call)) {
                    call.remove((MutableTreeNode)((Object)child));
                }
                if (parent == null) {
                    parent = new MyIdTreeNode(srcid, null, tm, null, null, null, new ArrayList());
                    call.add(parent);
                }
                List evs = (List)child.getObject();
                evs.add(event);
                parent.add((MutableTreeNode)((Object)child));
            }

            public void resultAvailable(Collection<IMonitoringEvent> result) {
                System.out.println("ra");
            }

            public void finished() {
                System.out.println("finfi");
            }

            public void exceptionOccurred(Exception exception) {
                exception.printStackTrace();
            }
        }));
        JButton clear = new JButton("Clear");
        clear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                root.removeAllChildren();
            }
        });
        JPanel south = new JPanel(new FlowLayout(2));
        south.add(clear);
        this.inner.add((Component)new JScrollPane(tree), "Center");
        this.inner.add((Component)south, "South");
        return IFuture.DONE;
    }

    public IFuture<Void> shutdown() {
        return IFuture.DONE;
    }

    public JComponent getComponent() {
        return this.inner;
    }

    public String getId() {
        return "monitoring";
    }

    public IFuture<Void> setProperties(Properties props) {
        return IFuture.DONE;
    }

    public IFuture<Properties> getProperties() {
        Properties props = new Properties();
        return new Future((Object)props);
    }
}

